"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.XmlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const xmlbuilder2_1 = require("xmlbuilder2");
const object_file_1 = require("./object-file");
/**
 * Represents an XML file.
 *
 * Objects passed in will be synthesized using the npm "xml" library.
 * @see https://www.npmjs.com/package/xml
 */
class XmlFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    synthesizeContent(resolver) {
        const obj = super.synthesizeContent(resolver);
        if (!obj) {
            return undefined;
        }
        const xmlString = (0, xmlbuilder2_1.create)({ encoding: "UTF-8" }, obj).end({
            prettyPrint: true,
            indent: " ".repeat(4),
        });
        return [
            xmlString,
            ...(this.marker ? [`<!-- ${this.marker} -->`] : []),
        ].join("\n");
    }
}
exports.XmlFile = XmlFile;
_a = JSII_RTTI_SYMBOL_1;
XmlFile[_a] = { fqn: "projen.XmlFile", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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