"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const YAML = require("yaml");
const object_file_1 = require("./object-file");
/**
 * Represents a YAML file.
 */
class YamlFile extends object_file_1.ObjectFile {
    constructor(scope, filePath, options) {
        super(scope, filePath, options);
        this.lineWidth = options.lineWidth ?? 0;
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            YAML.stringify(JSON.parse(json), {
                indent: 2,
                lineWidth: this.lineWidth,
            }),
        ].join("\n");
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "projen.YamlFile", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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