# mcp-agent Starter

Welcome! This project was generated by `mcp-agent init`. It’s a minimal, readable starting point you can run locally or expose as an MCP server.

## What’s included

- An `MCPApp` named `hello_world` (see `main.py`).
- Two tools defined with decorators:
  - `finder_agent(request: str, app_ctx?)`
    - An Agent that uses the `filesystem` and `fetch` MCP servers plus an LLM to answer the request.
    - Logs via the app logger (forwarded to the client as notifications when serving).
  - `run_agent_async(agent_name: str = "web_helper", prompt: str, app_ctx?)`
    - Loads an `AgentSpec` from `mcp_agent.config.yaml` (`agents.definitions`) and runs it.
    - Decorated with `@app.async_tool`: when serving, returns a workflow ID; when run in this script, it awaits and returns the string result.

## Quick start
1. Add your OpenAI API key to `mcp_agent.secrets.yaml` (or set `OPENAI_API_KEY` env var).

NOTE: You can use another supported provider (e.g. Anthropic) instead, just be sure to set its API key in the `mcp_agent.secrets.yaml` (or set its env var) and update the provider configuration in `main.py`.

2. Install dependencies and run locally:

```bash
uv init
uv add "mcp-agent[openai]"
uv run main.py
```

You’ll see two summaries printed:

- A summary of `README.md` from your current directory.
- A summary of the intro page at modelcontextprotocol.io.

3. Run locally as an MCP server:

- In `main.py`, UNCOMMENT the server lines that call `create_mcp_server_for_app(agent_app)` and `run_sse_async()`.

- Once you see the server started, e.g.
  ```bash
  Uvicorn running on http://127.0.0.1:8000
  ```
  you can connect to it with your preferred MCP Client. For example, you can use [MCP Inspector](https://github.com/modelcontextprotocol/inspector) to explore and test the server:

```bash
npx @modelcontextprotocol/inspector --transport sse --server-url http://127.0.0.1:8000/sse
```

4. Deploy a remote MCP server:

When you're ready to deploy, ensure the required API keys are set in `mcp_agent.secrets.yaml` and then run:

```bash
uv run mcp-agent login
```

to authenticate to mcp-agent cloud. You will be redirected to the login page, create an mcp-agent cloud account through Google or Github.

Set up your mcp-agent cloud API Key and copy & paste it into your terminal

```bash
INFO: Directing to MCP Agent Cloud API login...
Please enter your API key 🔑:
```

In your terminal, deploy the MCP app:

```bash
uv run mcp-agent deploy hello_world
```

The `deploy` command will bundle the app files and deploy them, wrapping your app as a hosted MCP SSE server with a URL of the form:
`https://<server_id>.deployments.mcp-agent.com`.

Anything decorated with `@app.tool` (or `@app.async_tool`) runs as a Temporal workflow in the cloud.

Since the mcp-agent app is exposed as an MCP server, it can be used in any MCP client just
like any other MCP server. For example, you can inspect and test the server using MCP Inspector:

```bash
npx @modelcontextprotocol/inspector --transport sse --server-url https://<server_id>.deployments.mcp-agent.com/sse
```

Make sure Inspector is configured with the following settings:

| Setting          | Value                                               |
| ---------------- | --------------------------------------------------- |
| _Transport Type_ | _SSE_                                               |
| _SSE_            | _https://[server_id].deployments.mcp-agent.com/sse_ |
| _Header Name_    | _Authorization_                                     |
| _Bearer Token_   | _your-mcp-agent-cloud-api-token_                    |

## Notes

- `app_ctx` is the MCPApp Context (configuration, logger, upstream session, etc.).
- Logging uses `app.logger` and is forwarded as notifications when connected to an MCP client.
- Configuration is read from `mcp_agent.config.yaml` and `mcp_agent.secrets.yaml` (env vars supported).
- The default model is configurable (see `openai.default_model` in config).

## Next steps

- Tweak `finder_agent` instructions or server list to fit your use case.
- Add more `AgentSpec` entries to `agents.definitions`.
- Add tools with `@app.tool` or `@app.async_tool` as you grow the app.
- Read the docs and explore examples:
  - GitHub: https://github.com/lastmile-ai/mcp-agent
  - Docs: https://docs.mcp-agent.com/
  - Discord: https://lmai.link/discord/mcp-agent
Happy building!
