# mcp-agent Factory Starter

Welcome! This project was generated by `mcp-agent init`. It demonstrates how to use the agent factory pattern with `LLMRouter` to intelligently route prompts to the appropriate agents based on their capabilities. This is just one of the many useful [workflow patterns](https://docs.mcp-agent.com/mcp-agent-sdk/overview#workflow-patterns) supported by mcp-agent out of the box.

## What's included

- An `MCPApp` named `factory_demo` (see `main.py`).
- A tool defined with a decorator:
  - `route_prompt(prompt: str, app_ctx?)` - Routes prompts to the right agent using `create_router_llm`.
  - Loads agent specifications from `agents.yaml` (finder and coder agents).
  - Automatically selects the best agent for each request based on server capabilities.
- `agents.yaml` - Contains agent specifications with different capabilities:
  - `finder`: Can read files and fetch URLs (filesystem + fetch servers)
  - `coder`: Can inspect and modify code files (filesystem server only)

## Quick start

1. Add your OpenAI API key to `mcp_agent.secrets.yaml` (or set `OPENAI_API_KEY` env var).

NOTE: You can use another supported provider (e.g. Anthropic) instead, just be sure to set its API key in the `mcp_agent.secrets.yaml` (or set its env var) and update the `provider` parameter in `main.py`.

2. Install dependencies and run locally:

```bash
uv init
uv add "mcp-agent[openai]"
uv run main.py
```

You'll see the router automatically select the appropriate agent and execute your request. The router intelligently chose the `finder` agent because the task requires reading a file (filesystem capability).

Want to exercise the same workflow with Temporal? Set `execution_engine: temporal` in `mcp_agent.config.yaml`, then in a separate terminal start the worker:

```bash
uv run run_worker.py
```

Once the worker is running, invoke the workflow (for example, run `uv run main.py` or call the `route_prompt` tool from your MCP client).

3. Deploy a remote MCP server:

When you're ready to deploy, ensure the required API keys are set in `mcp_agent.secrets.yaml` and then run:

```bash
uv run mcp-agent login
```

to authenticate to mcp-agent cloud. You will be redirected to the login page to create an mcp-agent cloud account through Google or Github.

Set up your mcp-agent cloud API Key and copy & paste it into your terminal

```bash
INFO: Directing to MCP Agent Cloud API login...
Please enter your API key 🔑:
```

In your terminal, deploy the MCP app:

```bash
uv run mcp-agent deploy agent_factory
```

The `deploy` command will bundle the app files and deploy them, wrapping your app as a hosted MCP SSE server with a URL of the form:
`https://<server_id>.deployments.mcp-agent.com`.

Anything decorated with `@app.async_tool` (or `@app.tool`) runs as a Temporal workflow in the cloud.

Since the mcp-agent app is exposed as an MCP server, it can be used in any MCP client just
like any other MCP server. For example, you can inspect and test the server using MCP Inspector:

```bash
npx @modelcontextprotocol/inspector --transport sse --server-url https://<server_id>.deployments.mcp-agent.com/sse
```

Make sure Inspector is configured with the following settings:

| Setting          | Value                                               |
| ---------------- | --------------------------------------------------- |
| _Transport Type_ | _SSE_                                               |
| _SSE_            | _https://[server_id].deployments.mcp-agent.com/sse_ |
| _Header Name_    | _Authorization_                                     |
| _Bearer Token_   | _your-mcp-agent-cloud-api-token_                    |

## Next steps

- Tweak the agent definitions in `agents.yaml` to fit your use case.
- Try other factory workflows, such as Orchestrator.
- Add tools with `@app.tool` or `@app.async_tool` as you grow the app.
- Read the docs and explore examples:
  - GitHub: https://github.com/lastmile-ai/mcp-agent
  - Docs: https://docs.mcp-agent.com/
  - Discord: https://lmai.link/discord/mcp-agent

Happy building!
