# mcp-agent Server Starter

Welcome! This project was generated by `mcp-agent init`. It demonstrates how to expose your mcp-agent application as an MCP server, making your agentic workflows available to any MCP client.

## What's included

- An `MCPApp` named `basic_agent_server` (see `main.py`).
- A workflow class `BasicAgentWorkflow`:
  - Uses `Agent` to connect to `filesystem` and `fetch` MCP servers.
  - Demonstrates multi-turn conversations with an LLM (OpenAI).
  - Shows how to configure model preferences for specific requests.
- A tool function decorated with `@app.tool`:
  - `grade_story(story: str, app_ctx?)` - Grades a student's short story using parallel agents (proofreader, fact checker, style enforcer) via `ParallelLLM`.
  - Returns the final result directly to the caller (no polling needed).
- Server logs are forwarded to connected MCP clients as notifications.

## What gets exposed as MCP tools

When you run `main.py`, your MCP server exposes:

- `workflows-list` - Lists available workflows and their parameter schemas
- `workflows-BasicAgentWorkflow-run` - Executes the BasicAgentWorkflow with input
- `workflows-get_status` - Get status for a running workflow by `run_id`
- `workflows-cancel` - Cancel a running workflow
- `grade_story` - Synchronous tool that grades a short story and returns the final result

## Quick start

1. Add your OpenAI API key to `mcp_agent.secrets.yaml` (or set `OPENAI_API_KEY` env var).

NOTE: You can use another supported provider (e.g. Anthropic) instead, just be sure to set its API key in the `mcp_agent.secrets.yaml` (or set its env var) and import/use the relevant `AugmentedLLM` in `main.py`.

2. Install dependencies and run the server:

```bash
uv init
uv add "mcp-agent[openai]"
uv run main.py
```

The server will start and expose its tools over sse. You'll see:

```bash
Creating MCP server for basic_agent_server
Registered workflows:
  - BasicAgentWorkflow
MCP Server settings: ...
```

4. Connect with an MCP client:

You can connect to this server using any MCP client. For example, use [MCP Inspector](https://github.com/modelcontextprotocol/inspector) to explore and test:

```bash
npx @modelcontextprotocol/inspector --transport sse --server-url http://127.0.0.1:8000/sse
```

This will launch the inspector UI where you can:

- See all available tools (`grade_story`, `workflows-BasicAgentWorkflow-run`, etc.)
- Test workflow execution
- View request/response details

4. Deploy as a remote MCP server:

When you're ready to deploy, ensure the required API keys are set in `mcp_agent.secrets.yaml` and then run:

```bash
uv run mcp-agent login
```

to authenticate to mcp-agent cloud. You will be redirected to the login page, create an mcp-agent cloud account through Google or Github.

Set up your mcp-agent cloud API Key and copy & paste it into your terminal

```bash
INFO: Directing to MCP Agent Cloud API login...
Please enter your API key 🔑:
```

In your terminal, deploy the MCP app:

```bash
uv run mcp-agent deploy basic_agent_server
```

You will then be prompted to specify the type of secret to save your OpenAI API key as. Select (1) deployment secret so that it is available to the deployed server.

The `deploy` command will bundle the app files and deploy them, wrapping your app as a hosted MCP SSE server with a URL of the form:
`https://<server_id>.deployments.mcp-agent.com`.

Anything decorated with `@app.tool` (or `@app.async_tool`) runs as a Temporal workflow in the cloud.

Since the mcp-agent app is exposed as an MCP server, it can be used in any MCP client just
like any other MCP server. For example, you can inspect and test the server using MCP Inspector:

```bash
npx @modelcontextprotocol/inspector --transport sse --server-url https://<server_id>.deployments.mcp-agent.com/sse
```

Make sure Inspector is configured with the following settings:

| Setting          | Value                                               |
| ---------------- | --------------------------------------------------- |
| _Transport Type_ | _SSE_                                               |
| _SSE_            | _https://[server_id].deployments.mcp-agent.com/sse_ |
| _Header Name_    | _Authorization_                                     |
| _Bearer Token_   | _your-mcp-agent-cloud-api-token_                    |

## Notes

- `app_ctx` is the MCPApp Context (configuration, logger, upstream session, etc.).
- Logging uses `app.logger` and is forwarded as notifications when connected to an MCP client.
- Configuration is read from `mcp_agent.config.yaml` and `mcp_agent.secrets.yaml` (env vars supported).
- The default model is configurable (see `openai.default_model` in config).
- The server runs in `asyncio` mode and exposes tools via sse by default.

## Key concepts demonstrated

- **Creating workflows**: Use the `@app.workflow` decorator and `Workflow` base class to define reusable workflows.
- **Defining tools**: Use `@app.tool` for synchronous tools that return results immediately.
- **Using agents**: Create `Agent` instances with specific instructions and server access (filesystem, fetch, etc.).
- **Parallel execution**: Use `ParallelLLM` to run multiple agents in parallel and aggregate their results.
- **Multi-turn conversations**: LLMs maintain conversation context across multiple `generate_str()` calls.
- **Model preferences**: Configure model selection via `RequestParams` and `ModelPreferences`.
- **Server creation**: Use `create_mcp_server_for_app()` to wrap your MCPApp as an MCP server.

## Next steps

- Modify the `BasicAgentWorkflow` instructions or server list to fit your use case.
- Add more tools with `@app.tool` or `@app.async_tool` as you grow the app.
- Explore the `grade_story` tool to understand parallel agent execution.
- Customize the agents used by `ParallelLLM` (proofreader, fact checker, style enforcer).
- Read the docs and explore examples:
  - GitHub: https://github.com/lastmile-ai/mcp-agent
  - Docs: https://docs.mcp-agent.com/
  - Discord: https://lmai.link/discord/mcp-agent
Happy building!
