"""Schema definitions for flowllm core components."""

from .flow_request import FlowRequest
from .flow_response import FlowResponse
from .flow_stream_chunk import FlowStreamChunk
from .message import Message, Trajectory
from .service_config import (
    CmdConfig,
    EmbeddingModelConfig,
    FlowConfig,
    HttpConfig,
    LLMConfig,
    MCPConfig,
    ServiceConfig,
    VectorStoreConfig,
)
from .tool_call import ParamAttrs, ToolCall
from .vector_node import VectorNode

# Rebuild FlowStreamChunk after ToolCall is imported to resolve forward references
FlowStreamChunk.model_rebuild()

__all__ = [
    "FlowRequest",
    "FlowResponse",
    "FlowStreamChunk",
    "Message",
    "Trajectory",
    "CmdConfig",
    "EmbeddingModelConfig",
    "FlowConfig",
    "HttpConfig",
    "LLMConfig",
    "MCPConfig",
    "ServiceConfig",
    "VectorStoreConfig",
    "ParamAttrs",
    "ToolCall",
    "VectorNode",
]
