"""Vector store module for managing vector embeddings.

This module provides implementations of vector stores for storing, searching,
and managing vector embeddings along with their associated metadata. It includes:

- BaseVectorStore: Abstract base class defining the vector store interface
- LocalVectorStore: File-based local vector store implementation
- ChromaVectorStore: ChromaDB-based vector store
- EsVectorStore: Elasticsearch-based vector store
- QdrantVectorStore: Qdrant-based vector store
- MemoryVectorStore: In-memory vector store for fast access

All vector stores support workspace-based organization and provide both synchronous
and asynchronous interfaces for operations such as insertion, search, and deletion.
"""

from .base_vector_store import BaseVectorStore
from .chroma_vector_store import ChromaVectorStore
from .es_vector_store import EsVectorStore
from .local_vector_store import LocalVectorStore
from .memory_vector_store import MemoryVectorStore
from .qdrant_vector_store import QdrantVectorStore

__all__ = [
    "BaseVectorStore",
    "ChromaVectorStore",
    "EsVectorStore",
    "LocalVectorStore",
    "MemoryVectorStore",
    "QdrantVectorStore",
]
