# metabook

> Updates pdf book filenames and tags with book metadata for easier indexing.

[![PyPI][pypi-image]][pypi-url]
[![Downloads][downloads-image]][downloads-url]
[![Status][status-image]][pypi-url]
[![Python Version][python-version-image]][pypi-url]
[![tests][tests-image]][tests-url]
[![Codecov][codecov-image]][codecov-url]
[![CodeQl][codeql-image]][codeql-url]
[![Docker][docker-image]][docker-url]
[![pre-commit][pre-commit-image]][pre-commit-url]
[![pre-commit.ci status][pre-commit.ci-image]][pre-commit.ci-url]
[![readthedocs][readthedocs-image]][readthedocs-url]
[![CodeFactor][codefactor-image]][codefactor-url]
[![Codeclimate][codeclimate-image]][codeclimate-url]
[![Imports: isort][isort-image]][isort-url]
[![Code style: black][black-image]][black-url]
[![Checked with mypy][mypy-image]][mypy-url]
[![security: bandit][bandit-image]][bandit-url]
[![Commitizen friendly][commitizen-image]][commitizen-url]
[![Conventional Commits][conventional-commits-image]][conventional-commits-url]
[![DeepSource][deepsource-image]][deepsource-url]
[![license][license-image]][license-url]
[![Pydough][pydough-image]][pydough-url]
[![OpenSSFScorecard][openssf-image]][openssf-url]

Metabook is a simple to use CLI utility that searches for pdf files inside a directory then searches for ISBN numbers
inside the files, gets the book metadata then updates the filename and meta tags inside the file.

![](assets/header_dough.png)

## Installation

---

Metabook is best installed with pipx

```sh
pipx install metabook
```

## Usage example

---

A few motivating and useful examples of how your product can be used. Spice this up with code blocks and potentially more screenshots.

_For more examples and usage, please refer to the [Wiki][wiki]._

## Development setup

---

Describe how to install all development dependencies and how to run an automated test-suite of some kind. Potentially do this for multiple platforms.

```sh
pip install --editable metabook
```

## Documentation

---

[**Read the Docs**](https://metabook.readthedocs.io/en/latest/)

-   [**Example Usage**](https://metabook.readthedocs.io/en/latest/example.html)
-   [**Credits**](https://metabook.readthedocs.io/en/latest/example.html)
-   [**Changelog**](https://metabook.readthedocs.io/en/latest/changelog.html)
-   [**API Reference**](https://metabook.readthedocs.io/en/latest/autoapi/index.html)

[**Wiki**](https://github.com/Stephen-RA-King/metabook/wiki)

## Meta

---

[![](assets/linkedin.png)](https://www.linkedin.com/in/sr-king)
[![](assets/github.png)](https://github.com/Stephen-RA-King)
[![](assets/pypi.png)](https://pypi.org/project/metabook)
[![Docker](assets/docker.png)](https://hub.docker.com/r/sraking/metabook)
[![](assets/www.png)](https://stephen-ra-king.github.io/justpython/)
[![](assets/email.png)](mailto:sking.github@gmail.com)
[![](assets/github.png)](https://github.com/Stephen-RA-King/metabook)

Author: Stephen R A King ([sking.github@gmail.com](mailto:sking.github@gmail.com))

Distributed under the MIT license. See [![][license-image]][license-url] for more information.

Created with Cookiecutter template: [![pydough][pydough-image]][pydough-url] version 1.3.3

Digital object identifier: [![DOI](https://zenodo.org/badge/xxxxxxxxx.svg)](https://zenodo.org/badge/latestdoi/xxxxxxxxx)

<!-- Markdown link & img dfn's -->

[bandit-image]: https://img.shields.io/badge/security-bandit-yellow.svg
[bandit-url]: https://github.com/PyCQA/bandit
[black-image]: https://img.shields.io/badge/code%20style-black-000000.svg
[black-url]: https://github.com/psf/black
[codeclimate-image]: https://api.codeclimate.com/v1/badges/7fc352185512a1dab75d/maintainability
[codeclimate-url]: https://codeclimate.com/github/Stephen-RA-King/metabook/maintainability
[codecov-image]: https://codecov.io/gh/Stephen-RA-King/metabook/branch/main/graph/badge.svg
[codecov-url]: https://app.codecov.io/gh/Stephen-RA-King/metabook
[codefactor-image]: https://www.codefactor.io/repository/github/Stephen-RA-King/metabook/badge
[codefactor-url]: https://www.codefactor.io/repository/github/Stephen-RA-King/metabook
[codeql-image]: https://github.com/Stephen-RA-King/metabook/actions/workflows/github-code-scanning/codeql/badge.svg
[codeql-url]: https://github.com/Stephen-RA-King/metabook/actions/workflows/github-code-scanning/codeql
[commitizen-image]: https://img.shields.io/badge/commitizen-friendly-brightgreen.svg
[commitizen-url]: http://commitizen.github.io/cz-cli/
[conventional-commits-image]: https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg?style=flat-square
[conventional-commits-url]: https://conventionalcommits.org
[deepsource-image]: https://static.deepsource.io/deepsource-badge-light-mini.svg
[deepsource-url]: https://deepsource.io/gh/Stephen-RA-King/metabook/?ref=repository-badge
[docker-image]: https://github.com/Stephen-RA-King/metabook/actions/workflows/docker-image.yml/badge.svg
[docker-url]: https://github.com/Stephen-RA-King/metabook/actions/workflows/docker-image.yml
[downloads-image]: https://static.pepy.tech/personalized-badge/metabook?period=total&units=international_system&left_color=black&right_color=orange&left_text=Downloads
[downloads-url]: https://pepy.tech/project/metabook
[format-image]: https://img.shields.io/pypi/format/metabook
[isort-image]: https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336
[isort-url]: https://github.com/pycqa/isort/
[lgtm-alerts-image]: https://img.shields.io/lgtm/alerts/g/Stephen-RA-King/metabook.svg?logo=lgtm&logoWidth=18
[lgtm-alerts-url]: https://lgtm.com/projects/g/Stephen-RA-King/metabook/alerts/
[lgtm-quality-image]: https://img.shields.io/lgtm/grade/python/g/Stephen-RA-King/metabook.svg?logo=lgtm&logoWidth=18
[lgtm-quality-url]: https://lgtm.com/projects/g/Stephen-RA-King/metabook/context:python
[license-image]: https://img.shields.io/pypi/l/metabook
[license-url]: https://github.com/Stephen-RA-King/metabook/blob/main/LICENSE
[mypy-image]: http://www.mypy-lang.org/static/mypy_badge.svg
[mypy-url]: http://mypy-lang.org/
[openssf-image]: https://api.securityscorecards.dev/projects/github.com/Stephen-RA-King/metabook/badge
[openssf-url]: https://api.securityscorecards.dev/projects/github.com/Stephen-RA-King/metabook
[pre-commit-image]: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white
[pre-commit-url]: https://github.com/pre-commit/pre-commit
[pre-commit.ci-image]: https://results.pre-commit.ci/badge/github/Stephen-RA-King/metabook/main.svg
[pre-commit.ci-url]: https://results.pre-commit.ci/latest/github/Stephen-RA-King/metabook/main
[pydough-image]: https://img.shields.io/badge/pydough-2023-orange
[pydough-url]: https://github.com/Stephen-RA-King/pydough
[pypi-url]: https://pypi.org/project/metabook/
[pypi-image]: https://img.shields.io/pypi/v/metabook.svg
[python-version-image]: https://img.shields.io/pypi/pyversions/metabook
[readthedocs-image]: https://readthedocs.org/projects/metabook/badge/?version=latest
[readthedocs-url]: https://metabook.readthedocs.io/en/latest/?badge=latest
[status-image]: https://img.shields.io/pypi/status/metabook.svg
[tests-image]: https://github.com/Stephen-RA-King/metabook/actions/workflows/tests.yml/badge.svg
[tests-url]: https://github.com/Stephen-RA-King/metabook/actions/workflows/tests.yml
[wiki]: https://github.com/Stephen-RA-King/metabook/wiki
