from __future__ import annotations

from .read.array import (
    _h5_read_array,
    _h5_read_array_of_equalsized_arrays,
    _h5_read_fixedsize_array,
    _h5_read_ndarray,
)
from .read.composite import (
    _h5_read_histogram,
    _h5_read_lgdo,
    _h5_read_struct,
    _h5_read_table,
)
from .read.encoded import (
    _h5_read_array_of_encoded_equalsized_arrays,
    _h5_read_vector_of_encoded_vectors,
)
from .read.scalar import _h5_read_scalar
from .read.vector_of_vectors import _h5_read_vector_of_vectors
from .write.array import _h5_write_array
from .write.composite import _h5_write_lgdo, _h5_write_struct
from .write.scalar import _h5_write_scalar
from .write.vector_of_vectors import _h5_write_vector_of_vectors

__all__ = [
    "_h5_read_array",
    "_h5_read_array_of_encoded_equalsized_arrays",
    "_h5_read_array_of_equalsized_arrays",
    "_h5_read_encoded_array",
    "_h5_read_fixedsize_array",
    "_h5_read_histogram",
    "_h5_read_lgdo",
    "_h5_read_ndarray",
    "_h5_read_scalar",
    "_h5_read_struct",
    "_h5_read_table",
    "_h5_read_vector_of_encoded_vectors",
    "_h5_read_vector_of_vectors",
    "_h5_write_array",
    "_h5_write_lgdo",
    "_h5_write_scalar",
    "_h5_write_struct",
    "_h5_write_vector_of_vectors",
]
