__author__="UShareSoft"

from ussclicore.argumentParser import ArgumentParser, ArgumentParserError
from ussclicore.cmd import Cmd, CoreGlobal
from texttable import Texttable
from uforgecli.utils.org_utils import org_get
from ussclicore.utils import generics_utils, printer
from ussclicore.utils.generics_utils import order_list_object_by
from uforgecli.utils.uforgecli_utils import *
from uforgecli.utils.compare_utils import compare
from uforgecli.utils import *
from uforgecli.utils.texttable_utils import *
from hurry.filesize import size
import shlex



class Images_Cmd(Cmd, CoreGlobal):
        """Administer generated images for a user"""

        cmd_name="images"

        def __init__(self):
                super(Images_Cmd, self).__init__()

        def arg_list(self):
                doParser = ArgumentParser(add_help = True, description="List all the images created by a user")

                mandatory = doParser.add_argument_group("Mandatory arguments")
                optional = doParser.add_argument_group("Optional arguments")

                mandatory.add_argument('--account', dest='account', type=str, required=True, help="The account on which you want to list the images")
                optional.add_argument('--os', dest='os', nargs='+', required=False, help="Only display images that have been built from the operating system(s). You can use Unix matching system (*,?,[seq],[!seq]) and multiple match separating by space.")
                optional.add_argument('--name', dest='name', nargs='+', required=False, help="Only display images that have the name matching this name. You can use Unix matching system (*,?,[seq],[!seq]) and multiple match separating by space.")
                optional.add_argument('--targetFormat', dest='targetFormat', nargs='+', required=False, help="Only display images that have been generated by the following format(s). You can use Unix matching system (*,?,[seq],[!seq]) and multiple match separating by space.")
                return doParser

        def do_list(self, args):
                try:
                        doParser = self.arg_list()
                        doArgs = doParser.parse_args(shlex.split(args))

                        #if the help command is called, parse_args returns None object
                        if not doArgs:
                                return 2

                        id = doArgs.account
                        imagesList = self.api.Users(id).Images.Getall()
                        imagesList = imagesList.images.image

                        appliancesList = self.api.Users(id).Appliances.Getall()
                        appliancesList = appliancesList.appliances.appliance

                        if imagesList is None or len(imagesList) == 0:
                                printer.out("There is no images for user [" + doArgs.account + "].")
                                return 0

                        if doArgs.name is not None:
                                imagesList = compare(imagesList, doArgs.name, "name")
                        if doArgs.targetFormat is not None:
                                imagesList = compare(imagesList, doArgs.targetFormat, "targetFormat", "name")
                        if doArgs.os is not None:
                                imagesList = compare(list=imagesList, values=doArgs.os, attrName='distributionName', subattrName=None, otherList=appliancesList, linkProperties=['applianceUri', 'uri'])

                        if len(imagesList) == 0:
                                printer.out("There is no images for user [" + doArgs.account + "] with these filters.")
                                return 0

                        imagesListSorted = order_list_object_by(imagesList, "name")
                        printer.out("List of images :", printer.OK)

                        table = init_texttable(["ID", "Name", "Version", "Rev", "OS", "Format", "Created", "Size", "Compressed", "Status"],
                                               200,
                                               ["c", "c", "c", "c", "c", "c", "c", "c", "c", "c"],
                                               ["a", "a", "t", "a", "a", "a", "a", "a", "a", "a"])
                        count = 0
                        error = 0
                        for item in imagesListSorted:
                                count = count + 1
                                if not item.compress:
                                        compressed = "No"
                                else:
                                        compressed = "Yes"
                                if item.status.error:
                                        status = "Error"
                                        error = error + 1
                                elif item.status.cancelled:
                                        status = "Cancelled"
                                elif item.status.complete:
                                        status = "Done"
                                else:
                                        status = "Generating"
                                timeCreated = item.created.strftime("%Y-%m-%d %H:%M:%S")
                                for item3 in imagesList:
                                        for item2 in appliancesList:
                                                if item3.applianceUri == item2.uri:
                                                        os = "" + item2.distributionName + "  " + item2.archName
                                                        break
                                table.add_row([item.dbId, item.name, item.version, item.revision, os, item.targetFormat.name, timeCreated, size(item.size), compressed, status])
                        print table.draw() + "\n"

                        printer.out(str(count)+" images found.")
                        if error != 0:
                                printer.out(str(error)+" images with error status.")
                        return 0

                except ArgumentParserError as e:
                        printer.out("In Arguments: "+str(e), printer.ERROR)
                        self.help_list()
                except Exception as e:
                        return handle_uforge_exception(e)

        def help_list(self):
                doParser = self.arg_list()
                doParser.print_help()

        def arg_info(self):
                doParser = ArgumentParser(add_help = True, description="Retrieve detailed information of a generated image")

                mandatory = doParser.add_argument_group("mandatory arguments")

                mandatory.add_argument('--id', dest='id', type=str, required=True, help="The unique identifier of the image to retrieve")
                mandatory.add_argument('--account', dest='account', type=str, required=True, help="The account on which you want to get the image info")

                return doParser

        def do_info(self, args):
                try:
                        doParser = self.arg_info()
                        doArgs = doParser.parse_args(shlex.split(args))

                        id = doArgs.account
                        imagesList = self.api.Users(id).Images.Getall()
                        imagesList = imagesList.images.image

                        infoImage = None
                        for item in imagesList:
                                if str(item.dbId) == str(doArgs.id):
                                        infoImage = item
                        if infoImage is None:
                                printer.out("The image with id \"" + doArgs.id + "\" doesn't exist.")
                                return 0

                        printer.out("Informations about [" + infoImage.name + "] :")

                        table = init_texttable(None, 200, ["l", "l"], ["a", "t"])
                        table.add_row(["Name", infoImage.name])
                        table.add_row(["Format", infoImage.targetFormat.name])
                        table.add_row(["Id", infoImage.dbId])
                        table.add_row(["Version", infoImage.version])
                        table.add_row(["Revision", infoImage.revision])
                        table.add_row(["Uri", infoImage.uri])

                        appliancesList = self.api.Users(id).Appliances.Getall()
                        appliancesList = appliancesList.appliances.appliance

                        for item in appliancesList:
                                Exist = False
                                if infoImage.applianceUri == item.uri:
                                        template = item
                                        os = "" + item.distributionName + "  " + item.archName
                                        Exist = True
                                        break
                                if not Exist:
                                        os = "Unknown"
                        table.add_row(["OS", os])
                        table.add_row(["Template Id", template.dbId])
                        table.add_row(["Created", infoImage.created.strftime("%Y-%m-%d %H:%M:%S")])
                        table.add_row(["Size", size(infoImage.size)])
                        if not infoImage.compress:
                                compressed = "No"
                        else:
                                compressed = "Yes"

                        table.add_row(["Compressed", compressed])
                        table.add_row(["Description", template.description])
                        print table.draw() + "\n"

                        table = Texttable(200)
                        table.set_cols_align(["l", "l"])
                        table.header(["Status Details", ""])

                        if infoImage.status.error:
                                status = "Error"
                        elif infoImage.status.cancelled:
                                status = "Cancelled"
                        elif infoImage.status.complete:
                                status = "Done"
                        else:
                                status = "Generating"
                        table.add_row(["Status", status])
                        if infoImage.status.error:
                                table.add_row(["Error Message", infoImage.status.message])
                                table.add_row(["Detailed Error Message", infoImage.status.errorMessage])
                        else:
                                table.add_row(["Message", infoImage.status.message])

                        print table.draw() + "\n"

                        pimagesList = self.api.Users(id).Pimages.Getall()
                        table = Texttable(200)
                        table.set_cols_align(["l", "l"])
                        table.header(["Published To Details", "Cloud Id"])
                        if len(pimagesList.publishImages.publishImage) == 0:
                                table.add_row(["# Published", "No published images"])
                        else:
                                for item2 in pimagesList.publishImages.publishImage:
                                        if item2.imageUri == infoImage.uri:
                                                table.add_row(["# Published","Format Id : " + str(item2.targetFormat.dbId)+"\nCloud Id : " + str(item2.cloudId)])
                        print table.draw() + "\n"
                        return 0

                except ArgumentParserError as e:
                        printer.out("In Arguments: "+str(e), printer.ERROR)
                        self.help_info()
                except Exception as e:
                        return handle_uforge_exception(e)

        def help_info(self):
                doParser = self.arg_info()
                doParser.print_help()
