import DashboardLayout from '../layout/DashboardLayout.vue'
// GeneralViews
import Error404 from '../pages/404.vue'

// Admin pages
import Overview from 'src/pages/Overview.vue'
import Carousels from 'src/pages/Carousels.vue'
import CarouselNew from 'src/pages/CarouselNew.vue'
import CarouselEdit from 'src/pages/CarouselEdit.vue'
import CarouselItems from 'src/pages/CarouselItems.vue'
import CarouselItemNew from 'src/pages/CarouselItemNew.vue'
import CarouselItemEdit from 'src/pages/CarouselItemEdit.vue'
import CarouselItemLinks from 'src/pages/CarouselItemLinks.vue'
import CarouselItemLinkNew from 'src/pages/CarouselItemLinkNew.vue'
import CarouselItemLinkEdit from 'src/pages/CarouselItemLinkEdit.vue'
import CarouselItemLocalizations from 'src/pages/CarouselItemLocalizations.vue'
import CarouselItemLocalizationNew from 'src/pages/CarouselItemLocalizationNew.vue'
import CarouselItemLocalizationEdit from 'src/pages/CarouselItemLocalizationEdit.vue'
import CarouselItemLinkLocalizations from 'src/pages/CarouselItemLinkLocalizations.vue'
import CarouselItemLinkLocalizationNew from 'src/pages/CarouselItemLinkLocalizationNew.vue'
import CarouselItemLinkLocalizationEdit from 'src/pages/CarouselItemLinkLocalizationEdit.vue'
import CarouselLocks from 'src/pages/CarouselLocks.vue'
import CarouselLockNew from 'src/pages/CarouselLockNew.vue'
import Media from 'src/pages/Media.vue'
import MediaEdit from 'src/pages/MediaEdit.vue'
import MediaNew from 'src/pages/MediaNew.vue'
import MediaLocks from 'src/pages/MediaLocks.vue'
import MediaLockNew from 'src/pages/MediaLockNew.vue'
import MediaCollections from 'src/pages/MediaCollections.vue'
import MediaCollectionNew from 'src/pages/MediaCollectionNew.vue'
import MediaCollectionEdit from 'src/pages/MediaCollectionEdit.vue'
import MediaCollectionItems from 'src/pages/MediaCollectionItems.vue'
import MediaCollectionItemNew from 'src/pages/MediaCollectionItemNew.vue'
import MediaCollectionItemEdit from 'src/pages/MediaCollectionItemEdit.vue'
import MediaCollectionLocks from 'src/pages/MediaCollectionLocks.vue'
import MediaCollectionLockNew from 'src/pages/MediaCollectionLockNew.vue'
import Menus from 'src/pages/Menus.vue'
import MenuEdit from 'src/pages/MenuEdit.vue'
import MenuNew from 'src/pages/MenuNew.vue'
import MenuLocks from 'src/pages/MenuLocks.vue'
import MenuLockNew from 'src/pages/MenuLockNew.vue'
import MenuItems from 'src/pages/MenuItems.vue'
import MenuItemEdit from 'src/pages/MenuItemEdit.vue'
import MenuItemNew from 'src/pages/MenuItemNew.vue'
import Publications from 'src/pages/Publications.vue'
import PublicationNew from 'src/pages/PublicationNew.vue'
import PublicationEdit from 'src/pages/PublicationEdit.vue'
import PublicationLocks from 'src/pages/PublicationLocks.vue'
import PublicationLockNew from 'src/pages/PublicationLockNew.vue'
import PublicationAttachments from 'src/pages/PublicationAttachments.vue'
import PublicationAttachmentNew from 'src/pages/PublicationAttachmentNew.vue'
import PublicationAttachmentEdit from 'src/pages/PublicationAttachmentEdit.vue'
import PublicationGalleries from 'src/pages/PublicationGalleries.vue'
import PublicationGalleryNew from 'src/pages/PublicationGalleryNew.vue'
import PublicationGalleryEdit from 'src/pages/PublicationGalleryEdit.vue'
import PublicationLinks from 'src/pages/PublicationLinks.vue'
import PublicationLinkNew from 'src/pages/PublicationLinkNew.vue'
import PublicationLinkEdit from 'src/pages/PublicationLinkEdit.vue'
import PublicationLocalizations from 'src/pages/PublicationLocalizations.vue'
import PublicationLocalizationNew from 'src/pages/PublicationLocalizationNew.vue'
import PublicationLocalizationEdit from 'src/pages/PublicationLocalizationEdit.vue'
import PublicationRelated from 'src/pages/PublicationRelated.vue'
import PublicationRelatedNew from 'src/pages/PublicationRelatedNew.vue'
import PublicationRelatedEdit from 'src/pages/PublicationRelatedEdit.vue'
import Websites from 'src/pages/Websites.vue'
import Webpaths from 'src/pages/Webpaths.vue'
import WebpathNew from 'src/pages/WebpathNew.vue'
import WebpathEdit from 'src/pages/WebpathEdit.vue'
import WebpathLocks from 'src/pages/WebpathLocks.vue'
import WebpathLockNew from 'src/pages/WebpathLockNew.vue'
import WebpathPublications from 'src/pages/WebpathPublications.vue'
import WebpathPublicationNew from 'src/pages/WebpathPublicationNew.vue'
import WebpathPublicationEdit from 'src/pages/WebpathPublicationEdit.vue'
import WebpathPages from 'src/pages/WebpathPages.vue'
import WebpathPageNew from 'src/pages/WebpathPageNew.vue'
import WebpathPageEdit from 'src/pages/WebpathPageEdit.vue'
import WebpathPageLocks from 'src/pages/WebpathPageLocks.vue'
import WebpathPageLockNew from 'src/pages/WebpathPageLockNew.vue'
import WebpathPageCarousels from 'src/pages/WebpathPageCarousels.vue'
import WebpathPageCarouselNew from 'src/pages/WebpathPageCarouselNew.vue'
import WebpathPageCarouselEdit from 'src/pages/WebpathPageCarouselEdit.vue'
import WebpathPageBlocks from 'src/pages/WebpathPageBlocks.vue'
import WebpathPageBlockNew from 'src/pages/WebpathPageBlockNew.vue'
import WebpathPageBlockEdit from 'src/pages/WebpathPageBlockEdit.vue'
import WebpathPageLinks from 'src/pages/WebpathPageLinks.vue'
import WebpathPageLinkNew from 'src/pages/WebpathPageLinkNew.vue'
import WebpathPageLinkEdit from 'src/pages/WebpathPageLinkEdit.vue'
import WebpathPageLocalizations from 'src/pages/WebpathPageLocalizations.vue'
import WebpathPageLocalizationNew from 'src/pages/WebpathPageLocalizationNew.vue'
import WebpathPageLocalizationEdit from 'src/pages/WebpathPageLocalizationEdit.vue'
import WebpathPageMedia from 'src/pages/WebpathPageMedia.vue'
import WebpathPageMediaNew from 'src/pages/WebpathPageMediaNew.vue'
import WebpathPageMediaEdit from 'src/pages/WebpathPageMediaEdit.vue'
import WebpathPageMenus from 'src/pages/WebpathPageMenus.vue'
import WebpathPageMenuNew from 'src/pages/WebpathPageMenuNew.vue'
import WebpathPageMenuEdit from 'src/pages/WebpathPageMenuEdit.vue'
import WebpathPagePublications from 'src/pages/WebpathPagePublications.vue'
import WebpathPagePublicationNew from 'src/pages/WebpathPagePublicationNew.vue'
import WebpathPagePublicationEdit from 'src/pages/WebpathPagePublicationEdit.vue'
import WebpathPageRelated from 'src/pages/WebpathPageRelated.vue'
import WebpathPageRelatedNew from 'src/pages/WebpathPageRelatedNew.vue'
import WebpathPageRelatedEdit from 'src/pages/WebpathPageRelatedEdit.vue'

const routes = [
{
    path: '/',
    component: DashboardLayout,
    redirect: '/dashboard',
    children: [
    {
        path: 'dashboard',
        name: 'Dashboard',
        component: Overview,
        meta: {
            breadcrumb: 'Dashboard'
        }
    },

    // websites
    {
        path: 'websites',
        name: 'Websites',
        component: Websites,
        meta: {
            breadcrumb: {
                label: 'Websites',
                parent: 'Dashboard'
            }
        }
    },

    // webpaths
    {
        path: 'websites/:site_id/webpaths',
        name: 'Webpaths',
        component: Webpaths,
        meta: {
            breadcrumb: {
                label: 'Webpaths',
                parent: 'Websites'
            }
          },
    },
    {
        path: 'websites/:site_id/webpaths/new',
        name: 'WebpathNew',
        component: WebpathNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'Webpaths'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/edit',
        name: 'WebpathEdit',
        component: WebpathEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.webpath_id.toString(),
                  parent: 'Webpaths'
                }
            }
        },
    },

    // webpath locks
    {
        path: 'websites/:site_id/webpaths/:webpath_id/locks',
        name: 'WebpathLocks',
        component: WebpathLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'WebpathEdit'
            }
        }
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/locks/new',
        name: 'WebpathLockNew',
        component: WebpathLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathLocks'
            }
        },
    },

    // webpath publications
    {
        path: 'websites/:site_id/webpaths/:webpath_id/publications',
        name: 'WebpathPublications',
        component: WebpathPublications,
        meta: {
            breadcrumb: {
                label: 'Publications',
                parent: 'WebpathEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/publications/new',
        name: 'WebpathPublicationNew',
        component: WebpathPublicationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPublications'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/publications/:publication_id/edit',
        name: 'WebpathPublicationEdit',
        component: WebpathPublicationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.publication_id.toString(),
                  parent: 'WebpathPublications'
                }
            }
        },
    },

    // webpath pages
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages',
        name: 'WebpathPages',
        component: WebpathPages,
        meta: {
            breadcrumb: {
                label: 'Pages',
                parent: 'WebpathEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/edit',
        name: 'WebpathPageEdit',
        component: WebpathPageEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.page_id.toString(),
                  parent: 'WebpathPages'
                }
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/new',
        name: 'WebpathPageNew',
        component: WebpathPageNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPages'
            }
        },
    },

    // webpath page locks
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/locks',
        name: 'WebpathPageLocks',
        component: WebpathPageLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'WebpathPageEdit'
            }
        }
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/locks/new',
        name: 'WebpathPageLockNew',
        component: WebpathPageLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageLocks'
            }
        },
    },

    // webpath page blocks
     {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/blocks',
        name: 'WebpathPageBlocks',
        component: WebpathPageBlocks,
        meta: {
            breadcrumb: {
                label: 'Blocks',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/blocks/new',
        name: 'WebpathPageBlockNew',
        component: WebpathPageBlockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageBlocks'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/blocks/:block_id/edit',
        name: 'WebpathPageBlockEdit',
        component: WebpathPageBlockEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.block_id.toString(),
                  parent: 'WebpathPageBlocks'
                }
            }
        },
    },

    // webpath page carousels
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/carousels',
        name: 'WebpathPageCarousels',
        component: WebpathPageCarousels,
        meta: {
            breadcrumb: {
                label: 'Carousels',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/carousels/new',
        name: 'WebpathPageCarouselNew',
        component: WebpathPageCarouselNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageCarousels'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/carousels/:carousel_id/edit',
        name: 'WebpathPageCarouselEdit',
        component: WebpathPageCarouselEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_id.toString(),
                  parent: 'WebpathPageCarousels'
                }
            }
        },
    },

    // webpath page localizations
     {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/localizations',
        name: 'WebpathPageLocalizations',
        component: WebpathPageLocalizations,
        meta: {
            breadcrumb: {
                label: 'Localizations',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/localizations/new',
        name: 'WebpathPageLocalizationNew',
        component: WebpathPageLocalizationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageLocalizations'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/localizations/:localization_id/edit',
        name: 'WebpathPageLocalizationEdit',
        component: WebpathPageLocalizationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.localization_id.toString(),
                  parent: 'WebpathPageLocalizations'
                }
            }
        },
    },

    // webpath page links
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/links',
        name: 'WebpathPageLinks',
        component: WebpathPageLinks,
        meta: {
            breadcrumb: {
                label: 'Links',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/links/new',
        name: 'WebpathPageLinkNew',
        component: WebpathPageLinkNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageLinks'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/links/:link_id/edit',
        name: 'WebpathPageLinkEdit',
        component: WebpathPageLinkEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.link_id.toString(),
                  parent: 'WebpathPageLinks'
                }
            }
        },
    },

    // webpath page media
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/media',
        name: 'WebpathPageMedia',
        component: WebpathPageMedia,
        meta: {
            breadcrumb: {
                label: 'Media',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/media/new',
        name: 'WebpathPageMediaNew',
        component: WebpathPageMediaNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageMedia'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/media/:media_id/edit',
        name: 'WebpathPageMediaEdit',
        component: WebpathPageMediaEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.media_id.toString(),
                  parent: 'WebpathPageMedia'
                }
            }
        },
    },

    // webpath page menus
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/menus',
        name: 'WebpathPageMenus',
        component: WebpathPageMenus,
        meta: {
            breadcrumb: {
                label: 'Menus',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/menus/new',
        name: 'WebpathPageMenuNew',
        component: WebpathPageMenuNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageMenus'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/menus/:menu_id/edit',
        name: 'WebpathPageMenuEdit',
        component: WebpathPageMenuEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.menu_id.toString(),
                  parent: 'WebpathPageMenus'
                }
            }
        },
    },

    // webpath page publications
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/publications',
        name: 'WebpathPagePublications',
        component: WebpathPagePublications,
        meta: {
            breadcrumb: {
                label: 'Publications',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/publications/new',
        name: 'WebpathPagePublicationNew',
        component: WebpathPagePublicationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPagePublications'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/publications/:publication_id/edit',
        name: 'WebpathPagePublicationEdit',
        component: WebpathPagePublicationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.publication_id.toString(),
                  parent: 'WebpathPagePublications'
                }
            }
        },
    },

    // webpath page related
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/related',
        name: 'WebpathPageRelated',
        component: WebpathPageRelated,
        meta: {
            breadcrumb: {
                label: 'Related',
                parent: 'WebpathPageEdit'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/related/new',
        name: 'WebpathPageRelatedNew',
        component: WebpathPageRelatedNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'WebpathPageRelated'
            }
        },
    },
    {
        path: 'websites/:site_id/webpaths/:webpath_id/pages/:page_id/related/:related_id/edit',
        name: 'WebpathPageRelatedEdit',
        component: WebpathPageRelatedEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.related_id.toString(),
                  parent: 'WebpathPageRelated'
                }
            }
        },
    },

    // media
    {
        path: 'media',
        name: 'Media',
        component: Media,
        meta: {
            breadcrumb: {
                label: 'Media',
                parent: 'Dashboard'
            }
        }
    },
    {
        path: 'media/new',
        name: 'MediaNew',
        component: MediaNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'Media'
            }
        },
    },
    {
        path: 'media/:media_id/edit',
        name: 'MediaEdit',
        component: MediaEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.media_id.toString(),
                  parent: 'Media'
                }
            }
        },
    },

    // medias locks
    {
        path: 'media/:media_id/locks',
        name: 'MediaLocks',
        component: MediaLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'MediaEdit'
            }
        }
    },
    {
        path: 'media/:media_id/locks/new',
        name: 'MediaLockNew',
        component: MediaLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'MediaLocks'
            }
        },
    },

    // media collections
    {
        path: 'media-collections',
        name: 'MediaCollections',
        component: MediaCollections,
        meta: {
            breadcrumb: {
                label: 'Media collections',
                parent: 'Dashboard'
            }
        }
    },
    {
        path: 'media-collections/new',
        name: 'MediaCollectionNew',
        component: MediaCollectionNew,
        meta: {
            breadcrumb: {
                label: 'new',
                parent: 'MediaCollections'
            }
        }
    },
    {
        path: 'media-collections/:collection_id/edit',
        name: 'MediaCollectionEdit',
        component: MediaCollectionEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.collection_id.toString(),
                  parent: 'MediaCollections'
                };
            }
        },
    },

    // media collections locks
    {
        path: 'media-collections/:collection_id/locks',
        name: 'MediaCollectionLocks',
        component: MediaCollectionLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'MediaCollectionEdit'
            }
        }
    },
    {
        path: 'media-collections/:collection_id/locks/new',
        name: 'MediaCollectionLockNew',
        component: MediaCollectionLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'MediaCollectionLocks'
            }
        },
    },


    // media collection items
    {
        path: 'media-collections/:collection_id/items',
        name: 'MediaCollectionItems',
        component: MediaCollectionItems,
        meta: {
            breadcrumb: {
                label: 'Items',
                parent: 'MediaCollectionEdit'
            }
        }
    },
    {
        path: 'media-collections/:collection_id/items/new',
        name: 'MediaCollectionItemNew',
        component: MediaCollectionItemNew,
        meta: {
            breadcrumb: {
                label: 'new',
                parent: 'MediaCollectionItems'
            }
        }
    },
    {
        path: 'media-collections/:collection_id/items/:collection_item_id/edit',
        name: 'MediaCollectionItemEdit',
        component: MediaCollectionItemEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.collection_item_id.toString(),
                  parent: 'MediaCollectionItems'
                }
            }
        }
    },

    // menus
    {
        path: 'menus',
        name: 'Menus',
        component: Menus,
        meta: {
            breadcrumb: {
                label: 'Menus',
                parent: 'Dashboard'
            }
        }
    },
    {
        path: 'menus/new',
        name: 'MenuNew',
        component: MenuNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'Menus'
            }
        },
    },
    {
        path: 'menus/:menu_id/edit',
        name: 'MenuEdit',
        component: MenuEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.menu_id.toString(),
                  parent: 'Menus'
                }
            }
        },
    },

    // menu locks
    {
        path: 'menus/:menu_id/locks',
        name: 'MenuLocks',
        component: MenuLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'MenuEdit'
            }
        }
    },
    {
        path: 'menus/:menu_id/locks/new',
        name: 'MenuLockNew',
        component: MenuLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'MenuLocks'
            }
        },
    },

    // menu items
    {
        path: 'menus/:menu_id/items',
        name: 'MenuItems',
        component: MenuItems,
        meta: {
            breadcrumb: {
                label: 'Menu items',
                parent: 'MenuEdit'
            }
        }
    },
    {
        path: 'menus/:menu_id/items/new',
        name: 'MenuItemNew',
        component: MenuItemNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'MenuItems'
            }
        },
    },
    {
        path: 'menus/:menu_id/items/:menu_item_id/edit',
        name: 'MenuItemEdit',
        component: MenuItemEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.menu_item_id.toString(),
                  parent: 'MenuItems'
                }
            }
        },
    },

    // carousels
    {
        path: 'carousels',
        name: 'Carousels',
        component: Carousels,
        meta: {
            breadcrumb: {
                label: 'Carousels',
                parent: 'Dashboard'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/new',
        name: 'CarouselNew',
        component: CarouselNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'Carousels'
            }
          },
    },
    {
        path: 'carousels/:carousel_id/edit',
        name: 'CarouselEdit',
        component: CarouselEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_id.toString(),
                  parent: 'Carousels'
                }
            }
        },
    },

    // carousel items
    {
        path: 'carousels/:carousel_id/items',
        name: 'CarouselItems',
        component: CarouselItems,
        meta: {
            breadcrumb: {
                label: 'Items',
                parent: 'CarouselEdit'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/new',
        name: 'CarouselItemNew',
        component: CarouselItemNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'CarouselItems'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/edit',
        name: 'CarouselItemEdit',
        component: CarouselItemEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_item_id.toString(),
                  parent: 'CarouselItems'
                }
            }
        }
    },

    // carousel item links
      {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links',
        name: 'CarouselItemLinks',
        component: CarouselItemLinks,
        meta: {
            breadcrumb: {
                label: 'Links',
                parent: 'CarouselItemEdit'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links/new',
        name: 'CarouselItemLinkNew',
        component: CarouselItemLinkNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'CarouselItemLinks'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links/:carousel_item_link_id/edit',
        name: 'CarouselItemLinkEdit',
        component: CarouselItemLinkEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_item_link_id.toString(),
                  parent: 'CarouselItemLinks'
                }
            }
        }
    },

    // carousel item localizations
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/localizations',
        name: 'CarouselItemLocalizations',
        component: CarouselItemLocalizations,
        meta: {
            breadcrumb: {
                label: 'Localizations',
                parent: 'CarouselItemEdit'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/localizations/new',
        name: 'CarouselItemLocalizationNew',
        component: CarouselItemLocalizationNew,
        meta: {
            breadcrumb: {
              label: 'New',
              parent: 'CarouselItemLocalizations'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/localizations/:carousel_item_localization_id/edit',
        name: 'CarouselItemLocalizationEdit',
        component: CarouselItemLocalizationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_item_localization_id.toString(),
                  parent: 'CarouselItemLocalizations'
                }
            }
        }
    },

    // carousel item link localizations
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links/:carousel_item_link_id/localizations',
        name: 'CarouselItemLinkLocalizations',
        component: CarouselItemLinkLocalizations,
        meta: {
            breadcrumb: {
                label: 'Localizations',
                parent: 'CarouselItemLinkEdit'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links/:carousel_item_link_id/localizations/new',
        name: 'CarouselItemLinkLocalizationNew',
        component: CarouselItemLinkLocalizationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'CarouselItemLinkLocalizations'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/items/:carousel_item_id/links/:carousel_item_link_id/localizations/:carousel_item_link_localization_id/edit',
        name: 'CarouselItemLinkLocalizationEdit',
        component: CarouselItemLinkLocalizationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.carousel_item_link_localization_id.toString(),
                  parent: 'CarouselItemLinkLocalizations'
                }
            }
        }
    },

    // carousel locks
    {
        path: 'carousels/:carousel_id/locks',
        name: 'CarouselLocks',
        component: CarouselLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'CarouselEdit'
            }
        }
    },
    {
        path: 'carousels/:carousel_id/locks/new',
        name: 'CarouselLockNew',
        component: CarouselLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'CarouselLocks'
            }
        },
    },
    // publications
    {
        path: 'publications',
        name: 'Publications',
        component: Publications,
        meta: {
            breadcrumb: {
                label: 'Publications',
                parent: 'Dashboard'
            }
        }
    },
    {
        path: 'publications/new',
        name: 'PublicationNew',
        component: PublicationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'Publications'
            }
        },
    },
    {
        path: 'publications/:publication_id/edit',
        name: 'PublicationEdit',
        component: PublicationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.publication_id.toString(),
                  parent: 'Publications'
                }
            }
        },
    },

    // publication locks
    {
        path: 'publications/:publication_id/locks',
        name: 'PublicationLocks',
        component: PublicationLocks,
        meta: {
            breadcrumb: {
                label: 'Locks',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/locks/new',
        name: 'PublicationLockNew',
        component: PublicationLockNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationLocks'
            }
        },
    },

    // publication attachments
    {
        path: 'publications/:publication_id/attachments',
        name: 'PublicationAttachments',
        component: PublicationAttachments,
        meta: {
            breadcrumb: {
                label: 'Attachments',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/attachments/new',
        name: 'PublicationAttachmentNew',
        component: PublicationAttachmentNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationAttachments'
            }
        }
    },
    {
        path: 'publications/:publication_id/attachments/:attachment_id/edit',
        name: 'PublicationAttachmentEdit',
        component: PublicationAttachmentEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.attachment_id.toString(),
                  parent: 'PublicationAttachments'
                }
            }
        }
    },

    // publication links
    {
        path: 'publications/:publication_id/links',
        name: 'PublicationLinks',
        component: PublicationLinks,
        meta: {
            breadcrumb: {
                label: 'Links',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/links/new',
        name: 'PublicationLinkNew',
        component: PublicationLinkNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationLinks'
            }
        }
    },
    {
        path: 'publications/:publication_id/links/:link_id/edit',
        name: 'PublicationLinkEdit',
        component: PublicationLinkEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.link_id.toString(),
                  parent: 'PublicationLinks'
                }
            }
        }
    },

    // publication galleries
    {
        path: 'publications/:publication_id/galleries',
        name: 'PublicationGalleries',
        component: PublicationGalleries,
        meta: {
            breadcrumb: {
                label: 'Galleries',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/galleries/new',
        name: 'PublicationGalleryNew',
        component: PublicationGalleryNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationGalleries'
            }
        }
    },
    {
        path: 'publications/:publication_id/galleries/:gallery_id/edit',
        name: 'PublicationGalleryEdit',
        component: PublicationGalleryEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.gallery_id.toString(),
                  parent: 'PublicationGalleries'
                }
            }
        }
    },

    // publication localizations
    {
        path: 'publications/:publication_id/localizations',
        name: 'PublicationLocalizations',
        component: PublicationLocalizations,
        meta: {
            breadcrumb: {
                label: 'Localizations',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/localizations/new',
        name: 'PublicationLocalizationNew',
        component: PublicationLocalizationNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationLocalizations'
            }
        }
    },
    {
        path: 'publications/:publication_id/localizations/:localization_id/edit',
        name: 'PublicationLocalizationEdit',
        component: PublicationLocalizationEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.localization_id.toString(),
                  parent: 'PublicationLocalizations'
                }
            }
        }
    },

    // publication related
    {
        path: 'publications/:publication_id/related',
        name: 'PublicationRelated',
        component: PublicationRelated,
        meta: {
            breadcrumb: {
                label: 'Related',
                parent: 'PublicationEdit'
            }
        }
    },
    {
        path: 'publications/:publication_id/related/new',
        name: 'PublicationRelatedNew',
        component: PublicationRelatedNew,
        meta: {
            breadcrumb: {
                label: 'New',
                parent: 'PublicationRelated'
            }
        }
    },
    {
        path: 'publications/:publication_id/related/:related_id/edit',
        name: 'PublicationRelatedEdit',
        component: PublicationRelatedEdit,
        meta: {
            breadcrumb() {
                return {
                  label: this.$route.params.related_id.toString(),
                  parent: 'PublicationRelated'
                }
            }
        }
    },
    ]
  },
  { path: '*', component: Error404 }
]

/**
 * Asynchronously load view (Webpack Lazy loading compatible)
 * The specified component must be inside the Views folder
 * @param  {string} name  the filename (basename) of the view to load.
function view(name) {
   var res= require('../components/Dashboard/Views/' + name + '.vue');
   return res;
};**/

export default routes
