# Serving Documentation

Serving is a modern, dependency-injection-driven ASGI web framework built on Starlette. It emphasizes configuration, type-safe routing, forms with CSRF protection, and a small but composable core.

- Requires Python 3.13+
- Package name: 
- CLI entrypoint: 

## What You’ll Find Here

- Getting started: install, minimal config, run the server
- Concepts: configuration, routing, DI, forms/CSRF, middleware, error pages, auth
- Reference: CLI flags, response helpers, return types
- Guides: step-by-step walkthroughs for common tasks

## Quick Links

- [Getting Started](getting-started.md)
- [Configuration](configuration.md)
- [Routing](routing.md)
- [Dependency Injection](dependency-injection.md)
- [Forms & CSRF](forms.md)
- [Authentication](authentication.md)
- [Sessions](sessions.md)
- [Events](usage-guide.md#8-events)
- [Error Handling & Theming](error-handling.md)
- [Middleware](middleware.md)
- [Response Helpers](response.md)
- [CLI](cli.md)
- [Testing](testing.md)

## Guides

- [Hello World](guides/hello-world.md)
- [Config & Environments](guides/config-and-envs.md)
- [Forms & CSRF Quickstart](guides/forms-and-csrf.md)
- [Custom Auth Provider](guides/custom-auth-provider.md)
- [Error Pages & Theming](guides/error-pages-and-theming.md)

---

If you’re new, start with Getting Started, then dive into Routing and Configuration. The guides are practical, copy-paste friendly recipes.
