"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StepFunctionsIntegration=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),core_1=require("../../../core"),integration_1=require("../integration"),model_1=require("../model"),aws_1=require("./aws");class StepFunctionsIntegration{static startExecution(stateMachine,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_IStateMachine(stateMachine),jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_StepFunctionsExecutionIntegrationOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.startExecution),error}return new StepFunctionsExecutionIntegration(stateMachine,options)}}exports.StepFunctionsIntegration=StepFunctionsIntegration,_a=JSII_RTTI_SYMBOL_1,StepFunctionsIntegration[_a]={fqn:"aws-cdk-lib.aws_apigateway.StepFunctionsIntegration",version:"2.42.0"};class StepFunctionsExecutionIntegration extends aws_1.AwsIntegration{constructor(stateMachine,options={}){super({service:"states",action:"StartSyncExecution",options:{credentialsRole:options.credentialsRole,integrationResponses:integrationResponse(),passthroughBehavior:integration_1.PassthroughBehavior.NEVER,requestTemplates:requestTemplates(stateMachine,options),...options}}),this.stateMachine=stateMachine}bind(method){const bindResult=super.bind(method),credentialsRole=bindResult.options?.credentialsRole??new iam.Role(method,"StartSyncExecutionRole",{assumedBy:new iam.ServicePrincipal("apigateway.amazonaws.com")});this.stateMachine.grantStartSyncExecution(credentialsRole);let stateMachineName;if(this.stateMachine instanceof sfn.StateMachine){if(this.stateMachine.stateMachineType!==sfn.StateMachineType.EXPRESS)throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');stateMachineName=this.stateMachine.node.defaultChild.stateMachineName}else stateMachineName=`StateMachine-${this.stateMachine.stack.node.addr}`;let deploymentToken;stateMachineName!==void 0&&!core_1.Token.isUnresolved(stateMachineName)&&(deploymentToken=JSON.stringify({stateMachineName}));for(const methodResponse of METHOD_RESPONSES)method.addMethodResponse(methodResponse);return{...bindResult,options:{...bindResult.options,credentialsRole},deploymentToken}}}function integrationResponse(){const errorResponse=[{selectionPattern:"4\\d{2}",statusCode:"400",responseTemplates:{"application/json":`{
            "error": "Bad request!"
          }`}},{selectionPattern:"5\\d{2}",statusCode:"500",responseTemplates:{"application/json":`"error": $input.path('$.error')`}}];return[{statusCode:"200",responseTemplates:{"application/json":["#set($inputRoot = $input.path('$'))",`#if($input.path('$.status').toString().equals("FAILED"))`,"#set($context.responseOverride.status = 500)","{",`"error": "$input.path('$.error')",`,`"cause": "$input.path('$.cause')"`,"}","#else","$input.path('$.output')","#end"].join(`
`)}},...errorResponse]}function requestTemplates(stateMachine,options){return{"application/json":templateString(stateMachine,options)}}function templateString(stateMachine,options){let templateStr,requestContextStr="";const includeHeader=options.headers??!1,includeQueryString=options.querystring??!0,includePath=options.path??!0,includeAuthorizer=options.authorizer??!1;return options.requestContext&&Object.keys(options.requestContext).length>0&&(requestContextStr=requestContext(options.requestContext)),templateStr=fs.readFileSync(path.join(__dirname,"stepfunctions.vtl"),{encoding:"utf-8"}),templateStr=templateStr.replace("%STATEMACHINE%",stateMachine.stateMachineArn),templateStr=templateStr.replace("%INCLUDE_HEADERS%",String(includeHeader)),templateStr=templateStr.replace("%INCLUDE_QUERYSTRING%",String(includeQueryString)),templateStr=templateStr.replace("%INCLUDE_PATH%",String(includePath)),templateStr=templateStr.replace("%INCLUDE_AUTHORIZER%",String(includeAuthorizer)),templateStr=templateStr.replace("%REQUESTCONTEXT%",requestContextStr),templateStr}function requestContext(requestContextObj){const context={accountId:requestContextObj?.accountId?"$context.identity.accountId":void 0,apiId:requestContextObj?.apiId?"$context.apiId":void 0,apiKey:requestContextObj?.apiKey?"$context.identity.apiKey":void 0,authorizerPrincipalId:requestContextObj?.authorizerPrincipalId?"$context.authorizer.principalId":void 0,caller:requestContextObj?.caller?"$context.identity.caller":void 0,cognitoAuthenticationProvider:requestContextObj?.cognitoAuthenticationProvider?"$context.identity.cognitoAuthenticationProvider":void 0,cognitoAuthenticationType:requestContextObj?.cognitoAuthenticationType?"$context.identity.cognitoAuthenticationType":void 0,cognitoIdentityId:requestContextObj?.cognitoIdentityId?"$context.identity.cognitoIdentityId":void 0,cognitoIdentityPoolId:requestContextObj?.cognitoIdentityPoolId?"$context.identity.cognitoIdentityPoolId":void 0,httpMethod:requestContextObj?.httpMethod?"$context.httpMethod":void 0,stage:requestContextObj?.stage?"$context.stage":void 0,sourceIp:requestContextObj?.sourceIp?"$context.identity.sourceIp":void 0,user:requestContextObj?.user?"$context.identity.user":void 0,userAgent:requestContextObj?.userAgent?"$context.identity.userAgent":void 0,userArn:requestContextObj?.userArn?"$context.identity.userArn":void 0,requestId:requestContextObj?.requestId?"$context.requestId":void 0,resourceId:requestContextObj?.resourceId?"$context.resourceId":void 0,resourcePath:requestContextObj?.resourcePath?"$context.resourcePath":void 0},contextAsString=JSON.stringify(context),doublequotes='"',replaceWith="@@";return contextAsString.split(doublequotes).join(replaceWith)}const METHOD_RESPONSES=[{statusCode:"200",responseModels:{"application/json":model_1.Model.EMPTY_MODEL}},{statusCode:"400",responseModels:{"application/json":model_1.Model.ERROR_MODEL}},{statusCode:"500",responseModels:{"application/json":model_1.Model.ERROR_MODEL}}];
//# sourceMappingURL=stepfunctions.js.map
