"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ServiceNamespace=exports.ScalableTarget=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),core_1=require("../../core"),applicationautoscaling_generated_1=require("./applicationautoscaling.generated"),step_scaling_policy_1=require("./step-scaling-policy"),target_tracking_scaling_policy_1=require("./target-tracking-scaling-policy");class ScalableTarget extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.actions=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_ScalableTargetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ScalableTarget),error}core_1.withResolved(props.maxCapacity,max=>{if(max<0)throw new RangeError(`maxCapacity cannot be negative, got: ${props.maxCapacity}`)}),core_1.withResolved(props.minCapacity,min=>{if(min<0)throw new RangeError(`minCapacity cannot be negative, got: ${props.minCapacity}`)}),core_1.withResolved(props.minCapacity,props.maxCapacity,(min,max)=>{if(max<min)throw new RangeError(`minCapacity (${props.minCapacity}) should be lower than maxCapacity (${props.maxCapacity})`)}),this.role=props.role||new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("application-autoscaling.amazonaws.com")});const resource=new applicationautoscaling_generated_1.CfnScalableTarget(this,"Resource",{maxCapacity:props.maxCapacity,minCapacity:props.minCapacity,resourceId:props.resourceId,roleArn:this.role.roleArn,scalableDimension:props.scalableDimension,scheduledActions:core_1.Lazy.any({produce:()=>this.actions},{omitEmptyArray:!0}),serviceNamespace:props.serviceNamespace});this.scalableTargetId=resource.ref}static fromScalableTargetId(scope,id,scalableTargetId){class Import extends core_1.Resource{constructor(){super(...arguments),this.scalableTargetId=scalableTargetId}}return new Import(scope,id)}addToRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToRolePolicy),error}this.role.addToPrincipalPolicy(statement)}scaleOnSchedule(id,action){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_ScalingSchedule(action)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.scaleOnSchedule),error}if(action.minCapacity===void 0&&action.maxCapacity===void 0)throw new Error(`You must supply at least one of minCapacity or maxCapacity, got ${JSON.stringify(action)}`);action.schedule._bind(this),this.actions.push({scheduledActionName:id,schedule:action.schedule.expressionString,startTime:action.startTime,endTime:action.endTime,scalableTargetAction:{maxCapacity:action.maxCapacity,minCapacity:action.minCapacity}})}scaleOnMetric(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_BasicStepScalingPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.scaleOnMetric),error}return new step_scaling_policy_1.StepScalingPolicy(this,id,{...props,scalingTarget:this})}scaleToTrackMetric(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_BasicTargetTrackingScalingPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.scaleToTrackMetric),error}return new target_tracking_scaling_policy_1.TargetTrackingScalingPolicy(this,id,{...props,scalingTarget:this})}}exports.ScalableTarget=ScalableTarget,_a=JSII_RTTI_SYMBOL_1,ScalableTarget[_a]={fqn:"aws-cdk-lib.aws_applicationautoscaling.ScalableTarget",version:"2.42.0"};var ServiceNamespace;(function(ServiceNamespace2){ServiceNamespace2.ECS="ecs",ServiceNamespace2.ELASTIC_MAP_REDUCE="elasticmapreduce",ServiceNamespace2.EC2="ec2",ServiceNamespace2.APPSTREAM="appstream",ServiceNamespace2.DYNAMODB="dynamodb",ServiceNamespace2.RDS="rds",ServiceNamespace2.SAGEMAKER="sagemaker",ServiceNamespace2.CUSTOM_RESOURCE="custom-resource",ServiceNamespace2.LAMBDA="lambda",ServiceNamespace2.COMPREHEND="comprehend",ServiceNamespace2.KAFKA="kafka",ServiceNamespace2.ELASTICACHE="elasticache"})(ServiceNamespace=exports.ServiceNamespace||(exports.ServiceNamespace={}));
//# sourceMappingURL=scalable-target.js.map
