"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.findAlarmThresholds=exports.normalizeIntervals=void 0;function normalizeIntervals(intervals,changesAreAbsolute){const full=orderAndCompleteIntervals(intervals);return makeGapsUndefined(full),changesAreAbsolute||makeZerosUndefined(full),combineUndefineds(full),validateAtMostOneUndefined(full),full}exports.normalizeIntervals=normalizeIntervals;function orderAndCompleteIntervals(intervals){if(intervals.length<2)throw new Error("Require at least 2 intervals");for(const interval of intervals)if(interval.lower===void 0&&interval.upper===void 0)throw new Error(`Must supply at least one of 'upper' or 'lower', got: ${JSON.stringify(interval)}`);for(intervals=intervals.map(x=>({...x})),intervals.sort(comparatorFromKey(x=>x.lower??x.upper));propagateBounds(intervals););const lastIndex=intervals.length-1;intervals[0].lower===void 0&&(intervals[0]={...intervals[0],lower:0}),intervals[lastIndex].upper===void 0&&(intervals[lastIndex]={...intervals[lastIndex],upper:1/0});for(const interval of intervals)if(interval.lower===void 0||interval.upper===void 0)throw new Error(`Could not determine the lower and upper bounds for ${JSON.stringify(interval)}`);const completeIntervals=intervals;for(let i=0;i<completeIntervals.length-1;i++)if(overlap(completeIntervals[i],completeIntervals[i+1]))throw new Error(`Two intervals overlap: ${JSON.stringify(completeIntervals[i])} and ${JSON.stringify(completeIntervals[i+1])}`);return completeIntervals}function makeGapsUndefined(intervals){intervals[0].lower!==0&&intervals.splice(0,0,{lower:0,upper:intervals[0].lower,change:void 0}),last(intervals).upper!==1/0&&intervals.push({lower:last(intervals).upper,upper:1/0,change:void 0});let i=1;for(;i<intervals.length;)intervals[i-1].upper<intervals[i].lower?intervals.splice(i,0,{lower:intervals[i-1].upper,upper:intervals[i].lower,change:void 0}):i++}function makeZerosUndefined(intervals){for(let i=0;i<intervals.length;++i){const interval=intervals[i];interval.change===0&&(intervals[i]={...interval,change:void 0})}}function combineUndefineds(intervals){let i=0;for(;i<intervals.length-1;)intervals[i].change===void 0&&intervals[i+1].change===void 0?(intervals[i]={...intervals[i],upper:intervals[i+1].upper},intervals.splice(i+1,1)):i++}function validateAtMostOneUndefined(intervals){const undef=intervals.filter(x=>x.change===void 0);if(undef.length>1)throw new Error(`Can have at most one no-change interval, got ${JSON.stringify(undef)}`)}function comparatorFromKey(keyFn){return(a,b)=>{const keyA=keyFn(a),keyB=keyFn(b);return keyA<keyB?-1:keyA===keyB?0:1}}function propagateBounds(intervals){let ret=!1;for(let i=0;i<intervals.length-1;i++)intervals[i].upper!==void 0&&intervals[i+1].lower===void 0&&(intervals[i+1]={...intervals[i+1],lower:intervals[i].upper},ret=!0);for(let i=intervals.length-1;i>=1;i--)intervals[i].lower!==void 0&&intervals[i-1].upper===void 0&&(intervals[i-1]={...intervals[i-1],upper:intervals[i].lower},ret=!0);return ret}function overlap(a,b){return a.lower<b.upper&&a.upper>b.lower}function last(xs){return xs[xs.length-1]}function findAlarmThresholds(intervals){const gapIndex=intervals.findIndex(x=>x.change===void 0);if(gapIndex!==-1)return{lowerAlarmIntervalIndex:gapIndex>0?gapIndex-1:void 0,upperAlarmIntervalIndex:gapIndex<intervals.length-1?gapIndex+1:void 0};if(intervals.length===1)return{upperAlarmIntervalIndex:0};const middleIndex=Math.floor(intervals.length/2);return{lowerAlarmIntervalIndex:middleIndex-1,upperAlarmIntervalIndex:middleIndex}}exports.findAlarmThresholds=findAlarmThresholds;
//# sourceMappingURL=interval-utils.js.map
