"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DnsValidatedCertificate=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),iam=require("../../aws-iam"),lambda=require("../../aws-lambda"),cdk=require("../../core"),certificate_base_1=require("./certificate-base");class DnsValidatedCertificate extends certificate_base_1.CertificateBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_certificatemanager_DnsValidatedCertificateProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DnsValidatedCertificate),error}if(this.region=props.region,this.domainName=props.domainName,this.domainName.length>64)throw new Error("Domain name must be 64 characters or less");this.normalizedZoneName=props.hostedZone.zoneName,this.normalizedZoneName.endsWith(".")&&(this.normalizedZoneName=this.normalizedZoneName.substring(0,this.normalizedZoneName.length-1)),this.hostedZoneId=props.hostedZone.hostedZoneId.replace(/^\/hostedzone\//,""),this.tags=new cdk.TagManager(cdk.TagType.MAP,"AWS::CertificateManager::Certificate");let certificateTransparencyLoggingPreference;props.transparencyLoggingEnabled!==void 0&&(certificateTransparencyLoggingPreference=props.transparencyLoggingEnabled?"ENABLED":"DISABLED");const requestorFunction=new lambda.Function(this,"CertificateRequestorFunction",{code:lambda.Code.fromAsset(path.resolve(__dirname,"..","lambda-packages","dns_validated_certificate_handler","lib")),handler:"index.certificateRequestHandler",runtime:lambda.Runtime.NODEJS_14_X,timeout:cdk.Duration.minutes(15),role:props.customResourceRole});requestorFunction.addToRolePolicy(new iam.PolicyStatement({actions:["acm:RequestCertificate","acm:DescribeCertificate","acm:DeleteCertificate","acm:AddTagsToCertificate"],resources:["*"]})),requestorFunction.addToRolePolicy(new iam.PolicyStatement({actions:["route53:GetChange"],resources:["*"]})),requestorFunction.addToRolePolicy(new iam.PolicyStatement({actions:["route53:changeResourceRecordSets"],resources:[`arn:${cdk.Stack.of(requestorFunction).partition}:route53:::hostedzone/${this.hostedZoneId}`]}));const certificate=new cdk.CustomResource(this,"CertificateRequestorResource",{serviceToken:requestorFunction.functionArn,properties:{DomainName:props.domainName,SubjectAlternativeNames:cdk.Lazy.list({produce:()=>props.subjectAlternativeNames},{omitEmpty:!0}),CertificateTransparencyLoggingPreference:certificateTransparencyLoggingPreference,HostedZoneId:this.hostedZoneId,Region:props.region,Route53Endpoint:props.route53Endpoint,CleanupRecords:props.cleanupRoute53Records?"true":void 0,Tags:cdk.Lazy.list({produce:()=>this.tags.renderTags()})}});this.certificateArn=certificate.getAtt("Arn").toString(),this.node.addValidation({validate:()=>this.validateDnsValidatedCertificate()})}validateDnsValidatedCertificate(){const errors=[];return!cdk.Token.isUnresolved(this.normalizedZoneName)&&this.domainName!==this.normalizedZoneName&&!this.domainName.endsWith("."+this.normalizedZoneName)&&errors.push(`DNS zone ${this.normalizedZoneName} is not authoritative for certificate domain name ${this.domainName}`),errors}}exports.DnsValidatedCertificate=DnsValidatedCertificate,_a=JSII_RTTI_SYMBOL_1,DnsValidatedCertificate[_a]={fqn:"aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate",version:"2.42.0"};
//# sourceMappingURL=dns-validated-certificate.js.map
