"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LambdaEdgeEventType=exports.CachedMethods=exports.AllowedMethods=exports.SecurityPolicyProtocol=exports.SSLMethod=exports.OriginProtocolPolicy=exports.ViewerProtocolPolicy=exports.PriceClass=exports.HttpVersion=exports.Distribution=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),s3=require("../../aws-s3"),core_1=require("../../core"),cx_api_1=require("../../cx-api"),constructs_1=require("constructs"),cloudfront_generated_1=require("./cloudfront.generated"),cache_behavior_1=require("./private/cache-behavior");class Distribution extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.additionalBehaviors=[],this.boundOrigins=[],this.originGroups=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_DistributionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Distribution),error}if(props.certificate){const certificateRegion=core_1.Stack.of(this).splitArn(props.certificate.certificateArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).region;if(!core_1.Token.isUnresolved(certificateRegion)&&certificateRegion!=="us-east-1")throw new Error(`Distribution certificates must be in the us-east-1 region and the certificate you provided is in ${certificateRegion}.`);if((props.domainNames??[]).length===0)throw new Error("Must specify at least one domain name to use a certificate with a distribution")}const originId=this.addOrigin(props.defaultBehavior.origin);this.defaultBehavior=new cache_behavior_1.CacheBehavior(originId,{pathPattern:"*",...props.defaultBehavior}),props.additionalBehaviors&&Object.entries(props.additionalBehaviors).forEach(([pathPattern,behaviorOptions])=>{this.addBehavior(pathPattern,behaviorOptions.origin,behaviorOptions)}),this.certificate=props.certificate,this.errorResponses=props.errorResponses??[];const trimmedComment=props.comment&&props.comment.length>128?`${props.comment.slice(0,128-3)}...`:props.comment,distribution=new cloudfront_generated_1.CfnDistribution(this,"Resource",{distributionConfig:{enabled:props.enabled??!0,origins:core_1.Lazy.any({produce:()=>this.renderOrigins()}),originGroups:core_1.Lazy.any({produce:()=>this.renderOriginGroups()}),defaultCacheBehavior:this.defaultBehavior._renderBehavior(),aliases:props.domainNames,cacheBehaviors:core_1.Lazy.any({produce:()=>this.renderCacheBehaviors()}),comment:trimmedComment,customErrorResponses:this.renderErrorResponses(),defaultRootObject:props.defaultRootObject,httpVersion:props.httpVersion??HttpVersion.HTTP2,ipv6Enabled:props.enableIpv6??!0,logging:this.renderLogging(props),priceClass:props.priceClass??void 0,restrictions:this.renderRestrictions(props.geoRestriction),viewerCertificate:this.certificate?this.renderViewerCertificate(this.certificate,props.minimumProtocolVersion,props.sslSupportMethod):void 0,webAclId:props.webAclId}});this.domainName=distribution.attrDomainName,this.distributionDomainName=distribution.attrDomainName,this.distributionId=distribution.ref}static fromDistributionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_DistributionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDistributionAttributes),error}return new class extends core_1.Resource{constructor(){super(scope,id),this.domainName=attrs.domainName,this.distributionDomainName=attrs.domainName,this.distributionId=attrs.distributionId}}}addBehavior(pathPattern,origin,behaviorOptions={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_IOrigin(origin),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_AddBehaviorOptions(behaviorOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addBehavior),error}if(pathPattern==="*")throw new Error("Only the default behavior can have a path pattern of '*'");const originId=this.addOrigin(origin);this.additionalBehaviors.push(new cache_behavior_1.CacheBehavior(originId,{pathPattern,...behaviorOptions}))}addOrigin(origin,isFailoverOrigin=!1){const existingOrigin=this.boundOrigins.find(boundOrigin=>boundOrigin.origin===origin);if(existingOrigin)return existingOrigin.originGroupId??existingOrigin.originId;{const originIndex=this.boundOrigins.length+1,scope=new constructs_1.Construct(this,`Origin${originIndex}`),originId=core_1.Names.uniqueId(scope).slice(-128),originBindConfig=origin.bind(scope,{originId});if(!originBindConfig.failoverConfig)this.boundOrigins.push({origin,originId,...originBindConfig});else{if(isFailoverOrigin)throw new Error("An Origin cannot use an Origin with its own failover configuration as its fallback origin!");const groupIndex=this.originGroups.length+1,originGroupId=core_1.Names.uniqueId(new constructs_1.Construct(this,`OriginGroup${groupIndex}`)).slice(-128);this.boundOrigins.push({origin,originId,originGroupId,...originBindConfig});const failoverOriginId=this.addOrigin(originBindConfig.failoverConfig.failoverOrigin,!0);return this.addOriginGroup(originGroupId,originBindConfig.failoverConfig.statusCodes,originId,failoverOriginId),originGroupId}return originId}}addOriginGroup(originGroupId,statusCodes,originId,failoverOriginId){if(statusCodes=statusCodes??[500,502,503,504],statusCodes.length===0)throw new Error("fallbackStatusCodes cannot be empty");this.originGroups.push({failoverCriteria:{statusCodes:{items:statusCodes,quantity:statusCodes.length}},id:originGroupId,members:{items:[{originId},{originId:failoverOriginId}],quantity:2}})}renderOrigins(){const renderedOrigins=[];return this.boundOrigins.forEach(boundOrigin=>{boundOrigin.originProperty&&renderedOrigins.push(boundOrigin.originProperty)}),renderedOrigins}renderOriginGroups(){return this.originGroups.length===0?void 0:{items:this.originGroups,quantity:this.originGroups.length}}renderCacheBehaviors(){if(this.additionalBehaviors.length!==0)return this.additionalBehaviors.map(behavior=>behavior._renderBehavior())}renderErrorResponses(){if(this.errorResponses.length!==0)return this.errorResponses.map(errorConfig=>{if(!errorConfig.responseHttpStatus&&!errorConfig.ttl&&!errorConfig.responsePagePath)throw new Error("A custom error response without either a 'responseHttpStatus', 'ttl' or 'responsePagePath' is not valid.");return{errorCachingMinTtl:errorConfig.ttl?.toSeconds(),errorCode:errorConfig.httpStatus,responseCode:errorConfig.responsePagePath?errorConfig.responseHttpStatus??errorConfig.httpStatus:errorConfig.responseHttpStatus,responsePagePath:errorConfig.responsePagePath}})}renderLogging(props){if(!props.enableLogging&&!props.logBucket)return;if(props.enableLogging===!1&&props.logBucket)throw new Error("Explicitly disabled logging but provided a logging bucket.");return{bucket:(props.logBucket??new s3.Bucket(this,"LoggingBucket",{encryption:s3.BucketEncryption.S3_MANAGED})).bucketRegionalDomainName,includeCookies:props.logIncludesCookies,prefix:props.logFilePrefix}}renderRestrictions(geoRestriction){return geoRestriction?{geoRestriction:{restrictionType:geoRestriction.restrictionType,locations:geoRestriction.locations}}:void 0}renderViewerCertificate(certificate,minimumProtocolVersionProp,sslSupportMethodProp){const defaultVersion=core_1.FeatureFlags.of(this).isEnabled(cx_api_1.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021)?SecurityPolicyProtocol.TLS_V1_2_2021:SecurityPolicyProtocol.TLS_V1_2_2019,minimumProtocolVersion=minimumProtocolVersionProp??defaultVersion,sslSupportMethod=sslSupportMethodProp??SSLMethod.SNI;return{acmCertificateArn:certificate.certificateArn,minimumProtocolVersion,sslSupportMethod}}}exports.Distribution=Distribution,_a=JSII_RTTI_SYMBOL_1,Distribution[_a]={fqn:"aws-cdk-lib.aws_cloudfront.Distribution",version:"2.42.0"};var HttpVersion;(function(HttpVersion2){HttpVersion2.HTTP1_1="http1.1",HttpVersion2.HTTP2="http2",HttpVersion2.HTTP2_AND_3="http2and3",HttpVersion2.HTTP3="http3"})(HttpVersion=exports.HttpVersion||(exports.HttpVersion={}));var PriceClass;(function(PriceClass2){PriceClass2.PRICE_CLASS_100="PriceClass_100",PriceClass2.PRICE_CLASS_200="PriceClass_200",PriceClass2.PRICE_CLASS_ALL="PriceClass_All"})(PriceClass=exports.PriceClass||(exports.PriceClass={}));var ViewerProtocolPolicy;(function(ViewerProtocolPolicy2){ViewerProtocolPolicy2.HTTPS_ONLY="https-only",ViewerProtocolPolicy2.REDIRECT_TO_HTTPS="redirect-to-https",ViewerProtocolPolicy2.ALLOW_ALL="allow-all"})(ViewerProtocolPolicy=exports.ViewerProtocolPolicy||(exports.ViewerProtocolPolicy={}));var OriginProtocolPolicy;(function(OriginProtocolPolicy2){OriginProtocolPolicy2.HTTP_ONLY="http-only",OriginProtocolPolicy2.MATCH_VIEWER="match-viewer",OriginProtocolPolicy2.HTTPS_ONLY="https-only"})(OriginProtocolPolicy=exports.OriginProtocolPolicy||(exports.OriginProtocolPolicy={}));var SSLMethod;(function(SSLMethod2){SSLMethod2.SNI="sni-only",SSLMethod2.VIP="vip"})(SSLMethod=exports.SSLMethod||(exports.SSLMethod={}));var SecurityPolicyProtocol;(function(SecurityPolicyProtocol2){SecurityPolicyProtocol2.SSL_V3="SSLv3",SecurityPolicyProtocol2.TLS_V1="TLSv1",SecurityPolicyProtocol2.TLS_V1_2016="TLSv1_2016",SecurityPolicyProtocol2.TLS_V1_1_2016="TLSv1.1_2016",SecurityPolicyProtocol2.TLS_V1_2_2018="TLSv1.2_2018",SecurityPolicyProtocol2.TLS_V1_2_2019="TLSv1.2_2019",SecurityPolicyProtocol2.TLS_V1_2_2021="TLSv1.2_2021"})(SecurityPolicyProtocol=exports.SecurityPolicyProtocol||(exports.SecurityPolicyProtocol={}));class AllowedMethods{constructor(methods){this.methods=methods}}exports.AllowedMethods=AllowedMethods,_b=JSII_RTTI_SYMBOL_1,AllowedMethods[_b]={fqn:"aws-cdk-lib.aws_cloudfront.AllowedMethods",version:"2.42.0"},AllowedMethods.ALLOW_GET_HEAD=new AllowedMethods(["GET","HEAD"]),AllowedMethods.ALLOW_GET_HEAD_OPTIONS=new AllowedMethods(["GET","HEAD","OPTIONS"]),AllowedMethods.ALLOW_ALL=new AllowedMethods(["GET","HEAD","OPTIONS","PUT","PATCH","POST","DELETE"]);class CachedMethods{constructor(methods){this.methods=methods}}exports.CachedMethods=CachedMethods,_c=JSII_RTTI_SYMBOL_1,CachedMethods[_c]={fqn:"aws-cdk-lib.aws_cloudfront.CachedMethods",version:"2.42.0"},CachedMethods.CACHE_GET_HEAD=new CachedMethods(["GET","HEAD"]),CachedMethods.CACHE_GET_HEAD_OPTIONS=new CachedMethods(["GET","HEAD","OPTIONS"]);var LambdaEdgeEventType;(function(LambdaEdgeEventType2){LambdaEdgeEventType2.ORIGIN_REQUEST="origin-request",LambdaEdgeEventType2.ORIGIN_RESPONSE="origin-response",LambdaEdgeEventType2.VIEWER_REQUEST="viewer-request",LambdaEdgeEventType2.VIEWER_RESPONSE="viewer-response"})(LambdaEdgeEventType=exports.LambdaEdgeEventType||(exports.LambdaEdgeEventType={}));
//# sourceMappingURL=distribution.js.map
