"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EdgeFunction=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),iam=require("../../../aws-iam"),lambda=require("../../../aws-lambda"),ssm=require("../../../aws-ssm"),core_1=require("../../../core");class EdgeFunction extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.isBoundToVpc=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_experimental_EdgeFunctionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EdgeFunction),error}const regionIsUsEast1=!core_1.Token.isUnresolved(this.env.region)&&this.env.region==="us-east-1",{edgeFunction,edgeArn}=regionIsUsEast1?this.createInRegionFunction(props):this.createCrossRegionFunction(id,props);this.edgeArn=edgeArn,this.functionArn=edgeArn,this._edgeFunction=edgeFunction,this.functionName=this._edgeFunction.functionName,this.grantPrincipal=this._edgeFunction.role,this.permissionsNode=this._edgeFunction.permissionsNode,this.version=lambda.extractQualifierFromArn(this.functionArn),this.architecture=this._edgeFunction.architecture,this.resourceArnsForGrantInvoke=this._edgeFunction.resourceArnsForGrantInvoke,this.node.defaultChild=this._edgeFunction}get lambda(){return this._edgeFunction}get currentVersion(){return this}addAlias(aliasName,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AliasOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlias),error}return new lambda.Alias(this._edgeFunction,`Alias${aliasName}`,{aliasName,version:this._edgeFunction.currentVersion,...options})}get connections(){throw new Error("Lambda@Edge does not support connections")}get latestVersion(){throw new Error("$LATEST function version cannot be used for Lambda@Edge")}addEventSourceMapping(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EventSourceMappingOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addEventSourceMapping),error}return this.lambda.addEventSourceMapping(id,options)}addPermission(id,permission){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_Permission(permission)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPermission),error}return this.lambda.addPermission(id,permission)}addToRolePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToRolePolicy),error}return this.lambda.addToRolePolicy(statement)}grantInvoke(identity){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantInvoke),error}return this.lambda.grantInvoke(identity)}grantInvokeUrl(identity){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantInvokeUrl),error}return this.lambda.grantInvokeUrl(identity)}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return this.lambda.metric(metricName,{...props,region:EdgeFunction.EDGE_REGION})}metricDuration(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricDuration),error}return this.lambda.metricDuration({...props,region:EdgeFunction.EDGE_REGION})}metricErrors(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricErrors),error}return this.lambda.metricErrors({...props,region:EdgeFunction.EDGE_REGION})}metricInvocations(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricInvocations),error}return this.lambda.metricInvocations({...props,region:EdgeFunction.EDGE_REGION})}metricThrottles(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricThrottles),error}return this.lambda.metricThrottles({...props,region:EdgeFunction.EDGE_REGION})}addEventSource(source){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IEventSource(source)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addEventSource),error}return this.lambda.addEventSource(source)}configureAsyncInvoke(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EventInvokeConfigOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureAsyncInvoke),error}return this.lambda.configureAsyncInvoke(options)}addFunctionUrl(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_FunctionUrlOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFunctionUrl),error}return this.lambda.addFunctionUrl(options)}createInRegionFunction(props){const edgeFunction=new lambda.Function(this,"Fn",props);return addEdgeLambdaToRoleTrustStatement(edgeFunction.role),{edgeFunction,edgeArn:edgeFunction.currentVersion.edgeArn}}createCrossRegionFunction(id,props){const parameterNamePrefix="cdk/EdgeFunctionArn";if(core_1.Token.isUnresolved(this.env.region))throw new Error("stacks which use EdgeFunctions must have an explicitly set region");const sanitizedPath=this.node.path.replace(/[^\/\w.-]/g,"_"),parameterName=`/${parameterNamePrefix}/${this.env.region}/${sanitizedPath}`,functionStack=this.edgeStack(props.stackId),edgeFunction=new lambda.Function(functionStack,id,props);addEdgeLambdaToRoleTrustStatement(edgeFunction.role);const version=edgeFunction.currentVersion;new ssm.StringParameter(edgeFunction,"Parameter",{parameterName,stringValue:version.edgeArn});const edgeArn=this.createCrossRegionArnReader(parameterNamePrefix,parameterName,version);return{edgeFunction,edgeArn}}createCrossRegionArnReader(parameterNamePrefix,parameterName,version){const parameterArnPrefix=this.stack.formatArn({service:"ssm",region:EdgeFunction.EDGE_REGION,resource:"parameter",resourceName:parameterNamePrefix+"/*"}),resourceType="Custom::CrossRegionStringParameterReader",serviceToken=core_1.CustomResourceProvider.getOrCreate(this,resourceType,{codeDirectory:path.join(__dirname,"edge-function"),runtime:core_1.CustomResourceProviderRuntime.NODEJS_14_X,policyStatements:[{Effect:"Allow",Resource:parameterArnPrefix,Action:["ssm:GetParameter"]}]});return new core_1.CustomResource(this,"ArnReader",{resourceType,serviceToken,properties:{Region:EdgeFunction.EDGE_REGION,ParameterName:parameterName,RefreshToken:core_1.Lazy.uncachedString({produce:()=>{const cfn=version.node.defaultChild;return this.stack.resolve(cfn.logicalId)}})}}).getAttString("FunctionArn")}edgeStack(stackId){const stage=core_1.Stage.of(this);if(!stage)throw new Error("stacks which use EdgeFunctions must be part of a CDK app or stage");const edgeStackId=stackId??`edge-lambda-stack-${this.stack.node.addr}`;let edgeStack=stage.node.tryFindChild(edgeStackId);return edgeStack||(edgeStack=new core_1.Stack(stage,edgeStackId,{env:{region:EdgeFunction.EDGE_REGION,account:core_1.Stack.of(this).account}})),this.stack.addDependency(edgeStack),edgeStack}}exports.EdgeFunction=EdgeFunction,_a=JSII_RTTI_SYMBOL_1,EdgeFunction[_a]={fqn:"aws-cdk-lib.aws_cloudfront.experimental.EdgeFunction",version:"2.42.0"},EdgeFunction.EDGE_REGION="us-east-1";function addEdgeLambdaToRoleTrustStatement(role){if(role instanceof iam.Role&&role.assumeRolePolicy){const statement=new iam.PolicyStatement,edgeLambdaServicePrincipal=new iam.ServicePrincipal("edgelambda.amazonaws.com");statement.addPrincipals(edgeLambdaServicePrincipal),statement.addActions(edgeLambdaServicePrincipal.assumeRoleAction),role.assumeRolePolicy.addStatements(statement)}}
//# sourceMappingURL=edge-function.js.map
