"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const lambda=require("../../aws-lambda"),s3=require("../../aws-s3"),sns=require("../../aws-sns"),cdk=require("../../core"),cloudtrail=require("../lib"),app=new cdk.App,stack=new cdk.Stack(app,"integ-cloudtrail"),bucket=new s3.Bucket(stack,"Bucket",{removalPolicy:cdk.RemovalPolicy.DESTROY,autoDeleteObjects:!0}),topic=new sns.Topic(stack,"Topic"),lambdaFunction=new lambda.Function(stack,"LambdaFunction",{runtime:lambda.Runtime.NODEJS_14_X,handler:"hello.handler",code:lambda.Code.fromInline("exports.handler = {}")}),trail=new cloudtrail.Trail(stack,"Trail",{snsTopic:topic});trail.addLambdaEventSelector([lambdaFunction]),trail.addS3EventSelector([{bucket}]),app.synth();
//# sourceMappingURL=integ.cloudtrail.lit.js.map
