"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CompositeAlarm=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../core"),alarm_base_1=require("./alarm-base"),cloudwatch_generated_1=require("./cloudwatch.generated");class CompositeAlarm extends alarm_base_1.AlarmBase{constructor(scope,id,props){super(scope,id,{physicalName:props.compositeAlarmName??core_1.Lazy.string({produce:()=>this.generateUniqueId()})});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_CompositeAlarmProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CompositeAlarm),error}if(props.alarmRule.renderAlarmRule().length>10240)throw new Error("Alarm Rule expression cannot be greater than 10240 characters, please reduce the conditions in the Alarm Rule");this.alarmRule=props.alarmRule.renderAlarmRule();const alarm=new cloudwatch_generated_1.CfnCompositeAlarm(this,"Resource",{alarmName:this.physicalName,alarmRule:this.alarmRule,alarmDescription:props.alarmDescription,actionsEnabled:props.actionsEnabled,alarmActions:core_1.Lazy.list({produce:()=>this.alarmActionArns}),insufficientDataActions:core_1.Lazy.list({produce:()=>this.insufficientDataActionArns}),okActions:core_1.Lazy.list({produce:()=>this.okActionArns})});this.alarmName=this.getResourceNameAttribute(alarm.ref),this.alarmArn=this.getResourceArnAttribute(alarm.attrArn,{service:"cloudwatch",resource:"alarm",resourceName:this.physicalName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}static fromCompositeAlarmName(scope,id,compositeAlarmName){const stack=core_1.Stack.of(scope);return this.fromCompositeAlarmArn(scope,id,stack.formatArn({service:"cloudwatch",resource:"alarm",resourceName:compositeAlarmName}))}static fromCompositeAlarmArn(scope,id,compositeAlarmArn){class Import extends alarm_base_1.AlarmBase{constructor(){super(...arguments),this.alarmArn=compositeAlarmArn,this.alarmName=core_1.Stack.of(scope).splitArn(compositeAlarmArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName}}return new Import(scope,id)}generateUniqueId(){const name=core_1.Names.uniqueId(this);return name.length>240?name.substring(0,120)+name.substring(name.length-120):name}}exports.CompositeAlarm=CompositeAlarm,_a=JSII_RTTI_SYMBOL_1,CompositeAlarm[_a]={fqn:"aws-cdk-lib.aws_cloudwatch.CompositeAlarm",version:"2.42.0"};
//# sourceMappingURL=composite-alarm.js.map
