"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.MathExpression=exports.Metric=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),cdk=require("../../core"),alarm_1=require("./alarm"),metric_util_1=require("./private/metric-util"),statistic_1=require("./private/statistic");class Metric{constructor(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Metric),error}this.period=props.period||cdk.Duration.minutes(5);const periodSec=this.period.toSeconds();if(periodSec!==1&&periodSec!==5&&periodSec!==10&&periodSec!==30&&periodSec%60!==0)throw new Error(`'period' must be 1, 5, 10, 30, or a multiple of 60 seconds, received ${periodSec}`);this.dimensions=this.validateDimensions(props.dimensionsMap??props.dimensions),this.namespace=props.namespace,this.metricName=props.metricName,this.statistic=statistic_1.normalizeStatistic(props.statistic||"Average"),this.label=props.label,this.color=props.color,this.unit=props.unit,this.account=props.account,this.region=props.region,this.warnings=void 0}static grantPutMetricData(grantee){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantPutMetricData),error}return iam.Grant.addToPrincipal({grantee,actions:["cloudwatch:PutMetricData"],resourceArns:["*"]})}with(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.with),error}return(props.label===void 0||props.label===this.label)&&(props.color===void 0||props.color===this.color)&&(props.statistic===void 0||props.statistic===this.statistic)&&(props.unit===void 0||props.unit===this.unit)&&(props.account===void 0||props.account===this.account)&&(props.region===void 0||props.region===this.region)&&props.dimensions===void 0&&props.dimensionsMap===void 0&&(props.period===void 0||props.period.toSeconds()===this.period.toSeconds())?this:new Metric({dimensionsMap:props.dimensionsMap??props.dimensions??this.dimensions,namespace:this.namespace,metricName:this.metricName,period:ifUndefined(props.period,this.period),statistic:ifUndefined(props.statistic,this.statistic),unit:ifUndefined(props.unit,this.unit),label:ifUndefined(props.label,this.label),color:ifUndefined(props.color,this.color),account:ifUndefined(props.account,this.account),region:ifUndefined(props.region,this.region)})}attachTo(scope){const stack=cdk.Stack.of(scope);return this.with({region:cdk.Token.isUnresolved(stack.region)?void 0:stack.region,account:cdk.Token.isUnresolved(stack.account)?void 0:stack.account})}toMetricConfig(){const dims=this.dimensionsAsList();return{metricStat:{dimensions:dims.length>0?dims:void 0,namespace:this.namespace,metricName:this.metricName,period:this.period,statistic:this.statistic,unitFilter:this.unit,account:this.account,region:this.region},renderingProperties:{color:this.color,label:this.label}}}toAlarmConfig(){const metricConfig=this.toMetricConfig();if(metricConfig.metricStat===void 0)throw new Error("Using a math expression is not supported here. Pass a 'Metric' object instead");const stat=statistic_1.parseStatistic(metricConfig.metricStat.statistic);return{dimensions:metricConfig.metricStat.dimensions,namespace:metricConfig.metricStat.namespace,metricName:metricConfig.metricStat.metricName,period:metricConfig.metricStat.period.toSeconds(),statistic:stat.type==="simple"?stat.statistic:void 0,extendedStatistic:stat.type==="percentile"?"p"+stat.percentile:void 0,unit:this.unit}}toGraphConfig(){const metricConfig=this.toMetricConfig();if(metricConfig.metricStat===void 0)throw new Error("Using a math expression is not supported here. Pass a 'Metric' object instead");return{dimensions:metricConfig.metricStat.dimensions,namespace:metricConfig.metricStat.namespace,metricName:metricConfig.metricStat.metricName,renderingProperties:{period:metricConfig.metricStat.period.toSeconds(),stat:metricConfig.metricStat.statistic,color:asString(metricConfig.renderingProperties?.color),label:asString(metricConfig.renderingProperties?.label)},period:metricConfig.metricStat.period.toSeconds(),statistic:metricConfig.metricStat.statistic,color:asString(metricConfig.renderingProperties?.color),label:asString(metricConfig.renderingProperties?.label),unit:this.unit}}createAlarm(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_CreateAlarmOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.createAlarm),error}return new alarm_1.Alarm(scope,id,{metric:this.with({statistic:props.statistic,period:props.period}),alarmName:props.alarmName,alarmDescription:props.alarmDescription,comparisonOperator:props.comparisonOperator,datapointsToAlarm:props.datapointsToAlarm,threshold:props.threshold,evaluationPeriods:props.evaluationPeriods,evaluateLowSampleCountPercentile:props.evaluateLowSampleCountPercentile,treatMissingData:props.treatMissingData,actionsEnabled:props.actionsEnabled})}toString(){return this.label||this.metricName}dimensionsAsList(){const dims=this.dimensions;return dims===void 0?[]:Object.keys(dims).sort().map(key=>({name:key,value:dims[key]}))}validateDimensions(dims){if(!dims)return dims;var dimsArray=Object.keys(dims);if(dimsArray?.length>10)throw new Error(`The maximum number of dimensions is 10, received ${dimsArray.length}`);return dimsArray.map(key=>{if(dims[key]===void 0||dims[key]===null)throw new Error(`Dimension value of '${dims[key]}' is invalid`);if(key.length<1||key.length>255)throw new Error(`Dimension name must be at least 1 and no more than 255 characters; received ${key}`);if(dims[key].length<1||dims[key].length>255)throw new Error(`Dimension value must be at least 1 and no more than 255 characters; received ${dims[key]}`)}),dims}}exports.Metric=Metric,_a=JSII_RTTI_SYMBOL_1,Metric[_a]={fqn:"aws-cdk-lib.aws_cloudwatch.Metric",version:"2.42.0"};function asString(x){if(x!==void 0){if(typeof x!="string")throw new Error(`Expected string, got ${x}`);return x}}class MathExpression{constructor(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MathExpressionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,MathExpression),error}this.period=props.period||cdk.Duration.minutes(5),this.expression=props.expression,this.usingMetrics=changeAllPeriods(props.usingMetrics??{},this.period),this.label=props.label,this.color=props.color,this.searchAccount=props.searchAccount,this.searchRegion=props.searchRegion;const invalidVariableNames=Object.keys(this.usingMetrics).filter(x=>!validVariableName(x));if(invalidVariableNames.length>0)throw new Error(`Invalid variable names in expression: ${invalidVariableNames}. Must start with lowercase letter and only contain alphanumerics.`);this.validateNoIdConflicts();const missingIdentifiers=allIdentifiersInExpression(this.expression).filter(i=>!this.usingMetrics[i]),warnings=[];missingIdentifiers.length>0&&warnings.push(`Math expression '${this.expression}' references unknown identifiers: ${missingIdentifiers.join(", ")}. Please add them to the 'usingMetrics' map.`);for(const m of Object.values(this.usingMetrics))warnings.push(...m.warnings??[]);warnings.length>0&&(this.warnings=warnings)}with(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MathExpressionOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.with),error}return(props.label===void 0||props.label===this.label)&&(props.color===void 0||props.color===this.color)&&(props.period===void 0||props.period.toSeconds()===this.period.toSeconds())&&(props.searchAccount===void 0||props.searchAccount===this.searchAccount)&&(props.searchRegion===void 0||props.searchRegion===this.searchRegion)?this:new MathExpression({expression:this.expression,usingMetrics:this.usingMetrics,label:ifUndefined(props.label,this.label),color:ifUndefined(props.color,this.color),period:ifUndefined(props.period,this.period),searchAccount:ifUndefined(props.searchAccount,this.searchAccount),searchRegion:ifUndefined(props.searchRegion,this.searchRegion)})}toAlarmConfig(){throw new Error("Using a math expression is not supported here. Pass a 'Metric' object instead")}toGraphConfig(){throw new Error("Using a math expression is not supported here. Pass a 'Metric' object instead")}toMetricConfig(){return{mathExpression:{period:this.period.toSeconds(),expression:this.expression,usingMetrics:this.usingMetrics,searchAccount:this.searchAccount,searchRegion:this.searchRegion},renderingProperties:{label:this.label,color:this.color}}}createAlarm(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_CreateAlarmOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.createAlarm),error}return new alarm_1.Alarm(scope,id,{metric:this.with({period:props.period}),alarmName:props.alarmName,alarmDescription:props.alarmDescription,comparisonOperator:props.comparisonOperator,datapointsToAlarm:props.datapointsToAlarm,threshold:props.threshold,evaluationPeriods:props.evaluationPeriods,evaluateLowSampleCountPercentile:props.evaluateLowSampleCountPercentile,treatMissingData:props.treatMissingData,actionsEnabled:props.actionsEnabled})}toString(){return this.label||this.expression}validateNoIdConflicts(){const seen=new Map;visit(this);function visit(metric){metric_util_1.dispatchMetric(metric,{withStat(){},withExpression(expr){for(const[id,subMetric]of Object.entries(expr.usingMetrics)){const existing=seen.get(id);if(existing&&metric_util_1.metricKey(existing)!==metric_util_1.metricKey(subMetric))throw new Error(`The ID '${id}' used for two metrics in the expression: '${subMetric}' and '${existing}'. Rename one.`);seen.set(id,subMetric),visit(subMetric)}}})}}}exports.MathExpression=MathExpression,_b=JSII_RTTI_SYMBOL_1,MathExpression[_b]={fqn:"aws-cdk-lib.aws_cloudwatch.MathExpression",version:"2.42.0"};const VARIABLE_PAT="[a-z][a-zA-Z0-9_]*",VALID_VARIABLE=new RegExp(`^${VARIABLE_PAT}$`),FIND_VARIABLE=new RegExp(VARIABLE_PAT,"g");function validVariableName(x){return VALID_VARIABLE.test(x)}function allIdentifiersInExpression(x){return Array.from(matchAll(x,FIND_VARIABLE)).map(m=>m[0])}function ifUndefined(x,def){return x!==void 0?x:def}function changeAllPeriods(metrics,period){const ret={};for(const[id,metric]of Object.entries(metrics))ret[id]=changePeriod(metric,period);return ret}function changePeriod(metric,period){if(isModifiableMetric(metric))return metric.with({period});throw new Error(`Metric object should also implement 'with': ${metric}`)}function isModifiableMetric(m){return typeof m=="object"&&m!==null&&!!m.with}function matchAll(x,re){const ret=new Array;let m;for(;m=re.exec(x);)ret.push(m);return ret}
//# sourceMappingURL=metric.js.map
