"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LambdaDeploymentGroup=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../../aws-iam"),cdk=require("../../../core"),constructs_1=require("constructs"),codedeploy_generated_1=require("../codedeploy.generated"),utils_1=require("../utils"),application_1=require("./application"),deployment_config_1=require("./deployment-config");class LambdaDeploymentGroup extends cdk.Resource{constructor(scope,id,props){super(scope,id,{physicalName:props.deploymentGroupName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_LambdaDeploymentGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LambdaDeploymentGroup),error}this.application=props.application||new application_1.LambdaApplication(this,"Application"),this.alarms=props.alarms||[],this.role=props.role||new iam.Role(this,"ServiceRole",{assumedBy:new iam.ServicePrincipal("codedeploy.amazonaws.com")}),this.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSCodeDeployRoleForLambdaLimited")),this.deploymentConfig=props.deploymentConfig||deployment_config_1.LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES;const resource=new codedeploy_generated_1.CfnDeploymentGroup(this,"Resource",{applicationName:this.application.applicationName,serviceRoleArn:this.role.roleArn,deploymentGroupName:this.physicalName,deploymentConfigName:this.deploymentConfig.deploymentConfigName,deploymentStyle:{deploymentType:"BLUE_GREEN",deploymentOption:"WITH_TRAFFIC_CONTROL"},alarmConfiguration:cdk.Lazy.any({produce:()=>utils_1.renderAlarmConfiguration(this.alarms,props.ignorePollAlarmsFailure)}),autoRollbackConfiguration:cdk.Lazy.any({produce:()=>utils_1.renderAutoRollbackConfiguration(this.alarms,props.autoRollback)})});this.deploymentGroupName=this.getResourceNameAttribute(resource.ref),this.deploymentGroupArn=this.getResourceArnAttribute(utils_1.arnForDeploymentGroup(this.application.applicationName,resource.ref),{service:"codedeploy",resource:"deploymentgroup",resourceName:`${this.application.applicationName}/${this.physicalName}`,arnFormat:cdk.ArnFormat.COLON_RESOURCE_NAME}),props.preHook&&this.addPreHook(props.preHook),props.postHook&&this.addPostHook(props.postHook),props.alias.node.defaultChild.cfnOptions.updatePolicy={codeDeployLambdaAliasUpdate:{applicationName:this.application.applicationName,deploymentGroupName:resource.ref,beforeAllowTrafficHook:cdk.Lazy.string({produce:()=>this.preHook&&this.preHook.functionName}),afterAllowTrafficHook:cdk.Lazy.string({produce:()=>this.postHook&&this.postHook.functionName})}},this.deploymentConfig instanceof constructs_1.Construct&&this.node.addDependency(this.deploymentConfig),this.node.addValidation({validate:()=>utils_1.validateName("Deployment group",this.physicalName)})}static fromLambdaDeploymentGroupAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_LambdaDeploymentGroupAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLambdaDeploymentGroupAttributes),error}return new ImportedLambdaDeploymentGroup(scope,id,attrs)}addAlarm(alarm){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(alarm)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlarm),error}this.alarms.push(alarm)}addPreHook(preHook){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(preHook)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPreHook),error}if(this.preHook!==void 0)throw new Error("A pre-hook function is already defined for this deployment group");this.preHook=preHook,this.grantPutLifecycleEventHookExecutionStatus(this.preHook),this.preHook.grantInvoke(this.role)}addPostHook(postHook){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(postHook)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPostHook),error}if(this.postHook!==void 0)throw new Error("A post-hook function is already defined for this deployment group");this.postHook=postHook,this.grantPutLifecycleEventHookExecutionStatus(this.postHook),this.postHook.grantInvoke(this.role)}grantPutLifecycleEventHookExecutionStatus(grantee){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantPutLifecycleEventHookExecutionStatus),error}return iam.Grant.addToPrincipal({grantee,resourceArns:[this.deploymentGroupArn],actions:["codedeploy:PutLifecycleEventHookExecutionStatus"]})}}exports.LambdaDeploymentGroup=LambdaDeploymentGroup,_a=JSII_RTTI_SYMBOL_1,LambdaDeploymentGroup[_a]={fqn:"aws-cdk-lib.aws_codedeploy.LambdaDeploymentGroup",version:"2.42.0"};class ImportedLambdaDeploymentGroup extends cdk.Resource{constructor(scope,id,props){super(scope,id),this.application=props.application,this.deploymentGroupName=props.deploymentGroupName,this.deploymentGroupArn=utils_1.arnForDeploymentGroup(props.application.applicationName,props.deploymentGroupName),this.deploymentConfig=props.deploymentConfig||deployment_config_1.LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES}}
//# sourceMappingURL=deployment-group.js.map
