"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ServerDeploymentGroup=exports.InstanceTagSet=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../../aws-ec2"),iam=require("../../../aws-iam"),s3=require("../../../aws-s3"),cdk=require("../../../core"),core_1=require("../../../core"),codedeploy_generated_1=require("../codedeploy.generated"),utils_1=require("../utils"),application_1=require("./application"),deployment_config_1=require("./deployment-config"),load_balancer_1=require("./load-balancer");class ServerDeploymentGroupBase extends cdk.Resource{constructor(scope,id,deploymentConfig,props){super(scope,id,props),this.deploymentConfig=deploymentConfig||deployment_config_1.ServerDeploymentConfig.ONE_AT_A_TIME}}class ImportedServerDeploymentGroup extends ServerDeploymentGroupBase{constructor(scope,id,props){super(scope,id,props.deploymentConfig),this.role=void 0,this.autoScalingGroups=void 0,this.application=props.application,this.deploymentGroupName=props.deploymentGroupName,this.deploymentGroupArn=utils_1.arnForDeploymentGroup(props.application.applicationName,props.deploymentGroupName)}}class InstanceTagSet{constructor(...instanceTagGroups){if(instanceTagGroups.length>3)throw new Error(`An instance tag set can have a maximum of 3 instance tag groups, but ${instanceTagGroups.length} were provided`);this._instanceTagGroups=instanceTagGroups}get instanceTagGroups(){return this._instanceTagGroups.slice()}}exports.InstanceTagSet=InstanceTagSet,_a=JSII_RTTI_SYMBOL_1,InstanceTagSet[_a]={fqn:"aws-cdk-lib.aws_codedeploy.InstanceTagSet",version:"2.42.0"};class ServerDeploymentGroup extends ServerDeploymentGroupBase{constructor(scope,id,props={}){super(scope,id,props.deploymentConfig,{physicalName:props.deploymentGroupName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_ServerDeploymentGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ServerDeploymentGroup),error}this.application=props.application||new application_1.ServerApplication(this,"Application",{applicationName:props.deploymentGroupName===cdk.PhysicalName.GENERATE_IF_NEEDED?cdk.PhysicalName.GENERATE_IF_NEEDED:void 0}),this.role=props.role||new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("codedeploy.amazonaws.com"),managedPolicies:[iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSCodeDeployRole")]}),this._autoScalingGroups=props.autoScalingGroups||[],this.installAgent=props.installAgent??!0,this.codeDeployBucket=s3.Bucket.fromBucketName(this,"Bucket",`aws-codedeploy-${cdk.Stack.of(this).region}`);for(const asg of this._autoScalingGroups)this.addCodeDeployAgentInstallUserData(asg);this.alarms=props.alarms||[];const resource=new codedeploy_generated_1.CfnDeploymentGroup(this,"Resource",{applicationName:this.application.applicationName,deploymentGroupName:this.physicalName,serviceRoleArn:this.role.roleArn,deploymentConfigName:props.deploymentConfig&&props.deploymentConfig.deploymentConfigName,autoScalingGroups:cdk.Lazy.list({produce:()=>this._autoScalingGroups.map(asg=>asg.autoScalingGroupName)},{omitEmpty:!0}),loadBalancerInfo:this.loadBalancerInfo(props.loadBalancer),deploymentStyle:props.loadBalancer===void 0?void 0:{deploymentOption:"WITH_TRAFFIC_CONTROL"},ec2TagSet:this.ec2TagSet(props.ec2InstanceTags),onPremisesTagSet:this.onPremiseTagSet(props.onPremiseInstanceTags),alarmConfiguration:cdk.Lazy.any({produce:()=>utils_1.renderAlarmConfiguration(this.alarms,props.ignorePollAlarmsFailure)}),autoRollbackConfiguration:cdk.Lazy.any({produce:()=>utils_1.renderAutoRollbackConfiguration(this.alarms,props.autoRollback)})});this.deploymentGroupName=this.getResourceNameAttribute(resource.ref),this.deploymentGroupArn=this.getResourceArnAttribute(utils_1.arnForDeploymentGroup(this.application.applicationName,resource.ref),{service:"codedeploy",resource:"deploymentgroup",resourceName:`${this.application.applicationName}/${this.physicalName}`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}),this.node.addValidation({validate:()=>utils_1.validateName("Deployment group",this.physicalName)})}static fromServerDeploymentGroupAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codedeploy_ServerDeploymentGroupAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromServerDeploymentGroupAttributes),error}return new ImportedServerDeploymentGroup(scope,id,attrs)}addAutoScalingGroup(asg){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_autoscaling_AutoScalingGroup(asg)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAutoScalingGroup),error}this._autoScalingGroups.push(asg),this.addCodeDeployAgentInstallUserData(asg)}addAlarm(alarm){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_IAlarm(alarm)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlarm),error}this.alarms.push(alarm)}get autoScalingGroups(){return this._autoScalingGroups.slice()}addCodeDeployAgentInstallUserData(asg){if(!!this.installAgent)switch(this.codeDeployBucket.grantRead(asg,"latest/*"),asg.osType){case ec2.OperatingSystemType.LINUX:asg.addUserData("set +e","PKG_CMD=`which yum 2>/dev/null`","set -e",'if [ -z "$PKG_CMD" ]; then',"PKG_CMD=apt-get","else","PKG_CMD=yum","fi","$PKG_CMD update -y","set +e","$PKG_CMD install -y ruby2.0","RUBY2_INSTALL=$?","set -e","if [ $RUBY2_INSTALL -ne 0 ]; then","$PKG_CMD install -y ruby","fi","AWS_CLI_PACKAGE_NAME=awscli",'if [ "$PKG_CMD" = "yum" ]; then',"AWS_CLI_PACKAGE_NAME=aws-cli","fi","$PKG_CMD install -y $AWS_CLI_PACKAGE_NAME","TMP_DIR=`mktemp -d`","cd $TMP_DIR",`aws s3 cp s3://aws-codedeploy-${cdk.Stack.of(this).region}/latest/install . --region ${cdk.Stack.of(this).region}`,"chmod +x ./install","./install auto","rm -fr $TMP_DIR");break;case ec2.OperatingSystemType.WINDOWS:asg.addUserData("Set-Variable -Name TEMPDIR -Value (New-TemporaryFile).DirectoryName",`aws s3 cp s3://aws-codedeploy-${cdk.Stack.of(this).region}/latest/codedeploy-agent.msi $TEMPDIR\\codedeploy-agent.msi`,"cd $TEMPDIR",".\\codedeploy-agent.msi /quiet /l c:\\temp\\host-agent-install-log.txt");break}}loadBalancerInfo(loadBalancer){if(!!loadBalancer)switch(loadBalancer.generation){case load_balancer_1.LoadBalancerGeneration.FIRST:return{elbInfoList:[{name:loadBalancer.name}]};case load_balancer_1.LoadBalancerGeneration.SECOND:return{targetGroupInfoList:[{name:loadBalancer.name}]}}}ec2TagSet(tagSet){if(!(!tagSet||tagSet.instanceTagGroups.length===0))return{ec2TagSetList:tagSet.instanceTagGroups.map(tagGroup=>({ec2TagGroup:this.tagGroup2TagsArray(tagGroup)}))}}onPremiseTagSet(tagSet){if(!(!tagSet||tagSet.instanceTagGroups.length===0))return{onPremisesTagSetList:tagSet.instanceTagGroups.map(tagGroup=>({onPremisesTagGroup:this.tagGroup2TagsArray(tagGroup)}))}}tagGroup2TagsArray(tagGroup){const tagsInGroup=new Array;for(const tagKey in tagGroup)if(tagGroup.hasOwnProperty(tagKey)){const tagValues=tagGroup[tagKey];if(tagKey.length>0)if(tagValues.length>0)for(const tagValue of tagValues)tagsInGroup.push({key:tagKey,value:tagValue,type:"KEY_AND_VALUE"});else tagsInGroup.push({key:tagKey,type:"KEY_ONLY"});else if(tagValues.length>0)for(const tagValue of tagValues)tagsInGroup.push({value:tagValue,type:"VALUE_ONLY"});else throw new Error("Cannot specify both an empty key and no values for an instance tag filter")}return tagsInGroup}}exports.ServerDeploymentGroup=ServerDeploymentGroup,_b=JSII_RTTI_SYMBOL_1,ServerDeploymentGroup[_b]={fqn:"aws-cdk-lib.aws_codedeploy.ServerDeploymentGroup",version:"2.42.0"};
//# sourceMappingURL=deployment-group.js.map
