"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateName=exports.renderAutoRollbackConfiguration=exports.renderAlarmConfiguration=exports.arnForDeploymentConfig=exports.arnForDeploymentGroup=exports.arnForApplication=void 0;const core_1=require("../../core");function arnForApplication(applicationName){return`arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`}exports.arnForApplication=arnForApplication;function arnForDeploymentGroup(applicationName,deploymentGroupName){return`arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`}exports.arnForDeploymentGroup=arnForDeploymentGroup;function arnForDeploymentConfig(name){return`arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`}exports.arnForDeploymentConfig=arnForDeploymentConfig;function renderAlarmConfiguration(alarms,ignorePollAlarmFailure){return alarms.length===0?void 0:{alarms:alarms.map(a=>({name:a.alarmName})),enabled:!0,ignorePollAlarmFailure}}exports.renderAlarmConfiguration=renderAlarmConfiguration;var AutoRollbackEvent;(function(AutoRollbackEvent2){AutoRollbackEvent2.DEPLOYMENT_FAILURE="DEPLOYMENT_FAILURE",AutoRollbackEvent2.DEPLOYMENT_STOP_ON_ALARM="DEPLOYMENT_STOP_ON_ALARM",AutoRollbackEvent2.DEPLOYMENT_STOP_ON_REQUEST="DEPLOYMENT_STOP_ON_REQUEST"})(AutoRollbackEvent||(AutoRollbackEvent={}));function renderAutoRollbackConfiguration(alarms,autoRollbackConfig={}){const events=new Array;if(autoRollbackConfig.failedDeployment!==!1&&events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE),autoRollbackConfig.stoppedDeployment===!0&&events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST),autoRollbackConfig.deploymentInAlarm!==!1){if(alarms.length>0)events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);else if(autoRollbackConfig.deploymentInAlarm===!0)throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate at least one CloudWatch alarm with the Deployment Group")}return events.length>0?{enabled:!0,events}:void 0}exports.renderAutoRollbackConfiguration=renderAutoRollbackConfiguration;function validateName(type,name){const ret=[];return!core_1.Token.isUnresolved(name)&&name!==void 0&&(name.length>100&&ret.push(`${type} name: "${name}" can be a max of 100 characters.`),/^[a-z0-9._+=,@-]+$/i.test(name)||ret.push(`${type} name: "${name}" can only contain letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), + (plus signs), = (equals signs), , (commas), @ (at signs), - (minus signs).`)),ret}exports.validateName=validateName;
//# sourceMappingURL=utils.js.map
