"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.PipelineStack=exports.EcsAppStack=void 0;const codebuild=require("../../aws-codebuild"),codecommit=require("../../aws-codecommit"),codepipeline=require("../../aws-codepipeline"),ec2=require("../../aws-ec2"),ecr=require("../../aws-ecr"),ecs=require("../../aws-ecs"),s3=require("../../aws-s3"),cdk=require("../../core"),codepipeline_actions=require("../lib");class EcsAppStack extends cdk.Stack{constructor(scope,id,props){super(scope,id,props);const taskDefinition=new ecs.TaskDefinition(this,"TaskDefinition",{compatibility:ecs.Compatibility.FARGATE,cpu:"1024",memoryMiB:"2048"});taskDefinition.addContainer("AppContainer",{image:props.image}),new ecs.FargateService(this,"EcsService",{taskDefinition,cluster:new ecs.Cluster(this,"Cluster",{vpc:new ec2.Vpc(this,"Vpc",{maxAzs:1})})})}}exports.EcsAppStack=EcsAppStack;class PipelineStack extends cdk.Stack{constructor(scope,id,props){super(scope,id,props);const appEcrRepo=new ecr.Repository(this,"EcsDeployRepository"),appCodeDockerBuild=new codebuild.PipelineProject(this,"AppCodeDockerImageBuildAndPushProject",{environment:{privileged:!0},buildSpec:codebuild.BuildSpec.fromObject({version:"0.2",phases:{build:{commands:["$(aws ecr get-login --region $AWS_DEFAULT_REGION --no-include-email)","docker build -t $REPOSITORY_URI:$CODEBUILD_RESOLVED_SOURCE_VERSION ."]},post_build:{commands:["docker push $REPOSITORY_URI:$CODEBUILD_RESOLVED_SOURCE_VERSION","export imageTag=$CODEBUILD_RESOLVED_SOURCE_VERSION"]}},env:{"exported-variables":["imageTag"]}}),environmentVariables:{REPOSITORY_URI:{value:appEcrRepo.repositoryUri}}});appEcrRepo.grantPullPush(appCodeDockerBuild),this.tagParameterContainerImage=new ecs.TagParameterContainerImage(appEcrRepo);const cdkCodeBuild=new codebuild.PipelineProject(this,"CdkCodeBuildProject",{buildSpec:codebuild.BuildSpec.fromObject({version:"0.2",phases:{install:{commands:["npm install"]},build:{commands:["npx cdk synth --verbose"]}},artifacts:{"base-directory":"cdk.out",files:"**/*"}})}),appCodeSourceOutput=new codepipeline.Artifact,cdkCodeSourceOutput=new codepipeline.Artifact,cdkCodeBuildOutput=new codepipeline.Artifact,appCodeBuildAction=new codepipeline_actions.CodeBuildAction({actionName:"AppCodeDockerImageBuildAndPush",project:appCodeDockerBuild,input:appCodeSourceOutput});new codepipeline.Pipeline(this,"CodePipelineDeployingEcsApplication",{artifactBucket:new s3.Bucket(this,"ArtifactBucket",{removalPolicy:cdk.RemovalPolicy.DESTROY}),stages:[{stageName:"Source",actions:[new codepipeline_actions.CodeCommitSourceAction({actionName:"AppCodeSource",repository:new codecommit.Repository(this,"AppCodeSourceRepository",{repositoryName:"AppCodeSourceRepository"}),output:appCodeSourceOutput}),new codepipeline_actions.CodeCommitSourceAction({actionName:"CdkCodeSource",repository:new codecommit.Repository(this,"CdkCodeSourceRepository",{repositoryName:"CdkCodeSourceRepository"}),output:cdkCodeSourceOutput})]},{stageName:"Build",actions:[appCodeBuildAction,new codepipeline_actions.CodeBuildAction({actionName:"CdkCodeBuildAndSynth",project:cdkCodeBuild,input:cdkCodeSourceOutput,outputs:[cdkCodeBuildOutput]})]},{stageName:"Deploy",actions:[new codepipeline_actions.CloudFormationCreateUpdateStackAction({actionName:"CFN_Deploy",stackName:"SampleEcsStackDeployedFromCodePipeline",templatePath:cdkCodeBuildOutput.atPath("EcsStackDeployedInPipeline.template.json"),adminPermissions:!0,parameterOverrides:{[this.tagParameterContainerImage.tagParameterName]:appCodeBuildAction.variable("imageTag")}})]}]})}}exports.PipelineStack=PipelineStack;const app=new cdk.App,pipelineStack=new PipelineStack(app,"aws-cdk-pipeline-ecs-separate-sources");new EcsAppStack(app,"EcsStackDeployedInPipeline",{image:pipelineStack.tagParameterContainerImage}),app.synth();
//# sourceMappingURL=integ.pipeline-ecs-separate-source.lit.js.map
