"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.CrossRegionSupportStack=exports.CrossRegionSupportConstruct=void 0;const kms=require("../../../aws-kms"),s3=require("../../../aws-s3"),cdk=require("../../../core"),constructs_1=require("constructs"),REQUIRED_ALIAS_PREFIX="alias/";class AliasWithShorterGeneratedName extends kms.Alias{generatePhysicalName(){let baseName=super.generatePhysicalName();baseName.startsWith(REQUIRED_ALIAS_PREFIX)&&(baseName=baseName.substring(REQUIRED_ALIAS_PREFIX.length));const maxLength=50-REQUIRED_ALIAS_PREFIX.length;return REQUIRED_ALIAS_PREFIX+lastNCharacters(baseName,maxLength)}}function lastNCharacters(str,n){const startIndex=Math.max(str.length-n,0);return str.substring(startIndex)}class CrossRegionSupportConstruct extends constructs_1.Construct{constructor(scope,id,props={}){super(scope,id);const createKmsKey=props.createKmsKey??!0;let encryptionAlias;if(createKmsKey){const encryptionKey=new kms.Key(this,"CrossRegionCodePipelineReplicationBucketEncryptionKey",{removalPolicy:cdk.RemovalPolicy.DESTROY,enableKeyRotation:props.enableKeyRotation});encryptionAlias=new AliasWithShorterGeneratedName(this,"CrossRegionCodePipelineReplicationBucketEncryptionAlias",{targetKey:encryptionKey,aliasName:cdk.PhysicalName.GENERATE_IF_NEEDED,removalPolicy:cdk.RemovalPolicy.DESTROY})}this.replicationBucket=new s3.Bucket(this,"CrossRegionCodePipelineReplicationBucket",{bucketName:cdk.PhysicalName.GENERATE_IF_NEEDED,encryption:encryptionAlias?s3.BucketEncryption.KMS:s3.BucketEncryption.KMS_MANAGED,encryptionKey:encryptionAlias,enforceSSL:!0,blockPublicAccess:s3.BlockPublicAccess.BLOCK_ALL})}}exports.CrossRegionSupportConstruct=CrossRegionSupportConstruct;class CrossRegionSupportStack extends cdk.Stack{constructor(scope,id,props){super(scope,id,{stackName:generateStackName(props),env:{region:props.region,account:props.account},synthesizer:props.synthesizer});const crossRegionSupportConstruct=new CrossRegionSupportConstruct(this,"Default",{createKmsKey:props.createKmsKey,enableKeyRotation:props.enableKeyRotation});this.replicationBucket=crossRegionSupportConstruct.replicationBucket}}exports.CrossRegionSupportStack=CrossRegionSupportStack;function generateStackName(props){return`${props.pipelineStackName}-support-${props.region}`}
//# sourceMappingURL=cross-region-support-stack.js.map
