"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.Stage=void 0;const events=require("../../../aws-events"),cdk=require("../../../core"),core_1=require("../../../core"),constructs_1=require("constructs"),validation=require("./validation");class Stage{constructor(props,pipeline){this._actions=new Array,validation.validateName("Stage",props.stageName),this.stageName=props.stageName,this.transitionToEnabled=props.transitionToEnabled??!0,this.transitionDisabledReason=props.transitionDisabledReason??"Transition disabled",this._pipeline=pipeline,this.scope=new constructs_1.Construct(pipeline,this.stageName);for(const action of props.actions||[])this.addAction(action)}get actionDescriptors(){return this._actions.slice()}get actions(){return this._actions.map(actionDescriptor=>actionDescriptor.action)}get pipeline(){return this._pipeline}render(){for(const action of this._actions){const outputArtifacts=action.outputs,unnamedOutputs=outputArtifacts.filter(o=>!o.artifactName);for(const outputArtifact of outputArtifacts)if(!outputArtifact.artifactName){const unsanitizedArtifactName=`Artifact_${this.stageName}_${action.actionName}`+(unnamedOutputs.length===1?"":"_"+(unnamedOutputs.indexOf(outputArtifact)+1)),artifactName=sanitizeArtifactName(unsanitizedArtifactName);outputArtifact._setName(artifactName)}}return{name:this.stageName,actions:this._actions.map(action=>this.renderAction(action))}}addAction(action){const actionName=action.actionProperties.actionName;if(validation.validateName("Action",actionName),this._actions.find(a=>a.actionName===actionName))throw new Error(`Stage ${this.stageName} already contains an action with name '${actionName}'`);this._actions.push(this.attachActionToPipeline(action))}onStateChange(name,target,options){const rule=new events.Rule(this.scope,name,options);return rule.addTarget(target),rule.addEventPattern({detailType:["CodePipeline Stage Execution State Change"],source:["aws.codepipeline"],resources:[this.pipeline.pipelineArn],detail:{stage:[this.stageName]}}),rule}validate(){return[...this.validateHasActions(),...this.validateActions()]}validateHasActions(){return this._actions.length===0?[`Stage '${this.stageName}' must have at least one action`]:[]}validateActions(){const ret=new Array;for(const action of this.actionDescriptors)ret.push(...this.validateAction(action));return ret}validateAction(action){return validation.validateArtifactBounds("input",action.inputs,action.artifactBounds.minInputs,action.artifactBounds.maxInputs,action.category,action.provider).concat(validation.validateArtifactBounds("output",action.outputs,action.artifactBounds.minOutputs,action.artifactBounds.maxOutputs,action.category,action.provider))}attachActionToPipeline(action){let actionScope=constructs_1.Node.of(this.scope).tryFindChild(action.actionProperties.actionName);if(!actionScope){let id=action.actionProperties.actionName;core_1.Token.isUnresolved(id)&&(id=findUniqueConstructId(this.scope,action.actionProperties.provider)),actionScope=new constructs_1.Construct(this.scope,id)}return this._pipeline._attachActionToPipeline(this,action,actionScope)}renderAction(action){const outputArtifacts=cdk.Lazy.any({produce:()=>this.renderArtifacts(action.outputs)},{omitEmptyArray:!0}),inputArtifacts=cdk.Lazy.any({produce:()=>this.renderArtifacts(action.inputs)},{omitEmptyArray:!0});return{name:action.actionName,inputArtifacts,outputArtifacts,actionTypeId:{category:action.category.toString(),version:action.version,owner:action.owner,provider:action.provider},configuration:action.configuration,runOrder:action.runOrder,roleArn:action.role?action.role.roleArn:void 0,region:action.region,namespace:action.namespace}}renderArtifacts(artifacts){return artifacts.filter(a=>a.artifactName).map(a=>({name:a.artifactName}))}}exports.Stage=Stage;function sanitizeArtifactName(artifactName){return artifactName.replace(/[@.]/g,"")}function findUniqueConstructId(scope,prefix){let current=prefix,ctr=1;for(;constructs_1.Node.of(scope).tryFindChild(current)!==void 0;)current=`${prefix}${++ctr}`;return current}
//# sourceMappingURL=stage.js.map
