"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateNamespaceName=exports.validateArtifactName=exports.validateName=exports.validateSourceAction=exports.validateArtifactBounds=void 0;const cdk=require("../../../core"),action_1=require("../action");function validateArtifactBounds(type,artifacts,min,max,category,provider){const ret=[];return artifacts.length<min&&ret.push(`${category}/${provider} must have at least ${min} ${type} artifacts`),artifacts.length>max&&ret.push(`${category}/${provider} cannot have more than ${max} ${type} artifacts`),ret}exports.validateArtifactBounds=validateArtifactBounds;function validateSourceAction(mustBeSource,category,actionName,stageName){return mustBeSource!==(category===action_1.ActionCategory.SOURCE)?[`Action ${actionName} in stage ${stageName}: `+(mustBeSource?"first stage may only contain Source actions":"Source actions may only occur in first stage")]:[]}exports.validateSourceAction=validateSourceAction;const VALID_IDENTIFIER_REGEX=/^[a-zA-Z0-9.@_-]{1,100}$/;function validateName(thing,name){validateAgainstRegex(VALID_IDENTIFIER_REGEX,thing,name)}exports.validateName=validateName;function validateArtifactName(artifactName){validateAgainstRegex(/^[a-zA-Z0-9_-]{1,100}$/,"Artifact",artifactName)}exports.validateArtifactName=validateArtifactName;function validateNamespaceName(namespaceName){validateAgainstRegex(/^[A-Za-z0-9@_-]{1,100}$/,"Namespace",namespaceName)}exports.validateNamespaceName=validateNamespaceName;function validateAgainstRegex(regex,thing,name){if(!cdk.Token.isUnresolved(name)&&name!==void 0&&!regex.test(name))throw new Error(`${thing} name must match regular expression: ${regex.toString()}, got '${name}'`)}
//# sourceMappingURL=validation.js.map
