"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnConnection=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnConnectionPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("connectionName",cdk.requiredValidator)(properties.connectionName)),errors.collect(cdk.propertyValidator("connectionName",cdk.validateString)(properties.connectionName)),errors.collect(cdk.propertyValidator("hostArn",cdk.validateString)(properties.hostArn)),errors.collect(cdk.propertyValidator("providerType",cdk.validateString)(properties.providerType)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnConnectionProps"')}function cfnConnectionPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnConnectionPropsValidator(properties).assertSuccess(),{ConnectionName:cdk.stringToCloudFormation(properties.connectionName),HostArn:cdk.stringToCloudFormation(properties.hostArn),ProviderType:cdk.stringToCloudFormation(properties.providerType),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnConnectionPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("connectionName","ConnectionName",cfn_parse.FromCloudFormation.getString(properties.ConnectionName)),ret.addPropertyResult("hostArn","HostArn",properties.HostArn!=null?cfn_parse.FromCloudFormation.getString(properties.HostArn):void 0),ret.addPropertyResult("providerType","ProviderType",properties.ProviderType!=null?cfn_parse.FromCloudFormation.getString(properties.ProviderType):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnConnection extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnConnection.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codestarconnections_CfnConnectionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnConnection),error}cdk.requireProperty(props,"connectionName",this),this.attrConnectionArn=cdk.Token.asString(this.getAtt("ConnectionArn")),this.attrConnectionStatus=cdk.Token.asString(this.getAtt("ConnectionStatus")),this.attrOwnerAccountId=cdk.Token.asString(this.getAtt("OwnerAccountId")),this.connectionName=props.connectionName,this.hostArn=props.hostArn,this.providerType=props.providerType,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CodeStarConnections::Connection",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnConnectionPropsFromCloudFormation(resourceProperties),ret=new CfnConnection(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnConnection.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{connectionName:this.connectionName,hostArn:this.hostArn,providerType:this.providerType,tags:this.tags.renderTags()}}renderProperties(props){return cfnConnectionPropsToCloudFormation(props)}}exports.CfnConnection=CfnConnection,_a=JSII_RTTI_SYMBOL_1,CfnConnection[_a]={fqn:"aws-cdk-lib.aws_codestarconnections.CfnConnection",version:"2.42.0"},CfnConnection.CFN_RESOURCE_TYPE_NAME="AWS::CodeStarConnections::Connection";
//# sourceMappingURL=codestarconnections.generated.js.map
