"use strict";var _a,_b,_c,_d,_e;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ResourceType=exports.ManagedRuleIdentifiers=exports.CustomRule=exports.ManagedRule=exports.MaximumExecutionFrequency=exports.RuleScope=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),events=require("../../aws-events"),iam=require("../../aws-iam"),core_1=require("../../core"),config_generated_1=require("./config.generated");class RuleBase extends core_1.Resource{onEvent(id,options={}){const rule=new events.Rule(this,id,options);return rule.addEventPattern({source:["aws.config"],detail:{configRuleName:[this.configRuleName]}}),rule.addTarget(options.target),rule}onComplianceChange(id,options={}){const rule=this.onEvent(id,options);return rule.addEventPattern({detailType:["Config Rules Compliance Change"]}),rule}onReEvaluationStatus(id,options={}){const rule=this.onEvent(id,options);return rule.addEventPattern({detailType:["Config Rules Re-evaluation Status"]}),rule}}class RuleNew extends RuleBase{static fromConfigRuleName(scope,id,configRuleName){class Import extends RuleBase{constructor(){super(...arguments),this.configRuleName=configRuleName}}return new Import(scope,id)}}class RuleScope{constructor(resourceId,resourceTypes,tagKey,tagValue){this.resourceTypes=resourceTypes,this.resourceId=resourceId,this.key=tagKey,this.value=tagValue}static fromResource(resourceType,resourceId){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_config_ResourceType(resourceType)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromResource),error}return new RuleScope(resourceId,[resourceType])}static fromResources(resourceTypes){return new RuleScope(void 0,resourceTypes)}static fromTag(key,value){return new RuleScope(void 0,void 0,key,value)}}exports.RuleScope=RuleScope,_a=JSII_RTTI_SYMBOL_1,RuleScope[_a]={fqn:"aws-cdk-lib.aws_config.RuleScope",version:"2.42.0"};var MaximumExecutionFrequency;(function(MaximumExecutionFrequency2){MaximumExecutionFrequency2.ONE_HOUR="One_Hour",MaximumExecutionFrequency2.THREE_HOURS="Three_Hours",MaximumExecutionFrequency2.SIX_HOURS="Six_Hours",MaximumExecutionFrequency2.TWELVE_HOURS="Twelve_Hours",MaximumExecutionFrequency2.TWENTY_FOUR_HOURS="TwentyFour_Hours"})(MaximumExecutionFrequency=exports.MaximumExecutionFrequency||(exports.MaximumExecutionFrequency={}));class ManagedRule extends RuleNew{constructor(scope,id,props){super(scope,id,{physicalName:props.configRuleName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_config_ManagedRuleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ManagedRule),error}this.ruleScope=props.ruleScope;const rule=new config_generated_1.CfnConfigRule(this,"Resource",{configRuleName:this.physicalName,description:props.description,inputParameters:props.inputParameters,maximumExecutionFrequency:props.maximumExecutionFrequency,scope:core_1.Lazy.any({produce:()=>renderScope(this.ruleScope)}),source:{owner:"AWS",sourceIdentifier:props.identifier}});this.configRuleName=rule.ref,this.configRuleArn=rule.attrArn,this.configRuleId=rule.attrConfigRuleId,this.configRuleComplianceType=rule.attrComplianceType,this.isManaged=!0}}exports.ManagedRule=ManagedRule,_b=JSII_RTTI_SYMBOL_1,ManagedRule[_b]={fqn:"aws-cdk-lib.aws_config.ManagedRule",version:"2.42.0"};class CustomRule extends RuleNew{constructor(scope,id,props){super(scope,id,{physicalName:props.configRuleName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_config_CustomRuleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CustomRule),error}if(!props.configurationChanges&&!props.periodic)throw new Error("At least one of `configurationChanges` or `periodic` must be set to true.");const sourceDetails=[];this.ruleScope=props.ruleScope,props.configurationChanges&&(sourceDetails.push({eventSource:"aws.config",messageType:"ConfigurationItemChangeNotification"}),sourceDetails.push({eventSource:"aws.config",messageType:"OversizedConfigurationItemChangeNotification"})),props.periodic&&sourceDetails.push({eventSource:"aws.config",maximumExecutionFrequency:props.maximumExecutionFrequency,messageType:"ScheduledNotification"}),props.lambdaFunction.addPermission("Permission",{principal:new iam.ServicePrincipal("config.amazonaws.com"),sourceAccount:this.env.account}),props.lambdaFunction.role&&props.lambdaFunction.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSConfigRulesExecutionRole")),this.node.addDependency(props.lambdaFunction);const rule=new config_generated_1.CfnConfigRule(this,"Resource",{configRuleName:this.physicalName,description:props.description,inputParameters:props.inputParameters,maximumExecutionFrequency:props.maximumExecutionFrequency,scope:core_1.Lazy.any({produce:()=>renderScope(this.ruleScope)}),source:{owner:"CUSTOM_LAMBDA",sourceDetails,sourceIdentifier:props.lambdaFunction.functionArn}});this.configRuleName=rule.ref,this.configRuleArn=rule.attrArn,this.configRuleId=rule.attrConfigRuleId,this.configRuleComplianceType=rule.attrComplianceType,props.configurationChanges&&(this.isCustomWithChanges=!0)}}exports.CustomRule=CustomRule,_c=JSII_RTTI_SYMBOL_1,CustomRule[_c]={fqn:"aws-cdk-lib.aws_config.CustomRule",version:"2.42.0"};class ManagedRuleIdentifiers{constructor(){}}exports.ManagedRuleIdentifiers=ManagedRuleIdentifiers,_d=JSII_RTTI_SYMBOL_1,ManagedRuleIdentifiers[_d]={fqn:"aws-cdk-lib.aws_config.ManagedRuleIdentifiers",version:"2.42.0"},ManagedRuleIdentifiers.IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS="IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS",ManagedRuleIdentifiers.IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS="IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS",ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED="ACCESS_KEYS_ROTATED",ManagedRuleIdentifiers.ACCOUNT_PART_OF_ORGANIZATIONS="ACCOUNT_PART_OF_ORGANIZATIONS",ManagedRuleIdentifiers.ACM_CERTIFICATE_EXPIRATION_CHECK="ACM_CERTIFICATE_EXPIRATION_CHECK",ManagedRuleIdentifiers.ALB_HTTP_DROP_INVALID_HEADER_ENABLED="ALB_HTTP_DROP_INVALID_HEADER_ENABLED",ManagedRuleIdentifiers.ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK="ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK",ManagedRuleIdentifiers.ALB_WAF_ENABLED="ALB_WAF_ENABLED",ManagedRuleIdentifiers.API_GW_CACHE_ENABLED_AND_ENCRYPTED="API_GW_CACHE_ENABLED_AND_ENCRYPTED",ManagedRuleIdentifiers.API_GW_ENDPOINT_TYPE_CHECK="API_GW_ENDPOINT_TYPE_CHECK",ManagedRuleIdentifiers.API_GW_EXECUTION_LOGGING_ENABLED="API_GW_EXECUTION_LOGGING_ENABLED",ManagedRuleIdentifiers.APPROVED_AMIS_BY_ID="APPROVED_AMIS_BY_ID",ManagedRuleIdentifiers.APPROVED_AMIS_BY_TAG="APPROVED_AMIS_BY_TAG",ManagedRuleIdentifiers.AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED="AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED",ManagedRuleIdentifiers.CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK="CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK",ManagedRuleIdentifiers.CLOUDFORMATION_STACK_NOTIFICATION_CHECK="CLOUDFORMATION_STACK_NOTIFICATION_CHECK",ManagedRuleIdentifiers.CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED="CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED",ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED="CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED",ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_FAILOVER_ENABLED="CLOUDFRONT_ORIGIN_FAILOVER_ENABLED",ManagedRuleIdentifiers.CLOUDFRONT_SNI_ENABLED="CLOUDFRONT_SNI_ENABLED",ManagedRuleIdentifiers.CLOUDFRONT_VIEWER_POLICY_HTTPS="CLOUDFRONT_VIEWER_POLICY_HTTPS",ManagedRuleIdentifiers.CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED="CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED",ManagedRuleIdentifiers.CLOUD_TRAIL_ENABLED="CLOUD_TRAIL_ENABLED",ManagedRuleIdentifiers.CLOUD_TRAIL_ENCRYPTION_ENABLED="CLOUD_TRAIL_ENCRYPTION_ENABLED",ManagedRuleIdentifiers.CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED="CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED",ManagedRuleIdentifiers.CLOUDTRAIL_S3_DATAEVENTS_ENABLED="CLOUDTRAIL_S3_DATAEVENTS_ENABLED",ManagedRuleIdentifiers.CLOUDTRAIL_SECURITY_TRAIL_ENABLED="CLOUDTRAIL_SECURITY_TRAIL_ENABLED",ManagedRuleIdentifiers.CLOUDWATCH_ALARM_ACTION_CHECK="CLOUDWATCH_ALARM_ACTION_CHECK",ManagedRuleIdentifiers.CLOUDWATCH_ALARM_RESOURCE_CHECK="CLOUDWATCH_ALARM_RESOURCE_CHECK",ManagedRuleIdentifiers.CLOUDWATCH_ALARM_SETTINGS_CHECK="CLOUDWATCH_ALARM_SETTINGS_CHECK",ManagedRuleIdentifiers.CLOUDWATCH_LOG_GROUP_ENCRYPTED="CLOUDWATCH_LOG_GROUP_ENCRYPTED",ManagedRuleIdentifiers.CMK_BACKING_KEY_ROTATION_ENABLED="CMK_BACKING_KEY_ROTATION_ENABLED",ManagedRuleIdentifiers.CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK="CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK",ManagedRuleIdentifiers.CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK="CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK",ManagedRuleIdentifiers.CODEPIPELINE_DEPLOYMENT_COUNT_CHECK="CODEPIPELINE_DEPLOYMENT_COUNT_CHECK",ManagedRuleIdentifiers.CODEPIPELINE_REGION_FANOUT_CHECK="CODEPIPELINE_REGION_FANOUT_CHECK",ManagedRuleIdentifiers.CW_LOGGROUP_RETENTION_PERIOD_CHECK="CW_LOGGROUP_RETENTION_PERIOD_CHECK",ManagedRuleIdentifiers.DAX_ENCRYPTION_ENABLED="DAX_ENCRYPTION_ENABLED",ManagedRuleIdentifiers.RDS_DB_INSTANCE_BACKUP_ENABLED="DB_INSTANCE_BACKUP_ENABLED",ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TENANCY="DESIRED_INSTANCE_TENANCY",ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TYPE="DESIRED_INSTANCE_TYPE",ManagedRuleIdentifiers.DMS_REPLICATION_NOT_PUBLIC="DMS_REPLICATION_NOT_PUBLIC",ManagedRuleIdentifiers.DYNAMODB_AUTOSCALING_ENABLED="DYNAMODB_AUTOSCALING_ENABLED",ManagedRuleIdentifiers.DYNAMODB_IN_BACKUP_PLAN="DYNAMODB_IN_BACKUP_PLAN",ManagedRuleIdentifiers.DYNAMODB_PITR_ENABLED="DYNAMODB_PITR_ENABLED",ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTED_KMS="DYNAMODB_TABLE_ENCRYPTED_KMS",ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTION_ENABLED="DYNAMODB_TABLE_ENCRYPTION_ENABLED",ManagedRuleIdentifiers.DYNAMODB_THROUGHPUT_LIMIT_CHECK="DYNAMODB_THROUGHPUT_LIMIT_CHECK",ManagedRuleIdentifiers.EBS_IN_BACKUP_PLAN="EBS_IN_BACKUP_PLAN",ManagedRuleIdentifiers.EFS_IN_BACKUP_PLAN="EFS_IN_BACKUP_PLAN",ManagedRuleIdentifiers.EC2_EBS_ENCRYPTION_BY_DEFAULT="EC2_EBS_ENCRYPTION_BY_DEFAULT",ManagedRuleIdentifiers.EBS_OPTIMIZED_INSTANCE="EBS_OPTIMIZED_INSTANCE",ManagedRuleIdentifiers.EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK="EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK",ManagedRuleIdentifiers.EC2_INSTANCE_DETAILED_MONITORING_ENABLED="EC2_INSTANCE_DETAILED_MONITORING_ENABLED",ManagedRuleIdentifiers.EC2_INSTANCE_MANAGED_BY_SSM="EC2_INSTANCE_MANAGED_BY_SSM",ManagedRuleIdentifiers.EC2_INSTANCE_PROFILE_ATTACHED="EC2_INSTANCE_PROFILE_ATTACHED",ManagedRuleIdentifiers.EC2_INSTANCE_NO_PUBLIC_IP="EC2_INSTANCE_NO_PUBLIC_IP",ManagedRuleIdentifiers.EC2_INSTANCES_IN_VPC="INSTANCES_IN_VPC",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED="EC2_MANAGEDINSTANCE_APPLICATIONS_BLACKLISTED",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED="EC2_MANAGEDINSTANCE_APPLICATIONS_REQUIRED",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK="EC2_MANAGEDINSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED="EC2_MANAGEDINSTANCE_INVENTORY_BLACKLISTED",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK="EC2_MANAGEDINSTANCE_PATCH_COMPLIANCE_STATUS_CHECK",ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PLATFORM_CHECK="EC2_MANAGEDINSTANCE_PLATFORM_CHECK",ManagedRuleIdentifiers.EC2_SECURITY_GROUP_ATTACHED_TO_ENI="EC2_SECURITY_GROUP_ATTACHED_TO_ENI",ManagedRuleIdentifiers.EC2_STOPPED_INSTANCE="EC2_STOPPED_INSTANCE",ManagedRuleIdentifiers.EC2_VOLUME_INUSE_CHECK="EC2_VOLUME_INUSE_CHECK",ManagedRuleIdentifiers.EFS_ENCRYPTED_CHECK="EFS_ENCRYPTED_CHECK",ManagedRuleIdentifiers.EIP_ATTACHED="EIP_ATTACHED",ManagedRuleIdentifiers.ELASTICSEARCH_ENCRYPTED_AT_REST="ELASTICSEARCH_ENCRYPTED_AT_REST",ManagedRuleIdentifiers.ELASTICSEARCH_IN_VPC_ONLY="ELASTICSEARCH_IN_VPC_ONLY",ManagedRuleIdentifiers.ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK="ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK",ManagedRuleIdentifiers.EC2_IMDSV2_CHECK="EC2_IMDSV2_CHECK",ManagedRuleIdentifiers.EKS_CLUSTER_OLDEST_SUPPORTED_VERSION="EKS_CLUSTER_OLDEST_SUPPORTED_VERSION",ManagedRuleIdentifiers.EKS_CLUSTER_SUPPORTED_VERSION="EKS_CLUSTER_SUPPORTED_VERSION",ManagedRuleIdentifiers.EKS_ENDPOINT_NO_PUBLIC_ACCESS="EKS_ENDPOINT_NO_PUBLIC_ACCESS",ManagedRuleIdentifiers.EKS_SECRETS_ENCRYPTED="EKS_SECRETS_ENCRYPTED",ManagedRuleIdentifiers.ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK="ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK",ManagedRuleIdentifiers.ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED="ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED",ManagedRuleIdentifiers.ELB_TLS_HTTPS_LISTENERS_ONLY="ELB_TLS_HTTPS_LISTENERS_ONLY",ManagedRuleIdentifiers.ELB_ACM_CERTIFICATE_REQUIRED="ELB_ACM_CERTIFICATE_REQUIRED",ManagedRuleIdentifiers.ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK="ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK",ManagedRuleIdentifiers.ELB_DELETION_PROTECTION_ENABLED="ELB_DELETION_PROTECTION_ENABLED",ManagedRuleIdentifiers.ELB_LOGGING_ENABLED="ELB_LOGGING_ENABLED",ManagedRuleIdentifiers.ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK="ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK",ManagedRuleIdentifiers.EMR_KERBEROS_ENABLED="EMR_KERBEROS_ENABLED",ManagedRuleIdentifiers.EMR_MASTER_NO_PUBLIC_IP="EMR_MASTER_NO_PUBLIC_IP",ManagedRuleIdentifiers.EBS_ENCRYPTED_VOLUMES="ENCRYPTED_VOLUMES",ManagedRuleIdentifiers.FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK="FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK",ManagedRuleIdentifiers.FMS_SECURITY_GROUP_CONTENT_CHECK="FMS_SECURITY_GROUP_CONTENT_CHECK",ManagedRuleIdentifiers.FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK="FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK",ManagedRuleIdentifiers.FMS_SHIELD_RESOURCE_POLICY_CHECK="FMS_SHIELD_RESOURCE_POLICY_CHECK",ManagedRuleIdentifiers.FMS_WEBACL_RESOURCE_POLICY_CHECK="FMS_WEBACL_RESOURCE_POLICY_CHECK",ManagedRuleIdentifiers.FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK="FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK",ManagedRuleIdentifiers.GUARDDUTY_ENABLED_CENTRALIZED="GUARDDUTY_ENABLED_CENTRALIZED",ManagedRuleIdentifiers.GUARDDUTY_NON_ARCHIVED_FINDINGS="GUARDDUTY_NON_ARCHIVED_FINDINGS",ManagedRuleIdentifiers.IAM_NO_INLINE_POLICY_CHECK="IAM_NO_INLINE_POLICY_CHECK",ManagedRuleIdentifiers.IAM_GROUP_HAS_USERS_CHECK="IAM_GROUP_HAS_USERS_CHECK",ManagedRuleIdentifiers.IAM_PASSWORD_POLICY="IAM_PASSWORD_POLICY",ManagedRuleIdentifiers.IAM_POLICY_BLOCKED_CHECK="IAM_POLICY_BLACKLISTED_CHECK",ManagedRuleIdentifiers.IAM_POLICY_IN_USE="IAM_POLICY_IN_USE",ManagedRuleIdentifiers.IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS="IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS",ManagedRuleIdentifiers.IAM_ROLE_MANAGED_POLICY_CHECK="IAM_ROLE_MANAGED_POLICY_CHECK",ManagedRuleIdentifiers.IAM_ROOT_ACCESS_KEY_CHECK="IAM_ROOT_ACCESS_KEY_CHECK",ManagedRuleIdentifiers.IAM_USER_GROUP_MEMBERSHIP_CHECK="IAM_USER_GROUP_MEMBERSHIP_CHECK",ManagedRuleIdentifiers.IAM_USER_MFA_ENABLED="IAM_USER_MFA_ENABLED",ManagedRuleIdentifiers.IAM_USER_NO_POLICIES_CHECK="IAM_USER_NO_POLICIES_CHECK",ManagedRuleIdentifiers.IAM_USER_UNUSED_CREDENTIALS_CHECK="IAM_USER_UNUSED_CREDENTIALS_CHECK",ManagedRuleIdentifiers.INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY="INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY",ManagedRuleIdentifiers.KMS_CMK_NOT_SCHEDULED_FOR_DELETION="KMS_CMK_NOT_SCHEDULED_FOR_DELETION",ManagedRuleIdentifiers.LAMBDA_CONCURRENCY_CHECK="LAMBDA_CONCURRENCY_CHECK",ManagedRuleIdentifiers.LAMBDA_DLQ_CHECK="LAMBDA_DLQ_CHECK",ManagedRuleIdentifiers.LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED="LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED",ManagedRuleIdentifiers.LAMBDA_FUNCTION_SETTINGS_CHECK="LAMBDA_FUNCTION_SETTINGS_CHECK",ManagedRuleIdentifiers.LAMBDA_INSIDE_VPC="LAMBDA_INSIDE_VPC",ManagedRuleIdentifiers.MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS="MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS",ManagedRuleIdentifiers.CLOUDTRAIL_MULTI_REGION_ENABLED="MULTI_REGION_CLOUD_TRAIL_ENABLED",ManagedRuleIdentifiers.RDS_CLUSTER_DELETION_PROTECTION_ENABLED="RDS_CLUSTER_DELETION_PROTECTION_ENABLED",ManagedRuleIdentifiers.RDS_INSTANCE_DELETION_PROTECTION_ENABLED="RDS_INSTANCE_DELETION_PROTECTION_ENABLED",ManagedRuleIdentifiers.RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED="RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED",ManagedRuleIdentifiers.RDS_LOGGING_ENABLED="RDS_LOGGING_ENABLED",ManagedRuleIdentifiers.REDSHIFT_BACKUP_ENABLED="REDSHIFT_BACKUP_ENABLED",ManagedRuleIdentifiers.RDS_ENHANCED_MONITORING_ENABLED="RDS_ENHANCED_MONITORING_ENABLED",ManagedRuleIdentifiers.RDS_SNAPSHOT_ENCRYPTED="RDS_SNAPSHOT_ENCRYPTED",ManagedRuleIdentifiers.REDSHIFT_REQUIRE_TLS_SSL="REDSHIFT_REQUIRE_TLS_SSL",ManagedRuleIdentifiers.RDS_IN_BACKUP_PLAN="RDS_IN_BACKUP_PLAN",ManagedRuleIdentifiers.RDS_INSTANCE_PUBLIC_ACCESS_CHECK="RDS_INSTANCE_PUBLIC_ACCESS_CHECK",ManagedRuleIdentifiers.RDS_MULTI_AZ_SUPPORT="RDS_MULTI_AZ_SUPPORT",ManagedRuleIdentifiers.RDS_SNAPSHOTS_PUBLIC_PROHIBITED="RDS_SNAPSHOTS_PUBLIC_PROHIBITED",ManagedRuleIdentifiers.RDS_STORAGE_ENCRYPTED="RDS_STORAGE_ENCRYPTED",ManagedRuleIdentifiers.REDSHIFT_CLUSTER_CONFIGURATION_CHECK="REDSHIFT_CLUSTER_CONFIGURATION_CHECK",ManagedRuleIdentifiers.REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK="REDSHIFT_CLUSTER_MAINTENANCESETTINGS_CHECK",ManagedRuleIdentifiers.REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK="REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK",ManagedRuleIdentifiers.REQUIRED_TAGS="REQUIRED_TAGS",ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC="RESTRICTED_INCOMING_TRAFFIC",ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED="INCOMING_SSH_DISABLED",ManagedRuleIdentifiers.ROOT_ACCOUNT_HARDWARE_MFA_ENABLED="ROOT_ACCOUNT_HARDWARE_MFA_ENABLED",ManagedRuleIdentifiers.ROOT_ACCOUNT_MFA_ENABLED="ROOT_ACCOUNT_MFA_ENABLED",ManagedRuleIdentifiers.S3_BUCKET_DEFAULT_LOCK_ENABLED="S3_BUCKET_DEFAULT_LOCK_ENABLED",ManagedRuleIdentifiers.S3_DEFAULT_ENCRYPTION_KMS="S3_DEFAULT_ENCRYPTION_KMS",ManagedRuleIdentifiers.SECURITYHUB_ENABLED="SECURITYHUB_ENABLED",ManagedRuleIdentifiers.SNS_ENCRYPTED_KMS="SNS_ENCRYPTED_KMS",ManagedRuleIdentifiers.S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS="S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS",ManagedRuleIdentifiers.S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED="S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED",ManagedRuleIdentifiers.S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED="S3_BUCKET_BLACKLISTED_ACTIONS_PROHIBITED",ManagedRuleIdentifiers.S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE="S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE",ManagedRuleIdentifiers.S3_BUCKET_LOGGING_ENABLED="S3_BUCKET_LOGGING_ENABLED",ManagedRuleIdentifiers.S3_BUCKET_POLICY_GRANTEE_CHECK="S3_BUCKET_POLICY_GRANTEE_CHECK",ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_READ_PROHIBITED="S3_BUCKET_PUBLIC_READ_PROHIBITED",ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_WRITE_PROHIBITED="S3_BUCKET_PUBLIC_WRITE_PROHIBITED",ManagedRuleIdentifiers.S3_BUCKET_REPLICATION_ENABLED="S3_BUCKET_REPLICATION_ENABLED",ManagedRuleIdentifiers.S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED="S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED",ManagedRuleIdentifiers.S3_BUCKET_SSL_REQUESTS_ONLY="S3_BUCKET_SSL_REQUESTS_ONLY",ManagedRuleIdentifiers.S3_BUCKET_VERSIONING_ENABLED="S3_BUCKET_VERSIONING_ENABLED",ManagedRuleIdentifiers.SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED="SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED",ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED="SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED",ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS="SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS",ManagedRuleIdentifiers.SECRETSMANAGER_ROTATION_ENABLED_CHECK="SECRETSMANAGER_ROTATION_ENABLED_CHECK",ManagedRuleIdentifiers.SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK="SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK",ManagedRuleIdentifiers.SERVICE_VPC_ENDPOINT_ENABLED="SERVICE_VPC_ENDPOINT_ENABLED",ManagedRuleIdentifiers.SHIELD_ADVANCED_ENABLED_AUTO_RENEW="SHIELD_ADVANCED_ENABLED_AUTORENEW",ManagedRuleIdentifiers.SHIELD_DRT_ACCESS="SHIELD_DRT_ACCESS",ManagedRuleIdentifiers.VPC_DEFAULT_SECURITY_GROUP_CLOSED="VPC_DEFAULT_SECURITY_GROUP_CLOSED",ManagedRuleIdentifiers.VPC_FLOW_LOGS_ENABLED="VPC_FLOW_LOGS_ENABLED",ManagedRuleIdentifiers.VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS="VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS",ManagedRuleIdentifiers.VPC_VPN_2_TUNNELS_UP="VPC_VPN_2_TUNNELS_UP",ManagedRuleIdentifiers.WAF_CLASSIC_LOGGING_ENABLED="WAF_CLASSIC_LOGGING_ENABLED",ManagedRuleIdentifiers.WAFV2_LOGGING_ENABLED="WAFV2_LOGGING_ENABLED";class ResourceType{constructor(type){this.complianceResourceType=type}static of(type){return new ResourceType(type)}}exports.ResourceType=ResourceType,_e=JSII_RTTI_SYMBOL_1,ResourceType[_e]={fqn:"aws-cdk-lib.aws_config.ResourceType",version:"2.42.0"},ResourceType.APIGATEWAY_STAGE=new ResourceType("AWS::ApiGateway::Stage"),ResourceType.APIGATEWAYV2_STAGE=new ResourceType("AWS::ApiGatewayV2::Stage"),ResourceType.APIGATEWAY_REST_API=new ResourceType("AWS::ApiGateway::RestApi"),ResourceType.APIGATEWAYV2_API=new ResourceType("AWS::ApiGatewayV2::Api"),ResourceType.CLOUDFRONT_DISTRIBUTION=new ResourceType("AWS::CloudFront::Distribution"),ResourceType.CLOUDFRONT_STREAMING_DISTRIBUTION=new ResourceType("AWS::CloudFront::StreamingDistribution"),ResourceType.CLOUDWATCH_ALARM=new ResourceType("AWS::CloudWatch::Alarm"),ResourceType.DYNAMODB_TABLE=new ResourceType("AWS::DynamoDB::Table"),ResourceType.EBS_VOLUME=new ResourceType("AWS::EC2::Volume"),ResourceType.EC2_HOST=new ResourceType("AWS::EC2::Host"),ResourceType.EC2_EIP=new ResourceType("AWS::EC2::EIP"),ResourceType.EC2_INSTANCE=new ResourceType("AWS::EC2::Instance"),ResourceType.EC2_NETWORK_INTERFACE=new ResourceType("AWS::EC2::NetworkInterface"),ResourceType.EC2_SECURITY_GROUP=new ResourceType("AWS::EC2::SecurityGroup"),ResourceType.EC2_NAT_GATEWAY=new ResourceType("AWS::EC2::NatGateway"),ResourceType.EC2_EGRESS_ONLY_INTERNET_GATEWAY=new ResourceType("AWS::EC2::EgressOnlyInternetGateway"),ResourceType.EC2_FLOW_LOG=new ResourceType("AWS::EC2::FlowLog"),ResourceType.EC2_TRANSIT_GATEWAY=new ResourceType("AWS::EC2::TransitGateway"),ResourceType.EC2_TRANSIT_GATEWAY_ATTACHMENT=new ResourceType("AWS::EC2::TransitGatewayAttachment"),ResourceType.EC2_TRANSIT_GATEWAY_ROUTE_TABLE=new ResourceType("AWS::EC2::TransitGatewayRouteTable"),ResourceType.EC2_VPC_ENDPOINT=new ResourceType("AWS::EC2::VPCEndpoint"),ResourceType.EC2_VPC_ENDPOINT_SERVICE=new ResourceType("AWS::EC2::VPCEndpointService"),ResourceType.EC2_VPC_PEERING_CONNECTION=new ResourceType("AWS::EC2::VPCPeeringConnection"),ResourceType.EC2_REGISTERED_HA_INSTANCE=new ResourceType("AWS::EC2::RegisteredHAInstance"),ResourceType.EC2_LAUNCH_TEMPLATE=new ResourceType("AWS::EC2::LaunchTemplate"),ResourceType.ECR_REPOSITORY=new ResourceType("AWS::ECR::Repository"),ResourceType.ECR_PUBLIC_REPOSITORY=new ResourceType("AWS::ECR::PublicRepository"),ResourceType.ECS_CLUSTER=new ResourceType("AWS::ECS::Cluster"),ResourceType.ECS_TASK_DEFINITION=new ResourceType("AWS::ECS::TaskDefinition"),ResourceType.ECS_SERVICE=new ResourceType("AWS::ECS::Service"),ResourceType.EFS_FILE_SYSTEM=new ResourceType("AWS::EFS::FileSystem"),ResourceType.EFS_ACCESS_POINT=new ResourceType("AWS::EFS::AccessPoint"),ResourceType.EKS_CLUSTER=new ResourceType("AWS::EKS::Cluster"),ResourceType.EMR_SECURITY_CONFIGURATION=new ResourceType("AWS::EMR::SecurityConfiguration"),ResourceType.GUARDDUTY_DETECTOR=new ResourceType("AWS::GuardDuty::Detector"),ResourceType.ELASTICSEARCH_DOMAIN=new ResourceType("AWS::Elasticsearch::Domain"),ResourceType.OPENSEARCH_DOMAIN=new ResourceType("AWS::OpenSearch::Domain"),ResourceType.QLDB_LEDGER=new ResourceType("AWS::QLDB::Ledger"),ResourceType.KINESIS_STREAM=new ResourceType("AWS::Kinesis::Stream"),ResourceType.KINESIS_STREAM_CONSUMER=new ResourceType("AWS::Kinesis::StreamConsumer"),ResourceType.MSK_CLUSTER=new ResourceType("AWS::MSK::Cluster"),ResourceType.REDSHIFT_CLUSTER=new ResourceType("AWS::Redshift::Cluster"),ResourceType.REDSHIFT_CLUSTER_PARAMETER_GROUP=new ResourceType("AWS::Redshift::ClusterParameterGroup"),ResourceType.REDSHIFT_CLUSTER_SECURITY_GROUP=new ResourceType("AWS::Redshift::ClusterSecurityGroup"),ResourceType.REDSHIFT_CLUSTER_SNAPSHOT=new ResourceType("AWS::Redshift::ClusterSnapshot"),ResourceType.REDSHIFT_CLUSTER_SUBNET_GROUP=new ResourceType("AWS::Redshift::ClusterSubnetGroup"),ResourceType.REDSHIFT_EVENT_SUBSCRIPTION=new ResourceType("AWS::Redshift::EventSubscription"),ResourceType.RDS_DB_INSTANCE=new ResourceType("AWS::RDS::DBInstance"),ResourceType.RDS_DB_SECURITY_GROUP=new ResourceType("AWS::RDS::DBSecurityGroup"),ResourceType.RDS_DB_SNAPSHOT=new ResourceType("AWS::RDS::DBSnapshot"),ResourceType.RDS_DB_SUBNET_GROUP=new ResourceType("AWS::RDS::DBSubnetGroup"),ResourceType.RDS_EVENT_SUBSCRIPTION=new ResourceType("AWS::RDS::EventSubscription"),ResourceType.RDS_DB_CLUSTER=new ResourceType("AWS::RDS::DBCluster"),ResourceType.RDS_DB_CLUSTER_SNAPSHOT=new ResourceType("AWS::RDS::DBClusterSnapshot"),ResourceType.ROUTE53_RESOLVER_RESOLVER_ENDPOINT=new ResourceType("AWS::Route53Resolver::ResolverEndpoint"),ResourceType.ROUTE53_RESOLVER_RESOLVER_RULE=new ResourceType("AWS::Route53Resolver::ResolverRule"),ResourceType.ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION=new ResourceType("AWS::Route53Resolver::ResolverRuleAssociation"),ResourceType.SQS_QUEUE=new ResourceType("AWS::SQS::Queue"),ResourceType.SNS_TOPIC=new ResourceType("AWS::SNS::Topic"),ResourceType.S3_BUCKET=new ResourceType("AWS::S3::Bucket"),ResourceType.SAGEMAKER_CODE_REPOSITORY=new ResourceType("AWS::SageMaker::CodeRepository"),ResourceType.SAGEMAKER_MODEL=new ResourceType("AWS::SageMaker::Model"),ResourceType.SAGEMAKER_NOTEBOOK_INSTANCE=new ResourceType("AWS::SageMaker::NotebookInstance"),ResourceType.S3_ACCOUNT_PUBLIC_ACCESS_BLOCK=new ResourceType("AWS::S3::AccountPublicAccessBlock"),ResourceType.EC2_CUSTOMER_GATEWAY=new ResourceType("AWS::EC2::CustomerGateway"),ResourceType.EC2_INTERNET_GATEWAY=new ResourceType("AWS::EC2::InternetGateway"),ResourceType.EC2_NETWORK_ACL=new ResourceType("AWS::EC2::NetworkAcl"),ResourceType.EC2_ROUTE_TABLE=new ResourceType("AWS::EC2::RouteTable"),ResourceType.EC2_SUBNET=new ResourceType("AWS::EC2::Subnet"),ResourceType.EC2_VPC=new ResourceType("AWS::EC2::VPC"),ResourceType.EC2_VPN_CONNECTION=new ResourceType("AWS::EC2::VPNConnection"),ResourceType.EC2_VPN_GATEWAY=new ResourceType("AWS::EC2::VPNGateway"),ResourceType.AUTO_SCALING_GROUP=new ResourceType("AWS::AutoScaling::AutoScalingGroup"),ResourceType.AUTO_SCALING_LAUNCH_CONFIGURATION=new ResourceType("AWS::AutoScaling::LaunchConfiguration"),ResourceType.AUTO_SCALING_POLICY=new ResourceType("AWS::AutoScaling::ScalingPolicy"),ResourceType.AUTO_SCALING_SCHEDULED_ACTION=new ResourceType("AWS::AutoScaling::ScheduledAction"),ResourceType.WORKSPACES_CONNECTION_ALIAS=new ResourceType("AWS::WorkSpaces::ConnectionAlias"),ResourceType.WORKSPACES_WORKSPACE=new ResourceType("AWS::WorkSpaces::Workspace"),ResourceType.BACKUP_BACKUP_PLAN=new ResourceType("AWS::Backup::BackupPlan"),ResourceType.BACKUP_BACKUP_SELECTION=new ResourceType("AWS::Backup::BackupSelection"),ResourceType.BACKUP_BACKUP_VAULT=new ResourceType("AWS::Backup::BackupVault"),ResourceType.BACKUP_RECOVERY_POINT=new ResourceType("AWS::Backup::RecoveryPoint"),ResourceType.BATCH_JOB_QUEUE=new ResourceType("AWS::Batch::JobQueue"),ResourceType.BATCH_COMPUTE_ENVIRONMENT=new ResourceType("AWS::Batch::ComputeEnvironment"),ResourceType.ACM_CERTIFICATE=new ResourceType("AWS::ACM::Certificate"),ResourceType.CLOUDFORMATION_STACK=new ResourceType("AWS::CloudFormation::Stack"),ResourceType.CLOUDTRAIL_TRAIL=new ResourceType("AWS::CloudTrail::Trail"),ResourceType.CODEBUILD_PROJECT=new ResourceType("AWS::CodeBuild::Project"),ResourceType.CODEDEPLOY_APPLICATION=new ResourceType("AWS::CodeDeploy::Application"),ResourceType.CODEDEPLOY_DEPLOYMENT_CONFIG=new ResourceType("AWS::CodeDeploy::DeploymentConfig"),ResourceType.CODEDEPLOY_DEPLOYMENT_GROUP=new ResourceType("AWS::CodeDeploy::DeploymentGroup"),ResourceType.CODEPIPELINE_PIPELINE=new ResourceType("AWS::CodePipeline::Pipeline"),ResourceType.CONFIG_RESOURCE_COMPLIANCE=new ResourceType("AWS::Config::ResourceCompliance"),ResourceType.CONFIG_CONFORMANCE_PACK_COMPLIANCE=new ResourceType("AWS::Config::ConformancePackCompliance"),ResourceType.DMS_EVENT_SUBSCRIPTION=new ResourceType("AWS::DMS::EventSubscription"),ResourceType.DMS_REPLICATION_SUBNET_GROUP=new ResourceType("AWS::DMS::ReplicationSubnetGroup"),ResourceType.ELASTIC_BEANSTALK_APPLICATION=new ResourceType("AWS::ElasticBeanstalk::Application"),ResourceType.ELASTIC_BEANSTALK_APPLICATION_VERSION=new ResourceType("AWS::ElasticBeanstalk::ApplicationVersion"),ResourceType.ELASTIC_BEANSTALK_ENVIRONMENT=new ResourceType("AWS::ElasticBeanstalk::Environment"),ResourceType.GLOBALACCELERATOR_LISTENER=new ResourceType("AWS::GlobalAccelerator::Listener"),ResourceType.GLOBALACCELERATOR_ENDPOINT_GROUP=new ResourceType("AWS::GlobalAccelerator::EndpointGroup"),ResourceType.GLOBALACCELERATOR_ACCELERATOR=new ResourceType("AWS::GlobalAccelerator::Accelerator"),ResourceType.IAM_USER=new ResourceType("AWS::IAM::User"),ResourceType.IAM_GROUP=new ResourceType("AWS::IAM::Group"),ResourceType.IAM_ROLE=new ResourceType("AWS::IAM::Role"),ResourceType.IAM_POLICY=new ResourceType("AWS::IAM::Policy"),ResourceType.IAM_ACCESSANALYZER_ANALYZER=new ResourceType("AWS::AccessAnalyzer::Analyzer"),ResourceType.KMS_KEY=new ResourceType("AWS::KMS::Key"),ResourceType.LAMBDA_FUNCTION=new ResourceType("AWS::Lambda::Function"),ResourceType.SECRETS_MANAGER_SECRET=new ResourceType("AWS::SecretsManager::Secret"),ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PRODUCT=new ResourceType("AWS::ServiceCatalog::CloudFormationProduct"),ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT=new ResourceType("AWS::ServiceCatalog::CloudFormationProvisionedProduct"),ResourceType.SERVICE_CATALOG_PORTFOLIO=new ResourceType("AWS::ServiceCatalog::Portfolio"),ResourceType.SHIELD_PROTECTION=new ResourceType("AWS::Shield::Protection"),ResourceType.SHIELD_REGIONAL_PROTECTION=new ResourceType("AWS::ShieldRegional::Protection"),ResourceType.STEPFUNCTIONS_ACTIVITY=new ResourceType("AWS::StepFunctions::Activity"),ResourceType.STEPFUNCTIONS_STATE_MACHINE=new ResourceType("AWS::StepFunctions::StateMachine"),ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY=new ResourceType("AWS::SSM::ManagedInstanceInventory"),ResourceType.SYSTEMS_MANAGER_PATCH_COMPLIANCE=new ResourceType("AWS::SSM::PatchCompliance"),ResourceType.SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE=new ResourceType("AWS::SSM::AssociationCompliance"),ResourceType.SYSTEMS_MANAGER_FILE_DATA=new ResourceType("AWS::SSM::FileData"),ResourceType.WAF_RATE_BASED_RULE=new ResourceType("AWS::WAF::RateBasedRule"),ResourceType.WAF_RULE=new ResourceType("AWS::WAF::Rule"),ResourceType.WAF_WEB_ACL=new ResourceType("AWS::WAF::WebACL"),ResourceType.WAF_RULE_GROUP=new ResourceType("AWS::WAF::RuleGroup"),ResourceType.WAF_REGIONAL_RATE_BASED_RULE=new ResourceType("AWS::WAFRegional::RateBasedRule"),ResourceType.WAF_REGIONAL_RULE=new ResourceType("AWS::WAFRegional::Rule"),ResourceType.WAF_REGIONAL_WEB_ACL=new ResourceType("AWS::WAFRegional::WebACL"),ResourceType.WAF_REGIONAL_RULE_GROUP=new ResourceType("AWS::WAFRegional::RuleGroup"),ResourceType.WAFV2_WEB_ACL=new ResourceType("AWS::WAFv2::WebACL"),ResourceType.WAFV2_RULE_GROUP=new ResourceType("AWS::WAFv2::RuleGroup"),ResourceType.WAFV2_MANAGED_RULE_SET=new ResourceType("AWS::WAFv2::ManagedRuleSet"),ResourceType.WAFV2_IP_SET=new ResourceType("AWS::WAFv2::IPSet"),ResourceType.WAFV2_REGEX_PATTERN_SET=new ResourceType("AWS::WAFv2::RegexPatternSet"),ResourceType.XRAY_ENCRYPTION_CONFIGURATION=new ResourceType("AWS::XRay::EncryptionConfig"),ResourceType.ELB_LOAD_BALANCER=new ResourceType("AWS::ElasticLoadBalancing::LoadBalancer"),ResourceType.ELBV2_LOAD_BALANCER=new ResourceType("AWS::ElasticLoadBalancingV2::LoadBalancer"),ResourceType.ELBV2_LISTENER=new ResourceType("AWS::ElasticLoadBalancingV2::Listener");function renderScope(ruleScope){return ruleScope?{complianceResourceId:ruleScope.resourceId,complianceResourceTypes:ruleScope.resourceTypes?.map(resource=>resource.complianceResourceType),tagKey:ruleScope.key,tagValue:ruleScope.value}:void 0}
//# sourceMappingURL=rule.js.map
