"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnObjectType=exports.CfnIntegration=exports.CfnDomain=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnDomainPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("deadLetterQueueUrl",cdk.validateString)(properties.deadLetterQueueUrl)),errors.collect(cdk.propertyValidator("defaultEncryptionKey",cdk.validateString)(properties.defaultEncryptionKey)),errors.collect(cdk.propertyValidator("defaultExpirationDays",cdk.validateNumber)(properties.defaultExpirationDays)),errors.collect(cdk.propertyValidator("domainName",cdk.requiredValidator)(properties.domainName)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDomainProps"')}function cfnDomainPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomainPropsValidator(properties).assertSuccess(),{DomainName:cdk.stringToCloudFormation(properties.domainName),DeadLetterQueueUrl:cdk.stringToCloudFormation(properties.deadLetterQueueUrl),DefaultEncryptionKey:cdk.stringToCloudFormation(properties.defaultEncryptionKey),DefaultExpirationDays:cdk.numberToCloudFormation(properties.defaultExpirationDays),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDomainPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("domainName","DomainName",cfn_parse.FromCloudFormation.getString(properties.DomainName)),ret.addPropertyResult("deadLetterQueueUrl","DeadLetterQueueUrl",properties.DeadLetterQueueUrl!=null?cfn_parse.FromCloudFormation.getString(properties.DeadLetterQueueUrl):void 0),ret.addPropertyResult("defaultEncryptionKey","DefaultEncryptionKey",properties.DefaultEncryptionKey!=null?cfn_parse.FromCloudFormation.getString(properties.DefaultEncryptionKey):void 0),ret.addPropertyResult("defaultExpirationDays","DefaultExpirationDays",properties.DefaultExpirationDays!=null?cfn_parse.FromCloudFormation.getNumber(properties.DefaultExpirationDays):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDomain extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnDomain.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_customerprofiles_CfnDomainProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDomain),error}cdk.requireProperty(props,"domainName",this),this.attrCreatedAt=cdk.Token.asString(this.getAtt("CreatedAt")),this.attrLastUpdatedAt=cdk.Token.asString(this.getAtt("LastUpdatedAt")),this.domainName=props.domainName,this.deadLetterQueueUrl=props.deadLetterQueueUrl,this.defaultEncryptionKey=props.defaultEncryptionKey,this.defaultExpirationDays=props.defaultExpirationDays,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CustomerProfiles::Domain",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDomainPropsFromCloudFormation(resourceProperties),ret=new CfnDomain(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDomain.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{domainName:this.domainName,deadLetterQueueUrl:this.deadLetterQueueUrl,defaultEncryptionKey:this.defaultEncryptionKey,defaultExpirationDays:this.defaultExpirationDays,tags:this.tags.renderTags()}}renderProperties(props){return cfnDomainPropsToCloudFormation(props)}}exports.CfnDomain=CfnDomain,_a=JSII_RTTI_SYMBOL_1,CfnDomain[_a]={fqn:"aws-cdk-lib.aws_customerprofiles.CfnDomain",version:"2.42.0"},CfnDomain.CFN_RESOURCE_TYPE_NAME="AWS::CustomerProfiles::Domain";function CfnIntegrationPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("domainName",cdk.requiredValidator)(properties.domainName)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("flowDefinition",CfnIntegration_FlowDefinitionPropertyValidator)(properties.flowDefinition)),errors.collect(cdk.propertyValidator("objectTypeName",cdk.validateString)(properties.objectTypeName)),errors.collect(cdk.propertyValidator("objectTypeNames",cdk.listValidator(CfnIntegration_ObjectTypeMappingPropertyValidator))(properties.objectTypeNames)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("uri",cdk.validateString)(properties.uri)),errors.wrap('supplied properties not correct for "CfnIntegrationProps"')}function cfnIntegrationPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegrationPropsValidator(properties).assertSuccess(),{DomainName:cdk.stringToCloudFormation(properties.domainName),FlowDefinition:cfnIntegrationFlowDefinitionPropertyToCloudFormation(properties.flowDefinition),ObjectTypeName:cdk.stringToCloudFormation(properties.objectTypeName),ObjectTypeNames:cdk.listMapper(cfnIntegrationObjectTypeMappingPropertyToCloudFormation)(properties.objectTypeNames),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),Uri:cdk.stringToCloudFormation(properties.uri)}):properties}function CfnIntegrationPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("domainName","DomainName",cfn_parse.FromCloudFormation.getString(properties.DomainName)),ret.addPropertyResult("flowDefinition","FlowDefinition",properties.FlowDefinition!=null?CfnIntegrationFlowDefinitionPropertyFromCloudFormation(properties.FlowDefinition):void 0),ret.addPropertyResult("objectTypeName","ObjectTypeName",properties.ObjectTypeName!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectTypeName):void 0),ret.addPropertyResult("objectTypeNames","ObjectTypeNames",properties.ObjectTypeNames!=null?cfn_parse.FromCloudFormation.getArray(CfnIntegrationObjectTypeMappingPropertyFromCloudFormation)(properties.ObjectTypeNames):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("uri","Uri",properties.Uri!=null?cfn_parse.FromCloudFormation.getString(properties.Uri):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnIntegration extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnIntegration.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_customerprofiles_CfnIntegrationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnIntegration),error}cdk.requireProperty(props,"domainName",this),this.attrCreatedAt=cdk.Token.asString(this.getAtt("CreatedAt")),this.attrLastUpdatedAt=cdk.Token.asString(this.getAtt("LastUpdatedAt")),this.domainName=props.domainName,this.flowDefinition=props.flowDefinition,this.objectTypeName=props.objectTypeName,this.objectTypeNames=props.objectTypeNames,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CustomerProfiles::Integration",props.tags,{tagPropertyName:"tags"}),this.uri=props.uri}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnIntegrationPropsFromCloudFormation(resourceProperties),ret=new CfnIntegration(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnIntegration.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{domainName:this.domainName,flowDefinition:this.flowDefinition,objectTypeName:this.objectTypeName,objectTypeNames:this.objectTypeNames,tags:this.tags.renderTags(),uri:this.uri}}renderProperties(props){return cfnIntegrationPropsToCloudFormation(props)}}exports.CfnIntegration=CfnIntegration,_b=JSII_RTTI_SYMBOL_1,CfnIntegration[_b]={fqn:"aws-cdk-lib.aws_customerprofiles.CfnIntegration",version:"2.42.0"},CfnIntegration.CFN_RESOURCE_TYPE_NAME="AWS::CustomerProfiles::Integration";function CfnIntegration_ConnectorOperatorPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("marketo",cdk.validateString)(properties.marketo)),errors.collect(cdk.propertyValidator("s3",cdk.validateString)(properties.s3)),errors.collect(cdk.propertyValidator("salesforce",cdk.validateString)(properties.salesforce)),errors.collect(cdk.propertyValidator("serviceNow",cdk.validateString)(properties.serviceNow)),errors.collect(cdk.propertyValidator("zendesk",cdk.validateString)(properties.zendesk)),errors.wrap('supplied properties not correct for "ConnectorOperatorProperty"')}function cfnIntegrationConnectorOperatorPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_ConnectorOperatorPropertyValidator(properties).assertSuccess(),{Marketo:cdk.stringToCloudFormation(properties.marketo),S3:cdk.stringToCloudFormation(properties.s3),Salesforce:cdk.stringToCloudFormation(properties.salesforce),ServiceNow:cdk.stringToCloudFormation(properties.serviceNow),Zendesk:cdk.stringToCloudFormation(properties.zendesk)}):properties}function CfnIntegrationConnectorOperatorPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("marketo","Marketo",properties.Marketo!=null?cfn_parse.FromCloudFormation.getString(properties.Marketo):void 0),ret.addPropertyResult("s3","S3",properties.S3!=null?cfn_parse.FromCloudFormation.getString(properties.S3):void 0),ret.addPropertyResult("salesforce","Salesforce",properties.Salesforce!=null?cfn_parse.FromCloudFormation.getString(properties.Salesforce):void 0),ret.addPropertyResult("serviceNow","ServiceNow",properties.ServiceNow!=null?cfn_parse.FromCloudFormation.getString(properties.ServiceNow):void 0),ret.addPropertyResult("zendesk","Zendesk",properties.Zendesk!=null?cfn_parse.FromCloudFormation.getString(properties.Zendesk):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_FlowDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("flowName",cdk.requiredValidator)(properties.flowName)),errors.collect(cdk.propertyValidator("flowName",cdk.validateString)(properties.flowName)),errors.collect(cdk.propertyValidator("kmsArn",cdk.requiredValidator)(properties.kmsArn)),errors.collect(cdk.propertyValidator("kmsArn",cdk.validateString)(properties.kmsArn)),errors.collect(cdk.propertyValidator("sourceFlowConfig",cdk.requiredValidator)(properties.sourceFlowConfig)),errors.collect(cdk.propertyValidator("sourceFlowConfig",CfnIntegration_SourceFlowConfigPropertyValidator)(properties.sourceFlowConfig)),errors.collect(cdk.propertyValidator("tasks",cdk.requiredValidator)(properties.tasks)),errors.collect(cdk.propertyValidator("tasks",cdk.listValidator(CfnIntegration_TaskPropertyValidator))(properties.tasks)),errors.collect(cdk.propertyValidator("triggerConfig",cdk.requiredValidator)(properties.triggerConfig)),errors.collect(cdk.propertyValidator("triggerConfig",CfnIntegration_TriggerConfigPropertyValidator)(properties.triggerConfig)),errors.wrap('supplied properties not correct for "FlowDefinitionProperty"')}function cfnIntegrationFlowDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_FlowDefinitionPropertyValidator(properties).assertSuccess(),{Description:cdk.stringToCloudFormation(properties.description),FlowName:cdk.stringToCloudFormation(properties.flowName),KmsArn:cdk.stringToCloudFormation(properties.kmsArn),SourceFlowConfig:cfnIntegrationSourceFlowConfigPropertyToCloudFormation(properties.sourceFlowConfig),Tasks:cdk.listMapper(cfnIntegrationTaskPropertyToCloudFormation)(properties.tasks),TriggerConfig:cfnIntegrationTriggerConfigPropertyToCloudFormation(properties.triggerConfig)}):properties}function CfnIntegrationFlowDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("flowName","FlowName",cfn_parse.FromCloudFormation.getString(properties.FlowName)),ret.addPropertyResult("kmsArn","KmsArn",cfn_parse.FromCloudFormation.getString(properties.KmsArn)),ret.addPropertyResult("sourceFlowConfig","SourceFlowConfig",CfnIntegrationSourceFlowConfigPropertyFromCloudFormation(properties.SourceFlowConfig)),ret.addPropertyResult("tasks","Tasks",cfn_parse.FromCloudFormation.getArray(CfnIntegrationTaskPropertyFromCloudFormation)(properties.Tasks)),ret.addPropertyResult("triggerConfig","TriggerConfig",CfnIntegrationTriggerConfigPropertyFromCloudFormation(properties.TriggerConfig)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_IncrementalPullConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datetimeTypeFieldName",cdk.validateString)(properties.datetimeTypeFieldName)),errors.wrap('supplied properties not correct for "IncrementalPullConfigProperty"')}function cfnIntegrationIncrementalPullConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_IncrementalPullConfigPropertyValidator(properties).assertSuccess(),{DatetimeTypeFieldName:cdk.stringToCloudFormation(properties.datetimeTypeFieldName)}):properties}function CfnIntegrationIncrementalPullConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datetimeTypeFieldName","DatetimeTypeFieldName",properties.DatetimeTypeFieldName!=null?cfn_parse.FromCloudFormation.getString(properties.DatetimeTypeFieldName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_MarketoSourcePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("object",cdk.requiredValidator)(properties.object)),errors.collect(cdk.propertyValidator("object",cdk.validateString)(properties.object)),errors.wrap('supplied properties not correct for "MarketoSourcePropertiesProperty"')}function cfnIntegrationMarketoSourcePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_MarketoSourcePropertiesPropertyValidator(properties).assertSuccess(),{Object:cdk.stringToCloudFormation(properties.object)}):properties}function CfnIntegrationMarketoSourcePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("object","Object",cfn_parse.FromCloudFormation.getString(properties.Object)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_ObjectTypeMappingPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("key",cdk.requiredValidator)(properties.key)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.wrap('supplied properties not correct for "ObjectTypeMappingProperty"')}function cfnIntegrationObjectTypeMappingPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_ObjectTypeMappingPropertyValidator(properties).assertSuccess(),{Key:cdk.stringToCloudFormation(properties.key),Value:cdk.stringToCloudFormation(properties.value)}):properties}function CfnIntegrationObjectTypeMappingPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("key","Key",cfn_parse.FromCloudFormation.getString(properties.Key)),ret.addPropertyResult("value","Value",cfn_parse.FromCloudFormation.getString(properties.Value)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_S3SourcePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketName",cdk.requiredValidator)(properties.bucketName)),errors.collect(cdk.propertyValidator("bucketName",cdk.validateString)(properties.bucketName)),errors.collect(cdk.propertyValidator("bucketPrefix",cdk.validateString)(properties.bucketPrefix)),errors.wrap('supplied properties not correct for "S3SourcePropertiesProperty"')}function cfnIntegrationS3SourcePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_S3SourcePropertiesPropertyValidator(properties).assertSuccess(),{BucketName:cdk.stringToCloudFormation(properties.bucketName),BucketPrefix:cdk.stringToCloudFormation(properties.bucketPrefix)}):properties}function CfnIntegrationS3SourcePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketName","BucketName",cfn_parse.FromCloudFormation.getString(properties.BucketName)),ret.addPropertyResult("bucketPrefix","BucketPrefix",properties.BucketPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.BucketPrefix):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_SalesforceSourcePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enableDynamicFieldUpdate",cdk.validateBoolean)(properties.enableDynamicFieldUpdate)),errors.collect(cdk.propertyValidator("includeDeletedRecords",cdk.validateBoolean)(properties.includeDeletedRecords)),errors.collect(cdk.propertyValidator("object",cdk.requiredValidator)(properties.object)),errors.collect(cdk.propertyValidator("object",cdk.validateString)(properties.object)),errors.wrap('supplied properties not correct for "SalesforceSourcePropertiesProperty"')}function cfnIntegrationSalesforceSourcePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_SalesforceSourcePropertiesPropertyValidator(properties).assertSuccess(),{EnableDynamicFieldUpdate:cdk.booleanToCloudFormation(properties.enableDynamicFieldUpdate),IncludeDeletedRecords:cdk.booleanToCloudFormation(properties.includeDeletedRecords),Object:cdk.stringToCloudFormation(properties.object)}):properties}function CfnIntegrationSalesforceSourcePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enableDynamicFieldUpdate","EnableDynamicFieldUpdate",properties.EnableDynamicFieldUpdate!=null?cfn_parse.FromCloudFormation.getBoolean(properties.EnableDynamicFieldUpdate):void 0),ret.addPropertyResult("includeDeletedRecords","IncludeDeletedRecords",properties.IncludeDeletedRecords!=null?cfn_parse.FromCloudFormation.getBoolean(properties.IncludeDeletedRecords):void 0),ret.addPropertyResult("object","Object",cfn_parse.FromCloudFormation.getString(properties.Object)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_ScheduledTriggerPropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dataPullMode",cdk.validateString)(properties.dataPullMode)),errors.collect(cdk.propertyValidator("firstExecutionFrom",cdk.validateNumber)(properties.firstExecutionFrom)),errors.collect(cdk.propertyValidator("scheduleEndTime",cdk.validateNumber)(properties.scheduleEndTime)),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.requiredValidator)(properties.scheduleExpression)),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.validateString)(properties.scheduleExpression)),errors.collect(cdk.propertyValidator("scheduleOffset",cdk.validateNumber)(properties.scheduleOffset)),errors.collect(cdk.propertyValidator("scheduleStartTime",cdk.validateNumber)(properties.scheduleStartTime)),errors.collect(cdk.propertyValidator("timezone",cdk.validateString)(properties.timezone)),errors.wrap('supplied properties not correct for "ScheduledTriggerPropertiesProperty"')}function cfnIntegrationScheduledTriggerPropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_ScheduledTriggerPropertiesPropertyValidator(properties).assertSuccess(),{DataPullMode:cdk.stringToCloudFormation(properties.dataPullMode),FirstExecutionFrom:cdk.numberToCloudFormation(properties.firstExecutionFrom),ScheduleEndTime:cdk.numberToCloudFormation(properties.scheduleEndTime),ScheduleExpression:cdk.stringToCloudFormation(properties.scheduleExpression),ScheduleOffset:cdk.numberToCloudFormation(properties.scheduleOffset),ScheduleStartTime:cdk.numberToCloudFormation(properties.scheduleStartTime),Timezone:cdk.stringToCloudFormation(properties.timezone)}):properties}function CfnIntegrationScheduledTriggerPropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dataPullMode","DataPullMode",properties.DataPullMode!=null?cfn_parse.FromCloudFormation.getString(properties.DataPullMode):void 0),ret.addPropertyResult("firstExecutionFrom","FirstExecutionFrom",properties.FirstExecutionFrom!=null?cfn_parse.FromCloudFormation.getNumber(properties.FirstExecutionFrom):void 0),ret.addPropertyResult("scheduleEndTime","ScheduleEndTime",properties.ScheduleEndTime!=null?cfn_parse.FromCloudFormation.getNumber(properties.ScheduleEndTime):void 0),ret.addPropertyResult("scheduleExpression","ScheduleExpression",cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression)),ret.addPropertyResult("scheduleOffset","ScheduleOffset",properties.ScheduleOffset!=null?cfn_parse.FromCloudFormation.getNumber(properties.ScheduleOffset):void 0),ret.addPropertyResult("scheduleStartTime","ScheduleStartTime",properties.ScheduleStartTime!=null?cfn_parse.FromCloudFormation.getNumber(properties.ScheduleStartTime):void 0),ret.addPropertyResult("timezone","Timezone",properties.Timezone!=null?cfn_parse.FromCloudFormation.getString(properties.Timezone):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_ServiceNowSourcePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("object",cdk.requiredValidator)(properties.object)),errors.collect(cdk.propertyValidator("object",cdk.validateString)(properties.object)),errors.wrap('supplied properties not correct for "ServiceNowSourcePropertiesProperty"')}function cfnIntegrationServiceNowSourcePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_ServiceNowSourcePropertiesPropertyValidator(properties).assertSuccess(),{Object:cdk.stringToCloudFormation(properties.object)}):properties}function CfnIntegrationServiceNowSourcePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("object","Object",cfn_parse.FromCloudFormation.getString(properties.Object)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_SourceConnectorPropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("marketo",CfnIntegration_MarketoSourcePropertiesPropertyValidator)(properties.marketo)),errors.collect(cdk.propertyValidator("s3",CfnIntegration_S3SourcePropertiesPropertyValidator)(properties.s3)),errors.collect(cdk.propertyValidator("salesforce",CfnIntegration_SalesforceSourcePropertiesPropertyValidator)(properties.salesforce)),errors.collect(cdk.propertyValidator("serviceNow",CfnIntegration_ServiceNowSourcePropertiesPropertyValidator)(properties.serviceNow)),errors.collect(cdk.propertyValidator("zendesk",CfnIntegration_ZendeskSourcePropertiesPropertyValidator)(properties.zendesk)),errors.wrap('supplied properties not correct for "SourceConnectorPropertiesProperty"')}function cfnIntegrationSourceConnectorPropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_SourceConnectorPropertiesPropertyValidator(properties).assertSuccess(),{Marketo:cfnIntegrationMarketoSourcePropertiesPropertyToCloudFormation(properties.marketo),S3:cfnIntegrationS3SourcePropertiesPropertyToCloudFormation(properties.s3),Salesforce:cfnIntegrationSalesforceSourcePropertiesPropertyToCloudFormation(properties.salesforce),ServiceNow:cfnIntegrationServiceNowSourcePropertiesPropertyToCloudFormation(properties.serviceNow),Zendesk:cfnIntegrationZendeskSourcePropertiesPropertyToCloudFormation(properties.zendesk)}):properties}function CfnIntegrationSourceConnectorPropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("marketo","Marketo",properties.Marketo!=null?CfnIntegrationMarketoSourcePropertiesPropertyFromCloudFormation(properties.Marketo):void 0),ret.addPropertyResult("s3","S3",properties.S3!=null?CfnIntegrationS3SourcePropertiesPropertyFromCloudFormation(properties.S3):void 0),ret.addPropertyResult("salesforce","Salesforce",properties.Salesforce!=null?CfnIntegrationSalesforceSourcePropertiesPropertyFromCloudFormation(properties.Salesforce):void 0),ret.addPropertyResult("serviceNow","ServiceNow",properties.ServiceNow!=null?CfnIntegrationServiceNowSourcePropertiesPropertyFromCloudFormation(properties.ServiceNow):void 0),ret.addPropertyResult("zendesk","Zendesk",properties.Zendesk!=null?CfnIntegrationZendeskSourcePropertiesPropertyFromCloudFormation(properties.Zendesk):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_SourceFlowConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("connectorProfileName",cdk.validateString)(properties.connectorProfileName)),errors.collect(cdk.propertyValidator("connectorType",cdk.requiredValidator)(properties.connectorType)),errors.collect(cdk.propertyValidator("connectorType",cdk.validateString)(properties.connectorType)),errors.collect(cdk.propertyValidator("incrementalPullConfig",CfnIntegration_IncrementalPullConfigPropertyValidator)(properties.incrementalPullConfig)),errors.collect(cdk.propertyValidator("sourceConnectorProperties",cdk.requiredValidator)(properties.sourceConnectorProperties)),errors.collect(cdk.propertyValidator("sourceConnectorProperties",CfnIntegration_SourceConnectorPropertiesPropertyValidator)(properties.sourceConnectorProperties)),errors.wrap('supplied properties not correct for "SourceFlowConfigProperty"')}function cfnIntegrationSourceFlowConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_SourceFlowConfigPropertyValidator(properties).assertSuccess(),{ConnectorProfileName:cdk.stringToCloudFormation(properties.connectorProfileName),ConnectorType:cdk.stringToCloudFormation(properties.connectorType),IncrementalPullConfig:cfnIntegrationIncrementalPullConfigPropertyToCloudFormation(properties.incrementalPullConfig),SourceConnectorProperties:cfnIntegrationSourceConnectorPropertiesPropertyToCloudFormation(properties.sourceConnectorProperties)}):properties}function CfnIntegrationSourceFlowConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("connectorProfileName","ConnectorProfileName",properties.ConnectorProfileName!=null?cfn_parse.FromCloudFormation.getString(properties.ConnectorProfileName):void 0),ret.addPropertyResult("connectorType","ConnectorType",cfn_parse.FromCloudFormation.getString(properties.ConnectorType)),ret.addPropertyResult("incrementalPullConfig","IncrementalPullConfig",properties.IncrementalPullConfig!=null?CfnIntegrationIncrementalPullConfigPropertyFromCloudFormation(properties.IncrementalPullConfig):void 0),ret.addPropertyResult("sourceConnectorProperties","SourceConnectorProperties",CfnIntegrationSourceConnectorPropertiesPropertyFromCloudFormation(properties.SourceConnectorProperties)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_TaskPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("connectorOperator",CfnIntegration_ConnectorOperatorPropertyValidator)(properties.connectorOperator)),errors.collect(cdk.propertyValidator("destinationField",cdk.validateString)(properties.destinationField)),errors.collect(cdk.propertyValidator("sourceFields",cdk.requiredValidator)(properties.sourceFields)),errors.collect(cdk.propertyValidator("sourceFields",cdk.listValidator(cdk.validateString))(properties.sourceFields)),errors.collect(cdk.propertyValidator("taskProperties",cdk.listValidator(CfnIntegration_TaskPropertiesMapPropertyValidator))(properties.taskProperties)),errors.collect(cdk.propertyValidator("taskType",cdk.requiredValidator)(properties.taskType)),errors.collect(cdk.propertyValidator("taskType",cdk.validateString)(properties.taskType)),errors.wrap('supplied properties not correct for "TaskProperty"')}function cfnIntegrationTaskPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_TaskPropertyValidator(properties).assertSuccess(),{ConnectorOperator:cfnIntegrationConnectorOperatorPropertyToCloudFormation(properties.connectorOperator),DestinationField:cdk.stringToCloudFormation(properties.destinationField),SourceFields:cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceFields),TaskProperties:cdk.listMapper(cfnIntegrationTaskPropertiesMapPropertyToCloudFormation)(properties.taskProperties),TaskType:cdk.stringToCloudFormation(properties.taskType)}):properties}function CfnIntegrationTaskPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("connectorOperator","ConnectorOperator",properties.ConnectorOperator!=null?CfnIntegrationConnectorOperatorPropertyFromCloudFormation(properties.ConnectorOperator):void 0),ret.addPropertyResult("destinationField","DestinationField",properties.DestinationField!=null?cfn_parse.FromCloudFormation.getString(properties.DestinationField):void 0),ret.addPropertyResult("sourceFields","SourceFields",cfn_parse.FromCloudFormation.getStringArray(properties.SourceFields)),ret.addPropertyResult("taskProperties","TaskProperties",properties.TaskProperties!=null?cfn_parse.FromCloudFormation.getArray(CfnIntegrationTaskPropertiesMapPropertyFromCloudFormation)(properties.TaskProperties):void 0),ret.addPropertyResult("taskType","TaskType",cfn_parse.FromCloudFormation.getString(properties.TaskType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_TaskPropertiesMapPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("operatorPropertyKey",cdk.requiredValidator)(properties.operatorPropertyKey)),errors.collect(cdk.propertyValidator("operatorPropertyKey",cdk.validateString)(properties.operatorPropertyKey)),errors.collect(cdk.propertyValidator("property",cdk.requiredValidator)(properties.property)),errors.collect(cdk.propertyValidator("property",cdk.validateString)(properties.property)),errors.wrap('supplied properties not correct for "TaskPropertiesMapProperty"')}function cfnIntegrationTaskPropertiesMapPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_TaskPropertiesMapPropertyValidator(properties).assertSuccess(),{OperatorPropertyKey:cdk.stringToCloudFormation(properties.operatorPropertyKey),Property:cdk.stringToCloudFormation(properties.property)}):properties}function CfnIntegrationTaskPropertiesMapPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("operatorPropertyKey","OperatorPropertyKey",cfn_parse.FromCloudFormation.getString(properties.OperatorPropertyKey)),ret.addPropertyResult("property","Property",cfn_parse.FromCloudFormation.getString(properties.Property)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_TriggerConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("triggerProperties",CfnIntegration_TriggerPropertiesPropertyValidator)(properties.triggerProperties)),errors.collect(cdk.propertyValidator("triggerType",cdk.requiredValidator)(properties.triggerType)),errors.collect(cdk.propertyValidator("triggerType",cdk.validateString)(properties.triggerType)),errors.wrap('supplied properties not correct for "TriggerConfigProperty"')}function cfnIntegrationTriggerConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_TriggerConfigPropertyValidator(properties).assertSuccess(),{TriggerProperties:cfnIntegrationTriggerPropertiesPropertyToCloudFormation(properties.triggerProperties),TriggerType:cdk.stringToCloudFormation(properties.triggerType)}):properties}function CfnIntegrationTriggerConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("triggerProperties","TriggerProperties",properties.TriggerProperties!=null?CfnIntegrationTriggerPropertiesPropertyFromCloudFormation(properties.TriggerProperties):void 0),ret.addPropertyResult("triggerType","TriggerType",cfn_parse.FromCloudFormation.getString(properties.TriggerType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_TriggerPropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("scheduled",CfnIntegration_ScheduledTriggerPropertiesPropertyValidator)(properties.scheduled)),errors.wrap('supplied properties not correct for "TriggerPropertiesProperty"')}function cfnIntegrationTriggerPropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_TriggerPropertiesPropertyValidator(properties).assertSuccess(),{Scheduled:cfnIntegrationScheduledTriggerPropertiesPropertyToCloudFormation(properties.scheduled)}):properties}function CfnIntegrationTriggerPropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("scheduled","Scheduled",properties.Scheduled!=null?CfnIntegrationScheduledTriggerPropertiesPropertyFromCloudFormation(properties.Scheduled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnIntegration_ZendeskSourcePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("object",cdk.requiredValidator)(properties.object)),errors.collect(cdk.propertyValidator("object",cdk.validateString)(properties.object)),errors.wrap('supplied properties not correct for "ZendeskSourcePropertiesProperty"')}function cfnIntegrationZendeskSourcePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnIntegration_ZendeskSourcePropertiesPropertyValidator(properties).assertSuccess(),{Object:cdk.stringToCloudFormation(properties.object)}):properties}function CfnIntegrationZendeskSourcePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("object","Object",cfn_parse.FromCloudFormation.getString(properties.Object)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnObjectTypePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("allowProfileCreation",cdk.validateBoolean)(properties.allowProfileCreation)),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("domainName",cdk.requiredValidator)(properties.domainName)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("encryptionKey",cdk.validateString)(properties.encryptionKey)),errors.collect(cdk.propertyValidator("expirationDays",cdk.validateNumber)(properties.expirationDays)),errors.collect(cdk.propertyValidator("fields",cdk.listValidator(CfnObjectType_FieldMapPropertyValidator))(properties.fields)),errors.collect(cdk.propertyValidator("keys",cdk.listValidator(CfnObjectType_KeyMapPropertyValidator))(properties.keys)),errors.collect(cdk.propertyValidator("objectTypeName",cdk.validateString)(properties.objectTypeName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("templateId",cdk.validateString)(properties.templateId)),errors.wrap('supplied properties not correct for "CfnObjectTypeProps"')}function cfnObjectTypePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnObjectTypePropsValidator(properties).assertSuccess(),{DomainName:cdk.stringToCloudFormation(properties.domainName),AllowProfileCreation:cdk.booleanToCloudFormation(properties.allowProfileCreation),Description:cdk.stringToCloudFormation(properties.description),EncryptionKey:cdk.stringToCloudFormation(properties.encryptionKey),ExpirationDays:cdk.numberToCloudFormation(properties.expirationDays),Fields:cdk.listMapper(cfnObjectTypeFieldMapPropertyToCloudFormation)(properties.fields),Keys:cdk.listMapper(cfnObjectTypeKeyMapPropertyToCloudFormation)(properties.keys),ObjectTypeName:cdk.stringToCloudFormation(properties.objectTypeName),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),TemplateId:cdk.stringToCloudFormation(properties.templateId)}):properties}function CfnObjectTypePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("domainName","DomainName",cfn_parse.FromCloudFormation.getString(properties.DomainName)),ret.addPropertyResult("allowProfileCreation","AllowProfileCreation",properties.AllowProfileCreation!=null?cfn_parse.FromCloudFormation.getBoolean(properties.AllowProfileCreation):void 0),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("encryptionKey","EncryptionKey",properties.EncryptionKey!=null?cfn_parse.FromCloudFormation.getString(properties.EncryptionKey):void 0),ret.addPropertyResult("expirationDays","ExpirationDays",properties.ExpirationDays!=null?cfn_parse.FromCloudFormation.getNumber(properties.ExpirationDays):void 0),ret.addPropertyResult("fields","Fields",properties.Fields!=null?cfn_parse.FromCloudFormation.getArray(CfnObjectTypeFieldMapPropertyFromCloudFormation)(properties.Fields):void 0),ret.addPropertyResult("keys","Keys",properties.Keys!=null?cfn_parse.FromCloudFormation.getArray(CfnObjectTypeKeyMapPropertyFromCloudFormation)(properties.Keys):void 0),ret.addPropertyResult("objectTypeName","ObjectTypeName",properties.ObjectTypeName!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectTypeName):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("templateId","TemplateId",properties.TemplateId!=null?cfn_parse.FromCloudFormation.getString(properties.TemplateId):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnObjectType extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnObjectType.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_customerprofiles_CfnObjectTypeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnObjectType),error}cdk.requireProperty(props,"domainName",this),this.attrCreatedAt=cdk.Token.asString(this.getAtt("CreatedAt")),this.attrLastUpdatedAt=cdk.Token.asString(this.getAtt("LastUpdatedAt")),this.domainName=props.domainName,this.allowProfileCreation=props.allowProfileCreation,this.description=props.description,this.encryptionKey=props.encryptionKey,this.expirationDays=props.expirationDays,this.fields=props.fields,this.keys=props.keys,this.objectTypeName=props.objectTypeName,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CustomerProfiles::ObjectType",props.tags,{tagPropertyName:"tags"}),this.templateId=props.templateId}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnObjectTypePropsFromCloudFormation(resourceProperties),ret=new CfnObjectType(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnObjectType.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{domainName:this.domainName,allowProfileCreation:this.allowProfileCreation,description:this.description,encryptionKey:this.encryptionKey,expirationDays:this.expirationDays,fields:this.fields,keys:this.keys,objectTypeName:this.objectTypeName,tags:this.tags.renderTags(),templateId:this.templateId}}renderProperties(props){return cfnObjectTypePropsToCloudFormation(props)}}exports.CfnObjectType=CfnObjectType,_c=JSII_RTTI_SYMBOL_1,CfnObjectType[_c]={fqn:"aws-cdk-lib.aws_customerprofiles.CfnObjectType",version:"2.42.0"},CfnObjectType.CFN_RESOURCE_TYPE_NAME="AWS::CustomerProfiles::ObjectType";function CfnObjectType_FieldMapPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("objectTypeField",CfnObjectType_ObjectTypeFieldPropertyValidator)(properties.objectTypeField)),errors.wrap('supplied properties not correct for "FieldMapProperty"')}function cfnObjectTypeFieldMapPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnObjectType_FieldMapPropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),ObjectTypeField:cfnObjectTypeObjectTypeFieldPropertyToCloudFormation(properties.objectTypeField)}):properties}function CfnObjectTypeFieldMapPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addPropertyResult("objectTypeField","ObjectTypeField",properties.ObjectTypeField!=null?CfnObjectTypeObjectTypeFieldPropertyFromCloudFormation(properties.ObjectTypeField):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnObjectType_KeyMapPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("objectTypeKeyList",cdk.listValidator(CfnObjectType_ObjectTypeKeyPropertyValidator))(properties.objectTypeKeyList)),errors.wrap('supplied properties not correct for "KeyMapProperty"')}function cfnObjectTypeKeyMapPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnObjectType_KeyMapPropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),ObjectTypeKeyList:cdk.listMapper(cfnObjectTypeObjectTypeKeyPropertyToCloudFormation)(properties.objectTypeKeyList)}):properties}function CfnObjectTypeKeyMapPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addPropertyResult("objectTypeKeyList","ObjectTypeKeyList",properties.ObjectTypeKeyList!=null?cfn_parse.FromCloudFormation.getArray(CfnObjectTypeObjectTypeKeyPropertyFromCloudFormation)(properties.ObjectTypeKeyList):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnObjectType_ObjectTypeFieldPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("contentType",cdk.validateString)(properties.contentType)),errors.collect(cdk.propertyValidator("source",cdk.validateString)(properties.source)),errors.collect(cdk.propertyValidator("target",cdk.validateString)(properties.target)),errors.wrap('supplied properties not correct for "ObjectTypeFieldProperty"')}function cfnObjectTypeObjectTypeFieldPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnObjectType_ObjectTypeFieldPropertyValidator(properties).assertSuccess(),{ContentType:cdk.stringToCloudFormation(properties.contentType),Source:cdk.stringToCloudFormation(properties.source),Target:cdk.stringToCloudFormation(properties.target)}):properties}function CfnObjectTypeObjectTypeFieldPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("contentType","ContentType",properties.ContentType!=null?cfn_parse.FromCloudFormation.getString(properties.ContentType):void 0),ret.addPropertyResult("source","Source",properties.Source!=null?cfn_parse.FromCloudFormation.getString(properties.Source):void 0),ret.addPropertyResult("target","Target",properties.Target!=null?cfn_parse.FromCloudFormation.getString(properties.Target):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnObjectType_ObjectTypeKeyPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("fieldNames",cdk.listValidator(cdk.validateString))(properties.fieldNames)),errors.collect(cdk.propertyValidator("standardIdentifiers",cdk.listValidator(cdk.validateString))(properties.standardIdentifiers)),errors.wrap('supplied properties not correct for "ObjectTypeKeyProperty"')}function cfnObjectTypeObjectTypeKeyPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnObjectType_ObjectTypeKeyPropertyValidator(properties).assertSuccess(),{FieldNames:cdk.listMapper(cdk.stringToCloudFormation)(properties.fieldNames),StandardIdentifiers:cdk.listMapper(cdk.stringToCloudFormation)(properties.standardIdentifiers)}):properties}function CfnObjectTypeObjectTypeKeyPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("fieldNames","FieldNames",properties.FieldNames!=null?cfn_parse.FromCloudFormation.getStringArray(properties.FieldNames):void 0),ret.addPropertyResult("standardIdentifiers","StandardIdentifiers",properties.StandardIdentifiers!=null?cfn_parse.FromCloudFormation.getStringArray(properties.StandardIdentifiers):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
//# sourceMappingURL=customerprofiles.generated.js.map
