"use strict";var _a,_b,_c,_d,_e,_f;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnSchedule=exports.CfnRuleset=exports.CfnRecipe=exports.CfnProject=exports.CfnJob=exports.CfnDataset=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnDatasetPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("format",cdk.validateString)(properties.format)),errors.collect(cdk.propertyValidator("formatOptions",CfnDataset_FormatOptionsPropertyValidator)(properties.formatOptions)),errors.collect(cdk.propertyValidator("input",cdk.requiredValidator)(properties.input)),errors.collect(cdk.propertyValidator("input",CfnDataset_InputPropertyValidator)(properties.input)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("pathOptions",CfnDataset_PathOptionsPropertyValidator)(properties.pathOptions)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDatasetProps"')}function cfnDatasetPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatasetPropsValidator(properties).assertSuccess(),{Input:cfnDatasetInputPropertyToCloudFormation(properties.input),Name:cdk.stringToCloudFormation(properties.name),Format:cdk.stringToCloudFormation(properties.format),FormatOptions:cfnDatasetFormatOptionsPropertyToCloudFormation(properties.formatOptions),PathOptions:cfnDatasetPathOptionsPropertyToCloudFormation(properties.pathOptions),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDatasetPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("input","Input",CfnDatasetInputPropertyFromCloudFormation(properties.Input)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("format","Format",properties.Format!=null?cfn_parse.FromCloudFormation.getString(properties.Format):void 0),ret.addPropertyResult("formatOptions","FormatOptions",properties.FormatOptions!=null?CfnDatasetFormatOptionsPropertyFromCloudFormation(properties.FormatOptions):void 0),ret.addPropertyResult("pathOptions","PathOptions",properties.PathOptions!=null?CfnDatasetPathOptionsPropertyFromCloudFormation(properties.PathOptions):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDataset extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnDataset.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnDatasetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDataset),error}cdk.requireProperty(props,"input",this),cdk.requireProperty(props,"name",this),this.input=props.input,this.name=props.name,this.format=props.format,this.formatOptions=props.formatOptions,this.pathOptions=props.pathOptions,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Dataset",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDatasetPropsFromCloudFormation(resourceProperties),ret=new CfnDataset(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDataset.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{input:this.input,name:this.name,format:this.format,formatOptions:this.formatOptions,pathOptions:this.pathOptions,tags:this.tags.renderTags()}}renderProperties(props){return cfnDatasetPropsToCloudFormation(props)}}exports.CfnDataset=CfnDataset,_a=JSII_RTTI_SYMBOL_1,CfnDataset[_a]={fqn:"aws-cdk-lib.aws_databrew.CfnDataset",version:"2.42.0"},CfnDataset.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Dataset";function CfnDataset_CsvOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("delimiter",cdk.validateString)(properties.delimiter)),errors.collect(cdk.propertyValidator("headerRow",cdk.validateBoolean)(properties.headerRow)),errors.wrap('supplied properties not correct for "CsvOptionsProperty"')}function cfnDatasetCsvOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_CsvOptionsPropertyValidator(properties).assertSuccess(),{Delimiter:cdk.stringToCloudFormation(properties.delimiter),HeaderRow:cdk.booleanToCloudFormation(properties.headerRow)}):properties}function CfnDatasetCsvOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("delimiter","Delimiter",properties.Delimiter!=null?cfn_parse.FromCloudFormation.getString(properties.Delimiter):void 0),ret.addPropertyResult("headerRow","HeaderRow",properties.HeaderRow!=null?cfn_parse.FromCloudFormation.getBoolean(properties.HeaderRow):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DataCatalogInputDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("catalogId",cdk.validateString)(properties.catalogId)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.collect(cdk.propertyValidator("tempDirectory",CfnDataset_S3LocationPropertyValidator)(properties.tempDirectory)),errors.wrap('supplied properties not correct for "DataCatalogInputDefinitionProperty"')}function cfnDatasetDataCatalogInputDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DataCatalogInputDefinitionPropertyValidator(properties).assertSuccess(),{CatalogId:cdk.stringToCloudFormation(properties.catalogId),DatabaseName:cdk.stringToCloudFormation(properties.databaseName),TableName:cdk.stringToCloudFormation(properties.tableName),TempDirectory:cfnDatasetS3LocationPropertyToCloudFormation(properties.tempDirectory)}):properties}function CfnDatasetDataCatalogInputDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("catalogId","CatalogId",properties.CatalogId!=null?cfn_parse.FromCloudFormation.getString(properties.CatalogId):void 0),ret.addPropertyResult("databaseName","DatabaseName",properties.DatabaseName!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseName):void 0),ret.addPropertyResult("tableName","TableName",properties.TableName!=null?cfn_parse.FromCloudFormation.getString(properties.TableName):void 0),ret.addPropertyResult("tempDirectory","TempDirectory",properties.TempDirectory!=null?CfnDatasetS3LocationPropertyFromCloudFormation(properties.TempDirectory):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatabaseInputDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseTableName",cdk.validateString)(properties.databaseTableName)),errors.collect(cdk.propertyValidator("glueConnectionName",cdk.requiredValidator)(properties.glueConnectionName)),errors.collect(cdk.propertyValidator("glueConnectionName",cdk.validateString)(properties.glueConnectionName)),errors.collect(cdk.propertyValidator("queryString",cdk.validateString)(properties.queryString)),errors.collect(cdk.propertyValidator("tempDirectory",CfnDataset_S3LocationPropertyValidator)(properties.tempDirectory)),errors.wrap('supplied properties not correct for "DatabaseInputDefinitionProperty"')}function cfnDatasetDatabaseInputDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatabaseInputDefinitionPropertyValidator(properties).assertSuccess(),{DatabaseTableName:cdk.stringToCloudFormation(properties.databaseTableName),GlueConnectionName:cdk.stringToCloudFormation(properties.glueConnectionName),QueryString:cdk.stringToCloudFormation(properties.queryString),TempDirectory:cfnDatasetS3LocationPropertyToCloudFormation(properties.tempDirectory)}):properties}function CfnDatasetDatabaseInputDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseTableName","DatabaseTableName",properties.DatabaseTableName!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseTableName):void 0),ret.addPropertyResult("glueConnectionName","GlueConnectionName",cfn_parse.FromCloudFormation.getString(properties.GlueConnectionName)),ret.addPropertyResult("queryString","QueryString",properties.QueryString!=null?cfn_parse.FromCloudFormation.getString(properties.QueryString):void 0),ret.addPropertyResult("tempDirectory","TempDirectory",properties.TempDirectory!=null?CfnDatasetS3LocationPropertyFromCloudFormation(properties.TempDirectory):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatasetParameterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("createColumn",cdk.validateBoolean)(properties.createColumn)),errors.collect(cdk.propertyValidator("datetimeOptions",CfnDataset_DatetimeOptionsPropertyValidator)(properties.datetimeOptions)),errors.collect(cdk.propertyValidator("filter",CfnDataset_FilterExpressionPropertyValidator)(properties.filter)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "DatasetParameterProperty"')}function cfnDatasetDatasetParameterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatasetParameterPropertyValidator(properties).assertSuccess(),{CreateColumn:cdk.booleanToCloudFormation(properties.createColumn),DatetimeOptions:cfnDatasetDatetimeOptionsPropertyToCloudFormation(properties.datetimeOptions),Filter:cfnDatasetFilterExpressionPropertyToCloudFormation(properties.filter),Name:cdk.stringToCloudFormation(properties.name),Type:cdk.stringToCloudFormation(properties.type)}):properties}function CfnDatasetDatasetParameterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("createColumn","CreateColumn",properties.CreateColumn!=null?cfn_parse.FromCloudFormation.getBoolean(properties.CreateColumn):void 0),ret.addPropertyResult("datetimeOptions","DatetimeOptions",properties.DatetimeOptions!=null?CfnDatasetDatetimeOptionsPropertyFromCloudFormation(properties.DatetimeOptions):void 0),ret.addPropertyResult("filter","Filter",properties.Filter!=null?CfnDatasetFilterExpressionPropertyFromCloudFormation(properties.Filter):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatetimeOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("format",cdk.requiredValidator)(properties.format)),errors.collect(cdk.propertyValidator("format",cdk.validateString)(properties.format)),errors.collect(cdk.propertyValidator("localeCode",cdk.validateString)(properties.localeCode)),errors.collect(cdk.propertyValidator("timezoneOffset",cdk.validateString)(properties.timezoneOffset)),errors.wrap('supplied properties not correct for "DatetimeOptionsProperty"')}function cfnDatasetDatetimeOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatetimeOptionsPropertyValidator(properties).assertSuccess(),{Format:cdk.stringToCloudFormation(properties.format),LocaleCode:cdk.stringToCloudFormation(properties.localeCode),TimezoneOffset:cdk.stringToCloudFormation(properties.timezoneOffset)}):properties}function CfnDatasetDatetimeOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("format","Format",cfn_parse.FromCloudFormation.getString(properties.Format)),ret.addPropertyResult("localeCode","LocaleCode",properties.LocaleCode!=null?cfn_parse.FromCloudFormation.getString(properties.LocaleCode):void 0),ret.addPropertyResult("timezoneOffset","TimezoneOffset",properties.TimezoneOffset!=null?cfn_parse.FromCloudFormation.getString(properties.TimezoneOffset):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_ExcelOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("headerRow",cdk.validateBoolean)(properties.headerRow)),errors.collect(cdk.propertyValidator("sheetIndexes",cdk.listValidator(cdk.validateNumber))(properties.sheetIndexes)),errors.collect(cdk.propertyValidator("sheetNames",cdk.listValidator(cdk.validateString))(properties.sheetNames)),errors.wrap('supplied properties not correct for "ExcelOptionsProperty"')}function cfnDatasetExcelOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_ExcelOptionsPropertyValidator(properties).assertSuccess(),{HeaderRow:cdk.booleanToCloudFormation(properties.headerRow),SheetIndexes:cdk.listMapper(cdk.numberToCloudFormation)(properties.sheetIndexes),SheetNames:cdk.listMapper(cdk.stringToCloudFormation)(properties.sheetNames)}):properties}function CfnDatasetExcelOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("headerRow","HeaderRow",properties.HeaderRow!=null?cfn_parse.FromCloudFormation.getBoolean(properties.HeaderRow):void 0),ret.addPropertyResult("sheetIndexes","SheetIndexes",properties.SheetIndexes!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.SheetIndexes):void 0),ret.addPropertyResult("sheetNames","SheetNames",properties.SheetNames!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SheetNames):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_FilesLimitPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("maxFiles",cdk.requiredValidator)(properties.maxFiles)),errors.collect(cdk.propertyValidator("maxFiles",cdk.validateNumber)(properties.maxFiles)),errors.collect(cdk.propertyValidator("order",cdk.validateString)(properties.order)),errors.collect(cdk.propertyValidator("orderedBy",cdk.validateString)(properties.orderedBy)),errors.wrap('supplied properties not correct for "FilesLimitProperty"')}function cfnDatasetFilesLimitPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_FilesLimitPropertyValidator(properties).assertSuccess(),{MaxFiles:cdk.numberToCloudFormation(properties.maxFiles),Order:cdk.stringToCloudFormation(properties.order),OrderedBy:cdk.stringToCloudFormation(properties.orderedBy)}):properties}function CfnDatasetFilesLimitPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("maxFiles","MaxFiles",cfn_parse.FromCloudFormation.getNumber(properties.MaxFiles)),ret.addPropertyResult("order","Order",properties.Order!=null?cfn_parse.FromCloudFormation.getString(properties.Order):void 0),ret.addPropertyResult("orderedBy","OrderedBy",properties.OrderedBy!=null?cfn_parse.FromCloudFormation.getString(properties.OrderedBy):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_FilterExpressionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("expression",cdk.requiredValidator)(properties.expression)),errors.collect(cdk.propertyValidator("expression",cdk.validateString)(properties.expression)),errors.collect(cdk.propertyValidator("valuesMap",cdk.requiredValidator)(properties.valuesMap)),errors.collect(cdk.propertyValidator("valuesMap",cdk.listValidator(CfnDataset_FilterValuePropertyValidator))(properties.valuesMap)),errors.wrap('supplied properties not correct for "FilterExpressionProperty"')}function cfnDatasetFilterExpressionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_FilterExpressionPropertyValidator(properties).assertSuccess(),{Expression:cdk.stringToCloudFormation(properties.expression),ValuesMap:cdk.listMapper(cfnDatasetFilterValuePropertyToCloudFormation)(properties.valuesMap)}):properties}function CfnDatasetFilterExpressionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("expression","Expression",cfn_parse.FromCloudFormation.getString(properties.Expression)),ret.addPropertyResult("valuesMap","ValuesMap",cfn_parse.FromCloudFormation.getArray(CfnDatasetFilterValuePropertyFromCloudFormation)(properties.ValuesMap)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_FilterValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.collect(cdk.propertyValidator("valueReference",cdk.requiredValidator)(properties.valueReference)),errors.collect(cdk.propertyValidator("valueReference",cdk.validateString)(properties.valueReference)),errors.wrap('supplied properties not correct for "FilterValueProperty"')}function cfnDatasetFilterValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_FilterValuePropertyValidator(properties).assertSuccess(),{Value:cdk.stringToCloudFormation(properties.value),ValueReference:cdk.stringToCloudFormation(properties.valueReference)}):properties}function CfnDatasetFilterValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("value","Value",cfn_parse.FromCloudFormation.getString(properties.Value)),ret.addPropertyResult("valueReference","ValueReference",cfn_parse.FromCloudFormation.getString(properties.ValueReference)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_FormatOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csv",CfnDataset_CsvOptionsPropertyValidator)(properties.csv)),errors.collect(cdk.propertyValidator("excel",CfnDataset_ExcelOptionsPropertyValidator)(properties.excel)),errors.collect(cdk.propertyValidator("json",CfnDataset_JsonOptionsPropertyValidator)(properties.json)),errors.wrap('supplied properties not correct for "FormatOptionsProperty"')}function cfnDatasetFormatOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_FormatOptionsPropertyValidator(properties).assertSuccess(),{Csv:cfnDatasetCsvOptionsPropertyToCloudFormation(properties.csv),Excel:cfnDatasetExcelOptionsPropertyToCloudFormation(properties.excel),Json:cfnDatasetJsonOptionsPropertyToCloudFormation(properties.json)}):properties}function CfnDatasetFormatOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csv","Csv",properties.Csv!=null?CfnDatasetCsvOptionsPropertyFromCloudFormation(properties.Csv):void 0),ret.addPropertyResult("excel","Excel",properties.Excel!=null?CfnDatasetExcelOptionsPropertyFromCloudFormation(properties.Excel):void 0),ret.addPropertyResult("json","Json",properties.Json!=null?CfnDatasetJsonOptionsPropertyFromCloudFormation(properties.Json):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_InputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dataCatalogInputDefinition",CfnDataset_DataCatalogInputDefinitionPropertyValidator)(properties.dataCatalogInputDefinition)),errors.collect(cdk.propertyValidator("databaseInputDefinition",CfnDataset_DatabaseInputDefinitionPropertyValidator)(properties.databaseInputDefinition)),errors.collect(cdk.propertyValidator("metadata",CfnDataset_MetadataPropertyValidator)(properties.metadata)),errors.collect(cdk.propertyValidator("s3InputDefinition",CfnDataset_S3LocationPropertyValidator)(properties.s3InputDefinition)),errors.wrap('supplied properties not correct for "InputProperty"')}function cfnDatasetInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_InputPropertyValidator(properties).assertSuccess(),{DataCatalogInputDefinition:cfnDatasetDataCatalogInputDefinitionPropertyToCloudFormation(properties.dataCatalogInputDefinition),DatabaseInputDefinition:cfnDatasetDatabaseInputDefinitionPropertyToCloudFormation(properties.databaseInputDefinition),Metadata:cfnDatasetMetadataPropertyToCloudFormation(properties.metadata),S3InputDefinition:cfnDatasetS3LocationPropertyToCloudFormation(properties.s3InputDefinition)}):properties}function CfnDatasetInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dataCatalogInputDefinition","DataCatalogInputDefinition",properties.DataCatalogInputDefinition!=null?CfnDatasetDataCatalogInputDefinitionPropertyFromCloudFormation(properties.DataCatalogInputDefinition):void 0),ret.addPropertyResult("databaseInputDefinition","DatabaseInputDefinition",properties.DatabaseInputDefinition!=null?CfnDatasetDatabaseInputDefinitionPropertyFromCloudFormation(properties.DatabaseInputDefinition):void 0),ret.addPropertyResult("metadata","Metadata",properties.Metadata!=null?CfnDatasetMetadataPropertyFromCloudFormation(properties.Metadata):void 0),ret.addPropertyResult("s3InputDefinition","S3InputDefinition",properties.S3InputDefinition!=null?CfnDatasetS3LocationPropertyFromCloudFormation(properties.S3InputDefinition):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_JsonOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("multiLine",cdk.validateBoolean)(properties.multiLine)),errors.wrap('supplied properties not correct for "JsonOptionsProperty"')}function cfnDatasetJsonOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_JsonOptionsPropertyValidator(properties).assertSuccess(),{MultiLine:cdk.booleanToCloudFormation(properties.multiLine)}):properties}function CfnDatasetJsonOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("multiLine","MultiLine",properties.MultiLine!=null?cfn_parse.FromCloudFormation.getBoolean(properties.MultiLine):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_MetadataPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("sourceArn",cdk.validateString)(properties.sourceArn)),errors.wrap('supplied properties not correct for "MetadataProperty"')}function cfnDatasetMetadataPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_MetadataPropertyValidator(properties).assertSuccess(),{SourceArn:cdk.stringToCloudFormation(properties.sourceArn)}):properties}function CfnDatasetMetadataPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("sourceArn","SourceArn",properties.SourceArn!=null?cfn_parse.FromCloudFormation.getString(properties.SourceArn):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_PathOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("filesLimit",CfnDataset_FilesLimitPropertyValidator)(properties.filesLimit)),errors.collect(cdk.propertyValidator("lastModifiedDateCondition",CfnDataset_FilterExpressionPropertyValidator)(properties.lastModifiedDateCondition)),errors.collect(cdk.propertyValidator("parameters",cdk.listValidator(CfnDataset_PathParameterPropertyValidator))(properties.parameters)),errors.wrap('supplied properties not correct for "PathOptionsProperty"')}function cfnDatasetPathOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_PathOptionsPropertyValidator(properties).assertSuccess(),{FilesLimit:cfnDatasetFilesLimitPropertyToCloudFormation(properties.filesLimit),LastModifiedDateCondition:cfnDatasetFilterExpressionPropertyToCloudFormation(properties.lastModifiedDateCondition),Parameters:cdk.listMapper(cfnDatasetPathParameterPropertyToCloudFormation)(properties.parameters)}):properties}function CfnDatasetPathOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("filesLimit","FilesLimit",properties.FilesLimit!=null?CfnDatasetFilesLimitPropertyFromCloudFormation(properties.FilesLimit):void 0),ret.addPropertyResult("lastModifiedDateCondition","LastModifiedDateCondition",properties.LastModifiedDateCondition!=null?CfnDatasetFilterExpressionPropertyFromCloudFormation(properties.LastModifiedDateCondition):void 0),ret.addPropertyResult("parameters","Parameters",properties.Parameters!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetPathParameterPropertyFromCloudFormation)(properties.Parameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_PathParameterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datasetParameter",cdk.requiredValidator)(properties.datasetParameter)),errors.collect(cdk.propertyValidator("datasetParameter",CfnDataset_DatasetParameterPropertyValidator)(properties.datasetParameter)),errors.collect(cdk.propertyValidator("pathParameterName",cdk.requiredValidator)(properties.pathParameterName)),errors.collect(cdk.propertyValidator("pathParameterName",cdk.validateString)(properties.pathParameterName)),errors.wrap('supplied properties not correct for "PathParameterProperty"')}function cfnDatasetPathParameterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_PathParameterPropertyValidator(properties).assertSuccess(),{DatasetParameter:cfnDatasetDatasetParameterPropertyToCloudFormation(properties.datasetParameter),PathParameterName:cdk.stringToCloudFormation(properties.pathParameterName)}):properties}function CfnDatasetPathParameterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datasetParameter","DatasetParameter",CfnDatasetDatasetParameterPropertyFromCloudFormation(properties.DatasetParameter)),ret.addPropertyResult("pathParameterName","PathParameterName",cfn_parse.FromCloudFormation.getString(properties.PathParameterName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_S3LocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.wrap('supplied properties not correct for "S3LocationProperty"')}function cfnDatasetS3LocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_S3LocationPropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),Key:cdk.stringToCloudFormation(properties.key)}):properties}function CfnDatasetS3LocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJobPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dataCatalogOutputs",cdk.listValidator(CfnJob_DataCatalogOutputPropertyValidator))(properties.dataCatalogOutputs)),errors.collect(cdk.propertyValidator("databaseOutputs",cdk.listValidator(CfnJob_DatabaseOutputPropertyValidator))(properties.databaseOutputs)),errors.collect(cdk.propertyValidator("datasetName",cdk.validateString)(properties.datasetName)),errors.collect(cdk.propertyValidator("encryptionKeyArn",cdk.validateString)(properties.encryptionKeyArn)),errors.collect(cdk.propertyValidator("encryptionMode",cdk.validateString)(properties.encryptionMode)),errors.collect(cdk.propertyValidator("jobSample",CfnJob_JobSamplePropertyValidator)(properties.jobSample)),errors.collect(cdk.propertyValidator("logSubscription",cdk.validateString)(properties.logSubscription)),errors.collect(cdk.propertyValidator("maxCapacity",cdk.validateNumber)(properties.maxCapacity)),errors.collect(cdk.propertyValidator("maxRetries",cdk.validateNumber)(properties.maxRetries)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("outputLocation",CfnJob_OutputLocationPropertyValidator)(properties.outputLocation)),errors.collect(cdk.propertyValidator("outputs",cdk.listValidator(CfnJob_OutputPropertyValidator))(properties.outputs)),errors.collect(cdk.propertyValidator("profileConfiguration",CfnJob_ProfileConfigurationPropertyValidator)(properties.profileConfiguration)),errors.collect(cdk.propertyValidator("projectName",cdk.validateString)(properties.projectName)),errors.collect(cdk.propertyValidator("recipe",CfnJob_RecipePropertyValidator)(properties.recipe)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("timeout",cdk.validateNumber)(properties.timeout)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.collect(cdk.propertyValidator("validationConfigurations",cdk.listValidator(CfnJob_ValidationConfigurationPropertyValidator))(properties.validationConfigurations)),errors.wrap('supplied properties not correct for "CfnJobProps"')}function cfnJobPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJobPropsValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),RoleArn:cdk.stringToCloudFormation(properties.roleArn),Type:cdk.stringToCloudFormation(properties.type),DatabaseOutputs:cdk.listMapper(cfnJobDatabaseOutputPropertyToCloudFormation)(properties.databaseOutputs),DataCatalogOutputs:cdk.listMapper(cfnJobDataCatalogOutputPropertyToCloudFormation)(properties.dataCatalogOutputs),DatasetName:cdk.stringToCloudFormation(properties.datasetName),EncryptionKeyArn:cdk.stringToCloudFormation(properties.encryptionKeyArn),EncryptionMode:cdk.stringToCloudFormation(properties.encryptionMode),JobSample:cfnJobJobSamplePropertyToCloudFormation(properties.jobSample),LogSubscription:cdk.stringToCloudFormation(properties.logSubscription),MaxCapacity:cdk.numberToCloudFormation(properties.maxCapacity),MaxRetries:cdk.numberToCloudFormation(properties.maxRetries),OutputLocation:cfnJobOutputLocationPropertyToCloudFormation(properties.outputLocation),Outputs:cdk.listMapper(cfnJobOutputPropertyToCloudFormation)(properties.outputs),ProfileConfiguration:cfnJobProfileConfigurationPropertyToCloudFormation(properties.profileConfiguration),ProjectName:cdk.stringToCloudFormation(properties.projectName),Recipe:cfnJobRecipePropertyToCloudFormation(properties.recipe),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),Timeout:cdk.numberToCloudFormation(properties.timeout),ValidationConfigurations:cdk.listMapper(cfnJobValidationConfigurationPropertyToCloudFormation)(properties.validationConfigurations)}):properties}function CfnJobPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addPropertyResult("databaseOutputs","DatabaseOutputs",properties.DatabaseOutputs!=null?cfn_parse.FromCloudFormation.getArray(CfnJobDatabaseOutputPropertyFromCloudFormation)(properties.DatabaseOutputs):void 0),ret.addPropertyResult("dataCatalogOutputs","DataCatalogOutputs",properties.DataCatalogOutputs!=null?cfn_parse.FromCloudFormation.getArray(CfnJobDataCatalogOutputPropertyFromCloudFormation)(properties.DataCatalogOutputs):void 0),ret.addPropertyResult("datasetName","DatasetName",properties.DatasetName!=null?cfn_parse.FromCloudFormation.getString(properties.DatasetName):void 0),ret.addPropertyResult("encryptionKeyArn","EncryptionKeyArn",properties.EncryptionKeyArn!=null?cfn_parse.FromCloudFormation.getString(properties.EncryptionKeyArn):void 0),ret.addPropertyResult("encryptionMode","EncryptionMode",properties.EncryptionMode!=null?cfn_parse.FromCloudFormation.getString(properties.EncryptionMode):void 0),ret.addPropertyResult("jobSample","JobSample",properties.JobSample!=null?CfnJobJobSamplePropertyFromCloudFormation(properties.JobSample):void 0),ret.addPropertyResult("logSubscription","LogSubscription",properties.LogSubscription!=null?cfn_parse.FromCloudFormation.getString(properties.LogSubscription):void 0),ret.addPropertyResult("maxCapacity","MaxCapacity",properties.MaxCapacity!=null?cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity):void 0),ret.addPropertyResult("maxRetries","MaxRetries",properties.MaxRetries!=null?cfn_parse.FromCloudFormation.getNumber(properties.MaxRetries):void 0),ret.addPropertyResult("outputLocation","OutputLocation",properties.OutputLocation!=null?CfnJobOutputLocationPropertyFromCloudFormation(properties.OutputLocation):void 0),ret.addPropertyResult("outputs","Outputs",properties.Outputs!=null?cfn_parse.FromCloudFormation.getArray(CfnJobOutputPropertyFromCloudFormation)(properties.Outputs):void 0),ret.addPropertyResult("profileConfiguration","ProfileConfiguration",properties.ProfileConfiguration!=null?CfnJobProfileConfigurationPropertyFromCloudFormation(properties.ProfileConfiguration):void 0),ret.addPropertyResult("projectName","ProjectName",properties.ProjectName!=null?cfn_parse.FromCloudFormation.getString(properties.ProjectName):void 0),ret.addPropertyResult("recipe","Recipe",properties.Recipe!=null?CfnJobRecipePropertyFromCloudFormation(properties.Recipe):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("timeout","Timeout",properties.Timeout!=null?cfn_parse.FromCloudFormation.getNumber(properties.Timeout):void 0),ret.addPropertyResult("validationConfigurations","ValidationConfigurations",properties.ValidationConfigurations!=null?cfn_parse.FromCloudFormation.getArray(CfnJobValidationConfigurationPropertyFromCloudFormation)(properties.ValidationConfigurations):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnJob extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnJob.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnJobProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnJob),error}cdk.requireProperty(props,"name",this),cdk.requireProperty(props,"roleArn",this),cdk.requireProperty(props,"type",this),this.name=props.name,this.roleArn=props.roleArn,this.type=props.type,this.databaseOutputs=props.databaseOutputs,this.dataCatalogOutputs=props.dataCatalogOutputs,this.datasetName=props.datasetName,this.encryptionKeyArn=props.encryptionKeyArn,this.encryptionMode=props.encryptionMode,this.jobSample=props.jobSample,this.logSubscription=props.logSubscription,this.maxCapacity=props.maxCapacity,this.maxRetries=props.maxRetries,this.outputLocation=props.outputLocation,this.outputs=props.outputs,this.profileConfiguration=props.profileConfiguration,this.projectName=props.projectName,this.recipe=props.recipe,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Job",props.tags,{tagPropertyName:"tags"}),this.timeout=props.timeout,this.validationConfigurations=props.validationConfigurations}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnJobPropsFromCloudFormation(resourceProperties),ret=new CfnJob(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnJob.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{name:this.name,roleArn:this.roleArn,type:this.type,databaseOutputs:this.databaseOutputs,dataCatalogOutputs:this.dataCatalogOutputs,datasetName:this.datasetName,encryptionKeyArn:this.encryptionKeyArn,encryptionMode:this.encryptionMode,jobSample:this.jobSample,logSubscription:this.logSubscription,maxCapacity:this.maxCapacity,maxRetries:this.maxRetries,outputLocation:this.outputLocation,outputs:this.outputs,profileConfiguration:this.profileConfiguration,projectName:this.projectName,recipe:this.recipe,tags:this.tags.renderTags(),timeout:this.timeout,validationConfigurations:this.validationConfigurations}}renderProperties(props){return cfnJobPropsToCloudFormation(props)}}exports.CfnJob=CfnJob,_b=JSII_RTTI_SYMBOL_1,CfnJob[_b]={fqn:"aws-cdk-lib.aws_databrew.CfnJob",version:"2.42.0"},CfnJob.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Job";function CfnJob_AllowedStatisticsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("statistics",cdk.requiredValidator)(properties.statistics)),errors.collect(cdk.propertyValidator("statistics",cdk.listValidator(cdk.validateString))(properties.statistics)),errors.wrap('supplied properties not correct for "AllowedStatisticsProperty"')}function cfnJobAllowedStatisticsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_AllowedStatisticsPropertyValidator(properties).assertSuccess(),{Statistics:cdk.listMapper(cdk.stringToCloudFormation)(properties.statistics)}):properties}function CfnJobAllowedStatisticsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("statistics","Statistics",cfn_parse.FromCloudFormation.getStringArray(properties.Statistics)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_ColumnSelectorPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("regex",cdk.validateString)(properties.regex)),errors.wrap('supplied properties not correct for "ColumnSelectorProperty"')}function cfnJobColumnSelectorPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_ColumnSelectorPropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Regex:cdk.stringToCloudFormation(properties.regex)}):properties}function CfnJobColumnSelectorPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addPropertyResult("regex","Regex",properties.Regex!=null?cfn_parse.FromCloudFormation.getString(properties.Regex):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_ColumnStatisticsConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("selectors",cdk.listValidator(CfnJob_ColumnSelectorPropertyValidator))(properties.selectors)),errors.collect(cdk.propertyValidator("statistics",cdk.requiredValidator)(properties.statistics)),errors.collect(cdk.propertyValidator("statistics",CfnJob_StatisticsConfigurationPropertyValidator)(properties.statistics)),errors.wrap('supplied properties not correct for "ColumnStatisticsConfigurationProperty"')}function cfnJobColumnStatisticsConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_ColumnStatisticsConfigurationPropertyValidator(properties).assertSuccess(),{Selectors:cdk.listMapper(cfnJobColumnSelectorPropertyToCloudFormation)(properties.selectors),Statistics:cfnJobStatisticsConfigurationPropertyToCloudFormation(properties.statistics)}):properties}function CfnJobColumnStatisticsConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("selectors","Selectors",properties.Selectors!=null?cfn_parse.FromCloudFormation.getArray(CfnJobColumnSelectorPropertyFromCloudFormation)(properties.Selectors):void 0),ret.addPropertyResult("statistics","Statistics",CfnJobStatisticsConfigurationPropertyFromCloudFormation(properties.Statistics)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_CsvOutputOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("delimiter",cdk.validateString)(properties.delimiter)),errors.wrap('supplied properties not correct for "CsvOutputOptionsProperty"')}function cfnJobCsvOutputOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_CsvOutputOptionsPropertyValidator(properties).assertSuccess(),{Delimiter:cdk.stringToCloudFormation(properties.delimiter)}):properties}function CfnJobCsvOutputOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("delimiter","Delimiter",properties.Delimiter!=null?cfn_parse.FromCloudFormation.getString(properties.Delimiter):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_DataCatalogOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("catalogId",cdk.validateString)(properties.catalogId)),errors.collect(cdk.propertyValidator("databaseName",cdk.requiredValidator)(properties.databaseName)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("databaseOptions",CfnJob_DatabaseTableOutputOptionsPropertyValidator)(properties.databaseOptions)),errors.collect(cdk.propertyValidator("overwrite",cdk.validateBoolean)(properties.overwrite)),errors.collect(cdk.propertyValidator("s3Options",CfnJob_S3TableOutputOptionsPropertyValidator)(properties.s3Options)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "DataCatalogOutputProperty"')}function cfnJobDataCatalogOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_DataCatalogOutputPropertyValidator(properties).assertSuccess(),{CatalogId:cdk.stringToCloudFormation(properties.catalogId),DatabaseName:cdk.stringToCloudFormation(properties.databaseName),DatabaseOptions:cfnJobDatabaseTableOutputOptionsPropertyToCloudFormation(properties.databaseOptions),Overwrite:cdk.booleanToCloudFormation(properties.overwrite),S3Options:cfnJobS3TableOutputOptionsPropertyToCloudFormation(properties.s3Options),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnJobDataCatalogOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("catalogId","CatalogId",properties.CatalogId!=null?cfn_parse.FromCloudFormation.getString(properties.CatalogId):void 0),ret.addPropertyResult("databaseName","DatabaseName",cfn_parse.FromCloudFormation.getString(properties.DatabaseName)),ret.addPropertyResult("databaseOptions","DatabaseOptions",properties.DatabaseOptions!=null?CfnJobDatabaseTableOutputOptionsPropertyFromCloudFormation(properties.DatabaseOptions):void 0),ret.addPropertyResult("overwrite","Overwrite",properties.Overwrite!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Overwrite):void 0),ret.addPropertyResult("s3Options","S3Options",properties.S3Options!=null?CfnJobS3TableOutputOptionsPropertyFromCloudFormation(properties.S3Options):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_DatabaseOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseOptions",cdk.requiredValidator)(properties.databaseOptions)),errors.collect(cdk.propertyValidator("databaseOptions",CfnJob_DatabaseTableOutputOptionsPropertyValidator)(properties.databaseOptions)),errors.collect(cdk.propertyValidator("databaseOutputMode",cdk.validateString)(properties.databaseOutputMode)),errors.collect(cdk.propertyValidator("glueConnectionName",cdk.requiredValidator)(properties.glueConnectionName)),errors.collect(cdk.propertyValidator("glueConnectionName",cdk.validateString)(properties.glueConnectionName)),errors.wrap('supplied properties not correct for "DatabaseOutputProperty"')}function cfnJobDatabaseOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_DatabaseOutputPropertyValidator(properties).assertSuccess(),{DatabaseOptions:cfnJobDatabaseTableOutputOptionsPropertyToCloudFormation(properties.databaseOptions),DatabaseOutputMode:cdk.stringToCloudFormation(properties.databaseOutputMode),GlueConnectionName:cdk.stringToCloudFormation(properties.glueConnectionName)}):properties}function CfnJobDatabaseOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseOptions","DatabaseOptions",CfnJobDatabaseTableOutputOptionsPropertyFromCloudFormation(properties.DatabaseOptions)),ret.addPropertyResult("databaseOutputMode","DatabaseOutputMode",properties.DatabaseOutputMode!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseOutputMode):void 0),ret.addPropertyResult("glueConnectionName","GlueConnectionName",cfn_parse.FromCloudFormation.getString(properties.GlueConnectionName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_DatabaseTableOutputOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.collect(cdk.propertyValidator("tempDirectory",CfnJob_S3LocationPropertyValidator)(properties.tempDirectory)),errors.wrap('supplied properties not correct for "DatabaseTableOutputOptionsProperty"')}function cfnJobDatabaseTableOutputOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_DatabaseTableOutputOptionsPropertyValidator(properties).assertSuccess(),{TableName:cdk.stringToCloudFormation(properties.tableName),TempDirectory:cfnJobS3LocationPropertyToCloudFormation(properties.tempDirectory)}):properties}function CfnJobDatabaseTableOutputOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addPropertyResult("tempDirectory","TempDirectory",properties.TempDirectory!=null?CfnJobS3LocationPropertyFromCloudFormation(properties.TempDirectory):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_EntityDetectorConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("allowedStatistics",CfnJob_AllowedStatisticsPropertyValidator)(properties.allowedStatistics)),errors.collect(cdk.propertyValidator("entityTypes",cdk.requiredValidator)(properties.entityTypes)),errors.collect(cdk.propertyValidator("entityTypes",cdk.listValidator(cdk.validateString))(properties.entityTypes)),errors.wrap('supplied properties not correct for "EntityDetectorConfigurationProperty"')}function cfnJobEntityDetectorConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_EntityDetectorConfigurationPropertyValidator(properties).assertSuccess(),{AllowedStatistics:cfnJobAllowedStatisticsPropertyToCloudFormation(properties.allowedStatistics),EntityTypes:cdk.listMapper(cdk.stringToCloudFormation)(properties.entityTypes)}):properties}function CfnJobEntityDetectorConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("allowedStatistics","AllowedStatistics",properties.AllowedStatistics!=null?CfnJobAllowedStatisticsPropertyFromCloudFormation(properties.AllowedStatistics):void 0),ret.addPropertyResult("entityTypes","EntityTypes",cfn_parse.FromCloudFormation.getStringArray(properties.EntityTypes)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_JobSamplePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mode",cdk.validateString)(properties.mode)),errors.collect(cdk.propertyValidator("size",cdk.validateNumber)(properties.size)),errors.wrap('supplied properties not correct for "JobSampleProperty"')}function cfnJobJobSamplePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_JobSamplePropertyValidator(properties).assertSuccess(),{Mode:cdk.stringToCloudFormation(properties.mode),Size:cdk.numberToCloudFormation(properties.size)}):properties}function CfnJobJobSamplePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mode","Mode",properties.Mode!=null?cfn_parse.FromCloudFormation.getString(properties.Mode):void 0),ret.addPropertyResult("size","Size",properties.Size!=null?cfn_parse.FromCloudFormation.getNumber(properties.Size):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_OutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("compressionFormat",cdk.validateString)(properties.compressionFormat)),errors.collect(cdk.propertyValidator("format",cdk.validateString)(properties.format)),errors.collect(cdk.propertyValidator("formatOptions",CfnJob_OutputFormatOptionsPropertyValidator)(properties.formatOptions)),errors.collect(cdk.propertyValidator("location",cdk.requiredValidator)(properties.location)),errors.collect(cdk.propertyValidator("location",CfnJob_S3LocationPropertyValidator)(properties.location)),errors.collect(cdk.propertyValidator("maxOutputFiles",cdk.validateNumber)(properties.maxOutputFiles)),errors.collect(cdk.propertyValidator("overwrite",cdk.validateBoolean)(properties.overwrite)),errors.collect(cdk.propertyValidator("partitionColumns",cdk.listValidator(cdk.validateString))(properties.partitionColumns)),errors.wrap('supplied properties not correct for "OutputProperty"')}function cfnJobOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_OutputPropertyValidator(properties).assertSuccess(),{CompressionFormat:cdk.stringToCloudFormation(properties.compressionFormat),Format:cdk.stringToCloudFormation(properties.format),FormatOptions:cfnJobOutputFormatOptionsPropertyToCloudFormation(properties.formatOptions),Location:cfnJobS3LocationPropertyToCloudFormation(properties.location),MaxOutputFiles:cdk.numberToCloudFormation(properties.maxOutputFiles),Overwrite:cdk.booleanToCloudFormation(properties.overwrite),PartitionColumns:cdk.listMapper(cdk.stringToCloudFormation)(properties.partitionColumns)}):properties}function CfnJobOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("compressionFormat","CompressionFormat",properties.CompressionFormat!=null?cfn_parse.FromCloudFormation.getString(properties.CompressionFormat):void 0),ret.addPropertyResult("format","Format",properties.Format!=null?cfn_parse.FromCloudFormation.getString(properties.Format):void 0),ret.addPropertyResult("formatOptions","FormatOptions",properties.FormatOptions!=null?CfnJobOutputFormatOptionsPropertyFromCloudFormation(properties.FormatOptions):void 0),ret.addPropertyResult("location","Location",CfnJobS3LocationPropertyFromCloudFormation(properties.Location)),ret.addPropertyResult("maxOutputFiles","MaxOutputFiles",properties.MaxOutputFiles!=null?cfn_parse.FromCloudFormation.getNumber(properties.MaxOutputFiles):void 0),ret.addPropertyResult("overwrite","Overwrite",properties.Overwrite!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Overwrite):void 0),ret.addPropertyResult("partitionColumns","PartitionColumns",properties.PartitionColumns!=null?cfn_parse.FromCloudFormation.getStringArray(properties.PartitionColumns):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_OutputFormatOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csv",CfnJob_CsvOutputOptionsPropertyValidator)(properties.csv)),errors.wrap('supplied properties not correct for "OutputFormatOptionsProperty"')}function cfnJobOutputFormatOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_OutputFormatOptionsPropertyValidator(properties).assertSuccess(),{Csv:cfnJobCsvOutputOptionsPropertyToCloudFormation(properties.csv)}):properties}function CfnJobOutputFormatOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csv","Csv",properties.Csv!=null?CfnJobCsvOutputOptionsPropertyFromCloudFormation(properties.Csv):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_OutputLocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("bucketOwner",cdk.validateString)(properties.bucketOwner)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.wrap('supplied properties not correct for "OutputLocationProperty"')}function cfnJobOutputLocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_OutputLocationPropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),BucketOwner:cdk.stringToCloudFormation(properties.bucketOwner),Key:cdk.stringToCloudFormation(properties.key)}):properties}function CfnJobOutputLocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("bucketOwner","BucketOwner",properties.BucketOwner!=null?cfn_parse.FromCloudFormation.getString(properties.BucketOwner):void 0),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_ProfileConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("columnStatisticsConfigurations",cdk.listValidator(CfnJob_ColumnStatisticsConfigurationPropertyValidator))(properties.columnStatisticsConfigurations)),errors.collect(cdk.propertyValidator("datasetStatisticsConfiguration",CfnJob_StatisticsConfigurationPropertyValidator)(properties.datasetStatisticsConfiguration)),errors.collect(cdk.propertyValidator("entityDetectorConfiguration",CfnJob_EntityDetectorConfigurationPropertyValidator)(properties.entityDetectorConfiguration)),errors.collect(cdk.propertyValidator("profileColumns",cdk.listValidator(CfnJob_ColumnSelectorPropertyValidator))(properties.profileColumns)),errors.wrap('supplied properties not correct for "ProfileConfigurationProperty"')}function cfnJobProfileConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_ProfileConfigurationPropertyValidator(properties).assertSuccess(),{ColumnStatisticsConfigurations:cdk.listMapper(cfnJobColumnStatisticsConfigurationPropertyToCloudFormation)(properties.columnStatisticsConfigurations),DatasetStatisticsConfiguration:cfnJobStatisticsConfigurationPropertyToCloudFormation(properties.datasetStatisticsConfiguration),EntityDetectorConfiguration:cfnJobEntityDetectorConfigurationPropertyToCloudFormation(properties.entityDetectorConfiguration),ProfileColumns:cdk.listMapper(cfnJobColumnSelectorPropertyToCloudFormation)(properties.profileColumns)}):properties}function CfnJobProfileConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("columnStatisticsConfigurations","ColumnStatisticsConfigurations",properties.ColumnStatisticsConfigurations!=null?cfn_parse.FromCloudFormation.getArray(CfnJobColumnStatisticsConfigurationPropertyFromCloudFormation)(properties.ColumnStatisticsConfigurations):void 0),ret.addPropertyResult("datasetStatisticsConfiguration","DatasetStatisticsConfiguration",properties.DatasetStatisticsConfiguration!=null?CfnJobStatisticsConfigurationPropertyFromCloudFormation(properties.DatasetStatisticsConfiguration):void 0),ret.addPropertyResult("entityDetectorConfiguration","EntityDetectorConfiguration",properties.EntityDetectorConfiguration!=null?CfnJobEntityDetectorConfigurationPropertyFromCloudFormation(properties.EntityDetectorConfiguration):void 0),ret.addPropertyResult("profileColumns","ProfileColumns",properties.ProfileColumns!=null?cfn_parse.FromCloudFormation.getArray(CfnJobColumnSelectorPropertyFromCloudFormation)(properties.ProfileColumns):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_RecipePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("version",cdk.validateString)(properties.version)),errors.wrap('supplied properties not correct for "RecipeProperty"')}function cfnJobRecipePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_RecipePropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Version:cdk.stringToCloudFormation(properties.version)}):properties}function CfnJobRecipePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("version","Version",properties.Version!=null?cfn_parse.FromCloudFormation.getString(properties.Version):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_S3LocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("bucketOwner",cdk.validateString)(properties.bucketOwner)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.wrap('supplied properties not correct for "S3LocationProperty"')}function cfnJobS3LocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_S3LocationPropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),BucketOwner:cdk.stringToCloudFormation(properties.bucketOwner),Key:cdk.stringToCloudFormation(properties.key)}):properties}function CfnJobS3LocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("bucketOwner","BucketOwner",properties.BucketOwner!=null?cfn_parse.FromCloudFormation.getString(properties.BucketOwner):void 0),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_S3TableOutputOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("location",cdk.requiredValidator)(properties.location)),errors.collect(cdk.propertyValidator("location",CfnJob_S3LocationPropertyValidator)(properties.location)),errors.wrap('supplied properties not correct for "S3TableOutputOptionsProperty"')}function cfnJobS3TableOutputOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_S3TableOutputOptionsPropertyValidator(properties).assertSuccess(),{Location:cfnJobS3LocationPropertyToCloudFormation(properties.location)}):properties}function CfnJobS3TableOutputOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("location","Location",CfnJobS3LocationPropertyFromCloudFormation(properties.Location)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_StatisticOverridePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("parameters",cdk.requiredValidator)(properties.parameters)),errors.collect(cdk.propertyValidator("parameters",cdk.validateObject)(properties.parameters)),errors.collect(cdk.propertyValidator("statistic",cdk.requiredValidator)(properties.statistic)),errors.collect(cdk.propertyValidator("statistic",cdk.validateString)(properties.statistic)),errors.wrap('supplied properties not correct for "StatisticOverrideProperty"')}function cfnJobStatisticOverridePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_StatisticOverridePropertyValidator(properties).assertSuccess(),{Parameters:cdk.objectToCloudFormation(properties.parameters),Statistic:cdk.stringToCloudFormation(properties.statistic)}):properties}function CfnJobStatisticOverridePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("parameters","Parameters",cfn_parse.FromCloudFormation.getAny(properties.Parameters)),ret.addPropertyResult("statistic","Statistic",cfn_parse.FromCloudFormation.getString(properties.Statistic)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_StatisticsConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("includedStatistics",cdk.listValidator(cdk.validateString))(properties.includedStatistics)),errors.collect(cdk.propertyValidator("overrides",cdk.listValidator(CfnJob_StatisticOverridePropertyValidator))(properties.overrides)),errors.wrap('supplied properties not correct for "StatisticsConfigurationProperty"')}function cfnJobStatisticsConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_StatisticsConfigurationPropertyValidator(properties).assertSuccess(),{IncludedStatistics:cdk.listMapper(cdk.stringToCloudFormation)(properties.includedStatistics),Overrides:cdk.listMapper(cfnJobStatisticOverridePropertyToCloudFormation)(properties.overrides)}):properties}function CfnJobStatisticsConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("includedStatistics","IncludedStatistics",properties.IncludedStatistics!=null?cfn_parse.FromCloudFormation.getStringArray(properties.IncludedStatistics):void 0),ret.addPropertyResult("overrides","Overrides",properties.Overrides!=null?cfn_parse.FromCloudFormation.getArray(CfnJobStatisticOverridePropertyFromCloudFormation)(properties.Overrides):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnJob_ValidationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("rulesetArn",cdk.requiredValidator)(properties.rulesetArn)),errors.collect(cdk.propertyValidator("rulesetArn",cdk.validateString)(properties.rulesetArn)),errors.collect(cdk.propertyValidator("validationMode",cdk.validateString)(properties.validationMode)),errors.wrap('supplied properties not correct for "ValidationConfigurationProperty"')}function cfnJobValidationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnJob_ValidationConfigurationPropertyValidator(properties).assertSuccess(),{RulesetArn:cdk.stringToCloudFormation(properties.rulesetArn),ValidationMode:cdk.stringToCloudFormation(properties.validationMode)}):properties}function CfnJobValidationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("rulesetArn","RulesetArn",cfn_parse.FromCloudFormation.getString(properties.RulesetArn)),ret.addPropertyResult("validationMode","ValidationMode",properties.ValidationMode!=null?cfn_parse.FromCloudFormation.getString(properties.ValidationMode):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnProjectPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datasetName",cdk.requiredValidator)(properties.datasetName)),errors.collect(cdk.propertyValidator("datasetName",cdk.validateString)(properties.datasetName)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("recipeName",cdk.requiredValidator)(properties.recipeName)),errors.collect(cdk.propertyValidator("recipeName",cdk.validateString)(properties.recipeName)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("sample",CfnProject_SamplePropertyValidator)(properties.sample)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnProjectProps"')}function cfnProjectPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnProjectPropsValidator(properties).assertSuccess(),{DatasetName:cdk.stringToCloudFormation(properties.datasetName),Name:cdk.stringToCloudFormation(properties.name),RecipeName:cdk.stringToCloudFormation(properties.recipeName),RoleArn:cdk.stringToCloudFormation(properties.roleArn),Sample:cfnProjectSamplePropertyToCloudFormation(properties.sample),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnProjectPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datasetName","DatasetName",cfn_parse.FromCloudFormation.getString(properties.DatasetName)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("recipeName","RecipeName",cfn_parse.FromCloudFormation.getString(properties.RecipeName)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("sample","Sample",properties.Sample!=null?CfnProjectSamplePropertyFromCloudFormation(properties.Sample):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnProject extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnProject.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnProjectProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnProject),error}cdk.requireProperty(props,"datasetName",this),cdk.requireProperty(props,"name",this),cdk.requireProperty(props,"recipeName",this),cdk.requireProperty(props,"roleArn",this),this.datasetName=props.datasetName,this.name=props.name,this.recipeName=props.recipeName,this.roleArn=props.roleArn,this.sample=props.sample,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Project",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnProjectPropsFromCloudFormation(resourceProperties),ret=new CfnProject(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnProject.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{datasetName:this.datasetName,name:this.name,recipeName:this.recipeName,roleArn:this.roleArn,sample:this.sample,tags:this.tags.renderTags()}}renderProperties(props){return cfnProjectPropsToCloudFormation(props)}}exports.CfnProject=CfnProject,_c=JSII_RTTI_SYMBOL_1,CfnProject[_c]={fqn:"aws-cdk-lib.aws_databrew.CfnProject",version:"2.42.0"},CfnProject.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Project";function CfnProject_SamplePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("size",cdk.validateNumber)(properties.size)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "SampleProperty"')}function cfnProjectSamplePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnProject_SamplePropertyValidator(properties).assertSuccess(),{Size:cdk.numberToCloudFormation(properties.size),Type:cdk.stringToCloudFormation(properties.type)}):properties}function CfnProjectSamplePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("size","Size",properties.Size!=null?cfn_parse.FromCloudFormation.getNumber(properties.Size):void 0),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("steps",cdk.requiredValidator)(properties.steps)),errors.collect(cdk.propertyValidator("steps",cdk.listValidator(CfnRecipe_RecipeStepPropertyValidator))(properties.steps)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnRecipeProps"')}function cfnRecipePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipePropsValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Steps:cdk.listMapper(cfnRecipeRecipeStepPropertyToCloudFormation)(properties.steps),Description:cdk.stringToCloudFormation(properties.description),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnRecipePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("steps","Steps",cfn_parse.FromCloudFormation.getArray(CfnRecipeRecipeStepPropertyFromCloudFormation)(properties.Steps)),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnRecipe extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnRecipe.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnRecipeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnRecipe),error}cdk.requireProperty(props,"name",this),cdk.requireProperty(props,"steps",this),this.name=props.name,this.steps=props.steps,this.description=props.description,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Recipe",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnRecipePropsFromCloudFormation(resourceProperties),ret=new CfnRecipe(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnRecipe.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{name:this.name,steps:this.steps,description:this.description,tags:this.tags.renderTags()}}renderProperties(props){return cfnRecipePropsToCloudFormation(props)}}exports.CfnRecipe=CfnRecipe,_d=JSII_RTTI_SYMBOL_1,CfnRecipe[_d]={fqn:"aws-cdk-lib.aws_databrew.CfnRecipe",version:"2.42.0"},CfnRecipe.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Recipe";function CfnRecipe_ActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("operation",cdk.requiredValidator)(properties.operation)),errors.collect(cdk.propertyValidator("operation",cdk.validateString)(properties.operation)),errors.collect(cdk.propertyValidator("parameters",cdk.hashValidator(cdk.validateString))(properties.parameters)),errors.wrap('supplied properties not correct for "ActionProperty"')}function cfnRecipeActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_ActionPropertyValidator(properties).assertSuccess(),{Operation:cdk.stringToCloudFormation(properties.operation),Parameters:cdk.hashMapper(cdk.stringToCloudFormation)(properties.parameters)}):properties}function CfnRecipeActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("operation","Operation",cfn_parse.FromCloudFormation.getString(properties.Operation)),ret.addPropertyResult("parameters","Parameters",properties.Parameters!=null?cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Parameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_ConditionExpressionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("condition",cdk.requiredValidator)(properties.condition)),errors.collect(cdk.propertyValidator("condition",cdk.validateString)(properties.condition)),errors.collect(cdk.propertyValidator("targetColumn",cdk.requiredValidator)(properties.targetColumn)),errors.collect(cdk.propertyValidator("targetColumn",cdk.validateString)(properties.targetColumn)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.wrap('supplied properties not correct for "ConditionExpressionProperty"')}function cfnRecipeConditionExpressionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_ConditionExpressionPropertyValidator(properties).assertSuccess(),{Condition:cdk.stringToCloudFormation(properties.condition),TargetColumn:cdk.stringToCloudFormation(properties.targetColumn),Value:cdk.stringToCloudFormation(properties.value)}):properties}function CfnRecipeConditionExpressionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("condition","Condition",cfn_parse.FromCloudFormation.getString(properties.Condition)),ret.addPropertyResult("targetColumn","TargetColumn",cfn_parse.FromCloudFormation.getString(properties.TargetColumn)),ret.addPropertyResult("value","Value",properties.Value!=null?cfn_parse.FromCloudFormation.getString(properties.Value):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_DataCatalogInputDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("catalogId",cdk.validateString)(properties.catalogId)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.collect(cdk.propertyValidator("tempDirectory",CfnRecipe_S3LocationPropertyValidator)(properties.tempDirectory)),errors.wrap('supplied properties not correct for "DataCatalogInputDefinitionProperty"')}function cfnRecipeDataCatalogInputDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_DataCatalogInputDefinitionPropertyValidator(properties).assertSuccess(),{CatalogId:cdk.stringToCloudFormation(properties.catalogId),DatabaseName:cdk.stringToCloudFormation(properties.databaseName),TableName:cdk.stringToCloudFormation(properties.tableName),TempDirectory:cfnRecipeS3LocationPropertyToCloudFormation(properties.tempDirectory)}):properties}function CfnRecipeDataCatalogInputDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("catalogId","CatalogId",properties.CatalogId!=null?cfn_parse.FromCloudFormation.getString(properties.CatalogId):void 0),ret.addPropertyResult("databaseName","DatabaseName",properties.DatabaseName!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseName):void 0),ret.addPropertyResult("tableName","TableName",properties.TableName!=null?cfn_parse.FromCloudFormation.getString(properties.TableName):void 0),ret.addPropertyResult("tempDirectory","TempDirectory",properties.TempDirectory!=null?CfnRecipeS3LocationPropertyFromCloudFormation(properties.TempDirectory):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_RecipeParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("aggregateFunction",cdk.validateString)(properties.aggregateFunction)),errors.collect(cdk.propertyValidator("base",cdk.validateString)(properties.base)),errors.collect(cdk.propertyValidator("caseStatement",cdk.validateString)(properties.caseStatement)),errors.collect(cdk.propertyValidator("categoryMap",cdk.validateString)(properties.categoryMap)),errors.collect(cdk.propertyValidator("charsToRemove",cdk.validateString)(properties.charsToRemove)),errors.collect(cdk.propertyValidator("collapseConsecutiveWhitespace",cdk.validateString)(properties.collapseConsecutiveWhitespace)),errors.collect(cdk.propertyValidator("columnDataType",cdk.validateString)(properties.columnDataType)),errors.collect(cdk.propertyValidator("columnRange",cdk.validateString)(properties.columnRange)),errors.collect(cdk.propertyValidator("count",cdk.validateString)(properties.count)),errors.collect(cdk.propertyValidator("customCharacters",cdk.validateString)(properties.customCharacters)),errors.collect(cdk.propertyValidator("customStopWords",cdk.validateString)(properties.customStopWords)),errors.collect(cdk.propertyValidator("customValue",cdk.validateString)(properties.customValue)),errors.collect(cdk.propertyValidator("datasetsColumns",cdk.validateString)(properties.datasetsColumns)),errors.collect(cdk.propertyValidator("dateAddValue",cdk.validateString)(properties.dateAddValue)),errors.collect(cdk.propertyValidator("dateTimeFormat",cdk.validateString)(properties.dateTimeFormat)),errors.collect(cdk.propertyValidator("dateTimeParameters",cdk.validateString)(properties.dateTimeParameters)),errors.collect(cdk.propertyValidator("deleteOtherRows",cdk.validateString)(properties.deleteOtherRows)),errors.collect(cdk.propertyValidator("delimiter",cdk.validateString)(properties.delimiter)),errors.collect(cdk.propertyValidator("endPattern",cdk.validateString)(properties.endPattern)),errors.collect(cdk.propertyValidator("endPosition",cdk.validateString)(properties.endPosition)),errors.collect(cdk.propertyValidator("endValue",cdk.validateString)(properties.endValue)),errors.collect(cdk.propertyValidator("expandContractions",cdk.validateString)(properties.expandContractions)),errors.collect(cdk.propertyValidator("exponent",cdk.validateString)(properties.exponent)),errors.collect(cdk.propertyValidator("falseString",cdk.validateString)(properties.falseString)),errors.collect(cdk.propertyValidator("groupByAggFunctionOptions",cdk.validateString)(properties.groupByAggFunctionOptions)),errors.collect(cdk.propertyValidator("groupByColumns",cdk.validateString)(properties.groupByColumns)),errors.collect(cdk.propertyValidator("hiddenColumns",cdk.validateString)(properties.hiddenColumns)),errors.collect(cdk.propertyValidator("ignoreCase",cdk.validateString)(properties.ignoreCase)),errors.collect(cdk.propertyValidator("includeInSplit",cdk.validateString)(properties.includeInSplit)),errors.collect(cdk.propertyValidator("input",cdk.validateObject)(properties.input)),errors.collect(cdk.propertyValidator("interval",cdk.validateString)(properties.interval)),errors.collect(cdk.propertyValidator("isText",cdk.validateString)(properties.isText)),errors.collect(cdk.propertyValidator("joinKeys",cdk.validateString)(properties.joinKeys)),errors.collect(cdk.propertyValidator("joinType",cdk.validateString)(properties.joinType)),errors.collect(cdk.propertyValidator("leftColumns",cdk.validateString)(properties.leftColumns)),errors.collect(cdk.propertyValidator("limit",cdk.validateString)(properties.limit)),errors.collect(cdk.propertyValidator("lowerBound",cdk.validateString)(properties.lowerBound)),errors.collect(cdk.propertyValidator("mapType",cdk.validateString)(properties.mapType)),errors.collect(cdk.propertyValidator("modeType",cdk.validateString)(properties.modeType)),errors.collect(cdk.propertyValidator("multiLine",cdk.validateBoolean)(properties.multiLine)),errors.collect(cdk.propertyValidator("numRows",cdk.validateString)(properties.numRows)),errors.collect(cdk.propertyValidator("numRowsAfter",cdk.validateString)(properties.numRowsAfter)),errors.collect(cdk.propertyValidator("numRowsBefore",cdk.validateString)(properties.numRowsBefore)),errors.collect(cdk.propertyValidator("orderByColumn",cdk.validateString)(properties.orderByColumn)),errors.collect(cdk.propertyValidator("orderByColumns",cdk.validateString)(properties.orderByColumns)),errors.collect(cdk.propertyValidator("other",cdk.validateString)(properties.other)),errors.collect(cdk.propertyValidator("pattern",cdk.validateString)(properties.pattern)),errors.collect(cdk.propertyValidator("patternOption1",cdk.validateString)(properties.patternOption1)),errors.collect(cdk.propertyValidator("patternOption2",cdk.validateString)(properties.patternOption2)),errors.collect(cdk.propertyValidator("patternOptions",cdk.validateString)(properties.patternOptions)),errors.collect(cdk.propertyValidator("period",cdk.validateString)(properties.period)),errors.collect(cdk.propertyValidator("position",cdk.validateString)(properties.position)),errors.collect(cdk.propertyValidator("removeAllPunctuation",cdk.validateString)(properties.removeAllPunctuation)),errors.collect(cdk.propertyValidator("removeAllQuotes",cdk.validateString)(properties.removeAllQuotes)),errors.collect(cdk.propertyValidator("removeAllWhitespace",cdk.validateString)(properties.removeAllWhitespace)),errors.collect(cdk.propertyValidator("removeCustomCharacters",cdk.validateString)(properties.removeCustomCharacters)),errors.collect(cdk.propertyValidator("removeCustomValue",cdk.validateString)(properties.removeCustomValue)),errors.collect(cdk.propertyValidator("removeLeadingAndTrailingPunctuation",cdk.validateString)(properties.removeLeadingAndTrailingPunctuation)),errors.collect(cdk.propertyValidator("removeLeadingAndTrailingQuotes",cdk.validateString)(properties.removeLeadingAndTrailingQuotes)),errors.collect(cdk.propertyValidator("removeLeadingAndTrailingWhitespace",cdk.validateString)(properties.removeLeadingAndTrailingWhitespace)),errors.collect(cdk.propertyValidator("removeLetters",cdk.validateString)(properties.removeLetters)),errors.collect(cdk.propertyValidator("removeNumbers",cdk.validateString)(properties.removeNumbers)),errors.collect(cdk.propertyValidator("removeSourceColumn",cdk.validateString)(properties.removeSourceColumn)),errors.collect(cdk.propertyValidator("removeSpecialCharacters",cdk.validateString)(properties.removeSpecialCharacters)),errors.collect(cdk.propertyValidator("rightColumns",cdk.validateString)(properties.rightColumns)),errors.collect(cdk.propertyValidator("sampleSize",cdk.validateString)(properties.sampleSize)),errors.collect(cdk.propertyValidator("sampleType",cdk.validateString)(properties.sampleType)),errors.collect(cdk.propertyValidator("secondInput",cdk.validateString)(properties.secondInput)),errors.collect(cdk.propertyValidator("secondaryInputs",cdk.listValidator(CfnRecipe_SecondaryInputPropertyValidator))(properties.secondaryInputs)),errors.collect(cdk.propertyValidator("sheetIndexes",cdk.listValidator(cdk.validateNumber))(properties.sheetIndexes)),errors.collect(cdk.propertyValidator("sheetNames",cdk.listValidator(cdk.validateString))(properties.sheetNames)),errors.collect(cdk.propertyValidator("sourceColumn",cdk.validateString)(properties.sourceColumn)),errors.collect(cdk.propertyValidator("sourceColumn1",cdk.validateString)(properties.sourceColumn1)),errors.collect(cdk.propertyValidator("sourceColumn2",cdk.validateString)(properties.sourceColumn2)),errors.collect(cdk.propertyValidator("sourceColumns",cdk.validateString)(properties.sourceColumns)),errors.collect(cdk.propertyValidator("startColumnIndex",cdk.validateString)(properties.startColumnIndex)),errors.collect(cdk.propertyValidator("startPattern",cdk.validateString)(properties.startPattern)),errors.collect(cdk.propertyValidator("startPosition",cdk.validateString)(properties.startPosition)),errors.collect(cdk.propertyValidator("startValue",cdk.validateString)(properties.startValue)),errors.collect(cdk.propertyValidator("stemmingMode",cdk.validateString)(properties.stemmingMode)),errors.collect(cdk.propertyValidator("stepCount",cdk.validateString)(properties.stepCount)),errors.collect(cdk.propertyValidator("stepIndex",cdk.validateString)(properties.stepIndex)),errors.collect(cdk.propertyValidator("stopWordsMode",cdk.validateString)(properties.stopWordsMode)),errors.collect(cdk.propertyValidator("strategy",cdk.validateString)(properties.strategy)),errors.collect(cdk.propertyValidator("targetColumn",cdk.validateString)(properties.targetColumn)),errors.collect(cdk.propertyValidator("targetColumnNames",cdk.validateString)(properties.targetColumnNames)),errors.collect(cdk.propertyValidator("targetDateFormat",cdk.validateString)(properties.targetDateFormat)),errors.collect(cdk.propertyValidator("targetIndex",cdk.validateString)(properties.targetIndex)),errors.collect(cdk.propertyValidator("timeZone",cdk.validateString)(properties.timeZone)),errors.collect(cdk.propertyValidator("tokenizerPattern",cdk.validateString)(properties.tokenizerPattern)),errors.collect(cdk.propertyValidator("trueString",cdk.validateString)(properties.trueString)),errors.collect(cdk.propertyValidator("udfLang",cdk.validateString)(properties.udfLang)),errors.collect(cdk.propertyValidator("units",cdk.validateString)(properties.units)),errors.collect(cdk.propertyValidator("unpivotColumn",cdk.validateString)(properties.unpivotColumn)),errors.collect(cdk.propertyValidator("upperBound",cdk.validateString)(properties.upperBound)),errors.collect(cdk.propertyValidator("useNewDataFrame",cdk.validateString)(properties.useNewDataFrame)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.collect(cdk.propertyValidator("value1",cdk.validateString)(properties.value1)),errors.collect(cdk.propertyValidator("value2",cdk.validateString)(properties.value2)),errors.collect(cdk.propertyValidator("valueColumn",cdk.validateString)(properties.valueColumn)),errors.collect(cdk.propertyValidator("viewFrame",cdk.validateString)(properties.viewFrame)),errors.wrap('supplied properties not correct for "RecipeParametersProperty"')}function cfnRecipeRecipeParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_RecipeParametersPropertyValidator(properties).assertSuccess(),{AggregateFunction:cdk.stringToCloudFormation(properties.aggregateFunction),Base:cdk.stringToCloudFormation(properties.base),CaseStatement:cdk.stringToCloudFormation(properties.caseStatement),CategoryMap:cdk.stringToCloudFormation(properties.categoryMap),CharsToRemove:cdk.stringToCloudFormation(properties.charsToRemove),CollapseConsecutiveWhitespace:cdk.stringToCloudFormation(properties.collapseConsecutiveWhitespace),ColumnDataType:cdk.stringToCloudFormation(properties.columnDataType),ColumnRange:cdk.stringToCloudFormation(properties.columnRange),Count:cdk.stringToCloudFormation(properties.count),CustomCharacters:cdk.stringToCloudFormation(properties.customCharacters),CustomStopWords:cdk.stringToCloudFormation(properties.customStopWords),CustomValue:cdk.stringToCloudFormation(properties.customValue),DatasetsColumns:cdk.stringToCloudFormation(properties.datasetsColumns),DateAddValue:cdk.stringToCloudFormation(properties.dateAddValue),DateTimeFormat:cdk.stringToCloudFormation(properties.dateTimeFormat),DateTimeParameters:cdk.stringToCloudFormation(properties.dateTimeParameters),DeleteOtherRows:cdk.stringToCloudFormation(properties.deleteOtherRows),Delimiter:cdk.stringToCloudFormation(properties.delimiter),EndPattern:cdk.stringToCloudFormation(properties.endPattern),EndPosition:cdk.stringToCloudFormation(properties.endPosition),EndValue:cdk.stringToCloudFormation(properties.endValue),ExpandContractions:cdk.stringToCloudFormation(properties.expandContractions),Exponent:cdk.stringToCloudFormation(properties.exponent),FalseString:cdk.stringToCloudFormation(properties.falseString),GroupByAggFunctionOptions:cdk.stringToCloudFormation(properties.groupByAggFunctionOptions),GroupByColumns:cdk.stringToCloudFormation(properties.groupByColumns),HiddenColumns:cdk.stringToCloudFormation(properties.hiddenColumns),IgnoreCase:cdk.stringToCloudFormation(properties.ignoreCase),IncludeInSplit:cdk.stringToCloudFormation(properties.includeInSplit),Input:cdk.objectToCloudFormation(properties.input),Interval:cdk.stringToCloudFormation(properties.interval),IsText:cdk.stringToCloudFormation(properties.isText),JoinKeys:cdk.stringToCloudFormation(properties.joinKeys),JoinType:cdk.stringToCloudFormation(properties.joinType),LeftColumns:cdk.stringToCloudFormation(properties.leftColumns),Limit:cdk.stringToCloudFormation(properties.limit),LowerBound:cdk.stringToCloudFormation(properties.lowerBound),MapType:cdk.stringToCloudFormation(properties.mapType),ModeType:cdk.stringToCloudFormation(properties.modeType),MultiLine:cdk.booleanToCloudFormation(properties.multiLine),NumRows:cdk.stringToCloudFormation(properties.numRows),NumRowsAfter:cdk.stringToCloudFormation(properties.numRowsAfter),NumRowsBefore:cdk.stringToCloudFormation(properties.numRowsBefore),OrderByColumn:cdk.stringToCloudFormation(properties.orderByColumn),OrderByColumns:cdk.stringToCloudFormation(properties.orderByColumns),Other:cdk.stringToCloudFormation(properties.other),Pattern:cdk.stringToCloudFormation(properties.pattern),PatternOption1:cdk.stringToCloudFormation(properties.patternOption1),PatternOption2:cdk.stringToCloudFormation(properties.patternOption2),PatternOptions:cdk.stringToCloudFormation(properties.patternOptions),Period:cdk.stringToCloudFormation(properties.period),Position:cdk.stringToCloudFormation(properties.position),RemoveAllPunctuation:cdk.stringToCloudFormation(properties.removeAllPunctuation),RemoveAllQuotes:cdk.stringToCloudFormation(properties.removeAllQuotes),RemoveAllWhitespace:cdk.stringToCloudFormation(properties.removeAllWhitespace),RemoveCustomCharacters:cdk.stringToCloudFormation(properties.removeCustomCharacters),RemoveCustomValue:cdk.stringToCloudFormation(properties.removeCustomValue),RemoveLeadingAndTrailingPunctuation:cdk.stringToCloudFormation(properties.removeLeadingAndTrailingPunctuation),RemoveLeadingAndTrailingQuotes:cdk.stringToCloudFormation(properties.removeLeadingAndTrailingQuotes),RemoveLeadingAndTrailingWhitespace:cdk.stringToCloudFormation(properties.removeLeadingAndTrailingWhitespace),RemoveLetters:cdk.stringToCloudFormation(properties.removeLetters),RemoveNumbers:cdk.stringToCloudFormation(properties.removeNumbers),RemoveSourceColumn:cdk.stringToCloudFormation(properties.removeSourceColumn),RemoveSpecialCharacters:cdk.stringToCloudFormation(properties.removeSpecialCharacters),RightColumns:cdk.stringToCloudFormation(properties.rightColumns),SampleSize:cdk.stringToCloudFormation(properties.sampleSize),SampleType:cdk.stringToCloudFormation(properties.sampleType),SecondInput:cdk.stringToCloudFormation(properties.secondInput),SecondaryInputs:cdk.listMapper(cfnRecipeSecondaryInputPropertyToCloudFormation)(properties.secondaryInputs),SheetIndexes:cdk.listMapper(cdk.numberToCloudFormation)(properties.sheetIndexes),SheetNames:cdk.listMapper(cdk.stringToCloudFormation)(properties.sheetNames),SourceColumn:cdk.stringToCloudFormation(properties.sourceColumn),SourceColumn1:cdk.stringToCloudFormation(properties.sourceColumn1),SourceColumn2:cdk.stringToCloudFormation(properties.sourceColumn2),SourceColumns:cdk.stringToCloudFormation(properties.sourceColumns),StartColumnIndex:cdk.stringToCloudFormation(properties.startColumnIndex),StartPattern:cdk.stringToCloudFormation(properties.startPattern),StartPosition:cdk.stringToCloudFormation(properties.startPosition),StartValue:cdk.stringToCloudFormation(properties.startValue),StemmingMode:cdk.stringToCloudFormation(properties.stemmingMode),StepCount:cdk.stringToCloudFormation(properties.stepCount),StepIndex:cdk.stringToCloudFormation(properties.stepIndex),StopWordsMode:cdk.stringToCloudFormation(properties.stopWordsMode),Strategy:cdk.stringToCloudFormation(properties.strategy),TargetColumn:cdk.stringToCloudFormation(properties.targetColumn),TargetColumnNames:cdk.stringToCloudFormation(properties.targetColumnNames),TargetDateFormat:cdk.stringToCloudFormation(properties.targetDateFormat),TargetIndex:cdk.stringToCloudFormation(properties.targetIndex),TimeZone:cdk.stringToCloudFormation(properties.timeZone),TokenizerPattern:cdk.stringToCloudFormation(properties.tokenizerPattern),TrueString:cdk.stringToCloudFormation(properties.trueString),UdfLang:cdk.stringToCloudFormation(properties.udfLang),Units:cdk.stringToCloudFormation(properties.units),UnpivotColumn:cdk.stringToCloudFormation(properties.unpivotColumn),UpperBound:cdk.stringToCloudFormation(properties.upperBound),UseNewDataFrame:cdk.stringToCloudFormation(properties.useNewDataFrame),Value:cdk.stringToCloudFormation(properties.value),Value1:cdk.stringToCloudFormation(properties.value1),Value2:cdk.stringToCloudFormation(properties.value2),ValueColumn:cdk.stringToCloudFormation(properties.valueColumn),ViewFrame:cdk.stringToCloudFormation(properties.viewFrame)}):properties}function CfnRecipeRecipeParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("aggregateFunction","AggregateFunction",properties.AggregateFunction!=null?cfn_parse.FromCloudFormation.getString(properties.AggregateFunction):void 0),ret.addPropertyResult("base","Base",properties.Base!=null?cfn_parse.FromCloudFormation.getString(properties.Base):void 0),ret.addPropertyResult("caseStatement","CaseStatement",properties.CaseStatement!=null?cfn_parse.FromCloudFormation.getString(properties.CaseStatement):void 0),ret.addPropertyResult("categoryMap","CategoryMap",properties.CategoryMap!=null?cfn_parse.FromCloudFormation.getString(properties.CategoryMap):void 0),ret.addPropertyResult("charsToRemove","CharsToRemove",properties.CharsToRemove!=null?cfn_parse.FromCloudFormation.getString(properties.CharsToRemove):void 0),ret.addPropertyResult("collapseConsecutiveWhitespace","CollapseConsecutiveWhitespace",properties.CollapseConsecutiveWhitespace!=null?cfn_parse.FromCloudFormation.getString(properties.CollapseConsecutiveWhitespace):void 0),ret.addPropertyResult("columnDataType","ColumnDataType",properties.ColumnDataType!=null?cfn_parse.FromCloudFormation.getString(properties.ColumnDataType):void 0),ret.addPropertyResult("columnRange","ColumnRange",properties.ColumnRange!=null?cfn_parse.FromCloudFormation.getString(properties.ColumnRange):void 0),ret.addPropertyResult("count","Count",properties.Count!=null?cfn_parse.FromCloudFormation.getString(properties.Count):void 0),ret.addPropertyResult("customCharacters","CustomCharacters",properties.CustomCharacters!=null?cfn_parse.FromCloudFormation.getString(properties.CustomCharacters):void 0),ret.addPropertyResult("customStopWords","CustomStopWords",properties.CustomStopWords!=null?cfn_parse.FromCloudFormation.getString(properties.CustomStopWords):void 0),ret.addPropertyResult("customValue","CustomValue",properties.CustomValue!=null?cfn_parse.FromCloudFormation.getString(properties.CustomValue):void 0),ret.addPropertyResult("datasetsColumns","DatasetsColumns",properties.DatasetsColumns!=null?cfn_parse.FromCloudFormation.getString(properties.DatasetsColumns):void 0),ret.addPropertyResult("dateAddValue","DateAddValue",properties.DateAddValue!=null?cfn_parse.FromCloudFormation.getString(properties.DateAddValue):void 0),ret.addPropertyResult("dateTimeFormat","DateTimeFormat",properties.DateTimeFormat!=null?cfn_parse.FromCloudFormation.getString(properties.DateTimeFormat):void 0),ret.addPropertyResult("dateTimeParameters","DateTimeParameters",properties.DateTimeParameters!=null?cfn_parse.FromCloudFormation.getString(properties.DateTimeParameters):void 0),ret.addPropertyResult("deleteOtherRows","DeleteOtherRows",properties.DeleteOtherRows!=null?cfn_parse.FromCloudFormation.getString(properties.DeleteOtherRows):void 0),ret.addPropertyResult("delimiter","Delimiter",properties.Delimiter!=null?cfn_parse.FromCloudFormation.getString(properties.Delimiter):void 0),ret.addPropertyResult("endPattern","EndPattern",properties.EndPattern!=null?cfn_parse.FromCloudFormation.getString(properties.EndPattern):void 0),ret.addPropertyResult("endPosition","EndPosition",properties.EndPosition!=null?cfn_parse.FromCloudFormation.getString(properties.EndPosition):void 0),ret.addPropertyResult("endValue","EndValue",properties.EndValue!=null?cfn_parse.FromCloudFormation.getString(properties.EndValue):void 0),ret.addPropertyResult("expandContractions","ExpandContractions",properties.ExpandContractions!=null?cfn_parse.FromCloudFormation.getString(properties.ExpandContractions):void 0),ret.addPropertyResult("exponent","Exponent",properties.Exponent!=null?cfn_parse.FromCloudFormation.getString(properties.Exponent):void 0),ret.addPropertyResult("falseString","FalseString",properties.FalseString!=null?cfn_parse.FromCloudFormation.getString(properties.FalseString):void 0),ret.addPropertyResult("groupByAggFunctionOptions","GroupByAggFunctionOptions",properties.GroupByAggFunctionOptions!=null?cfn_parse.FromCloudFormation.getString(properties.GroupByAggFunctionOptions):void 0),ret.addPropertyResult("groupByColumns","GroupByColumns",properties.GroupByColumns!=null?cfn_parse.FromCloudFormation.getString(properties.GroupByColumns):void 0),ret.addPropertyResult("hiddenColumns","HiddenColumns",properties.HiddenColumns!=null?cfn_parse.FromCloudFormation.getString(properties.HiddenColumns):void 0),ret.addPropertyResult("ignoreCase","IgnoreCase",properties.IgnoreCase!=null?cfn_parse.FromCloudFormation.getString(properties.IgnoreCase):void 0),ret.addPropertyResult("includeInSplit","IncludeInSplit",properties.IncludeInSplit!=null?cfn_parse.FromCloudFormation.getString(properties.IncludeInSplit):void 0),ret.addPropertyResult("input","Input",properties.Input!=null?cfn_parse.FromCloudFormation.getAny(properties.Input):void 0),ret.addPropertyResult("interval","Interval",properties.Interval!=null?cfn_parse.FromCloudFormation.getString(properties.Interval):void 0),ret.addPropertyResult("isText","IsText",properties.IsText!=null?cfn_parse.FromCloudFormation.getString(properties.IsText):void 0),ret.addPropertyResult("joinKeys","JoinKeys",properties.JoinKeys!=null?cfn_parse.FromCloudFormation.getString(properties.JoinKeys):void 0),ret.addPropertyResult("joinType","JoinType",properties.JoinType!=null?cfn_parse.FromCloudFormation.getString(properties.JoinType):void 0),ret.addPropertyResult("leftColumns","LeftColumns",properties.LeftColumns!=null?cfn_parse.FromCloudFormation.getString(properties.LeftColumns):void 0),ret.addPropertyResult("limit","Limit",properties.Limit!=null?cfn_parse.FromCloudFormation.getString(properties.Limit):void 0),ret.addPropertyResult("lowerBound","LowerBound",properties.LowerBound!=null?cfn_parse.FromCloudFormation.getString(properties.LowerBound):void 0),ret.addPropertyResult("mapType","MapType",properties.MapType!=null?cfn_parse.FromCloudFormation.getString(properties.MapType):void 0),ret.addPropertyResult("modeType","ModeType",properties.ModeType!=null?cfn_parse.FromCloudFormation.getString(properties.ModeType):void 0),ret.addPropertyResult("multiLine","MultiLine",properties.MultiLine!=null?cfn_parse.FromCloudFormation.getBoolean(properties.MultiLine):void 0),ret.addPropertyResult("numRows","NumRows",properties.NumRows!=null?cfn_parse.FromCloudFormation.getString(properties.NumRows):void 0),ret.addPropertyResult("numRowsAfter","NumRowsAfter",properties.NumRowsAfter!=null?cfn_parse.FromCloudFormation.getString(properties.NumRowsAfter):void 0),ret.addPropertyResult("numRowsBefore","NumRowsBefore",properties.NumRowsBefore!=null?cfn_parse.FromCloudFormation.getString(properties.NumRowsBefore):void 0),ret.addPropertyResult("orderByColumn","OrderByColumn",properties.OrderByColumn!=null?cfn_parse.FromCloudFormation.getString(properties.OrderByColumn):void 0),ret.addPropertyResult("orderByColumns","OrderByColumns",properties.OrderByColumns!=null?cfn_parse.FromCloudFormation.getString(properties.OrderByColumns):void 0),ret.addPropertyResult("other","Other",properties.Other!=null?cfn_parse.FromCloudFormation.getString(properties.Other):void 0),ret.addPropertyResult("pattern","Pattern",properties.Pattern!=null?cfn_parse.FromCloudFormation.getString(properties.Pattern):void 0),ret.addPropertyResult("patternOption1","PatternOption1",properties.PatternOption1!=null?cfn_parse.FromCloudFormation.getString(properties.PatternOption1):void 0),ret.addPropertyResult("patternOption2","PatternOption2",properties.PatternOption2!=null?cfn_parse.FromCloudFormation.getString(properties.PatternOption2):void 0),ret.addPropertyResult("patternOptions","PatternOptions",properties.PatternOptions!=null?cfn_parse.FromCloudFormation.getString(properties.PatternOptions):void 0),ret.addPropertyResult("period","Period",properties.Period!=null?cfn_parse.FromCloudFormation.getString(properties.Period):void 0),ret.addPropertyResult("position","Position",properties.Position!=null?cfn_parse.FromCloudFormation.getString(properties.Position):void 0),ret.addPropertyResult("removeAllPunctuation","RemoveAllPunctuation",properties.RemoveAllPunctuation!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveAllPunctuation):void 0),ret.addPropertyResult("removeAllQuotes","RemoveAllQuotes",properties.RemoveAllQuotes!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveAllQuotes):void 0),ret.addPropertyResult("removeAllWhitespace","RemoveAllWhitespace",properties.RemoveAllWhitespace!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveAllWhitespace):void 0),ret.addPropertyResult("removeCustomCharacters","RemoveCustomCharacters",properties.RemoveCustomCharacters!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveCustomCharacters):void 0),ret.addPropertyResult("removeCustomValue","RemoveCustomValue",properties.RemoveCustomValue!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveCustomValue):void 0),ret.addPropertyResult("removeLeadingAndTrailingPunctuation","RemoveLeadingAndTrailingPunctuation",properties.RemoveLeadingAndTrailingPunctuation!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveLeadingAndTrailingPunctuation):void 0),ret.addPropertyResult("removeLeadingAndTrailingQuotes","RemoveLeadingAndTrailingQuotes",properties.RemoveLeadingAndTrailingQuotes!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveLeadingAndTrailingQuotes):void 0),ret.addPropertyResult("removeLeadingAndTrailingWhitespace","RemoveLeadingAndTrailingWhitespace",properties.RemoveLeadingAndTrailingWhitespace!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveLeadingAndTrailingWhitespace):void 0),ret.addPropertyResult("removeLetters","RemoveLetters",properties.RemoveLetters!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveLetters):void 0),ret.addPropertyResult("removeNumbers","RemoveNumbers",properties.RemoveNumbers!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveNumbers):void 0),ret.addPropertyResult("removeSourceColumn","RemoveSourceColumn",properties.RemoveSourceColumn!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveSourceColumn):void 0),ret.addPropertyResult("removeSpecialCharacters","RemoveSpecialCharacters",properties.RemoveSpecialCharacters!=null?cfn_parse.FromCloudFormation.getString(properties.RemoveSpecialCharacters):void 0),ret.addPropertyResult("rightColumns","RightColumns",properties.RightColumns!=null?cfn_parse.FromCloudFormation.getString(properties.RightColumns):void 0),ret.addPropertyResult("sampleSize","SampleSize",properties.SampleSize!=null?cfn_parse.FromCloudFormation.getString(properties.SampleSize):void 0),ret.addPropertyResult("sampleType","SampleType",properties.SampleType!=null?cfn_parse.FromCloudFormation.getString(properties.SampleType):void 0),ret.addPropertyResult("secondInput","SecondInput",properties.SecondInput!=null?cfn_parse.FromCloudFormation.getString(properties.SecondInput):void 0),ret.addPropertyResult("secondaryInputs","SecondaryInputs",properties.SecondaryInputs!=null?cfn_parse.FromCloudFormation.getArray(CfnRecipeSecondaryInputPropertyFromCloudFormation)(properties.SecondaryInputs):void 0),ret.addPropertyResult("sheetIndexes","SheetIndexes",properties.SheetIndexes!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.SheetIndexes):void 0),ret.addPropertyResult("sheetNames","SheetNames",properties.SheetNames!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SheetNames):void 0),ret.addPropertyResult("sourceColumn","SourceColumn",properties.SourceColumn!=null?cfn_parse.FromCloudFormation.getString(properties.SourceColumn):void 0),ret.addPropertyResult("sourceColumn1","SourceColumn1",properties.SourceColumn1!=null?cfn_parse.FromCloudFormation.getString(properties.SourceColumn1):void 0),ret.addPropertyResult("sourceColumn2","SourceColumn2",properties.SourceColumn2!=null?cfn_parse.FromCloudFormation.getString(properties.SourceColumn2):void 0),ret.addPropertyResult("sourceColumns","SourceColumns",properties.SourceColumns!=null?cfn_parse.FromCloudFormation.getString(properties.SourceColumns):void 0),ret.addPropertyResult("startColumnIndex","StartColumnIndex",properties.StartColumnIndex!=null?cfn_parse.FromCloudFormation.getString(properties.StartColumnIndex):void 0),ret.addPropertyResult("startPattern","StartPattern",properties.StartPattern!=null?cfn_parse.FromCloudFormation.getString(properties.StartPattern):void 0),ret.addPropertyResult("startPosition","StartPosition",properties.StartPosition!=null?cfn_parse.FromCloudFormation.getString(properties.StartPosition):void 0),ret.addPropertyResult("startValue","StartValue",properties.StartValue!=null?cfn_parse.FromCloudFormation.getString(properties.StartValue):void 0),ret.addPropertyResult("stemmingMode","StemmingMode",properties.StemmingMode!=null?cfn_parse.FromCloudFormation.getString(properties.StemmingMode):void 0),ret.addPropertyResult("stepCount","StepCount",properties.StepCount!=null?cfn_parse.FromCloudFormation.getString(properties.StepCount):void 0),ret.addPropertyResult("stepIndex","StepIndex",properties.StepIndex!=null?cfn_parse.FromCloudFormation.getString(properties.StepIndex):void 0),ret.addPropertyResult("stopWordsMode","StopWordsMode",properties.StopWordsMode!=null?cfn_parse.FromCloudFormation.getString(properties.StopWordsMode):void 0),ret.addPropertyResult("strategy","Strategy",properties.Strategy!=null?cfn_parse.FromCloudFormation.getString(properties.Strategy):void 0),ret.addPropertyResult("targetColumn","TargetColumn",properties.TargetColumn!=null?cfn_parse.FromCloudFormation.getString(properties.TargetColumn):void 0),ret.addPropertyResult("targetColumnNames","TargetColumnNames",properties.TargetColumnNames!=null?cfn_parse.FromCloudFormation.getString(properties.TargetColumnNames):void 0),ret.addPropertyResult("targetDateFormat","TargetDateFormat",properties.TargetDateFormat!=null?cfn_parse.FromCloudFormation.getString(properties.TargetDateFormat):void 0),ret.addPropertyResult("targetIndex","TargetIndex",properties.TargetIndex!=null?cfn_parse.FromCloudFormation.getString(properties.TargetIndex):void 0),ret.addPropertyResult("timeZone","TimeZone",properties.TimeZone!=null?cfn_parse.FromCloudFormation.getString(properties.TimeZone):void 0),ret.addPropertyResult("tokenizerPattern","TokenizerPattern",properties.TokenizerPattern!=null?cfn_parse.FromCloudFormation.getString(properties.TokenizerPattern):void 0),ret.addPropertyResult("trueString","TrueString",properties.TrueString!=null?cfn_parse.FromCloudFormation.getString(properties.TrueString):void 0),ret.addPropertyResult("udfLang","UdfLang",properties.UdfLang!=null?cfn_parse.FromCloudFormation.getString(properties.UdfLang):void 0),ret.addPropertyResult("units","Units",properties.Units!=null?cfn_parse.FromCloudFormation.getString(properties.Units):void 0),ret.addPropertyResult("unpivotColumn","UnpivotColumn",properties.UnpivotColumn!=null?cfn_parse.FromCloudFormation.getString(properties.UnpivotColumn):void 0),ret.addPropertyResult("upperBound","UpperBound",properties.UpperBound!=null?cfn_parse.FromCloudFormation.getString(properties.UpperBound):void 0),ret.addPropertyResult("useNewDataFrame","UseNewDataFrame",properties.UseNewDataFrame!=null?cfn_parse.FromCloudFormation.getString(properties.UseNewDataFrame):void 0),ret.addPropertyResult("value","Value",properties.Value!=null?cfn_parse.FromCloudFormation.getString(properties.Value):void 0),ret.addPropertyResult("value1","Value1",properties.Value1!=null?cfn_parse.FromCloudFormation.getString(properties.Value1):void 0),ret.addPropertyResult("value2","Value2",properties.Value2!=null?cfn_parse.FromCloudFormation.getString(properties.Value2):void 0),ret.addPropertyResult("valueColumn","ValueColumn",properties.ValueColumn!=null?cfn_parse.FromCloudFormation.getString(properties.ValueColumn):void 0),ret.addPropertyResult("viewFrame","ViewFrame",properties.ViewFrame!=null?cfn_parse.FromCloudFormation.getString(properties.ViewFrame):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_RecipeStepPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("action",cdk.requiredValidator)(properties.action)),errors.collect(cdk.propertyValidator("action",CfnRecipe_ActionPropertyValidator)(properties.action)),errors.collect(cdk.propertyValidator("conditionExpressions",cdk.listValidator(CfnRecipe_ConditionExpressionPropertyValidator))(properties.conditionExpressions)),errors.wrap('supplied properties not correct for "RecipeStepProperty"')}function cfnRecipeRecipeStepPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_RecipeStepPropertyValidator(properties).assertSuccess(),{Action:cfnRecipeActionPropertyToCloudFormation(properties.action),ConditionExpressions:cdk.listMapper(cfnRecipeConditionExpressionPropertyToCloudFormation)(properties.conditionExpressions)}):properties}function CfnRecipeRecipeStepPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("action","Action",CfnRecipeActionPropertyFromCloudFormation(properties.Action)),ret.addPropertyResult("conditionExpressions","ConditionExpressions",properties.ConditionExpressions!=null?cfn_parse.FromCloudFormation.getArray(CfnRecipeConditionExpressionPropertyFromCloudFormation)(properties.ConditionExpressions):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_S3LocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.wrap('supplied properties not correct for "S3LocationProperty"')}function cfnRecipeS3LocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_S3LocationPropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),Key:cdk.stringToCloudFormation(properties.key)}):properties}function CfnRecipeS3LocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRecipe_SecondaryInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dataCatalogInputDefinition",CfnRecipe_DataCatalogInputDefinitionPropertyValidator)(properties.dataCatalogInputDefinition)),errors.collect(cdk.propertyValidator("s3InputDefinition",CfnRecipe_S3LocationPropertyValidator)(properties.s3InputDefinition)),errors.wrap('supplied properties not correct for "SecondaryInputProperty"')}function cfnRecipeSecondaryInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRecipe_SecondaryInputPropertyValidator(properties).assertSuccess(),{DataCatalogInputDefinition:cfnRecipeDataCatalogInputDefinitionPropertyToCloudFormation(properties.dataCatalogInputDefinition),S3InputDefinition:cfnRecipeS3LocationPropertyToCloudFormation(properties.s3InputDefinition)}):properties}function CfnRecipeSecondaryInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dataCatalogInputDefinition","DataCatalogInputDefinition",properties.DataCatalogInputDefinition!=null?CfnRecipeDataCatalogInputDefinitionPropertyFromCloudFormation(properties.DataCatalogInputDefinition):void 0),ret.addPropertyResult("s3InputDefinition","S3InputDefinition",properties.S3InputDefinition!=null?CfnRecipeS3LocationPropertyFromCloudFormation(properties.S3InputDefinition):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRulesetPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("rules",cdk.requiredValidator)(properties.rules)),errors.collect(cdk.propertyValidator("rules",cdk.listValidator(CfnRuleset_RulePropertyValidator))(properties.rules)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("targetArn",cdk.requiredValidator)(properties.targetArn)),errors.collect(cdk.propertyValidator("targetArn",cdk.validateString)(properties.targetArn)),errors.wrap('supplied properties not correct for "CfnRulesetProps"')}function cfnRulesetPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRulesetPropsValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Rules:cdk.listMapper(cfnRulesetRulePropertyToCloudFormation)(properties.rules),TargetArn:cdk.stringToCloudFormation(properties.targetArn),Description:cdk.stringToCloudFormation(properties.description),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnRulesetPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("rules","Rules",cfn_parse.FromCloudFormation.getArray(CfnRulesetRulePropertyFromCloudFormation)(properties.Rules)),ret.addPropertyResult("targetArn","TargetArn",cfn_parse.FromCloudFormation.getString(properties.TargetArn)),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnRuleset extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnRuleset.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnRulesetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnRuleset),error}cdk.requireProperty(props,"name",this),cdk.requireProperty(props,"rules",this),cdk.requireProperty(props,"targetArn",this),this.name=props.name,this.rules=props.rules,this.targetArn=props.targetArn,this.description=props.description,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Ruleset",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnRulesetPropsFromCloudFormation(resourceProperties),ret=new CfnRuleset(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnRuleset.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{name:this.name,rules:this.rules,targetArn:this.targetArn,description:this.description,tags:this.tags.renderTags()}}renderProperties(props){return cfnRulesetPropsToCloudFormation(props)}}exports.CfnRuleset=CfnRuleset,_e=JSII_RTTI_SYMBOL_1,CfnRuleset[_e]={fqn:"aws-cdk-lib.aws_databrew.CfnRuleset",version:"2.42.0"},CfnRuleset.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Ruleset";function CfnRuleset_ColumnSelectorPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("regex",cdk.validateString)(properties.regex)),errors.wrap('supplied properties not correct for "ColumnSelectorProperty"')}function cfnRulesetColumnSelectorPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRuleset_ColumnSelectorPropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Regex:cdk.stringToCloudFormation(properties.regex)}):properties}function CfnRulesetColumnSelectorPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addPropertyResult("regex","Regex",properties.Regex!=null?cfn_parse.FromCloudFormation.getString(properties.Regex):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRuleset_RulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("checkExpression",cdk.requiredValidator)(properties.checkExpression)),errors.collect(cdk.propertyValidator("checkExpression",cdk.validateString)(properties.checkExpression)),errors.collect(cdk.propertyValidator("columnSelectors",cdk.listValidator(CfnRuleset_ColumnSelectorPropertyValidator))(properties.columnSelectors)),errors.collect(cdk.propertyValidator("disabled",cdk.validateBoolean)(properties.disabled)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("substitutionMap",cdk.listValidator(CfnRuleset_SubstitutionValuePropertyValidator))(properties.substitutionMap)),errors.collect(cdk.propertyValidator("threshold",CfnRuleset_ThresholdPropertyValidator)(properties.threshold)),errors.wrap('supplied properties not correct for "RuleProperty"')}function cfnRulesetRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRuleset_RulePropertyValidator(properties).assertSuccess(),{CheckExpression:cdk.stringToCloudFormation(properties.checkExpression),ColumnSelectors:cdk.listMapper(cfnRulesetColumnSelectorPropertyToCloudFormation)(properties.columnSelectors),Disabled:cdk.booleanToCloudFormation(properties.disabled),Name:cdk.stringToCloudFormation(properties.name),SubstitutionMap:cdk.listMapper(cfnRulesetSubstitutionValuePropertyToCloudFormation)(properties.substitutionMap),Threshold:cfnRulesetThresholdPropertyToCloudFormation(properties.threshold)}):properties}function CfnRulesetRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("checkExpression","CheckExpression",cfn_parse.FromCloudFormation.getString(properties.CheckExpression)),ret.addPropertyResult("columnSelectors","ColumnSelectors",properties.ColumnSelectors!=null?cfn_parse.FromCloudFormation.getArray(CfnRulesetColumnSelectorPropertyFromCloudFormation)(properties.ColumnSelectors):void 0),ret.addPropertyResult("disabled","Disabled",properties.Disabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Disabled):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("substitutionMap","SubstitutionMap",properties.SubstitutionMap!=null?cfn_parse.FromCloudFormation.getArray(CfnRulesetSubstitutionValuePropertyFromCloudFormation)(properties.SubstitutionMap):void 0),ret.addPropertyResult("threshold","Threshold",properties.Threshold!=null?CfnRulesetThresholdPropertyFromCloudFormation(properties.Threshold):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRuleset_SubstitutionValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.collect(cdk.propertyValidator("valueReference",cdk.requiredValidator)(properties.valueReference)),errors.collect(cdk.propertyValidator("valueReference",cdk.validateString)(properties.valueReference)),errors.wrap('supplied properties not correct for "SubstitutionValueProperty"')}function cfnRulesetSubstitutionValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRuleset_SubstitutionValuePropertyValidator(properties).assertSuccess(),{Value:cdk.stringToCloudFormation(properties.value),ValueReference:cdk.stringToCloudFormation(properties.valueReference)}):properties}function CfnRulesetSubstitutionValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("value","Value",cfn_parse.FromCloudFormation.getString(properties.Value)),ret.addPropertyResult("valueReference","ValueReference",cfn_parse.FromCloudFormation.getString(properties.ValueReference)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRuleset_ThresholdPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.collect(cdk.propertyValidator("unit",cdk.validateString)(properties.unit)),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",cdk.validateNumber)(properties.value)),errors.wrap('supplied properties not correct for "ThresholdProperty"')}function cfnRulesetThresholdPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRuleset_ThresholdPropertyValidator(properties).assertSuccess(),{Type:cdk.stringToCloudFormation(properties.type),Unit:cdk.stringToCloudFormation(properties.unit),Value:cdk.numberToCloudFormation(properties.value)}):properties}function CfnRulesetThresholdPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("type","Type",properties.Type!=null?cfn_parse.FromCloudFormation.getString(properties.Type):void 0),ret.addPropertyResult("unit","Unit",properties.Unit!=null?cfn_parse.FromCloudFormation.getString(properties.Unit):void 0),ret.addPropertyResult("value","Value",cfn_parse.FromCloudFormation.getNumber(properties.Value)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnSchedulePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("cronExpression",cdk.requiredValidator)(properties.cronExpression)),errors.collect(cdk.propertyValidator("cronExpression",cdk.validateString)(properties.cronExpression)),errors.collect(cdk.propertyValidator("jobNames",cdk.listValidator(cdk.validateString))(properties.jobNames)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnScheduleProps"')}function cfnSchedulePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnSchedulePropsValidator(properties).assertSuccess(),{CronExpression:cdk.stringToCloudFormation(properties.cronExpression),Name:cdk.stringToCloudFormation(properties.name),JobNames:cdk.listMapper(cdk.stringToCloudFormation)(properties.jobNames),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnSchedulePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("cronExpression","CronExpression",cfn_parse.FromCloudFormation.getString(properties.CronExpression)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("jobNames","JobNames",properties.JobNames!=null?cfn_parse.FromCloudFormation.getStringArray(properties.JobNames):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnSchedule extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnSchedule.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_databrew_CfnScheduleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnSchedule),error}cdk.requireProperty(props,"cronExpression",this),cdk.requireProperty(props,"name",this),this.cronExpression=props.cronExpression,this.name=props.name,this.jobNames=props.jobNames,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::DataBrew::Schedule",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnSchedulePropsFromCloudFormation(resourceProperties),ret=new CfnSchedule(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnSchedule.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{cronExpression:this.cronExpression,name:this.name,jobNames:this.jobNames,tags:this.tags.renderTags()}}renderProperties(props){return cfnSchedulePropsToCloudFormation(props)}}exports.CfnSchedule=CfnSchedule,_f=JSII_RTTI_SYMBOL_1,CfnSchedule[_f]={fqn:"aws-cdk-lib.aws_databrew.CfnSchedule",version:"2.42.0"},CfnSchedule.CFN_RESOURCE_TYPE_NAME="AWS::DataBrew::Schedule";
//# sourceMappingURL=databrew.generated.js.map
