"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NatInstanceImage=exports.NatInstanceProvider=exports.NatProvider=exports.NatTrafficDirection=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),core_1=require("../../core"),connections_1=require("./connections"),instance_1=require("./instance"),machine_image_1=require("./machine-image"),port_1=require("./port"),security_group_1=require("./security-group"),vpc_1=require("./vpc");var NatTrafficDirection;(function(NatTrafficDirection2){NatTrafficDirection2.OUTBOUND_ONLY="OUTBOUND_ONLY",NatTrafficDirection2.INBOUND_AND_OUTBOUND="INBOUND_AND_OUTBOUND",NatTrafficDirection2.NONE="NONE"})(NatTrafficDirection=exports.NatTrafficDirection||(exports.NatTrafficDirection={}));class NatProvider{static gateway(props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NatGatewayProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.gateway),error}return new NatGatewayProvider(props)}static instance(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NatInstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.instance),error}return new NatInstanceProvider(props)}}exports.NatProvider=NatProvider,_a=JSII_RTTI_SYMBOL_1,NatProvider[_a]={fqn:"aws-cdk-lib.aws_ec2.NatProvider",version:"2.42.0"};class NatGatewayProvider extends NatProvider{constructor(props={}){super(),this.props=props,this.gateways=new PrefSet}configureNat(options){if(this.props.eipAllocationIds!=null&&!core_1.Token.isUnresolved(this.props.eipAllocationIds)&&this.props.eipAllocationIds.length<options.natSubnets.length)throw new Error(`Not enough NAT gateway EIP allocation IDs (${this.props.eipAllocationIds.length} provided) for the requested subnet count (${options.natSubnets.length} needed).`);let i=0;for(const sub of options.natSubnets){const eipAllocationId=this.props.eipAllocationIds?pickN(i,this.props.eipAllocationIds):void 0,gateway=sub.addNatGateway(eipAllocationId);this.gateways.add(sub.availabilityZone,gateway.ref),i++}for(const sub of options.privateSubnets)this.configureSubnet(sub)}configureSubnet(subnet){const az=subnet.availabilityZone,gatewayId=this.gateways.pick(az);subnet.addRoute("DefaultRoute",{routerType:vpc_1.RouterType.NAT_GATEWAY,routerId:gatewayId,enablesInternetConnectivity:!0})}get configuredGateways(){return this.gateways.values().map(x=>({az:x[0],gatewayId:x[1]}))}}class NatInstanceProvider extends NatProvider{constructor(props){super(),this.props=props,this.gateways=new PrefSet;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_NatInstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NatInstanceProvider),error}if(props.defaultAllowedTraffic!==void 0&&props.allowAllTraffic!==void 0)throw new Error("Can not specify both of 'defaultAllowedTraffic' and 'defaultAllowedTraffic'; prefer 'defaultAllowedTraffic'")}configureNat(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ConfigureNatOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureNat),error}const defaultDirection=this.props.defaultAllowedTraffic??(this.props.allowAllTraffic??!0?NatTrafficDirection.INBOUND_AND_OUTBOUND:NatTrafficDirection.OUTBOUND_ONLY),machineImage=this.props.machineImage||new NatInstanceImage;this._securityGroup=this.props.securityGroup??new security_group_1.SecurityGroup(options.vpc,"NatSecurityGroup",{vpc:options.vpc,description:"Security Group for NAT instances",allowAllOutbound:isOutboundAllowed(defaultDirection)}),this._connections=new connections_1.Connections({securityGroups:[this._securityGroup]}),isInboundAllowed(defaultDirection)&&this.connections.allowFromAnyIpv4(port_1.Port.allTraffic());const role=new iam.Role(options.vpc,"NatRole",{assumedBy:new iam.ServicePrincipal("ec2.amazonaws.com")});for(const sub of options.natSubnets){const natInstance=new instance_1.Instance(sub,"NatInstance",{instanceType:this.props.instanceType,machineImage,sourceDestCheck:!1,vpc:options.vpc,vpcSubnets:{subnets:[sub]},securityGroup:this._securityGroup,role,keyName:this.props.keyName});this.gateways.add(sub.availabilityZone,natInstance)}for(const sub of options.privateSubnets)this.configureSubnet(sub)}get securityGroup(){if(!this._securityGroup)throw new Error("Pass the NatInstanceProvider to a Vpc before accessing 'securityGroup'");return this._securityGroup}get connections(){if(!this._connections)throw new Error("Pass the NatInstanceProvider to a Vpc before accessing 'connections'");return this._connections}get configuredGateways(){return this.gateways.values().map(x=>({az:x[0],gatewayId:x[1].instanceId}))}configureSubnet(subnet){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_PrivateSubnet(subnet)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureSubnet),error}const az=subnet.availabilityZone,gatewayId=this.gateways.pick(az).instanceId;subnet.addRoute("DefaultRoute",{routerType:vpc_1.RouterType.INSTANCE,routerId:gatewayId,enablesInternetConnectivity:!0})}}exports.NatInstanceProvider=NatInstanceProvider,_b=JSII_RTTI_SYMBOL_1,NatInstanceProvider[_b]={fqn:"aws-cdk-lib.aws_ec2.NatInstanceProvider",version:"2.42.0"};class PrefSet{constructor(){this.map={},this.vals=new Array,this.next=0}add(pref,value){this.map[pref]=value,this.vals.push([pref,value])}pick(pref){if(this.vals.length===0)throw new Error("Cannot pick, set is empty");return pref in this.map?this.map[pref]:this.vals[this.next++%this.vals.length][1]}values(){return this.vals}}class NatInstanceImage extends machine_image_1.LookupMachineImage{constructor(){super({name:"amzn-ami-vpc-nat-*",owners:["amazon"]})}}exports.NatInstanceImage=NatInstanceImage,_c=JSII_RTTI_SYMBOL_1,NatInstanceImage[_c]={fqn:"aws-cdk-lib.aws_ec2.NatInstanceImage",version:"2.42.0"};function isOutboundAllowed(direction){return direction===NatTrafficDirection.INBOUND_AND_OUTBOUND||direction===NatTrafficDirection.OUTBOUND_ONLY}function isInboundAllowed(direction){return direction===NatTrafficDirection.INBOUND_AND_OUTBOUND}function pickN(i,xs){if(core_1.Token.isUnresolved(xs))return core_1.Fn.select(i,xs);if(i>=xs.length)throw new Error(`Cannot get element ${i} from ${xs}`);return xs[i]}
//# sourceMappingURL=nat.js.map
