"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SubnetFilter=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),network_util_1=require("./network-util");class SubnetFilter{static byIds(subnetIds){return new SubnetIdSubnetFilter(subnetIds)}static availabilityZones(availabilityZones){return new AvailabilityZoneSubnetFilter(availabilityZones)}static onePerAz(){return new OnePerAZSubnetFilter}static containsIpAddresses(ipv4addrs){return new ContainsIpAddressesSubnetFilter(ipv4addrs)}static byCidrMask(mask){return new CidrMaskSubnetFilter(mask)}selectSubnets(_subnets){throw new Error("Cannot select subnets with an abstract SubnetFilter. `selectSubnets` needs to be implmemented.")}}exports.SubnetFilter=SubnetFilter,_a=JSII_RTTI_SYMBOL_1,SubnetFilter[_a]={fqn:"aws-cdk-lib.aws_ec2.SubnetFilter",version:"2.42.0"};class AvailabilityZoneSubnetFilter extends SubnetFilter{constructor(availabilityZones){super(),this.availabilityZones=availabilityZones}selectSubnets(subnets){return subnets.filter(s=>this.availabilityZones.includes(s.availabilityZone))}}class OnePerAZSubnetFilter extends SubnetFilter{constructor(){super()}selectSubnets(subnets){return this.retainOnePerAz(subnets)}retainOnePerAz(subnets){const azsSeen=new Set;return subnets.filter(subnet=>azsSeen.has(subnet.availabilityZone)?!1:(azsSeen.add(subnet.availabilityZone),!0))}}class ContainsIpAddressesSubnetFilter extends SubnetFilter{constructor(ipAddresses){super(),this.ipAddresses=ipAddresses}selectSubnets(subnets){return this.retainByIp(subnets,this.ipAddresses)}retainByIp(subnets,ips){const cidrBlockObjs=ips.map(ip=>{const ipNum=network_util_1.NetworkUtils.ipToNum(ip);return new network_util_1.CidrBlock(ipNum,32)});return subnets.filter(s=>{const subnetCidrBlock=new network_util_1.CidrBlock(s.ipv4CidrBlock);return cidrBlockObjs.some(cidr=>subnetCidrBlock.containsCidr(cidr))})}}class SubnetIdSubnetFilter extends SubnetFilter{constructor(subnetIds){super(),this.subnetIds=subnetIds}selectSubnets(subnets){return subnets.filter(subnet=>this.subnetIds.includes(subnet.subnetId))}}class CidrMaskSubnetFilter extends SubnetFilter{constructor(mask){super(),this.mask=mask}selectSubnets(subnets){return subnets.filter(subnet=>new network_util_1.CidrBlock(subnet.ipv4CidrBlock).mask===this.mask)}}
//# sourceMappingURL=subnet.js.map
