"use strict";var _a,_b,_c,_d,_e,_f;Object.defineProperty(exports,"__esModule",{value:!0}),exports.InterfaceVpcEndpoint=exports.InterfaceVpcEndpointAwsService=exports.InterfaceVpcEndpointService=exports.GatewayVpcEndpoint=exports.GatewayVpcEndpointAwsService=exports.VpcEndpointType=exports.VpcEndpoint=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),cxschema=require("../../cloud-assembly-schema"),core_1=require("../../core"),connections_1=require("./connections"),ec2_generated_1=require("./ec2.generated"),peer_1=require("./peer"),port_1=require("./port"),security_group_1=require("./security-group"),util_1=require("./util");class VpcEndpoint extends core_1.Resource{addToPolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToPolicy),error}if(!statement.hasPrincipal)throw new Error("Statement must have a `Principal`.");this.policyDocument||(this.policyDocument=new iam.PolicyDocument),this.policyDocument.addStatements(statement)}}exports.VpcEndpoint=VpcEndpoint,_a=JSII_RTTI_SYMBOL_1,VpcEndpoint[_a]={fqn:"aws-cdk-lib.aws_ec2.VpcEndpoint",version:"2.42.0"};var VpcEndpointType;(function(VpcEndpointType2){VpcEndpointType2.INTERFACE="Interface",VpcEndpointType2.GATEWAY="Gateway"})(VpcEndpointType=exports.VpcEndpointType||(exports.VpcEndpointType={}));class GatewayVpcEndpointAwsService{constructor(name,prefix){this.name=`${prefix||"com.amazonaws"}.${core_1.Aws.REGION}.${name}`}}exports.GatewayVpcEndpointAwsService=GatewayVpcEndpointAwsService,_b=JSII_RTTI_SYMBOL_1,GatewayVpcEndpointAwsService[_b]={fqn:"aws-cdk-lib.aws_ec2.GatewayVpcEndpointAwsService",version:"2.42.0"},GatewayVpcEndpointAwsService.DYNAMODB=new GatewayVpcEndpointAwsService("dynamodb"),GatewayVpcEndpointAwsService.S3=new GatewayVpcEndpointAwsService("s3");class GatewayVpcEndpoint extends VpcEndpoint{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_GatewayVpcEndpointProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,GatewayVpcEndpoint),error}const subnets=props.subnets?util_1.flatten(props.subnets.map(s=>props.vpc.selectSubnets(s).subnets)):[...props.vpc.privateSubnets,...props.vpc.publicSubnets,...props.vpc.isolatedSubnets],routeTableIds=util_1.allRouteTableIds(subnets);if(routeTableIds.length===0)throw new Error("Can't add a gateway endpoint to VPC; route table IDs are not available");const endpoint=new ec2_generated_1.CfnVPCEndpoint(this,"Resource",{policyDocument:core_1.Lazy.any({produce:()=>this.policyDocument}),routeTableIds,serviceName:props.service.name,vpcEndpointType:VpcEndpointType.GATEWAY,vpcId:props.vpc.vpcId});this.vpcEndpointId=endpoint.ref,this.vpcEndpointCreationTimestamp=endpoint.attrCreationTimestamp,this.vpcEndpointDnsEntries=endpoint.attrDnsEntries,this.vpcEndpointNetworkInterfaceIds=endpoint.attrNetworkInterfaceIds}static fromGatewayVpcEndpointId(scope,id,gatewayVpcEndpointId){class Import extends VpcEndpoint{constructor(){super(...arguments),this.vpcEndpointId=gatewayVpcEndpointId}}return new Import(scope,id)}}exports.GatewayVpcEndpoint=GatewayVpcEndpoint,_c=JSII_RTTI_SYMBOL_1,GatewayVpcEndpoint[_c]={fqn:"aws-cdk-lib.aws_ec2.GatewayVpcEndpoint",version:"2.42.0"};class InterfaceVpcEndpointService{constructor(name,port){this.privateDnsDefault=!1,this.name=name,this.port=port||443}}exports.InterfaceVpcEndpointService=InterfaceVpcEndpointService,_d=JSII_RTTI_SYMBOL_1,InterfaceVpcEndpointService[_d]={fqn:"aws-cdk-lib.aws_ec2.InterfaceVpcEndpointService",version:"2.42.0"};class InterfaceVpcEndpointAwsService{constructor(name,prefix,port){this.privateDnsDefault=!0;const region=core_1.Lazy.uncachedString({produce:context=>core_1.Stack.of(context.scope).region}),defaultEndpointPrefix=core_1.Lazy.uncachedString({produce:context=>{const regionName=core_1.Stack.of(context.scope).region;return this.getDefaultEndpointPrefix(name,regionName)}}),defaultEndpointSuffix=core_1.Lazy.uncachedString({produce:context=>{const regionName=core_1.Stack.of(context.scope).region;return this.getDefaultEndpointSuffix(name,regionName)}});this.name=`${prefix||defaultEndpointPrefix}.${region}.${name}${defaultEndpointSuffix}`,this.shortName=name,this.port=port||443}getDefaultEndpointPrefix(name,region){return{"cn-north-1":["application-autoscaling","athena","autoscaling","awsconnector","cassandra","cloudformation","codedeploy-commands-secure","databrew","dms","ebs","ec2","ecr.api","ecr.dkr","elasticbeanstalk","elasticfilesystem","elasticfilesystem-fips","execute-api","imagebuilder","iotsitewise.api","iotsitewise.data","kinesis-streams","lambda","license-manager","monitoring","rds","redshift","redshift-data","s3","sagemaker.api","sagemaker.featurestore-runtime","sagemaker.runtime","servicecatalog","sms","sqs","states","sts","synthetics","transcribe","transcribestreaming","transfer","xray"],"cn-northwest-1":["application-autoscaling","athena","autoscaling","awsconnector","cassandra","cloudformation","codedeploy-commands-secure","databrew","dms","ebs","ec2","ecr.api","ecr.dkr","elasticbeanstalk","elasticfilesystem","elasticfilesystem-fips","execute-api","imagebuilder","kinesis-streams","lambda","license-manager","monitoring","rds","redshift","redshift-data","s3","sagemaker.api","sagemaker.featurestore-runtime","sagemaker.runtime","servicecatalog","sms","sqs","states","sts","synthetics","transcribe","transcribestreaming","transfer","workspaces","xray"]}[region]?.includes(name)?"cn.com.amazonaws":"com.amazonaws"}getDefaultEndpointSuffix(name,region){return{"cn-north-1":["transcribe"],"cn-northwest-1":["transcribe"]}[region]?.includes(name)?".cn":""}}exports.InterfaceVpcEndpointAwsService=InterfaceVpcEndpointAwsService,_e=JSII_RTTI_SYMBOL_1,InterfaceVpcEndpointAwsService[_e]={fqn:"aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService",version:"2.42.0"},InterfaceVpcEndpointAwsService.SAGEMAKER_STUDIO=new InterfaceVpcEndpointAwsService("studio","aws.sagemaker"),InterfaceVpcEndpointAwsService.SAGEMAKER_NOTEBOOK=new InterfaceVpcEndpointAwsService("notebook","aws.sagemaker"),InterfaceVpcEndpointAwsService.ATHENA=new InterfaceVpcEndpointAwsService("athena"),InterfaceVpcEndpointAwsService.APPLICATION_AUTOSCALING=new InterfaceVpcEndpointAwsService("application-autoscaling"),InterfaceVpcEndpointAwsService.AUTOSCALING=new InterfaceVpcEndpointAwsService("autoscaling"),InterfaceVpcEndpointAwsService.AUTOSCALING_PLANS=new InterfaceVpcEndpointAwsService("autoscaling-plans"),InterfaceVpcEndpointAwsService.BATCH=new InterfaceVpcEndpointAwsService("batch"),InterfaceVpcEndpointAwsService.CLOUDFORMATION=new InterfaceVpcEndpointAwsService("cloudformation"),InterfaceVpcEndpointAwsService.CLOUDTRAIL=new InterfaceVpcEndpointAwsService("cloudtrail"),InterfaceVpcEndpointAwsService.CODEARTIFACT_API=new InterfaceVpcEndpointAwsService("codeartifact.api"),InterfaceVpcEndpointAwsService.CODEARTIFACT_REPOSITORIES=new InterfaceVpcEndpointAwsService("codeartifact.repositories"),InterfaceVpcEndpointAwsService.CODEBUILD=new InterfaceVpcEndpointAwsService("codebuild"),InterfaceVpcEndpointAwsService.CODEBUILD_FIPS=new InterfaceVpcEndpointAwsService("codebuild-fips"),InterfaceVpcEndpointAwsService.CODECOMMIT=new InterfaceVpcEndpointAwsService("codecommit"),InterfaceVpcEndpointAwsService.CODECOMMIT_FIPS=new InterfaceVpcEndpointAwsService("codecommit-fips"),InterfaceVpcEndpointAwsService.CODEGURU_PROFILER=new InterfaceVpcEndpointAwsService("codeguru-profiler"),InterfaceVpcEndpointAwsService.CODEGURU_REVIEWER=new InterfaceVpcEndpointAwsService("codeguru-reviewer"),InterfaceVpcEndpointAwsService.CODEPIPELINE=new InterfaceVpcEndpointAwsService("codepipeline"),InterfaceVpcEndpointAwsService.CONFIG=new InterfaceVpcEndpointAwsService("config"),InterfaceVpcEndpointAwsService.EC2=new InterfaceVpcEndpointAwsService("ec2"),InterfaceVpcEndpointAwsService.EC2_MESSAGES=new InterfaceVpcEndpointAwsService("ec2messages"),InterfaceVpcEndpointAwsService.ECR=new InterfaceVpcEndpointAwsService("ecr.api"),InterfaceVpcEndpointAwsService.ECR_DOCKER=new InterfaceVpcEndpointAwsService("ecr.dkr"),InterfaceVpcEndpointAwsService.ECS=new InterfaceVpcEndpointAwsService("ecs"),InterfaceVpcEndpointAwsService.ECS_AGENT=new InterfaceVpcEndpointAwsService("ecs-agent"),InterfaceVpcEndpointAwsService.ECS_TELEMETRY=new InterfaceVpcEndpointAwsService("ecs-telemetry"),InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM=new InterfaceVpcEndpointAwsService("elasticfilesystem"),InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM_FIPS=new InterfaceVpcEndpointAwsService("elasticfilesystem-fips"),InterfaceVpcEndpointAwsService.ELASTIC_INFERENCE_RUNTIME=new InterfaceVpcEndpointAwsService("elastic-inference.runtime"),InterfaceVpcEndpointAwsService.ELASTIC_LOAD_BALANCING=new InterfaceVpcEndpointAwsService("elasticloadbalancing"),InterfaceVpcEndpointAwsService.CLOUDWATCH_EVENTS=new InterfaceVpcEndpointAwsService("events"),InterfaceVpcEndpointAwsService.APIGATEWAY=new InterfaceVpcEndpointAwsService("execute-api"),InterfaceVpcEndpointAwsService.CODECOMMIT_GIT=new InterfaceVpcEndpointAwsService("git-codecommit"),InterfaceVpcEndpointAwsService.CODECOMMIT_GIT_FIPS=new InterfaceVpcEndpointAwsService("git-codecommit-fips"),InterfaceVpcEndpointAwsService.GLUE=new InterfaceVpcEndpointAwsService("glue"),InterfaceVpcEndpointAwsService.KEYSPACES=new InterfaceVpcEndpointAwsService("cassandra","",9142),InterfaceVpcEndpointAwsService.KINESIS_STREAMS=new InterfaceVpcEndpointAwsService("kinesis-streams"),InterfaceVpcEndpointAwsService.KINESIS_FIREHOSE=new InterfaceVpcEndpointAwsService("kinesis-firehose"),InterfaceVpcEndpointAwsService.KMS=new InterfaceVpcEndpointAwsService("kms"),InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS=new InterfaceVpcEndpointAwsService("logs"),InterfaceVpcEndpointAwsService.CLOUDWATCH=new InterfaceVpcEndpointAwsService("monitoring"),InterfaceVpcEndpointAwsService.RDS=new InterfaceVpcEndpointAwsService("rds"),InterfaceVpcEndpointAwsService.RDS_DATA=new InterfaceVpcEndpointAwsService("rds-data"),InterfaceVpcEndpointAwsService.S3=new InterfaceVpcEndpointAwsService("s3"),InterfaceVpcEndpointAwsService.SAGEMAKER_API=new InterfaceVpcEndpointAwsService("sagemaker.api"),InterfaceVpcEndpointAwsService.SAGEMAKER_RUNTIME=new InterfaceVpcEndpointAwsService("sagemaker.runtime"),InterfaceVpcEndpointAwsService.SAGEMAKER_RUNTIME_FIPS=new InterfaceVpcEndpointAwsService("sagemaker.runtime-fips"),InterfaceVpcEndpointAwsService.SECRETS_MANAGER=new InterfaceVpcEndpointAwsService("secretsmanager"),InterfaceVpcEndpointAwsService.SERVICE_CATALOG=new InterfaceVpcEndpointAwsService("servicecatalog"),InterfaceVpcEndpointAwsService.SNS=new InterfaceVpcEndpointAwsService("sns"),InterfaceVpcEndpointAwsService.SQS=new InterfaceVpcEndpointAwsService("sqs"),InterfaceVpcEndpointAwsService.SSM=new InterfaceVpcEndpointAwsService("ssm"),InterfaceVpcEndpointAwsService.SSM_MESSAGES=new InterfaceVpcEndpointAwsService("ssmmessages"),InterfaceVpcEndpointAwsService.STS=new InterfaceVpcEndpointAwsService("sts"),InterfaceVpcEndpointAwsService.TEXTRACT=new InterfaceVpcEndpointAwsService("textract"),InterfaceVpcEndpointAwsService.TEXTRACT_FIPS=new InterfaceVpcEndpointAwsService("textract-fips"),InterfaceVpcEndpointAwsService.TRANSFER=new InterfaceVpcEndpointAwsService("transfer.server"),InterfaceVpcEndpointAwsService.STORAGE_GATEWAY=new InterfaceVpcEndpointAwsService("storagegateway"),InterfaceVpcEndpointAwsService.REKOGNITION=new InterfaceVpcEndpointAwsService("rekognition"),InterfaceVpcEndpointAwsService.REKOGNITION_FIPS=new InterfaceVpcEndpointAwsService("rekognition-fips"),InterfaceVpcEndpointAwsService.STEP_FUNCTIONS=new InterfaceVpcEndpointAwsService("states"),InterfaceVpcEndpointAwsService.LAMBDA=new InterfaceVpcEndpointAwsService("lambda"),InterfaceVpcEndpointAwsService.TRANSCRIBE=new InterfaceVpcEndpointAwsService("transcribe"),InterfaceVpcEndpointAwsService.XRAY=new InterfaceVpcEndpointAwsService("xray");class InterfaceVpcEndpoint extends VpcEndpoint{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InterfaceVpcEndpointProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,InterfaceVpcEndpoint),error}const securityGroups=props.securityGroups||[new security_group_1.SecurityGroup(this,"SecurityGroup",{vpc:props.vpc})];this.securityGroupId=securityGroups[0].securityGroupId,this.connections=new connections_1.Connections({defaultPort:port_1.Port.tcp(props.service.port),securityGroups}),props.open!==!1&&this.connections.allowDefaultPortFrom(peer_1.Peer.ipv4(props.vpc.vpcCidrBlock));const subnetIds=this.endpointSubnets(props),endpoint=new ec2_generated_1.CfnVPCEndpoint(this,"Resource",{privateDnsEnabled:props.privateDnsEnabled??props.service.privateDnsDefault??!0,policyDocument:core_1.Lazy.any({produce:()=>this.policyDocument}),securityGroupIds:securityGroups.map(s=>s.securityGroupId),serviceName:props.service.name,vpcEndpointType:VpcEndpointType.INTERFACE,subnetIds,vpcId:props.vpc.vpcId});this.vpcEndpointId=endpoint.ref,this.vpcEndpointCreationTimestamp=endpoint.attrCreationTimestamp,this.vpcEndpointDnsEntries=endpoint.attrDnsEntries,this.vpcEndpointNetworkInterfaceIds=endpoint.attrNetworkInterfaceIds}static fromInterfaceVpcEndpointAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InterfaceVpcEndpointAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromInterfaceVpcEndpointAttributes),error}const securityGroups=attrs.securityGroupId?[security_group_1.SecurityGroup.fromSecurityGroupId(scope,"SecurityGroup",attrs.securityGroupId)]:attrs.securityGroups;class Import extends core_1.Resource{constructor(){super(...arguments),this.vpcEndpointId=attrs.vpcEndpointId,this.connections=new connections_1.Connections({defaultPort:port_1.Port.tcp(attrs.port),securityGroups})}}return new Import(scope,id)}endpointSubnets(props){const lookupSupportedAzs=props.lookupSupportedAzs??!1,subnetSelection=props.vpc.selectSubnets({...props.subnets,onePerAz:!0}),subnets=subnetSelection.subnets;if(!subnetSelection.isPendingLookup&&subnetSelection.subnets.length==0)throw new Error("Cannot create a VPC Endpoint with no subnets");if(!lookupSupportedAzs)return subnetSelection.subnetIds;const lookupServiceName=core_1.Token.isUnresolved(props.service.name)&&props.service instanceof InterfaceVpcEndpointAwsService?core_1.Stack.of(this).resolve(props.service.name):props.service.name;this.validateCanLookupSupportedAzs(subnets,lookupServiceName);const availableAZs=this.availableAvailabilityZones(lookupServiceName),filteredSubnets=subnets.filter(s=>availableAZs.includes(s.availabilityZone));if(filteredSubnets.length==0)throw new Error(`lookupSupportedAzs returned ${availableAZs} but subnets have AZs ${subnets.map(s=>s.availabilityZone)}`);return filteredSubnets.map(s=>s.subnetId)}validateCanLookupSupportedAzs(subnets,serviceName){const agnosticAcct=core_1.Token.isUnresolved(this.env.account),agnosticRegion=core_1.Token.isUnresolved(this.env.region),agnosticService=core_1.Token.isUnresolved(serviceName),agnosticSubnets=subnets.some(s=>core_1.Token.isUnresolved(s.availabilityZone)),agnosticSubnetList=core_1.Token.isUnresolved(subnets.map(s=>s.availabilityZone));if(agnosticAcct||agnosticRegion)throw new Error("Cannot look up VPC endpoint availability zones if account/region are not specified");if(agnosticService)throw new Error(`Cannot lookup AZs for a service name with a Token: ${serviceName}`);if(agnosticSubnets||agnosticSubnetList){const agnostic=subnets.filter(s=>core_1.Token.isUnresolved(s.availabilityZone));throw new Error(`lookupSupportedAzs cannot filter on subnets with Token AZs: ${agnostic}`)}}availableAvailabilityZones(serviceName){const availableAZs=core_1.ContextProvider.getValue(this,{provider:cxschema.ContextProvider.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER,dummyValue:this.stack.availabilityZones,props:{serviceName}}).value;if(!Array.isArray(availableAZs))throw new Error(`Discovered AZs for endpoint service ${serviceName} must be an array`);return availableAZs}}exports.InterfaceVpcEndpoint=InterfaceVpcEndpoint,_f=JSII_RTTI_SYMBOL_1,InterfaceVpcEndpoint[_f]={fqn:"aws-cdk-lib.aws_ec2.InterfaceVpcEndpoint",version:"2.42.0"};
//# sourceMappingURL=vpc-endpoint.js.map
