"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FlowLog=exports.FlowLogDestination=exports.FlowLogFileFormat=exports.FlowLogResourceType=exports.FlowLogDestinationType=exports.FlowLogTrafficType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),logs=require("../../aws-logs"),s3=require("../../aws-s3"),core_1=require("../../core"),cx_api_1=require("../../cx-api"),ec2_generated_1=require("./ec2.generated");var FlowLogTrafficType;(function(FlowLogTrafficType2){FlowLogTrafficType2.ACCEPT="ACCEPT",FlowLogTrafficType2.ALL="ALL",FlowLogTrafficType2.REJECT="REJECT"})(FlowLogTrafficType=exports.FlowLogTrafficType||(exports.FlowLogTrafficType={}));var FlowLogDestinationType;(function(FlowLogDestinationType2){FlowLogDestinationType2.CLOUD_WATCH_LOGS="cloud-watch-logs",FlowLogDestinationType2.S3="s3"})(FlowLogDestinationType=exports.FlowLogDestinationType||(exports.FlowLogDestinationType={}));class FlowLogResourceType{static fromSubnet(subnet){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISubnet(subnet)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSubnet),error}return{resourceType:"Subnet",resourceId:subnet.subnetId}}static fromVpc(vpc){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IVpc(vpc)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromVpc),error}return{resourceType:"VPC",resourceId:vpc.vpcId}}static fromNetworkInterfaceId(id){return{resourceType:"NetworkInterface",resourceId:id}}}exports.FlowLogResourceType=FlowLogResourceType,_a=JSII_RTTI_SYMBOL_1,FlowLogResourceType[_a]={fqn:"aws-cdk-lib.aws_ec2.FlowLogResourceType",version:"2.42.0"};var FlowLogFileFormat;(function(FlowLogFileFormat2){FlowLogFileFormat2.PLAIN_TEXT="plain-text",FlowLogFileFormat2.PARQUET="parquet"})(FlowLogFileFormat=exports.FlowLogFileFormat||(exports.FlowLogFileFormat={}));class FlowLogDestination{static toCloudWatchLogs(logGroup,iamRole){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_ILogGroup(logGroup),jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IRole(iamRole)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.toCloudWatchLogs),error}return new CloudWatchLogsDestination({logDestinationType:FlowLogDestinationType.CLOUD_WATCH_LOGS,logGroup,iamRole})}static toS3(bucket,keyPrefix,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_S3DestinationOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.toS3),error}return new S3Destination({logDestinationType:FlowLogDestinationType.S3,s3Bucket:bucket,keyPrefix,destinationOptions:options})}}exports.FlowLogDestination=FlowLogDestination,_b=JSII_RTTI_SYMBOL_1,FlowLogDestination[_b]={fqn:"aws-cdk-lib.aws_ec2.FlowLogDestination",version:"2.42.0"};class S3Destination extends FlowLogDestination{constructor(props){super(),this.props=props}bind(scope,_flowLog){let s3Bucket;if(this.props.s3Bucket===void 0?s3Bucket=new s3.Bucket(scope,"Bucket",{encryption:s3.BucketEncryption.UNENCRYPTED,removalPolicy:core_1.RemovalPolicy.RETAIN}):s3Bucket=this.props.s3Bucket,core_1.FeatureFlags.of(scope).isEnabled(cx_api_1.S3_CREATE_DEFAULT_LOGGING_POLICY)){const stack=core_1.Stack.of(scope);let keyPrefix=this.props.keyPrefix??"";keyPrefix&&!keyPrefix.endsWith("/")&&(keyPrefix=keyPrefix+"/");const prefix=this.props.destinationOptions?.hiveCompatiblePartitions?s3Bucket.arnForObjects(`${keyPrefix}AWSLogs/aws-account-id=${stack.account}/*`):s3Bucket.arnForObjects(`${keyPrefix}AWSLogs/${stack.account}/*`);s3Bucket.addToResourcePolicy(new iam.PolicyStatement({effect:iam.Effect.ALLOW,principals:[new iam.ServicePrincipal("delivery.logs.amazonaws.com")],resources:[prefix],actions:["s3:PutObject"],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control","aws:SourceAccount":stack.account},ArnLike:{"aws:SourceArn":stack.formatArn({service:"logs",resource:"*"})}}})),s3Bucket.addToResourcePolicy(new iam.PolicyStatement({effect:iam.Effect.ALLOW,principals:[new iam.ServicePrincipal("delivery.logs.amazonaws.com")],resources:[s3Bucket.bucketArn],actions:["s3:GetBucketAcl","s3:ListBucket"],conditions:{StringEquals:{"aws:SourceAccount":stack.account},ArnLike:{"aws:SourceArn":stack.formatArn({service:"logs",resource:"*"})}}}))}return{logDestinationType:FlowLogDestinationType.S3,s3Bucket,keyPrefix:this.props.keyPrefix,destinationOptions:this.props.destinationOptions?.fileFormat||this.props.destinationOptions?.perHourPartition||this.props.destinationOptions?.hiveCompatiblePartitions?{fileFormat:this.props.destinationOptions.fileFormat??FlowLogFileFormat.PLAIN_TEXT,perHourPartition:this.props.destinationOptions.perHourPartition??!1,hiveCompatiblePartitions:this.props.destinationOptions.hiveCompatiblePartitions??!1}:void 0}}}class CloudWatchLogsDestination extends FlowLogDestination{constructor(props){super(),this.props=props}bind(scope,_flowLog){let iamRole,logGroup;return this.props.iamRole===void 0?iamRole=new iam.Role(scope,"IAMRole",{roleName:core_1.PhysicalName.GENERATE_IF_NEEDED,assumedBy:new iam.ServicePrincipal("vpc-flow-logs.amazonaws.com")}):iamRole=this.props.iamRole,this.props.logGroup===void 0?logGroup=new logs.LogGroup(scope,"LogGroup"):logGroup=this.props.logGroup,iamRole.addToPrincipalPolicy(new iam.PolicyStatement({actions:["logs:CreateLogStream","logs:PutLogEvents","logs:DescribeLogStreams"],effect:iam.Effect.ALLOW,resources:[logGroup.logGroupArn]})),iamRole.addToPrincipalPolicy(new iam.PolicyStatement({actions:["iam:PassRole"],effect:iam.Effect.ALLOW,resources:[iamRole.roleArn]})),{logDestinationType:FlowLogDestinationType.CLOUD_WATCH_LOGS,logGroup,iamRole}}}class FlowLogBase extends core_1.Resource{}class FlowLog extends FlowLogBase{constructor(scope,id,props){super(scope,id,{physicalName:props.flowLogName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_FlowLogProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,FlowLog),error}const destinationConfig=(props.destination||FlowLogDestination.toCloudWatchLogs()).bind(this,this);this.logGroup=destinationConfig.logGroup,this.bucket=destinationConfig.s3Bucket,this.iamRole=destinationConfig.iamRole,this.keyPrefix=destinationConfig.keyPrefix;let logDestination;this.bucket&&(logDestination=this.keyPrefix?this.bucket.arnForObjects(this.keyPrefix):this.bucket.bucketArn);const flowLog=new ec2_generated_1.CfnFlowLog(this,"FlowLog",{destinationOptions:destinationConfig.destinationOptions,deliverLogsPermissionArn:this.iamRole?this.iamRole.roleArn:void 0,logDestinationType:destinationConfig.logDestinationType,logGroupName:this.logGroup?this.logGroup.logGroupName:void 0,resourceId:props.resourceType.resourceId,resourceType:props.resourceType.resourceType,trafficType:props.trafficType?props.trafficType:FlowLogTrafficType.ALL,logDestination});this.flowLogId=flowLog.ref,this.node.defaultChild=flowLog}static fromFlowLogId(scope,id,flowLogId){class Import extends FlowLogBase{constructor(){super(...arguments),this.flowLogId=flowLogId}}return new Import(scope,id)}}exports.FlowLog=FlowLog,_c=JSII_RTTI_SYMBOL_1,FlowLog[_c]={fqn:"aws-cdk-lib.aws_ec2.FlowLog",version:"2.42.0"};
//# sourceMappingURL=vpc-flow-logs.js.map
