"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.PropagatedTagSource=exports.DeploymentControllerType=exports.LaunchType=exports.BaseService=exports.ListenerConfig=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),appscaling=require("../../../aws-applicationautoscaling"),cloudwatch=require("../../../aws-cloudwatch"),ec2=require("../../../aws-ec2"),elbv2=require("../../../aws-elasticloadbalancingv2"),iam=require("../../../aws-iam"),cloudmap=require("../../../aws-servicediscovery"),core_1=require("../../../core"),task_definition_1=require("../base/task-definition"),cluster_1=require("../cluster"),ecs_generated_1=require("../ecs.generated"),scalable_task_count_1=require("./scalable-task-count");class ListenerConfig{static applicationListener(listener,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListener(listener),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationTargetsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.applicationListener),error}return new ApplicationListenerConfig(listener,props)}static networkListener(listener,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_NetworkListener(listener),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_AddNetworkTargetsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.networkListener),error}return new NetworkListenerConfig(listener,props)}}exports.ListenerConfig=ListenerConfig,_a=JSII_RTTI_SYMBOL_1,ListenerConfig[_a]={fqn:"aws-cdk-lib.aws_ecs.ListenerConfig",version:"2.42.0"};class ApplicationListenerConfig extends ListenerConfig{constructor(listener,props){super(),this.listener=listener,this.props=props}addTargets(id,target,service){const props=this.props||{},protocol=props.protocol,port=props.port??(protocol===elbv2.ApplicationProtocol.HTTPS?443:80);this.listener.addTargets(id,{...props,targets:[service.loadBalancerTarget({...target})],port})}}class NetworkListenerConfig extends ListenerConfig{constructor(listener,props){super(),this.listener=listener,this.props=props}addTargets(id,target,service){const port=this.props?.port??80;this.listener.addTargets(id,{...this.props,targets:[service.loadBalancerTarget({...target})],port})}}class BaseService extends core_1.Resource{constructor(scope,id,props,additionalProps,taskDefinition){super(scope,id,{physicalName:props.serviceName}),this.connections=new ec2.Connections,this.loadBalancers=new Array,this.serviceRegistries=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_BaseServiceProps(props),jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_TaskDefinition(taskDefinition)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BaseService),error}if(props.propagateTags&&props.propagateTaskTagsFrom)throw new Error("You can only specify either propagateTags or propagateTaskTagsFrom. Alternatively, you can leave both blank");this.taskDefinition=taskDefinition;const launchType=props.deploymentController?.type===DeploymentControllerType.EXTERNAL||props.capacityProviderStrategies!==void 0?void 0:props.launchType,propagateTagsFromSource=props.propagateTaskTagsFrom??props.propagateTags??PropagatedTagSource.NONE;if(this.resource=new ecs_generated_1.CfnService(this,"Service",{desiredCount:props.desiredCount,serviceName:this.physicalName,loadBalancers:core_1.Lazy.any({produce:()=>this.loadBalancers},{omitEmptyArray:!0}),deploymentConfiguration:{maximumPercent:props.maxHealthyPercent||200,minimumHealthyPercent:props.minHealthyPercent===void 0?50:props.minHealthyPercent,deploymentCircuitBreaker:props.circuitBreaker?{enable:!0,rollback:props.circuitBreaker.rollback??!1}:void 0},propagateTags:propagateTagsFromSource===PropagatedTagSource.NONE?void 0:props.propagateTags,enableEcsManagedTags:props.enableECSManagedTags??!1,deploymentController:props.circuitBreaker?{type:DeploymentControllerType.ECS}:props.deploymentController,launchType,enableExecuteCommand:props.enableExecuteCommand,capacityProviderStrategy:props.capacityProviderStrategies,healthCheckGracePeriodSeconds:this.evaluateHealthGracePeriod(props.healthCheckGracePeriod),networkConfiguration:core_1.Lazy.any({produce:()=>this.networkConfiguration},{omitEmptyArray:!0}),serviceRegistries:core_1.Lazy.any({produce:()=>this.serviceRegistries},{omitEmptyArray:!0}),...additionalProps}),props.deploymentController?.type===DeploymentControllerType.EXTERNAL&&core_1.Annotations.of(this).addWarning("taskDefinition and launchType are blanked out when using external deployment controller."),this.serviceArn=this.getResourceArnAttribute(this.resource.ref,{service:"ecs",resource:"service",resourceName:`${props.cluster.clusterName}/${this.physicalName}`}),this.serviceName=this.getResourceNameAttribute(this.resource.attrName),this.cluster=props.cluster,props.cloudMapOptions&&this.enableCloudMap(props.cloudMapOptions),props.enableExecuteCommand){this.enableExecuteCommand();const logging=this.cluster.executeCommandConfiguration?.logging??cluster_1.ExecuteCommandLogging.DEFAULT;this.cluster.executeCommandConfiguration?.kmsKey&&this.enableExecuteCommandEncryption(logging),logging!==cluster_1.ExecuteCommandLogging.NONE&&this.executeCommandLogConfiguration()}this.node.defaultChild=this.resource}static fromServiceArnWithCluster(scope,id,serviceArn){const arn=core_1.Stack.of(scope).splitArn(serviceArn,core_1.ArnFormat.SLASH_RESOURCE_NAME),resourceName=arn.resourceName;if(!resourceName)throw new Error("Missing resource Name from service ARN: ${serviceArn}");const resourceNameParts=resourceName.split("/");if(resourceNameParts.length!==2)throw new Error(`resource name ${resourceName} from service ARN: ${serviceArn} is not using the ARN cluster format`);const clusterName=resourceNameParts[0],serviceName=resourceNameParts[1],clusterArn=core_1.Stack.of(scope).formatArn({partition:arn.partition,region:arn.region,account:arn.account,service:"ecs",resource:"cluster",resourceName:clusterName}),cluster=cluster_1.Cluster.fromClusterArn(scope,`${id}Cluster`,clusterArn);class Import extends core_1.Resource{constructor(){super(...arguments),this.serviceArn=serviceArn,this.serviceName=serviceName,this.cluster=cluster}}return new Import(scope,id,{environmentFromArn:serviceArn})}get cloudMapService(){return this.cloudmapService}executeCommandLogConfiguration(){const logConfiguration=this.cluster.executeCommandConfiguration?.logConfiguration;this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["logs:DescribeLogGroups"],resources:["*"]}));const logGroupArn=logConfiguration?.cloudWatchLogGroup?`arn:${this.stack.partition}:logs:${this.env.region}:${this.env.account}:log-group:${logConfiguration.cloudWatchLogGroup.logGroupName}:*`:"*";this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["logs:CreateLogStream","logs:DescribeLogStreams","logs:PutLogEvents"],resources:[logGroupArn]})),logConfiguration?.s3Bucket?.bucketName&&(this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["s3:GetBucketLocation"],resources:["*"]})),this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["s3:PutObject"],resources:[`arn:${this.stack.partition}:s3:::${logConfiguration.s3Bucket.bucketName}/*`]})),logConfiguration.s3EncryptionEnabled&&this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["s3:GetEncryptionConfiguration"],resources:[`arn:${this.stack.partition}:s3:::${logConfiguration.s3Bucket.bucketName}`]})))}enableExecuteCommandEncryption(logging){this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["kms:Decrypt","kms:GenerateDataKey"],resources:[`${this.cluster.executeCommandConfiguration?.kmsKey?.keyArn}`]})),this.cluster.executeCommandConfiguration?.kmsKey?.addToResourcePolicy(new iam.PolicyStatement({actions:["kms:*"],resources:["*"],principals:[new iam.ArnPrincipal(`arn:${this.stack.partition}:iam::${this.env.account}:root`)]})),(logging===cluster_1.ExecuteCommandLogging.DEFAULT||this.cluster.executeCommandConfiguration?.logConfiguration?.cloudWatchEncryptionEnabled)&&this.cluster.executeCommandConfiguration?.kmsKey?.addToResourcePolicy(new iam.PolicyStatement({actions:["kms:Encrypt*","kms:Decrypt*","kms:ReEncrypt*","kms:GenerateDataKey*","kms:Describe*"],resources:["*"],principals:[new iam.ServicePrincipal(`logs.${this.env.region}.amazonaws.com`)],conditions:{ArnLike:{"kms:EncryptionContext:aws:logs:arn":`arn:${this.stack.partition}:logs:${this.env.region}:${this.env.account}:*`}}}))}attachToApplicationTargetGroup(targetGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_IApplicationTargetGroup(targetGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToApplicationTargetGroup),error}return this.defaultLoadBalancerTarget.attachToApplicationTargetGroup(targetGroup)}attachToClassicLB(loadBalancer){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancing_LoadBalancer(loadBalancer)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToClassicLB),error}return this.defaultLoadBalancerTarget.attachToClassicLB(loadBalancer)}loadBalancerTarget(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_LoadBalancerTargetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.loadBalancerTarget),error}const self=this,target=this.taskDefinition._validateTarget(options),connections=self.connections;return{attachToApplicationTargetGroup(targetGroup){return targetGroup.registerConnectable(self,self.taskDefinition._portRangeFromPortMapping(target.portMapping)),self.attachToELBv2(targetGroup,target.containerName,target.portMapping.containerPort)},attachToNetworkTargetGroup(targetGroup){return self.attachToELBv2(targetGroup,target.containerName,target.portMapping.containerPort)},connections,attachToClassicLB(loadBalancer){return self.attachToELB(loadBalancer,target.containerName,target.portMapping.containerPort)}}}registerLoadBalancerTargets(...targets){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_EcsTarget(targets)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerLoadBalancerTargets),error}for(const target of targets)target.listener.addTargets(target.newTargetGroupId,{containerName:target.containerName,containerPort:target.containerPort,protocol:target.protocol},this)}attachToNetworkTargetGroup(targetGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_INetworkTargetGroup(targetGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToNetworkTargetGroup),error}return this.defaultLoadBalancerTarget.attachToNetworkTargetGroup(targetGroup)}autoScaleTaskCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_applicationautoscaling_EnableScalingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.autoScaleTaskCount),error}if(this.scalableTaskCount)throw new Error("AutoScaling of task count already enabled for this service");return this.scalableTaskCount=new scalable_task_count_1.ScalableTaskCount(this,"TaskCount",{serviceNamespace:appscaling.ServiceNamespace.ECS,resourceId:`service/${this.cluster.clusterName}/${this.serviceName}`,dimension:"ecs:service:DesiredCount",role:this.makeAutoScalingRole(),...props})}enableCloudMap(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_CloudMapOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.enableCloudMap),error}const sdNamespace=options.cloudMapNamespace??this.cluster.defaultCloudMapNamespace;if(sdNamespace===void 0)throw new Error("Cannot enable service discovery if a Cloudmap Namespace has not been created in the cluster.");const networkMode=this.taskDefinition.networkMode;if(networkMode===task_definition_1.NetworkMode.NONE)throw new Error("Cannot use a service discovery if NetworkMode is None. Use Bridge, Host or AwsVpc instead.");let dnsRecordType=options.dnsRecordType;if((networkMode===task_definition_1.NetworkMode.BRIDGE||networkMode===task_definition_1.NetworkMode.HOST)&&(dnsRecordType===void 0&&(dnsRecordType=cloudmap.DnsRecordType.SRV),dnsRecordType!==cloudmap.DnsRecordType.SRV))throw new Error("SRV records must be used when network mode is Bridge or Host.");networkMode===task_definition_1.NetworkMode.AWS_VPC&&dnsRecordType===void 0&&(dnsRecordType=cloudmap.DnsRecordType.A);const{containerName,containerPort}=determineContainerNameAndPort({taskDefinition:this.taskDefinition,dnsRecordType,container:options.container,containerPort:options.containerPort}),cloudmapService=new cloudmap.Service(this,"CloudmapService",{namespace:sdNamespace,name:options.name,dnsRecordType,customHealthCheck:{failureThreshold:options.failureThreshold||1},dnsTtl:options.dnsTtl}),serviceArn=cloudmapService.serviceArn;return this.addServiceRegistry({arn:serviceArn,containerName,containerPort}),this.cloudmapService=cloudmapService,cloudmapService}associateCloudMapService(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AssociateCloudMapServiceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.associateCloudMapService),error}const service=options.service,{containerName,containerPort}=determineContainerNameAndPort({taskDefinition:this.taskDefinition,dnsRecordType:service.dnsRecordType,container:options.container,containerPort:options.containerPort});this.addServiceRegistry({arn:service.serviceArn,containerName,containerPort})}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/ECS",metricName,dimensionsMap:{ClusterName:this.cluster.clusterName,ServiceName:this.serviceName},...props}).attachTo(this)}metricMemoryUtilization(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricMemoryUtilization),error}return this.metric("MemoryUtilization",props)}metricCpuUtilization(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCpuUtilization),error}return this.metric("CPUUtilization",props)}configureAwsVpcNetworking(vpc,assignPublicIp,vpcSubnets,securityGroup){vpcSubnets===void 0&&(vpcSubnets=assignPublicIp?{subnetType:ec2.SubnetType.PUBLIC}:{}),securityGroup===void 0&&(securityGroup=new ec2.SecurityGroup(this,"SecurityGroup",{vpc})),this.connections.addSecurityGroup(securityGroup),this.networkConfiguration={awsvpcConfiguration:{assignPublicIp:assignPublicIp?"ENABLED":"DISABLED",subnets:vpc.selectSubnets(vpcSubnets).subnetIds,securityGroups:core_1.Lazy.list({produce:()=>[securityGroup.securityGroupId]})}}}configureAwsVpcNetworkingWithSecurityGroups(vpc,assignPublicIp,vpcSubnets,securityGroups){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IVpc(vpc),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_SubnetSelection(vpcSubnets)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureAwsVpcNetworkingWithSecurityGroups),error}vpcSubnets===void 0&&(vpcSubnets=assignPublicIp?{subnetType:ec2.SubnetType.PUBLIC}:{}),(securityGroups===void 0||securityGroups.length===0)&&(securityGroups=[new ec2.SecurityGroup(this,"SecurityGroup",{vpc})]),securityGroups.forEach(sg=>{this.connections.addSecurityGroup(sg)},this),this.networkConfiguration={awsvpcConfiguration:{assignPublicIp:assignPublicIp?"ENABLED":"DISABLED",subnets:vpc.selectSubnets(vpcSubnets).subnetIds,securityGroups:securityGroups.map(sg=>sg.securityGroupId)}}}renderServiceRegistry(registry){return{registryArn:registry.arn,containerName:registry.containerName,containerPort:registry.containerPort}}attachToELB(loadBalancer,containerName,containerPort){if(this.taskDefinition.networkMode===task_definition_1.NetworkMode.AWS_VPC)throw new Error("Cannot use a Classic Load Balancer if NetworkMode is AwsVpc. Use Host or Bridge instead.");if(this.taskDefinition.networkMode===task_definition_1.NetworkMode.NONE)throw new Error("Cannot use a Classic Load Balancer if NetworkMode is None. Use Host or Bridge instead.");this.loadBalancers.push({loadBalancerName:loadBalancer.loadBalancerName,containerName,containerPort})}attachToELBv2(targetGroup,containerName,containerPort){if(this.taskDefinition.networkMode===task_definition_1.NetworkMode.NONE)throw new Error("Cannot use a load balancer if NetworkMode is None. Use Bridge, Host or AwsVpc instead.");return this.loadBalancers.push({targetGroupArn:targetGroup.targetGroupArn,containerName,containerPort}),this.resource.node.addDependency(targetGroup.loadBalancerAttached),{targetType:this.taskDefinition.networkMode===task_definition_1.NetworkMode.AWS_VPC?elbv2.TargetType.IP:elbv2.TargetType.INSTANCE}}get defaultLoadBalancerTarget(){return this.loadBalancerTarget({containerName:this.taskDefinition.defaultContainer.containerName})}makeAutoScalingRole(){return iam.Role.fromRoleArn(this,"ScalingRole",core_1.Stack.of(this).formatArn({region:"",service:"iam",resource:"role/aws-service-role/ecs.application-autoscaling.amazonaws.com",resourceName:"AWSServiceRoleForApplicationAutoScaling_ECSService"}))}addServiceRegistry(registry){if(this.serviceRegistries.length>=1)throw new Error("Cannot associate with the given service discovery registry. ECS supports at most one service registry per service.");const sr=this.renderServiceRegistry(registry);this.serviceRegistries.push(sr)}evaluateHealthGracePeriod(providedHealthCheckGracePeriod){return core_1.Lazy.any({produce:()=>providedHealthCheckGracePeriod?.toSeconds()??(this.loadBalancers.length>0?60:void 0)})}enableExecuteCommand(){this.taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({actions:["ssmmessages:CreateControlChannel","ssmmessages:CreateDataChannel","ssmmessages:OpenControlChannel","ssmmessages:OpenDataChannel"],resources:["*"]}))}}exports.BaseService=BaseService,_b=JSII_RTTI_SYMBOL_1,BaseService[_b]={fqn:"aws-cdk-lib.aws_ecs.BaseService",version:"2.42.0"};var LaunchType;(function(LaunchType2){LaunchType2.EC2="EC2",LaunchType2.FARGATE="FARGATE",LaunchType2.EXTERNAL="EXTERNAL"})(LaunchType=exports.LaunchType||(exports.LaunchType={}));var DeploymentControllerType;(function(DeploymentControllerType2){DeploymentControllerType2.ECS="ECS",DeploymentControllerType2.CODE_DEPLOY="CODE_DEPLOY",DeploymentControllerType2.EXTERNAL="EXTERNAL"})(DeploymentControllerType=exports.DeploymentControllerType||(exports.DeploymentControllerType={}));var PropagatedTagSource;(function(PropagatedTagSource2){PropagatedTagSource2.SERVICE="SERVICE",PropagatedTagSource2.TASK_DEFINITION="TASK_DEFINITION",PropagatedTagSource2.NONE="NONE"})(PropagatedTagSource=exports.PropagatedTagSource||(exports.PropagatedTagSource={}));function determineContainerNameAndPort(options){if(options.dnsRecordType===cloudmap.DnsRecordType.SRV){if(options.container&&options.container.taskDefinition!=options.taskDefinition)throw new Error("Cannot add discovery for a container from another task definition");const container=options.container??options.taskDefinition.defaultContainer;if(options.containerPort&&!container.portMappings.some(mapping=>mapping.containerPort===options.containerPort))throw new Error("Cannot add discovery for a container port that has not been mapped");return{containerName:container.containerName,containerPort:options.containerPort??options.taskDefinition.defaultContainer.containerPort}}return{}}
//# sourceMappingURL=base-service.js.map
