"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.extractServiceNameFromArn=exports.fromServiceAttributes=void 0;const core_1=require("../../../core"),cx_api_1=require("../../../cx-api");function fromServiceAttributes(scope,id,attrs){if(attrs.serviceArn&&attrs.serviceName||!attrs.serviceArn&&!attrs.serviceName)throw new Error("You can only specify either serviceArn or serviceName.");const newArnFormat=core_1.FeatureFlags.of(scope).isEnabled(cx_api_1.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME),stack=core_1.Stack.of(scope);let name,arn;if(attrs.serviceName){name=attrs.serviceName;const resourceName=newArnFormat?`${attrs.cluster.clusterName}/${attrs.serviceName}`:attrs.serviceName;arn=stack.formatArn({partition:stack.partition,service:"ecs",region:stack.region,account:stack.account,resource:"service",resourceName})}else arn=attrs.serviceArn,name=extractServiceNameFromArn(scope,arn);class Import extends core_1.Resource{constructor(){super(...arguments),this.serviceArn=arn,this.serviceName=name,this.cluster=attrs.cluster}}return new Import(scope,id,{environmentFromArn:arn})}exports.fromServiceAttributes=fromServiceAttributes;function extractServiceNameFromArn(scope,arn){const newArnFormat=core_1.FeatureFlags.of(scope).isEnabled(cx_api_1.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME),stack=core_1.Stack.of(scope);if(core_1.Token.isUnresolved(arn))if(newArnFormat){const components=core_1.Fn.split(":",arn),lastComponents=core_1.Fn.split("/",core_1.Fn.select(5,components));return core_1.Fn.select(2,lastComponents)}else return stack.splitArn(arn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;else{const resourceName=stack.splitArn(arn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName,resourceNameSplit=resourceName.split("/");return resourceNameSplit.length===1?resourceName:resourceNameSplit[1]}}exports.extractServiceNameFromArn=extractServiceNameFromArn;
//# sourceMappingURL=from-service-attributes.js.map
