"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AsgCapacityProvider=exports.ExecuteCommandLogging=exports.Cluster=exports.MachineImageType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),autoscaling=require("../../aws-autoscaling"),cloudwatch=require("../../aws-cloudwatch"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),cloudmap=require("../../aws-servicediscovery"),core_1=require("../../core"),constructs_1=require("constructs"),amis_1=require("./amis"),instance_drain_hook_1=require("./drain-hook/instance-drain-hook"),ecs_canned_metrics_generated_1=require("./ecs-canned-metrics.generated"),ecs_generated_1=require("./ecs.generated");var MachineImageType;(function(MachineImageType2){MachineImageType2[MachineImageType2.AMAZON_LINUX_2=0]="AMAZON_LINUX_2",MachineImageType2[MachineImageType2.BOTTLEROCKET=1]="BOTTLEROCKET"})(MachineImageType=exports.MachineImageType||(exports.MachineImageType={}));class Cluster extends core_1.Resource{constructor(scope,id,props={}){super(scope,id,{physicalName:props.clusterName}),this.connections=new ec2.Connections,this._capacityProviderNames=[],this._hasEc2Capacity=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ClusterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Cluster),error}let clusterSettings;if(props.containerInsights!==void 0&&(clusterSettings=[{name:"containerInsights",value:props.containerInsights?ContainerInsights.ENABLED:ContainerInsights.DISABLED}]),this._capacityProviderNames=props.capacityProviders??[],props.enableFargateCapacityProviders&&this.enableFargateCapacityProviders(),props.executeCommandConfiguration){if(props.executeCommandConfiguration.logging===ExecuteCommandLogging.OVERRIDE!=(props.executeCommandConfiguration.logConfiguration!==void 0))throw new Error("Execute command log configuration must only be specified when logging is OVERRIDE.");this._executeCommandConfiguration=props.executeCommandConfiguration}const cluster=new ecs_generated_1.CfnCluster(this,"Resource",{clusterName:this.physicalName,clusterSettings,configuration:this._executeCommandConfiguration&&this.renderExecuteCommandConfiguration()});this.clusterArn=this.getResourceArnAttribute(cluster.attrArn,{service:"ecs",resource:"cluster",resourceName:this.physicalName}),this.clusterName=this.getResourceNameAttribute(cluster.ref),this.vpc=props.vpc||new ec2.Vpc(this,"Vpc",{maxAzs:2}),this._defaultCloudMapNamespace=props.defaultCloudMapNamespace!==void 0?this.addDefaultCloudMapNamespace(props.defaultCloudMapNamespace):void 0,this._autoscalingGroup=props.capacity!==void 0?this.addCapacity("DefaultAutoScalingGroup",props.capacity):void 0,core_1.Aspects.of(this).add(new MaybeCreateCapacityProviderAssociations(this,id,this._capacityProviderNames))}static fromClusterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ClusterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromClusterAttributes),error}return new ImportedCluster(scope,id,attrs)}static fromClusterArn(scope,id,clusterArn){const clusterName=core_1.Stack.of(scope).splitArn(clusterArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!clusterName)throw new Error(`Missing required Cluster Name from Cluster ARN: ${clusterArn}`);const errorSuffix="is not available for a Cluster imported using fromClusterArn(), please use fromClusterAttributes() instead.";class Import extends core_1.Resource{constructor(){super(...arguments),this.clusterArn=clusterArn,this.clusterName=clusterName}get hasEc2Capacity(){throw new Error(`hasEc2Capacity ${errorSuffix}`)}get connections(){throw new Error(`connections ${errorSuffix}`)}get vpc(){throw new Error(`vpc ${errorSuffix}`)}}return new Import(scope,id,{environmentFromArn:clusterArn})}enableFargateCapacityProviders(){for(const provider of["FARGATE","FARGATE_SPOT"])this._capacityProviderNames.includes(provider)||this._capacityProviderNames.push(provider)}renderExecuteCommandConfiguration(){return{executeCommandConfiguration:{kmsKeyId:this._executeCommandConfiguration?.kmsKey?.keyArn,logConfiguration:this._executeCommandConfiguration?.logConfiguration&&this.renderExecuteCommandLogConfiguration(),logging:this._executeCommandConfiguration?.logging}}}renderExecuteCommandLogConfiguration(){const logConfiguration=this._executeCommandConfiguration?.logConfiguration;if(logConfiguration?.s3EncryptionEnabled&&!logConfiguration?.s3Bucket)throw new Error("You must specify an S3 bucket name in the execute command log configuration to enable S3 encryption.");if(logConfiguration?.cloudWatchEncryptionEnabled&&!logConfiguration?.cloudWatchLogGroup)throw new Error("You must specify a CloudWatch log group in the execute command log configuration to enable CloudWatch encryption.");return{cloudWatchEncryptionEnabled:logConfiguration?.cloudWatchEncryptionEnabled,cloudWatchLogGroupName:logConfiguration?.cloudWatchLogGroup?.logGroupName,s3BucketName:logConfiguration?.s3Bucket?.bucketName,s3EncryptionEnabled:logConfiguration?.s3EncryptionEnabled,s3KeyPrefix:logConfiguration?.s3KeyPrefix}}addDefaultCloudMapNamespace(options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_CloudMapNamespaceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDefaultCloudMapNamespace),error}if(this._defaultCloudMapNamespace!==void 0)throw new Error("Can only add default namespace once.");const sdNamespace=(options.type!==void 0?options.type:cloudmap.NamespaceType.DNS_PRIVATE)===cloudmap.NamespaceType.DNS_PRIVATE?new cloudmap.PrivateDnsNamespace(this,"DefaultServiceDiscoveryNamespace",{name:options.name,vpc:this.vpc}):new cloudmap.PublicDnsNamespace(this,"DefaultServiceDiscoveryNamespace",{name:options.name});return this._defaultCloudMapNamespace=sdNamespace,sdNamespace}get defaultCloudMapNamespace(){return this._defaultCloudMapNamespace}addCapacity(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AddCapacityOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addCapacity),error}const machineImage=options.machineImage??(options.machineImageType===MachineImageType.BOTTLEROCKET?new amis_1.BottleRocketImage({architecture:options.instanceType.architecture}):new amis_1.EcsOptimizedAmi),machineImageType=options.machineImageType??(isBottleRocketImage(machineImage)?MachineImageType.BOTTLEROCKET:MachineImageType.AMAZON_LINUX_2),autoScalingGroup=new autoscaling.AutoScalingGroup(this,id,{vpc:this.vpc,machineImage,updateType:options.updatePolicy?void 0:options.updateType||autoscaling.UpdateType.REPLACING_UPDATE,...options});return this.addAutoScalingGroup(autoScalingGroup,{machineImageType,...options}),autoScalingGroup}addAsgCapacityProvider(provider,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AsgCapacityProvider(provider),jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AddAutoScalingGroupCapacityOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAsgCapacityProvider),error}this._capacityProviderNames.includes(provider.capacityProviderName)||(this._hasEc2Capacity=!0,this.configureAutoScalingGroup(provider.autoScalingGroup,{...options,machineImageType:provider.machineImageType,taskDrainTime:provider.enableManagedTerminationProtection?core_1.Duration.seconds(0):options.taskDrainTime,canContainersAccessInstanceRole:options.canContainersAccessInstanceRole??provider.canContainersAccessInstanceRole}),this._capacityProviderNames.push(provider.capacityProviderName))}addAutoScalingGroup(autoScalingGroup,options={}){this._hasEc2Capacity=!0,this.connections.connections.addSecurityGroup(...autoScalingGroup.connections.securityGroups),this.configureAutoScalingGroup(autoScalingGroup,options)}configureAutoScalingGroup(autoScalingGroup,options={}){if(autoScalingGroup.osType===ec2.OperatingSystemType.WINDOWS)this.configureWindowsAutoScalingGroup(autoScalingGroup,options);else switch(options.machineImageType){case MachineImageType.BOTTLEROCKET:{autoScalingGroup.addUserData("[settings.ecs]",`cluster = "${this.clusterName}"`),autoScalingGroup.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonSSMManagedInstanceCore")),autoScalingGroup.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AmazonEC2ContainerServiceforEC2Role"));break}default:autoScalingGroup.addUserData(`echo ECS_CLUSTER=${this.clusterName} >> /etc/ecs/ecs.config`),options.canContainersAccessInstanceRole||(autoScalingGroup.addUserData("sudo iptables --insert FORWARD 1 --in-interface docker+ --destination 169.254.169.254/32 --jump DROP"),autoScalingGroup.addUserData("sudo service iptables save"),autoScalingGroup.addUserData("echo ECS_AWSVPC_BLOCK_IMDS=true >> /etc/ecs/ecs.config")),autoScalingGroup.spotPrice&&options.spotInstanceDraining&&autoScalingGroup.addUserData("echo ECS_ENABLE_SPOT_INSTANCE_DRAINING=true >> /etc/ecs/ecs.config")}autoScalingGroup.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:DeregisterContainerInstance","ecs:RegisterContainerInstance","ecs:Submit*"],resources:[this.clusterArn]})),autoScalingGroup.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:Poll","ecs:StartTelemetrySession"],resources:["*"],conditions:{ArnEquals:{"ecs:cluster":this.clusterArn}}})),autoScalingGroup.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:DiscoverPollEndpoint","ecr:GetAuthorizationToken","logs:CreateLogStream","logs:PutLogEvents"],resources:["*"]})),(!options.taskDrainTime||options.taskDrainTime.toSeconds()!==0)&&new instance_drain_hook_1.InstanceDrainHook(autoScalingGroup,"DrainECSHook",{autoScalingGroup,cluster:this,drainTime:options.taskDrainTime,topicEncryptionKey:options.topicEncryptionKey})}addCapacityProvider(provider){if(!(provider==="FARGATE"||provider==="FARGATE_SPOT"))throw new Error("CapacityProvider not supported");this._capacityProviderNames.includes(provider)||this._capacityProviderNames.push(provider)}configureWindowsAutoScalingGroup(autoScalingGroup,options={}){autoScalingGroup.addUserData("Remove-Item -Recurse C:\\ProgramData\\Amazon\\ECS\\Cache"),autoScalingGroup.addUserData("Import-Module ECSTools"),autoScalingGroup.addUserData(`[Environment]::SetEnvironmentVariable("ECS_CLUSTER", "${this.clusterName}", "Machine")`),autoScalingGroup.addUserData('[Environment]::SetEnvironmentVariable("ECS_ENABLE_AWSLOGS_EXECUTIONROLE_OVERRIDE", "true", "Machine")'),autoScalingGroup.addUserData(`[Environment]::SetEnvironmentVariable("ECS_AVAILABLE_LOGGING_DRIVERS", '["json-file","awslogs"]', "Machine")`),autoScalingGroup.spotPrice&&options.spotInstanceDraining&&autoScalingGroup.addUserData('[Environment]::SetEnvironmentVariable("ECS_ENABLE_SPOT_INSTANCE_DRAINING", "true", "Machine")'),options.canContainersAccessInstanceRole?autoScalingGroup.addUserData(`Initialize-ECSAgent -Cluster '${this.clusterName}'`):(autoScalingGroup.addUserData('[Environment]::SetEnvironmentVariable("ECS_ENABLE_TASK_IAM_ROLE", "true", "Machine")'),autoScalingGroup.addUserData(`Initialize-ECSAgent -Cluster '${this.clusterName}' -EnableTaskIAMRole`))}get autoscalingGroup(){return this._autoscalingGroup}get hasEc2Capacity(){return this._hasEc2Capacity}get executeCommandConfiguration(){return this._executeCommandConfiguration}metricCpuReservation(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCpuReservation),error}return this.cannedMetric(ecs_canned_metrics_generated_1.ECSMetrics.cpuReservationAverage,props)}metricCpuUtilization(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricCpuUtilization),error}return this.cannedMetric(ecs_canned_metrics_generated_1.ECSMetrics.cpuUtilizationAverage,props)}metricMemoryReservation(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricMemoryReservation),error}return this.cannedMetric(ecs_canned_metrics_generated_1.ECSMetrics.memoryReservationAverage,props)}metricMemoryUtilization(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricMemoryUtilization),error}return this.cannedMetric(ecs_canned_metrics_generated_1.ECSMetrics.memoryUtilizationAverage,props)}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/ECS",metricName,dimensionsMap:{ClusterName:this.clusterName},...props}).attachTo(this)}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({ClusterName:this.clusterName}),...props}).attachTo(this)}}exports.Cluster=Cluster,_a=JSII_RTTI_SYMBOL_1,Cluster[_a]={fqn:"aws-cdk-lib.aws_ecs.Cluster",version:"2.42.0"};class ImportedCluster extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.connections=new ec2.Connections,this.clusterName=props.clusterName,this.vpc=props.vpc,this.hasEc2Capacity=props.hasEc2Capacity!==!1,this._defaultCloudMapNamespace=props.defaultCloudMapNamespace,this._executeCommandConfiguration=props.executeCommandConfiguration,this.clusterArn=props.clusterArn??core_1.Stack.of(this).formatArn({service:"ecs",resource:"cluster",resourceName:props.clusterName}),this.connections=new ec2.Connections({securityGroups:props.securityGroups})}get defaultCloudMapNamespace(){return this._defaultCloudMapNamespace}get executeCommandConfiguration(){return this._executeCommandConfiguration}}var ContainerInsights;(function(ContainerInsights2){ContainerInsights2.ENABLED="enabled",ContainerInsights2.DISABLED="disabled"})(ContainerInsights||(ContainerInsights={}));var ExecuteCommandLogging;(function(ExecuteCommandLogging2){ExecuteCommandLogging2.NONE="NONE",ExecuteCommandLogging2.DEFAULT="DEFAULT",ExecuteCommandLogging2.OVERRIDE="OVERRIDE"})(ExecuteCommandLogging=exports.ExecuteCommandLogging||(exports.ExecuteCommandLogging={}));class AsgCapacityProvider extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_AsgCapacityProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AsgCapacityProvider),error}if(this.autoScalingGroup=props.autoScalingGroup,this.machineImageType=props.machineImageType??MachineImageType.AMAZON_LINUX_2,this.canContainersAccessInstanceRole=props.canContainersAccessInstanceRole,this.enableManagedTerminationProtection=props.enableManagedTerminationProtection===void 0?!0:props.enableManagedTerminationProtection,this.enableManagedTerminationProtection&&this.autoScalingGroup.protectNewInstancesFromScaleIn(),props.capacityProviderName&&!/^(?!aws|ecs|fargate).+/gm.test(props.capacityProviderName))throw new Error(`Invalid Capacity Provider Name: ${props.capacityProviderName}, If a name is specified, it cannot start with aws, ecs, or fargate.`);const capacityProvider=new ecs_generated_1.CfnCapacityProvider(this,id,{name:props.capacityProviderName,autoScalingGroupProvider:{autoScalingGroupArn:this.autoScalingGroup.autoScalingGroupName,managedScaling:props.enableManagedScaling===!1?void 0:{status:"ENABLED",targetCapacity:props.targetCapacityPercent||100,maximumScalingStepSize:props.maximumScalingStepSize,minimumScalingStepSize:props.minimumScalingStepSize},managedTerminationProtection:this.enableManagedTerminationProtection?"ENABLED":"DISABLED"}});this.capacityProviderName=capacityProvider.ref}}exports.AsgCapacityProvider=AsgCapacityProvider,_b=JSII_RTTI_SYMBOL_1,AsgCapacityProvider[_b]={fqn:"aws-cdk-lib.aws_ecs.AsgCapacityProvider",version:"2.42.0"};class MaybeCreateCapacityProviderAssociations{constructor(scope,id,capacityProviders){this.scope=scope,this.id=id,this.capacityProviders=capacityProviders}visit(node){if(node instanceof Cluster&&this.capacityProviders.length>0&&!this.resource){const resource=new ecs_generated_1.CfnClusterCapacityProviderAssociations(this.scope,this.id,{cluster:node.clusterName,defaultCapacityProviderStrategy:[],capacityProviders:core_1.Lazy.list({produce:()=>this.capacityProviders})});this.resource=resource}}}function isBottleRocketImage(image){return image instanceof amis_1.BottleRocketImage}
//# sourceMappingURL=cluster.js.map
