"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Protocol=exports.ContainerDependencyCondition=exports.UlimitName=exports.ContainerDefinition=exports.Secret=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),constructs_1=require("constructs"),task_definition_1=require("./base/task-definition");class Secret{static fromSsmParameter(parameter){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_IParameter(parameter)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSsmParameter),error}return{arn:parameter.parameterArn,grantRead:grantee=>parameter.grantRead(grantee)}}static fromSecretsManager(secret,field){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_ISecret(secret)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecretsManager),error}return{arn:field?`${secret.secretArn}:${field}::`:secret.secretArn,hasField:!!field,grantRead:grantee=>secret.grantRead(grantee)}}static fromSecretsManagerVersion(secret,versionInfo,field){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_ISecret(secret),jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_SecretVersionInfo(versionInfo)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecretsManagerVersion),error}return{arn:`${secret.secretArn}:${field??""}:${versionInfo.versionStage??""}:${versionInfo.versionId??""}`,hasField:!!field,grantRead:grantee=>secret.grantRead(grantee)}}}exports.Secret=Secret,_a=JSII_RTTI_SYMBOL_1,Secret[_a]={fqn:"aws-cdk-lib.aws_ecs.Secret",version:"2.42.0"};class ContainerDefinition extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),this.props=props,this.mountPoints=new Array,this.portMappings=new Array,this.volumesFrom=new Array,this.ulimits=new Array,this.containerDependencies=new Array,this.inferenceAcceleratorResources=[],this.links=new Array,this.secrets=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinitionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ContainerDefinition),error}if(props.memoryLimitMiB!==void 0&&props.memoryReservationMiB!==void 0&&props.memoryLimitMiB<props.memoryReservationMiB)throw new Error("MemoryLimitMiB should not be less than MemoryReservationMiB.");if(this.essential=props.essential??!0,this.taskDefinition=props.taskDefinition,this.memoryLimitSpecified=props.memoryLimitMiB!==void 0||props.memoryReservationMiB!==void 0,this.linuxParameters=props.linuxParameters,this.containerName=props.containerName??this.node.id,this.imageConfig=props.image.bind(this,this),this.imageName=this.imageConfig.imageName,props.logging&&(this.logDriverConfig=props.logging.bind(this,this)),props.secrets)for(const[name,secret]of Object.entries(props.secrets))this.addSecret(name,secret);if(props.environment?this.environment={...props.environment}:this.environment={},props.environmentFiles){this.environmentFiles=[];for(const environmentFile of props.environmentFiles)this.environmentFiles.push(environmentFile.bind(this))}props.taskDefinition._linkContainer(this),props.portMappings&&this.addPortMappings(...props.portMappings),props.inferenceAcceleratorResources&&this.addInferenceAcceleratorResource(...props.inferenceAcceleratorResources)}addLink(container,alias){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDefinition(container)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLink),error}if(this.taskDefinition.networkMode!==task_definition_1.NetworkMode.BRIDGE)throw new Error("You must use network mode Bridge to add container links.");alias!==void 0?this.links.push(`${container.containerName}:${alias}`):this.links.push(`${container.containerName}`)}addMountPoints(...mountPoints){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_MountPoint(mountPoints)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addMountPoints),error}this.mountPoints.push(...mountPoints)}addScratch(scratch){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ScratchSpace(scratch)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addScratch),error}const mountPoint={containerPath:scratch.containerPath,readOnly:scratch.readOnly,sourceVolume:scratch.name},volume={host:{sourcePath:scratch.sourcePath},name:scratch.name};this.taskDefinition.addVolume(volume),this.addMountPoints(mountPoint)}addPortMappings(...portMappings){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_PortMapping(portMappings)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPortMappings),error}this.portMappings.push(...portMappings.map(pm=>{if((this.taskDefinition.networkMode===task_definition_1.NetworkMode.AWS_VPC||this.taskDefinition.networkMode===task_definition_1.NetworkMode.HOST)&&pm.containerPort!==pm.hostPort&&pm.hostPort!==void 0)throw new Error(`Host port (${pm.hostPort}) must be left out or equal to container port ${pm.containerPort} for network mode ${this.taskDefinition.networkMode}`);return this.taskDefinition.networkMode===task_definition_1.NetworkMode.BRIDGE&&pm.hostPort===void 0&&(pm={...pm,hostPort:0}),pm}))}addEnvironment(name,value){this.environment[name]=value}addSecret(name,secret){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Secret(secret)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecret),error}secret.grantRead(this.taskDefinition.obtainExecutionRole()),this.secrets.push({name,valueFrom:secret.arn})}addInferenceAcceleratorResource(...inferenceAcceleratorResources){this.inferenceAcceleratorResources.push(...inferenceAcceleratorResources.map(resource=>{for(const inferenceAccelerator of this.taskDefinition.inferenceAccelerators)if(resource===inferenceAccelerator.deviceName)return resource;throw new Error(`Resource value ${resource} in container definition doesn't match any inference accelerator device name in the task definition.`)}))}addUlimits(...ulimits){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Ulimit(ulimits)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addUlimits),error}this.ulimits.push(...ulimits)}addContainerDependencies(...containerDependencies){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_ContainerDependency(containerDependencies)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addContainerDependencies),error}this.containerDependencies.push(...containerDependencies)}addVolumesFrom(...volumesFrom){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_VolumeFrom(volumesFrom)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addVolumesFrom),error}this.volumesFrom.push(...volumesFrom)}addToExecutionPolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToExecutionPolicy),error}this.taskDefinition.addToExecutionRolePolicy(statement)}findPortMapping(containerPort,protocol){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Protocol(protocol)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.findPortMapping),error}for(const portMapping of this.portMappings){const p=portMapping.protocol||Protocol.TCP;if(portMapping.containerPort===containerPort&&p===protocol)return portMapping}}get referencesSecretJsonField(){for(const secret of this.secrets)if(secret.valueFrom.endsWith("::"))return!0;return!1}get ingressPort(){if(this.portMappings.length===0)throw new Error(`Container ${this.containerName} hasn't defined any ports. Call addPortMappings().`);const defaultPortMapping=this.portMappings[0];return defaultPortMapping.hostPort!==void 0&&defaultPortMapping.hostPort!==0?defaultPortMapping.hostPort:this.taskDefinition.networkMode===task_definition_1.NetworkMode.BRIDGE?0:defaultPortMapping.containerPort}get containerPort(){if(this.portMappings.length===0)throw new Error(`Container ${this.containerName} hasn't defined any ports. Call addPortMappings().`);return this.portMappings[0].containerPort}renderContainerDefinition(_taskDefinition){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_TaskDefinition(_taskDefinition)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.renderContainerDefinition),error}return{command:this.props.command,cpu:this.props.cpu,disableNetworking:this.props.disableNetworking,dependsOn:cdk.Lazy.any({produce:()=>this.containerDependencies.map(renderContainerDependency)},{omitEmptyArray:!0}),dnsSearchDomains:this.props.dnsSearchDomains,dnsServers:this.props.dnsServers,dockerLabels:this.props.dockerLabels,dockerSecurityOptions:this.props.dockerSecurityOptions,entryPoint:this.props.entryPoint,essential:this.essential,hostname:this.props.hostname,image:this.imageConfig.imageName,memory:this.props.memoryLimitMiB,memoryReservation:this.props.memoryReservationMiB,mountPoints:cdk.Lazy.any({produce:()=>this.mountPoints.map(renderMountPoint)},{omitEmptyArray:!0}),name:this.containerName,portMappings:cdk.Lazy.any({produce:()=>this.portMappings.map(renderPortMapping)},{omitEmptyArray:!0}),privileged:this.props.privileged,readonlyRootFilesystem:this.props.readonlyRootFilesystem,repositoryCredentials:this.imageConfig.repositoryCredentials,startTimeout:this.props.startTimeout&&this.props.startTimeout.toSeconds(),stopTimeout:this.props.stopTimeout&&this.props.stopTimeout.toSeconds(),ulimits:cdk.Lazy.any({produce:()=>this.ulimits.map(renderUlimit)},{omitEmptyArray:!0}),user:this.props.user,volumesFrom:cdk.Lazy.any({produce:()=>this.volumesFrom.map(renderVolumeFrom)},{omitEmptyArray:!0}),workingDirectory:this.props.workingDirectory,logConfiguration:this.logDriverConfig,environment:this.environment&&Object.keys(this.environment).length?renderKV(this.environment,"name","value"):void 0,environmentFiles:this.environmentFiles&&renderEnvironmentFiles(cdk.Stack.of(this).partition,this.environmentFiles),secrets:this.secrets.length?this.secrets:void 0,extraHosts:this.props.extraHosts&&renderKV(this.props.extraHosts,"hostname","ipAddress"),healthCheck:this.props.healthCheck&&renderHealthCheck(this.props.healthCheck),links:cdk.Lazy.list({produce:()=>this.links},{omitEmpty:!0}),linuxParameters:this.linuxParameters&&this.linuxParameters.renderLinuxParameters(),resourceRequirements:!this.props.gpuCount&&this.inferenceAcceleratorResources.length==0?void 0:renderResourceRequirements(this.props.gpuCount,this.inferenceAcceleratorResources),systemControls:this.props.systemControls&&renderSystemControls(this.props.systemControls)}}}exports.ContainerDefinition=ContainerDefinition,_b=JSII_RTTI_SYMBOL_1,ContainerDefinition[_b]={fqn:"aws-cdk-lib.aws_ecs.ContainerDefinition",version:"2.42.0"};function renderKV(env,keyName,valueName){const ret=[];for(const[key,value]of Object.entries(env))ret.push({[keyName]:key,[valueName]:value});return ret}function renderEnvironmentFiles(partition,environmentFiles){const ret=[];for(const environmentFile of environmentFiles){const s3Location=environmentFile.s3Location;if(!s3Location)throw Error("Environment file must specify an S3 location");ret.push({type:environmentFile.fileType,value:`arn:${partition}:s3:::${s3Location.bucketName}/${s3Location.objectKey}`})}return ret}function renderHealthCheck(hc){return{command:getHealthCheckCommand(hc),interval:hc.interval?.toSeconds()??30,retries:hc.retries??3,startPeriod:hc.startPeriod?.toSeconds(),timeout:hc.timeout?.toSeconds()??5}}function getHealthCheckCommand(hc){const cmd=hc.command,hcCommand=new Array;if(cmd.length===0)throw new Error("At least one argument must be supplied for health check command.");return cmd.length===1?(hcCommand.push("CMD-SHELL",cmd[0]),hcCommand):(cmd[0]!=="CMD"&&cmd[0]!=="CMD-SHELL"&&hcCommand.push("CMD"),hcCommand.concat(cmd))}function renderResourceRequirements(gpuCount=0,inferenceAcceleratorResources=[]){const ret=[];for(const resource of inferenceAcceleratorResources)ret.push({type:"InferenceAccelerator",value:resource});return gpuCount>0&&ret.push({type:"GPU",value:gpuCount.toString()}),ret}var UlimitName;(function(UlimitName2){UlimitName2.CORE="core",UlimitName2.CPU="cpu",UlimitName2.DATA="data",UlimitName2.FSIZE="fsize",UlimitName2.LOCKS="locks",UlimitName2.MEMLOCK="memlock",UlimitName2.MSGQUEUE="msgqueue",UlimitName2.NICE="nice",UlimitName2.NOFILE="nofile",UlimitName2.NPROC="nproc",UlimitName2.RSS="rss",UlimitName2.RTPRIO="rtprio",UlimitName2.RTTIME="rttime",UlimitName2.SIGPENDING="sigpending",UlimitName2.STACK="stack"})(UlimitName=exports.UlimitName||(exports.UlimitName={}));function renderUlimit(ulimit){return{name:ulimit.name,softLimit:ulimit.softLimit,hardLimit:ulimit.hardLimit}}var ContainerDependencyCondition;(function(ContainerDependencyCondition2){ContainerDependencyCondition2.START="START",ContainerDependencyCondition2.COMPLETE="COMPLETE",ContainerDependencyCondition2.SUCCESS="SUCCESS",ContainerDependencyCondition2.HEALTHY="HEALTHY"})(ContainerDependencyCondition=exports.ContainerDependencyCondition||(exports.ContainerDependencyCondition={}));function renderContainerDependency(containerDependency){return{containerName:containerDependency.container.containerName,condition:containerDependency.condition||ContainerDependencyCondition.HEALTHY}}var Protocol;(function(Protocol2){Protocol2.TCP="tcp",Protocol2.UDP="udp"})(Protocol=exports.Protocol||(exports.Protocol={}));function renderPortMapping(pm){return{containerPort:pm.containerPort,hostPort:pm.hostPort,protocol:pm.protocol||Protocol.TCP}}function renderMountPoint(mp){return{containerPath:mp.containerPath,readOnly:mp.readOnly,sourceVolume:mp.sourceVolume}}function renderVolumeFrom(vf){return{sourceContainer:vf.sourceContainer,readOnly:vf.readOnly}}function renderSystemControls(systemControls){return systemControls.map(sc=>({namespace:sc.namespace,value:sc.value}))}
//# sourceMappingURL=container-definition.js.map
