"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.renderLogDriverSecretOptions=exports.joinWithCommas=exports.renderCommonLogDriverOptions=exports.stringifyOptions=exports.ensureInRange=exports.ensurePositiveInteger=exports.removeEmpty=void 0;const core_1=require("../../../core");function removeEmpty(x){for(const key of Object.keys(x))x[key]===void 0&&delete x[key];return x}exports.removeEmpty=removeEmpty;function ensurePositiveInteger(val){if(!core_1.Token.isUnresolved(val)&&Number.isInteger(val)&&val<0)throw new Error(`\`${val}\` must be a positive integer.`)}exports.ensurePositiveInteger=ensurePositiveInteger;function ensureInRange(val,start,end){if(!core_1.Token.isUnresolved(val)&&!(val>=start&&val<=end))throw new Error(`\`${val}\` must be within range ${start}:${end}`)}exports.ensureInRange=ensureInRange;function stringifyOptions(options){const _options={},filteredOptions=removeEmpty(options);for(const[key,value]of Object.entries(filteredOptions))_options[key]=core_1.SecretValue.isSecretValue(value)?value.unsafeUnwrap():`${value}`;return _options}exports.stringifyOptions=stringifyOptions;function renderCommonLogDriverOptions(opts){return{tag:opts.tag,labels:joinWithCommas(opts.labels),env:joinWithCommas(opts.env),"env-regex":opts.envRegex}}exports.renderCommonLogDriverOptions=renderCommonLogDriverOptions;function joinWithCommas(xs){return xs&&xs.join(",")}exports.joinWithCommas=joinWithCommas;function renderLogDriverSecretOptions(secretValue,taskDefinition){const secrets=[];for(const[name,secret]of Object.entries(secretValue))secret.grantRead(taskDefinition.obtainExecutionRole()),secrets.push({name,valueFrom:secret.arn});return secrets}exports.renderLogDriverSecretOptions=renderLogDriverSecretOptions;
//# sourceMappingURL=utils.js.map
