"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AlbController=exports.AlbScheme=exports.AlbControllerVersion=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),iam=require("../../aws-iam"),constructs_1=require("constructs"),helm_chart_1=require("./helm-chart"),service_account_1=require("./service-account"),core_1=require("../../core");class AlbControllerVersion{constructor(version,custom){this.version=version,this.custom=custom}static of(version){return new AlbControllerVersion(version,!0)}}exports.AlbControllerVersion=AlbControllerVersion,_a=JSII_RTTI_SYMBOL_1,AlbControllerVersion[_a]={fqn:"aws-cdk-lib.aws_eks.AlbControllerVersion",version:"2.42.0"},AlbControllerVersion.V2_0_0=new AlbControllerVersion("v2.0.0",!1),AlbControllerVersion.V2_0_1=new AlbControllerVersion("v2.0.1",!1),AlbControllerVersion.V2_1_0=new AlbControllerVersion("v2.1.0",!1),AlbControllerVersion.V2_1_1=new AlbControllerVersion("v2.1.1",!1),AlbControllerVersion.V2_1_2=new AlbControllerVersion("v2.1.2",!1),AlbControllerVersion.V2_1_3=new AlbControllerVersion("v2.1.3",!1),AlbControllerVersion.V2_2_0=new AlbControllerVersion("v2.2.0",!1),AlbControllerVersion.V2_2_1=new AlbControllerVersion("v2.2.1",!1),AlbControllerVersion.V2_2_2=new AlbControllerVersion("v2.2.2",!1),AlbControllerVersion.V2_2_3=new AlbControllerVersion("v2.2.3",!1),AlbControllerVersion.V2_2_4=new AlbControllerVersion("v2.2.4",!1),AlbControllerVersion.V2_3_0=new AlbControllerVersion("v2.3.0",!1),AlbControllerVersion.V2_3_1=new AlbControllerVersion("v2.3.1",!1),AlbControllerVersion.V2_4_1=new AlbControllerVersion("v2.4.1",!1);var AlbScheme;(function(AlbScheme2){AlbScheme2.INTERNAL="internal",AlbScheme2.INTERNET_FACING="internet-facing"})(AlbScheme=exports.AlbScheme||(exports.AlbScheme={}));class AlbController extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_AlbControllerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AlbController),error}const namespace="kube-system",serviceAccount=new service_account_1.ServiceAccount(this,"alb-sa",{namespace,name:"aws-load-balancer-controller",cluster:props.cluster});if(props.version.custom&&!props.policy)throw new Error("'albControllerOptions.policy' is required when using a custom controller version");const policy=props.policy??JSON.parse(fs.readFileSync(path.join(__dirname,"addons",`alb-iam_policy-${props.version.version}.json`),"utf8"));for(const statement of policy.Statement)serviceAccount.addToPrincipalPolicy(iam.PolicyStatement.fromJson(statement));const chart=new helm_chart_1.HelmChart(this,"Resource",{cluster:props.cluster,chart:"aws-load-balancer-controller",repository:"https://aws.github.io/eks-charts",namespace,release:"aws-load-balancer-controller",version:"1.4.1",wait:!0,timeout:core_1.Duration.minutes(15),values:{clusterName:props.cluster.clusterName,serviceAccount:{create:!1,name:serviceAccount.serviceAccountName},region:core_1.Stack.of(this).region,vpcId:props.cluster.vpc.vpcId,image:{repository:props.repository??"602401143452.dkr.ecr.us-west-2.amazonaws.com/amazon/aws-load-balancer-controller",tag:props.version.version}}});constructs_1.Node.of(chart).addDependency(serviceAccount),constructs_1.Node.of(chart).addDependency(props.cluster.openIdConnectProvider),constructs_1.Node.of(chart).addDependency(props.cluster.awsAuth)}static create(scope,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_AlbControllerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.create),error}const stack=core_1.Stack.of(scope),uid=AlbController.uid(props.cluster);return new AlbController(stack,uid,props)}static uid(cluster){return`${core_1.Names.nodeUniqueId(cluster.node)}-AlbController`}}exports.AlbController=AlbController,_b=JSII_RTTI_SYMBOL_1,AlbController[_b]={fqn:"aws-cdk-lib.aws_eks.AlbController",version:"2.42.0"};
//# sourceMappingURL=alb-controller.js.map
