"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NetworkTargetGroup=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../../aws-cloudwatch"),cdk=require("../../../core"),base_target_group_1=require("../shared/base-target-group"),enums_1=require("../shared/enums"),imported_1=require("../shared/imported"),util_1=require("../shared/util");class NetworkTargetGroup extends base_target_group_1.TargetGroupBase{constructor(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_NetworkTargetGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NetworkTargetGroup),error}const proto=props.protocol||enums_1.Protocol.TCP;util_1.validateNetworkProtocol(proto),super(scope,id,props,{protocol:proto,port:props.port}),this.listeners=[],props.proxyProtocolV2!=null&&this.setAttribute("proxy_protocol_v2.enabled",props.proxyProtocolV2?"true":"false"),props.preserveClientIp!==void 0&&this.setAttribute("preserve_client_ip.enabled",props.preserveClientIp?"true":"false"),props.connectionTermination!==void 0&&this.setAttribute("deregistration_delay.connection_termination.enabled",props.connectionTermination?"true":"false"),this.addTarget(...props.targets||[])}static fromTargetGroupAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_TargetGroupAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTargetGroupAttributes),error}return new ImportedNetworkTargetGroup(scope,id,attrs)}static import(scope,id,props){return NetworkTargetGroup.fromTargetGroupAttributes(scope,id,props)}addTarget(...targets){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_INetworkLoadBalancerTarget(targets)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTarget),error}for(const target of targets){const result=target.attachToNetworkTargetGroup(this);this.addLoadBalancerTarget(result)}}registerListener(listener){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_INetworkListener(listener)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerListener),error}this.loadBalancerAttachedDependencies.add(listener),this.listeners.push(listener)}metricHealthyHostCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHealthyHostCount),error}return this.metric("HealthyHostCount",{statistic:"Average",...props})}metricUnHealthyHostCount(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricUnHealthyHostCount),error}return this.metric("UnHealthyHostCount",{statistic:"Average",...props})}get firstLoadBalancerFullName(){if(this.listeners.length===0)throw new Error("The TargetGroup needs to be attached to a LoadBalancer before you can call this method");return base_target_group_1.loadBalancerNameFromListenerArn(this.listeners[0].listenerArn)}validateTargetGroup(){const ret=super.validateTargetGroup(),healthCheck=this.healthCheck||{},allowedIntervals=[10,30];if(healthCheck.interval){const seconds=healthCheck.interval.toSeconds();!cdk.Token.isUnresolved(seconds)&&!allowedIntervals.includes(seconds)&&ret.push(`Health check interval '${seconds}' not supported. Must be one of the following values '${allowedIntervals.join(",")}'.`)}if(healthCheck.healthyThresholdCount){const thresholdCount=healthCheck.healthyThresholdCount;(thresholdCount<2||thresholdCount>10)&&ret.push(`Healthy Threshold Count '${thresholdCount}' not supported. Must be a number between 2 and 10.`)}if(healthCheck.unhealthyThresholdCount){const thresholdCount=healthCheck.unhealthyThresholdCount;(thresholdCount<2||thresholdCount>10)&&ret.push(`Unhealthy Threshold Count '${thresholdCount}' not supported. Must be a number between 2 and 10.`)}return healthCheck.healthyThresholdCount&&healthCheck.unhealthyThresholdCount&&healthCheck.healthyThresholdCount!==healthCheck.unhealthyThresholdCount&&ret.push([`Healthy and Unhealthy Threshold Counts must be the same: ${healthCheck.healthyThresholdCount}`,`is not equal to ${healthCheck.unhealthyThresholdCount}.`].join(" ")),healthCheck.protocol&&(NLB_HEALTH_CHECK_PROTOCOLS.includes(healthCheck.protocol)||ret.push(`Health check protocol '${healthCheck.protocol}' is not supported. Must be one of [${NLB_HEALTH_CHECK_PROTOCOLS.join(", ")}]`),healthCheck.path&&!NLB_PATH_HEALTH_CHECK_PROTOCOLS.includes(healthCheck.protocol)&&ret.push([`'${healthCheck.protocol}' health checks do not support the path property.`,`Must be one of [${NLB_PATH_HEALTH_CHECK_PROTOCOLS.join(", ")}]`].join(" ")),healthCheck.timeout&&healthCheck.timeout.toSeconds()!==NLB_HEALTH_CHECK_TIMEOUTS[healthCheck.protocol]&&ret.push(["Custom health check timeouts are not supported for Network Load Balancer health checks.",`Expected ${NLB_HEALTH_CHECK_TIMEOUTS[healthCheck.protocol]} seconds for ${healthCheck.protocol}, got ${healthCheck.timeout.toSeconds()}`].join(" "))),ret}metric(metricName,props){return new cloudwatch.Metric({namespace:"AWS/NetworkELB",metricName,dimensionsMap:{LoadBalancer:this.firstLoadBalancerFullName,TargetGroup:this.targetGroupFullName},...props}).attachTo(this)}}exports.NetworkTargetGroup=NetworkTargetGroup,_a=JSII_RTTI_SYMBOL_1,NetworkTargetGroup[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup",version:"2.42.0"};class ImportedNetworkTargetGroup extends imported_1.ImportedTargetGroupBase{registerListener(_listener){}addTarget(...targets){for(const target of targets)if(target.attachToNetworkTargetGroup(this).targetJson!==void 0)throw new Error("Cannot add a non-self registering target to an imported TargetGroup. Create a new TargetGroup instead.")}}const NLB_HEALTH_CHECK_PROTOCOLS=[enums_1.Protocol.HTTP,enums_1.Protocol.HTTPS,enums_1.Protocol.TCP],NLB_PATH_HEALTH_CHECK_PROTOCOLS=[enums_1.Protocol.HTTP,enums_1.Protocol.HTTPS],NLB_HEALTH_CHECK_TIMEOUTS={[enums_1.Protocol.HTTP]:6,[enums_1.Protocol.HTTPS]:10,[enums_1.Protocol.TCP]:10};
//# sourceMappingURL=network-target-group.js.map
