"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnApplication=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnApplicationPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("autoStartConfiguration",CfnApplication_AutoStartConfigurationPropertyValidator)(properties.autoStartConfiguration)),errors.collect(cdk.propertyValidator("autoStopConfiguration",CfnApplication_AutoStopConfigurationPropertyValidator)(properties.autoStopConfiguration)),errors.collect(cdk.propertyValidator("initialCapacity",cdk.listValidator(CfnApplication_InitialCapacityConfigKeyValuePairPropertyValidator))(properties.initialCapacity)),errors.collect(cdk.propertyValidator("maximumCapacity",CfnApplication_MaximumAllowedResourcesPropertyValidator)(properties.maximumCapacity)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("networkConfiguration",CfnApplication_NetworkConfigurationPropertyValidator)(properties.networkConfiguration)),errors.collect(cdk.propertyValidator("releaseLabel",cdk.requiredValidator)(properties.releaseLabel)),errors.collect(cdk.propertyValidator("releaseLabel",cdk.validateString)(properties.releaseLabel)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "CfnApplicationProps"')}function cfnApplicationPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationPropsValidator(properties).assertSuccess(),{ReleaseLabel:cdk.stringToCloudFormation(properties.releaseLabel),Type:cdk.stringToCloudFormation(properties.type),AutoStartConfiguration:cfnApplicationAutoStartConfigurationPropertyToCloudFormation(properties.autoStartConfiguration),AutoStopConfiguration:cfnApplicationAutoStopConfigurationPropertyToCloudFormation(properties.autoStopConfiguration),InitialCapacity:cdk.listMapper(cfnApplicationInitialCapacityConfigKeyValuePairPropertyToCloudFormation)(properties.initialCapacity),MaximumCapacity:cfnApplicationMaximumAllowedResourcesPropertyToCloudFormation(properties.maximumCapacity),Name:cdk.stringToCloudFormation(properties.name),NetworkConfiguration:cfnApplicationNetworkConfigurationPropertyToCloudFormation(properties.networkConfiguration),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnApplicationPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("releaseLabel","ReleaseLabel",cfn_parse.FromCloudFormation.getString(properties.ReleaseLabel)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addPropertyResult("autoStartConfiguration","AutoStartConfiguration",properties.AutoStartConfiguration!=null?CfnApplicationAutoStartConfigurationPropertyFromCloudFormation(properties.AutoStartConfiguration):void 0),ret.addPropertyResult("autoStopConfiguration","AutoStopConfiguration",properties.AutoStopConfiguration!=null?CfnApplicationAutoStopConfigurationPropertyFromCloudFormation(properties.AutoStopConfiguration):void 0),ret.addPropertyResult("initialCapacity","InitialCapacity",properties.InitialCapacity!=null?cfn_parse.FromCloudFormation.getArray(CfnApplicationInitialCapacityConfigKeyValuePairPropertyFromCloudFormation)(properties.InitialCapacity):void 0),ret.addPropertyResult("maximumCapacity","MaximumCapacity",properties.MaximumCapacity!=null?CfnApplicationMaximumAllowedResourcesPropertyFromCloudFormation(properties.MaximumCapacity):void 0),ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addPropertyResult("networkConfiguration","NetworkConfiguration",properties.NetworkConfiguration!=null?CfnApplicationNetworkConfigurationPropertyFromCloudFormation(properties.NetworkConfiguration):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplication extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnApplication.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_emrserverless_CfnApplicationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplication),error}cdk.requireProperty(props,"releaseLabel",this),cdk.requireProperty(props,"type",this),this.attrApplicationId=cdk.Token.asString(this.getAtt("ApplicationId")),this.attrArn=cdk.Token.asString(this.getAtt("Arn")),this.releaseLabel=props.releaseLabel,this.type=props.type,this.autoStartConfiguration=props.autoStartConfiguration,this.autoStopConfiguration=props.autoStopConfiguration,this.initialCapacity=props.initialCapacity,this.maximumCapacity=props.maximumCapacity,this.name=props.name,this.networkConfiguration=props.networkConfiguration,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::EMRServerless::Application",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationPropsFromCloudFormation(resourceProperties),ret=new CfnApplication(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplication.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{releaseLabel:this.releaseLabel,type:this.type,autoStartConfiguration:this.autoStartConfiguration,autoStopConfiguration:this.autoStopConfiguration,initialCapacity:this.initialCapacity,maximumCapacity:this.maximumCapacity,name:this.name,networkConfiguration:this.networkConfiguration,tags:this.tags.renderTags()}}renderProperties(props){return cfnApplicationPropsToCloudFormation(props)}}exports.CfnApplication=CfnApplication,_a=JSII_RTTI_SYMBOL_1,CfnApplication[_a]={fqn:"aws-cdk-lib.aws_emrserverless.CfnApplication",version:"2.42.0"},CfnApplication.CFN_RESOURCE_TYPE_NAME="AWS::EMRServerless::Application";function CfnApplication_AutoStartConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.wrap('supplied properties not correct for "AutoStartConfigurationProperty"')}function cfnApplicationAutoStartConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_AutoStartConfigurationPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled)}):properties}function CfnApplicationAutoStartConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_AutoStopConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("idleTimeoutMinutes",cdk.validateNumber)(properties.idleTimeoutMinutes)),errors.wrap('supplied properties not correct for "AutoStopConfigurationProperty"')}function cfnApplicationAutoStopConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_AutoStopConfigurationPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled),IdleTimeoutMinutes:cdk.numberToCloudFormation(properties.idleTimeoutMinutes)}):properties}function CfnApplicationAutoStopConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("idleTimeoutMinutes","IdleTimeoutMinutes",properties.IdleTimeoutMinutes!=null?cfn_parse.FromCloudFormation.getNumber(properties.IdleTimeoutMinutes):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InitialCapacityConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("workerConfiguration",cdk.requiredValidator)(properties.workerConfiguration)),errors.collect(cdk.propertyValidator("workerConfiguration",CfnApplication_WorkerConfigurationPropertyValidator)(properties.workerConfiguration)),errors.collect(cdk.propertyValidator("workerCount",cdk.requiredValidator)(properties.workerCount)),errors.collect(cdk.propertyValidator("workerCount",cdk.validateNumber)(properties.workerCount)),errors.wrap('supplied properties not correct for "InitialCapacityConfigProperty"')}function cfnApplicationInitialCapacityConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InitialCapacityConfigPropertyValidator(properties).assertSuccess(),{WorkerConfiguration:cfnApplicationWorkerConfigurationPropertyToCloudFormation(properties.workerConfiguration),WorkerCount:cdk.numberToCloudFormation(properties.workerCount)}):properties}function CfnApplicationInitialCapacityConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("workerConfiguration","WorkerConfiguration",CfnApplicationWorkerConfigurationPropertyFromCloudFormation(properties.WorkerConfiguration)),ret.addPropertyResult("workerCount","WorkerCount",cfn_parse.FromCloudFormation.getNumber(properties.WorkerCount)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InitialCapacityConfigKeyValuePairPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("key",cdk.requiredValidator)(properties.key)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("value",cdk.requiredValidator)(properties.value)),errors.collect(cdk.propertyValidator("value",CfnApplication_InitialCapacityConfigPropertyValidator)(properties.value)),errors.wrap('supplied properties not correct for "InitialCapacityConfigKeyValuePairProperty"')}function cfnApplicationInitialCapacityConfigKeyValuePairPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InitialCapacityConfigKeyValuePairPropertyValidator(properties).assertSuccess(),{Key:cdk.stringToCloudFormation(properties.key),Value:cfnApplicationInitialCapacityConfigPropertyToCloudFormation(properties.value)}):properties}function CfnApplicationInitialCapacityConfigKeyValuePairPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("key","Key",cfn_parse.FromCloudFormation.getString(properties.Key)),ret.addPropertyResult("value","Value",CfnApplicationInitialCapacityConfigPropertyFromCloudFormation(properties.Value)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_MaximumAllowedResourcesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("cpu",cdk.requiredValidator)(properties.cpu)),errors.collect(cdk.propertyValidator("cpu",cdk.validateString)(properties.cpu)),errors.collect(cdk.propertyValidator("disk",cdk.validateString)(properties.disk)),errors.collect(cdk.propertyValidator("memory",cdk.requiredValidator)(properties.memory)),errors.collect(cdk.propertyValidator("memory",cdk.validateString)(properties.memory)),errors.wrap('supplied properties not correct for "MaximumAllowedResourcesProperty"')}function cfnApplicationMaximumAllowedResourcesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_MaximumAllowedResourcesPropertyValidator(properties).assertSuccess(),{Cpu:cdk.stringToCloudFormation(properties.cpu),Disk:cdk.stringToCloudFormation(properties.disk),Memory:cdk.stringToCloudFormation(properties.memory)}):properties}function CfnApplicationMaximumAllowedResourcesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("cpu","Cpu",cfn_parse.FromCloudFormation.getString(properties.Cpu)),ret.addPropertyResult("disk","Disk",properties.Disk!=null?cfn_parse.FromCloudFormation.getString(properties.Disk):void 0),ret.addPropertyResult("memory","Memory",cfn_parse.FromCloudFormation.getString(properties.Memory)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_NetworkConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("securityGroupIds",cdk.listValidator(cdk.validateString))(properties.securityGroupIds)),errors.collect(cdk.propertyValidator("subnetIds",cdk.listValidator(cdk.validateString))(properties.subnetIds)),errors.wrap('supplied properties not correct for "NetworkConfigurationProperty"')}function cfnApplicationNetworkConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_NetworkConfigurationPropertyValidator(properties).assertSuccess(),{SecurityGroupIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),SubnetIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds)}):properties}function CfnApplicationNetworkConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("securityGroupIds","SecurityGroupIds",properties.SecurityGroupIds!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds):void 0),ret.addPropertyResult("subnetIds","SubnetIds",properties.SubnetIds!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_WorkerConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("cpu",cdk.requiredValidator)(properties.cpu)),errors.collect(cdk.propertyValidator("cpu",cdk.validateString)(properties.cpu)),errors.collect(cdk.propertyValidator("disk",cdk.validateString)(properties.disk)),errors.collect(cdk.propertyValidator("memory",cdk.requiredValidator)(properties.memory)),errors.collect(cdk.propertyValidator("memory",cdk.validateString)(properties.memory)),errors.wrap('supplied properties not correct for "WorkerConfigurationProperty"')}function cfnApplicationWorkerConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_WorkerConfigurationPropertyValidator(properties).assertSuccess(),{Cpu:cdk.stringToCloudFormation(properties.cpu),Disk:cdk.stringToCloudFormation(properties.disk),Memory:cdk.stringToCloudFormation(properties.memory)}):properties}function CfnApplicationWorkerConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("cpu","Cpu",cfn_parse.FromCloudFormation.getString(properties.Cpu)),ret.addPropertyResult("disk","Disk",properties.Disk!=null?cfn_parse.FromCloudFormation.getString(properties.Disk):void 0),ret.addPropertyResult("memory","Memory",cfn_parse.FromCloudFormation.getString(properties.Memory)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
//# sourceMappingURL=emrserverless.generated.js.map
