"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LustreFileSystem=exports.LustreDataCompressionType=exports.LustreAutoImportPolicy=exports.LustreDeploymentType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_ec2_1=require("../../aws-ec2"),core_1=require("../../core"),file_system_1=require("./file-system"),fsx_generated_1=require("./fsx.generated");var LustreDeploymentType;(function(LustreDeploymentType2){LustreDeploymentType2.SCRATCH_1="SCRATCH_1",LustreDeploymentType2.SCRATCH_2="SCRATCH_2",LustreDeploymentType2.PERSISTENT_1="PERSISTENT_1",LustreDeploymentType2.PERSISTENT_2="PERSISTENT_2"})(LustreDeploymentType=exports.LustreDeploymentType||(exports.LustreDeploymentType={}));var LustreAutoImportPolicy;(function(LustreAutoImportPolicy2){LustreAutoImportPolicy2.NONE="NONE",LustreAutoImportPolicy2.NEW="NEW",LustreAutoImportPolicy2.NEW_CHANGED="NEW_CHANGED",LustreAutoImportPolicy2.NEW_CHANGED_DELETED="NEW_CHANGED_DELETED"})(LustreAutoImportPolicy=exports.LustreAutoImportPolicy||(exports.LustreAutoImportPolicy={}));var LustreDataCompressionType;(function(LustreDataCompressionType2){LustreDataCompressionType2.NONE="NONE",LustreDataCompressionType2.LZ4="LZ4"})(LustreDataCompressionType=exports.LustreDataCompressionType||(exports.LustreDataCompressionType={}));class LustreFileSystem extends file_system_1.FileSystemBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_fsx_LustreFileSystemProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LustreFileSystem),error}this.validateProps(props);const updatedLustureProps={importedFileChunkSize:props.lustreConfiguration.importedFileChunkSizeMiB,weeklyMaintenanceStartTime:props.lustreConfiguration.weeklyMaintenanceStartTime?.toTimestamp()},lustreConfiguration=Object.assign({},props.lustreConfiguration,updatedLustureProps),securityGroup=props.securityGroup||new aws_ec2_1.SecurityGroup(this,"FsxLustreSecurityGroup",{vpc:props.vpc});securityGroup.addIngressRule(securityGroup,aws_ec2_1.Port.tcpRange(LustreFileSystem.DEFAULT_PORT_RANGE.startPort,LustreFileSystem.DEFAULT_PORT_RANGE.endPort)),this.connections=LustreFileSystem.configureConnections(securityGroup),this.fileSystem=new fsx_generated_1.CfnFileSystem(this,"Resource",{fileSystemType:LustreFileSystem.DEFAULT_FILE_SYSTEM_TYPE,subnetIds:[props.vpcSubnet.subnetId],backupId:props.backupId,kmsKeyId:props.kmsKey?props.kmsKey.keyId:void 0,lustreConfiguration,securityGroupIds:[securityGroup.securityGroupId],storageCapacity:props.storageCapacityGiB}),this.fileSystem.applyRemovalPolicy(props.removalPolicy),this.fileSystemId=this.fileSystem.ref,this.dnsName=`${this.fileSystemId}.fsx.${this.env.region}.${core_1.Aws.URL_SUFFIX}`,this.mountName=this.fileSystem.attrLustreMountName}static fromLustreFileSystemAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_fsx_FileSystemAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLustreFileSystemAttributes),error}class Import extends file_system_1.FileSystemBase{constructor(){super(...arguments),this.dnsName=attrs.dnsName,this.fileSystemId=attrs.fileSystemId,this.connections=LustreFileSystem.configureConnections(attrs.securityGroup)}}return new Import(scope,id)}static configureConnections(securityGroup){return new aws_ec2_1.Connections({securityGroups:[securityGroup],defaultPort:aws_ec2_1.Port.tcpRange(LustreFileSystem.DEFAULT_PORT_RANGE.startPort,LustreFileSystem.DEFAULT_PORT_RANGE.endPort)})}validateProps(props){const lustreConfiguration=props.lustreConfiguration,deploymentType=lustreConfiguration.deploymentType;this.validateImportPath(lustreConfiguration.importPath),this.validateExportPath(lustreConfiguration.exportPath,lustreConfiguration.importPath),this.validateImportedFileChunkSize(lustreConfiguration.importedFileChunkSizeMiB),this.validateAutoImportPolicy(deploymentType,lustreConfiguration.importPath,lustreConfiguration.autoImportPolicy),this.validatePerUnitStorageThroughput(deploymentType,lustreConfiguration.perUnitStorageThroughput),this.validateStorageCapacity(deploymentType,props.storageCapacityGiB)}validateAutoImportPolicy(deploymentType,importPath,autoImportPolicy){if(autoImportPolicy!==void 0){if(importPath===void 0)throw new Error("autoImportPolicy requires importPath to be defined");if(deploymentType===LustreDeploymentType.PERSISTENT_2)throw new Error("autoImportPolicy is not supported with PERSISTENT_2 deployments")}}validateExportPath(exportPath,importPath){if(exportPath!==void 0){if(importPath===void 0)throw new Error("Cannot define an export path without also defining an import path");if(!(core_1.Token.isUnresolved(exportPath)&&core_1.Token.isUnresolved(importPath))){if(core_1.Token.isUnresolved(importPath)!==core_1.Token.isUnresolved(exportPath))throw new Error("The importPath and exportPath must each be Tokens or not Tokens, you cannot use a mix");if(!exportPath.startsWith(importPath))throw new Error(`The export path "${exportPath}" is invalid. Expecting the format: s3://{IMPORT_PATH}/optional-prefix`);if(exportPath.length>900)throw new Error(`The export path "${exportPath}" exceeds the maximum length of 900 characters`)}}}validateImportedFileChunkSize(importedFileChunkSize){if(importedFileChunkSize!==void 0&&(importedFileChunkSize<1||importedFileChunkSize>512e3))throw new Error(`importedFileChunkSize cannot be ${importedFileChunkSize} MiB. It must be a value from 1 to 512,000 MiB`)}validateImportPath(importPath){if(importPath===void 0||core_1.Token.isUnresolved(importPath))return;const regexp=/^s3:\/\//;if(importPath.search(regexp)===-1)throw new Error(`The import path "${importPath}" is invalid. Expecting the format: s3://{BUCKET_NAME}/optional-prefix`);if(importPath.length>900)throw new Error(`The import path "${importPath}" exceeds the maximum length of 900 characters`)}validatePerUnitStorageThroughput(deploymentType,perUnitStorageThroughput){if(perUnitStorageThroughput!==void 0){if(deploymentType!==LustreDeploymentType.PERSISTENT_1&&deploymentType!==LustreDeploymentType.PERSISTENT_2)throw new Error("perUnitStorageThroughput can only be set for the PERSISTENT_1/PERSISTENT_2 deployment types, received: "+deploymentType);if(deploymentType===LustreDeploymentType.PERSISTENT_1&&![50,100,200].includes(perUnitStorageThroughput))throw new Error("perUnitStorageThroughput must be 50, 100, or 200 MB/s/TiB for PERSISTENT_1 deployment type, got: "+perUnitStorageThroughput);if(deploymentType===LustreDeploymentType.PERSISTENT_2&&![125,250,500,1e3].includes(perUnitStorageThroughput))throw new Error("perUnitStorageThroughput must be 125, 250, 500 or 1000 MB/s/TiB for PERSISTENT_2 deployment type, got: "+perUnitStorageThroughput)}}validateStorageCapacity(deploymentType,storageCapacity){if(deploymentType===LustreDeploymentType.SCRATCH_1){if(![1200,2400,3600].includes(storageCapacity)&&storageCapacity%3600!==0)throw new Error("storageCapacity must be 1,200, 2,400, 3,600, or a multiple of 3,600")}else if(![1200,2400].includes(storageCapacity)&&storageCapacity%2400!==0)throw new Error("storageCapacity must be 1,200, 2,400, or a multiple of 2,400")}}exports.LustreFileSystem=LustreFileSystem,_a=JSII_RTTI_SYMBOL_1,LustreFileSystem[_a]={fqn:"aws-cdk-lib.aws_fsx.LustreFileSystem",version:"2.42.0"},LustreFileSystem.DEFAULT_FILE_SYSTEM_TYPE="LUSTRE",LustreFileSystem.DEFAULT_PORT_RANGE={startPort:988,endPort:1023};
//# sourceMappingURL=lustre-file-system.js.map
