"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.PolicyDocument=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cxapi=require("../../cx-api"),policy_statement_1=require("./policy-statement"),merge_statements_1=require("./private/merge-statements"),postprocess_policy_document_1=require("./private/postprocess-policy-document");class PolicyDocument{constructor(props={}){this.statements=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyDocumentProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,PolicyDocument),error}this.creationStack=cdk.captureStackTrace(),this.autoAssignSids=!!props.assignSids,this.minimize=props.minimize,this.addStatements(...props.statements||[])}static fromJson(obj){const newPolicyDocument=new PolicyDocument,statement=obj.Statement??[];if(statement&&!Array.isArray(statement))throw new Error("Statement must be an array");return newPolicyDocument.addStatements(...obj.Statement.map(s=>policy_statement_1.PolicyStatement.fromJson(s))),newPolicyDocument}resolve(context){try{jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(context)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.resolve),error}this.freezeStatements(),this._maybeMergeStatements(context.scope);const sort=this.shouldMerge(context.scope);return context.registerPostProcessor(new postprocess_policy_document_1.PostProcessPolicyDocument(this.autoAssignSids,sort)),this.render()}get isEmpty(){return this.statements.length===0}get statementCount(){return this.statements.length}addStatements(...statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addStatements),error}this.statements.push(...statement)}toString(){return cdk.Token.asString(this,{displayHint:"PolicyDocument"})}toJSON(){return this.render()}validateForAnyPolicy(){const errors=new Array;for(const statement of this.statements)errors.push(...statement.validateForAnyPolicy());return errors}validateForResourcePolicy(){const errors=new Array;for(const statement of this.statements)errors.push(...statement.validateForResourcePolicy());return errors}validateForIdentityPolicy(){const errors=new Array;for(const statement of this.statements)errors.push(...statement.validateForIdentityPolicy());return errors}_maybeMergeStatements(scope){if(this.shouldMerge(scope)){const result=merge_statements_1.mergeStatements(this.statements,{scope});this.statements.splice(0,this.statements.length,...result.mergedStatements)}}_splitDocument(scope,selfMaximumSize,splitMaximumSize){const self=this,newDocs=[];this.freezeStatements();let statementsToOriginals=new Map(this.statements.map(s=>[s,[s]]));const doActualMerging=this.shouldMerge(scope),result=merge_statements_1.mergeStatements(this.statements,{scope,limitSize:!0,mergeIfCombinable:doActualMerging});this.statements.splice(0,this.statements.length,...result.mergedStatements),statementsToOriginals=result.originsMap;const sizeOptions=policy_statement_1.deriveEstimateSizeOptions(scope),statementSizes=new Map(this.statements.map(s=>[s,s._estimateSize(sizeOptions)]));let selfSize=0;const polSizes=new Map,polSize=x=>polSizes.get(x)??0;let i=0;for(;i<this.statements.length;){const statement=this.statements[i],statementSize=statementSizes.get(statement)??0;if(selfSize+statementSize<selfMaximumSize){selfSize+=statementSize,i++;continue}const addToDoc=findDocWithSpace(statementSize);addToDoc.addStatements(statement),polSizes.set(addToDoc,polSize(addToDoc)+statementSize),this.statements.splice(i,1)}const ret=new Map;ret.set(this,this.statements.flatMap(s=>statementsToOriginals.get(s)??[s]));for(const newDoc of newDocs)ret.set(newDoc,newDoc.statements.flatMap(s=>statementsToOriginals.get(s)??[s]));return ret;function findDocWithSpace(size){let j=0;for(;j<newDocs.length&&polSize(newDocs[j])+size>splitMaximumSize;)j++;if(j<newDocs.length)return newDocs[j];const newDoc=new PolicyDocument({assignSids:self.autoAssignSids,minimize:self.minimize});return newDocs.push(newDoc),newDoc}}render(){return this.isEmpty?void 0:{Statement:this.statements.map(s=>s.toStatementJson()),Version:"2012-10-17"}}shouldMerge(scope){return this.minimize??cdk.FeatureFlags.of(scope).isEnabled(cxapi.IAM_MINIMIZE_POLICIES)??!1}freezeStatements(){for(const statement of this.statements)statement.freeze()}}exports.PolicyDocument=PolicyDocument,_a=JSII_RTTI_SYMBOL_1,PolicyDocument[_a]={fqn:"aws-cdk-lib.aws_iam.PolicyDocument",version:"2.42.0"};
//# sourceMappingURL=policy-document.js.map
