"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Role=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../core"),constructs_1=require("constructs"),grant_1=require("./grant"),iam_generated_1=require("./iam.generated"),managed_policy_1=require("./managed-policy"),policy_1=require("./policy"),policy_document_1=require("./policy-document"),principals_1=require("./principals"),assume_role_policy_1=require("./private/assume-role-policy"),immutable_role_1=require("./private/immutable-role"),policydoc_adapter_1=require("./private/policydoc-adapter"),util_1=require("./util"),MAX_INLINE_SIZE=1e4,MAX_MANAGEDPOL_SIZE=6e3;class Role extends core_1.Resource{constructor(scope,id,props){super(scope,id,{physicalName:props.roleName}),this.grantPrincipal=this,this.principalAccount=this.env.account,this.assumeRoleAction="sts:AssumeRole",this.managedPolicies=[],this.attachedPolicies=new util_1.AttachedPolicies,this.dependables=new Map,this._didSplit=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_RoleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Role),error}const externalIds=props.externalIds||[];props.externalId&&externalIds.push(props.externalId),this.assumeRolePolicy=createAssumeRolePolicy(props.assumedBy,externalIds),this.managedPolicies.push(...props.managedPolicies||[]),this.inlinePolicies=props.inlinePolicies||{},this.permissionsBoundary=props.permissionsBoundary;const maxSessionDuration=props.maxSessionDuration&&props.maxSessionDuration.toSeconds();validateMaxSessionDuration(maxSessionDuration);const description=props.description&&props.description?.length>0?props.description:void 0;if(description&&description.length>1e3)throw new Error("Role description must be no longer than 1000 characters.");validateRolePath(props.path);const role=new iam_generated_1.CfnRole(this,"Resource",{assumeRolePolicyDocument:this.assumeRolePolicy,managedPolicyArns:util_1.UniqueStringSet.from(()=>this.managedPolicies.map(p=>p.managedPolicyArn)),policies:_flatten(this.inlinePolicies),path:props.path,permissionsBoundary:this.permissionsBoundary?this.permissionsBoundary.managedPolicyArn:void 0,roleName:this.physicalName,maxSessionDuration,description});this.roleId=role.attrRoleId,this.roleArn=this.getResourceArnAttribute(role.attrArn,{region:"",service:"iam",resource:"role",resourceName:`${props.path?props.path.substr(props.path.charAt(0)==="/"?1:0):""}${this.physicalName}`}),this.roleName=this.getResourceNameAttribute(role.ref),this.policyFragment=new principals_1.ArnPrincipal(this.roleArn).policyFragment;function _flatten(policies){if(policies==null||Object.keys(policies).length===0)return;const result=new Array;for(const policyName of Object.keys(policies)){const policyDocument=policies[policyName];result.push({policyName,policyDocument})}return result}core_1.Aspects.of(this).add({visit:c=>{c===this&&this.splitLargePolicy()}}),this.node.addValidation({validate:()=>this.validateRole()})}static fromRoleArn(scope,id,roleArn,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_FromRoleArnOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromRoleArn),error}const scopeStack=core_1.Stack.of(scope),parsedArn=scopeStack.splitArn(roleArn,core_1.ArnFormat.SLASH_RESOURCE_NAME),resourceName=parsedArn.resourceName,roleAccount=parsedArn.account,roleName=resourceName.split("/").pop();class Import extends core_1.Resource{constructor(_scope,_id){super(_scope,_id,{account:roleAccount}),this.grantPrincipal=this,this.principalAccount=roleAccount,this.assumeRoleAction="sts:AssumeRole",this.policyFragment=new principals_1.ArnPrincipal(roleArn).policyFragment,this.roleArn=roleArn,this.roleName=roleName,this.attachedPolicies=new util_1.AttachedPolicies,this.defaultPolicyName=options.defaultPolicyName}addToPolicy(statement){return this.addToPrincipalPolicy(statement).statementAdded}addToPrincipalPolicy(statement){return this.defaultPolicy||(this.defaultPolicy=new policy_1.Policy(this,this.defaultPolicyName??"Policy"),this.attachInlinePolicy(this.defaultPolicy)),this.defaultPolicy.addStatements(statement),{statementAdded:!0,policyDependable:this.defaultPolicy}}attachInlinePolicy(policy){const thisAndPolicyAccountComparison=core_1.Token.compareStrings(this.env.account,policy.env.account);(thisAndPolicyAccountComparison===core_1.TokenComparison.SAME||thisAndPolicyAccountComparison===core_1.TokenComparison.BOTH_UNRESOLVED||thisAndPolicyAccountComparison===core_1.TokenComparison.ONE_UNRESOLVED)&&(this.attachedPolicies.attach(policy),policy.attachToRole(this))}addManagedPolicy(_policy){}grantPassRole(identity){return this.grant(identity,"iam:PassRole")}grantAssumeRole(identity){return this.grant(identity,"sts:AssumeRole")}grant(grantee,...actions){return grant_1.Grant.addToPrincipal({grantee,actions,resourceArns:[this.roleArn],scope:this})}dedupeString(){return`ImportedRole:${roleArn}`}}if(options.addGrantsToResources!==void 0&&options.mutable!==!1)throw new Error("'addGrantsToResources' can only be passed if 'mutable: false'");const roleArnAndScopeStackAccountComparison=core_1.Token.compareStrings(roleAccount??"",scopeStack.account),equalOrAnyUnresolved=roleArnAndScopeStackAccountComparison===core_1.TokenComparison.SAME||roleArnAndScopeStackAccountComparison===core_1.TokenComparison.BOTH_UNRESOLVED||roleArnAndScopeStackAccountComparison===core_1.TokenComparison.ONE_UNRESOLVED,mutableRoleId=options.mutable!==!1&&equalOrAnyUnresolved?id:`MutableRole${id}`,importedRole=new Import(scope,mutableRoleId);return options.mutable!==!1&&equalOrAnyUnresolved?importedRole:new immutable_role_1.ImmutableRole(scope,id,importedRole,options.addGrantsToResources??!1)}static fromRoleName(scope,id,roleName,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_FromRoleNameOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromRoleName),error}return Role.fromRoleArn(scope,id,core_1.Stack.of(scope).formatArn({region:"",service:"iam",resource:"role",resourceName:roleName}),options)}addToPrincipalPolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToPrincipalPolicy),error}this.defaultPolicy||(this.defaultPolicy=new policy_1.Policy(this,"DefaultPolicy"),this.attachInlinePolicy(this.defaultPolicy)),this.defaultPolicy.addStatements(statement);const policyDependable=new constructs_1.DependencyGroup;return this.dependables.set(statement,policyDependable),{statementAdded:!0,policyDependable}}addToPolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToPolicy),error}return this.addToPrincipalPolicy(statement).statementAdded}addManagedPolicy(policy){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IManagedPolicy(policy)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addManagedPolicy),error}this.managedPolicies.find(mp=>mp===policy)||this.managedPolicies.push(policy)}attachInlinePolicy(policy){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_Policy(policy)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachInlinePolicy),error}this.attachedPolicies.attach(policy),policy.attachToRole(this)}grant(grantee,...actions){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IPrincipal(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grant),error}return grant_1.Grant.addToPrincipal({grantee,actions,resourceArns:[this.roleArn],scope:this})}grantPassRole(identity){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IPrincipal(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantPassRole),error}return this.grant(identity,"iam:PassRole")}grantAssumeRole(identity){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IPrincipal(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantAssumeRole),error}return this.grant(identity,"sts:AssumeRole")}withoutPolicyUpdates(options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_WithoutPolicyUpdatesOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.withoutPolicyUpdates),error}return this.immutableRole||(this.immutableRole=new immutable_role_1.ImmutableRole(constructs_1.Node.of(this).scope,`ImmutableRole${this.node.id}`,this,options.addGrantsToResources??!1)),this.immutableRole}validateRole(){const errors=new Array;errors.push(...this.assumeRolePolicy?.validateForResourcePolicy()??[]);for(const policy of Object.values(this.inlinePolicies))errors.push(...policy.validateForIdentityPolicy());return errors}splitLargePolicy(){if(!this.defaultPolicy||this._didSplit)return;this._didSplit=!0;const self=this,originalDoc=this.defaultPolicy.document,splitOffDocs=originalDoc._splitDocument(this,MAX_INLINE_SIZE,MAX_MANAGEDPOL_SIZE),mpCount=this.managedPolicies.length+(splitOffDocs.size-1);mpCount>20?core_1.Annotations.of(this).addWarning(`Policy too large: ${mpCount} exceeds the maximum of 20 managed policies attached to a Role`):mpCount>10&&core_1.Annotations.of(this).addWarning(`Policy large: ${mpCount} exceeds 10 managed policies attached to a Role, this requires a quota increase`),markDeclaringConstruct(originalDoc,this.defaultPolicy);let i=1;for(const newDoc of splitOffDocs.keys()){if(newDoc===originalDoc)continue;const mp=new managed_policy_1.ManagedPolicy(this,`OverflowPolicy${i++}`,{description:`Part of the policies for ${this.node.path}`,document:newDoc,roles:[this]});markDeclaringConstruct(newDoc,mp)}function markDeclaringConstruct(doc,declaringConstruct){for(const original of splitOffDocs.get(doc)??[])self.dependables.get(original)?.add(declaringConstruct)}}}exports.Role=Role,_a=JSII_RTTI_SYMBOL_1,Role[_a]={fqn:"aws-cdk-lib.aws_iam.Role",version:"2.42.0"};function createAssumeRolePolicy(principal,externalIds){const actualDoc=new policy_document_1.PolicyDocument,addDoc=externalIds.length===0?actualDoc:new policydoc_adapter_1.MutatingPolicyDocumentAdapter(actualDoc,statement=>(statement.addCondition("StringEquals",{"sts:ExternalId":externalIds.length===1?externalIds[0]:externalIds}),statement));return assume_role_policy_1.defaultAddPrincipalToAssumeRole(principal,addDoc),actualDoc}function validateRolePath(path){if(path===void 0||core_1.Token.isUnresolved(path))return;const validRolePath=/^(\/|\/[\u0021-\u007F]+\/)$/;if(path.length==0||path.length>512)throw new Error(`Role path must be between 1 and 512 characters. The provided role path is ${path.length} characters.`);if(!validRolePath.test(path))throw new Error(`Role path must be either a slash or valid characters (alphanumerics and symbols) surrounded by slashes. Valid characters are unicode characters in [\\u0021-\\u007F]. However, ${path} is provided.`)}function validateMaxSessionDuration(duration){if(duration!==void 0&&(duration<3600||duration>43200))throw new Error(`maxSessionDuration is set to ${duration}, but must be >= 3600sec (1hr) and <= 43200sec (12hrs)`)}
//# sourceMappingURL=role.js.map
