"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnApplicationReferenceDataSource=exports.CfnApplicationOutput=exports.CfnApplication=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnApplicationPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationCode",cdk.validateString)(properties.applicationCode)),errors.collect(cdk.propertyValidator("applicationDescription",cdk.validateString)(properties.applicationDescription)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("inputs",cdk.requiredValidator)(properties.inputs)),errors.collect(cdk.propertyValidator("inputs",cdk.listValidator(CfnApplication_InputPropertyValidator))(properties.inputs)),errors.wrap('supplied properties not correct for "CfnApplicationProps"')}function cfnApplicationPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationPropsValidator(properties).assertSuccess(),{Inputs:cdk.listMapper(cfnApplicationInputPropertyToCloudFormation)(properties.inputs),ApplicationCode:cdk.stringToCloudFormation(properties.applicationCode),ApplicationDescription:cdk.stringToCloudFormation(properties.applicationDescription),ApplicationName:cdk.stringToCloudFormation(properties.applicationName)}):properties}function CfnApplicationPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputs","Inputs",cfn_parse.FromCloudFormation.getArray(CfnApplicationInputPropertyFromCloudFormation)(properties.Inputs)),ret.addPropertyResult("applicationCode","ApplicationCode",properties.ApplicationCode!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationCode):void 0),ret.addPropertyResult("applicationDescription","ApplicationDescription",properties.ApplicationDescription!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationDescription):void 0),ret.addPropertyResult("applicationName","ApplicationName",properties.ApplicationName!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplication extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnApplication.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalytics_CfnApplicationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplication),error}cdk.requireProperty(props,"inputs",this),this.inputs=props.inputs,this.applicationCode=props.applicationCode,this.applicationDescription=props.applicationDescription,this.applicationName=props.applicationName}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationPropsFromCloudFormation(resourceProperties),ret=new CfnApplication(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplication.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{inputs:this.inputs,applicationCode:this.applicationCode,applicationDescription:this.applicationDescription,applicationName:this.applicationName}}renderProperties(props){return cfnApplicationPropsToCloudFormation(props)}}exports.CfnApplication=CfnApplication,_a=JSII_RTTI_SYMBOL_1,CfnApplication[_a]={fqn:"aws-cdk-lib.aws_kinesisanalytics.CfnApplication",version:"2.42.0"},CfnApplication.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalytics::Application";function CfnApplication_CSVMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.requiredValidator)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.validateString)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.requiredValidator)(properties.recordRowDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.validateString)(properties.recordRowDelimiter)),errors.wrap('supplied properties not correct for "CSVMappingParametersProperty"')}function cfnApplicationCSVMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CSVMappingParametersPropertyValidator(properties).assertSuccess(),{RecordColumnDelimiter:cdk.stringToCloudFormation(properties.recordColumnDelimiter),RecordRowDelimiter:cdk.stringToCloudFormation(properties.recordRowDelimiter)}):properties}function CfnApplicationCSVMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumnDelimiter","RecordColumnDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordColumnDelimiter)),ret.addPropertyResult("recordRowDelimiter","RecordRowDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordRowDelimiter)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputParallelism",CfnApplication_InputParallelismPropertyValidator)(properties.inputParallelism)),errors.collect(cdk.propertyValidator("inputProcessingConfiguration",CfnApplication_InputProcessingConfigurationPropertyValidator)(properties.inputProcessingConfiguration)),errors.collect(cdk.propertyValidator("inputSchema",cdk.requiredValidator)(properties.inputSchema)),errors.collect(cdk.propertyValidator("inputSchema",CfnApplication_InputSchemaPropertyValidator)(properties.inputSchema)),errors.collect(cdk.propertyValidator("kinesisFirehoseInput",CfnApplication_KinesisFirehoseInputPropertyValidator)(properties.kinesisFirehoseInput)),errors.collect(cdk.propertyValidator("kinesisStreamsInput",CfnApplication_KinesisStreamsInputPropertyValidator)(properties.kinesisStreamsInput)),errors.collect(cdk.propertyValidator("namePrefix",cdk.requiredValidator)(properties.namePrefix)),errors.collect(cdk.propertyValidator("namePrefix",cdk.validateString)(properties.namePrefix)),errors.wrap('supplied properties not correct for "InputProperty"')}function cfnApplicationInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputPropertyValidator(properties).assertSuccess(),{InputParallelism:cfnApplicationInputParallelismPropertyToCloudFormation(properties.inputParallelism),InputProcessingConfiguration:cfnApplicationInputProcessingConfigurationPropertyToCloudFormation(properties.inputProcessingConfiguration),InputSchema:cfnApplicationInputSchemaPropertyToCloudFormation(properties.inputSchema),KinesisFirehoseInput:cfnApplicationKinesisFirehoseInputPropertyToCloudFormation(properties.kinesisFirehoseInput),KinesisStreamsInput:cfnApplicationKinesisStreamsInputPropertyToCloudFormation(properties.kinesisStreamsInput),NamePrefix:cdk.stringToCloudFormation(properties.namePrefix)}):properties}function CfnApplicationInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputParallelism","InputParallelism",properties.InputParallelism!=null?CfnApplicationInputParallelismPropertyFromCloudFormation(properties.InputParallelism):void 0),ret.addPropertyResult("inputProcessingConfiguration","InputProcessingConfiguration",properties.InputProcessingConfiguration!=null?CfnApplicationInputProcessingConfigurationPropertyFromCloudFormation(properties.InputProcessingConfiguration):void 0),ret.addPropertyResult("inputSchema","InputSchema",CfnApplicationInputSchemaPropertyFromCloudFormation(properties.InputSchema)),ret.addPropertyResult("kinesisFirehoseInput","KinesisFirehoseInput",properties.KinesisFirehoseInput!=null?CfnApplicationKinesisFirehoseInputPropertyFromCloudFormation(properties.KinesisFirehoseInput):void 0),ret.addPropertyResult("kinesisStreamsInput","KinesisStreamsInput",properties.KinesisStreamsInput!=null?CfnApplicationKinesisStreamsInputPropertyFromCloudFormation(properties.KinesisStreamsInput):void 0),ret.addPropertyResult("namePrefix","NamePrefix",cfn_parse.FromCloudFormation.getString(properties.NamePrefix)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputLambdaProcessorPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "InputLambdaProcessorProperty"')}function cfnApplicationInputLambdaProcessorPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputLambdaProcessorPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationInputLambdaProcessorPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputParallelismPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("count",cdk.validateNumber)(properties.count)),errors.wrap('supplied properties not correct for "InputParallelismProperty"')}function cfnApplicationInputParallelismPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputParallelismPropertyValidator(properties).assertSuccess(),{Count:cdk.numberToCloudFormation(properties.count)}):properties}function CfnApplicationInputParallelismPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("count","Count",properties.Count!=null?cfn_parse.FromCloudFormation.getNumber(properties.Count):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputProcessingConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputLambdaProcessor",CfnApplication_InputLambdaProcessorPropertyValidator)(properties.inputLambdaProcessor)),errors.wrap('supplied properties not correct for "InputProcessingConfigurationProperty"')}function cfnApplicationInputProcessingConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputProcessingConfigurationPropertyValidator(properties).assertSuccess(),{InputLambdaProcessor:cfnApplicationInputLambdaProcessorPropertyToCloudFormation(properties.inputLambdaProcessor)}):properties}function CfnApplicationInputProcessingConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputLambdaProcessor","InputLambdaProcessor",properties.InputLambdaProcessor!=null?CfnApplicationInputLambdaProcessorPropertyFromCloudFormation(properties.InputLambdaProcessor):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumns",cdk.requiredValidator)(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordColumns",cdk.listValidator(CfnApplication_RecordColumnPropertyValidator))(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordEncoding",cdk.validateString)(properties.recordEncoding)),errors.collect(cdk.propertyValidator("recordFormat",cdk.requiredValidator)(properties.recordFormat)),errors.collect(cdk.propertyValidator("recordFormat",CfnApplication_RecordFormatPropertyValidator)(properties.recordFormat)),errors.wrap('supplied properties not correct for "InputSchemaProperty"')}function cfnApplicationInputSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputSchemaPropertyValidator(properties).assertSuccess(),{RecordColumns:cdk.listMapper(cfnApplicationRecordColumnPropertyToCloudFormation)(properties.recordColumns),RecordEncoding:cdk.stringToCloudFormation(properties.recordEncoding),RecordFormat:cfnApplicationRecordFormatPropertyToCloudFormation(properties.recordFormat)}):properties}function CfnApplicationInputSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumns","RecordColumns",cfn_parse.FromCloudFormation.getArray(CfnApplicationRecordColumnPropertyFromCloudFormation)(properties.RecordColumns)),ret.addPropertyResult("recordEncoding","RecordEncoding",properties.RecordEncoding!=null?cfn_parse.FromCloudFormation.getString(properties.RecordEncoding):void 0),ret.addPropertyResult("recordFormat","RecordFormat",CfnApplicationRecordFormatPropertyFromCloudFormation(properties.RecordFormat)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_JSONMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordRowPath",cdk.requiredValidator)(properties.recordRowPath)),errors.collect(cdk.propertyValidator("recordRowPath",cdk.validateString)(properties.recordRowPath)),errors.wrap('supplied properties not correct for "JSONMappingParametersProperty"')}function cfnApplicationJSONMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_JSONMappingParametersPropertyValidator(properties).assertSuccess(),{RecordRowPath:cdk.stringToCloudFormation(properties.recordRowPath)}):properties}function CfnApplicationJSONMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordRowPath","RecordRowPath",cfn_parse.FromCloudFormation.getString(properties.RecordRowPath)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_KinesisFirehoseInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "KinesisFirehoseInputProperty"')}function cfnApplicationKinesisFirehoseInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_KinesisFirehoseInputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationKinesisFirehoseInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_KinesisStreamsInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "KinesisStreamsInputProperty"')}function cfnApplicationKinesisStreamsInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_KinesisStreamsInputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationKinesisStreamsInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_MappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csvMappingParameters",CfnApplication_CSVMappingParametersPropertyValidator)(properties.csvMappingParameters)),errors.collect(cdk.propertyValidator("jsonMappingParameters",CfnApplication_JSONMappingParametersPropertyValidator)(properties.jsonMappingParameters)),errors.wrap('supplied properties not correct for "MappingParametersProperty"')}function cfnApplicationMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_MappingParametersPropertyValidator(properties).assertSuccess(),{CSVMappingParameters:cfnApplicationCSVMappingParametersPropertyToCloudFormation(properties.csvMappingParameters),JSONMappingParameters:cfnApplicationJSONMappingParametersPropertyToCloudFormation(properties.jsonMappingParameters)}):properties}function CfnApplicationMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csvMappingParameters","CSVMappingParameters",properties.CSVMappingParameters!=null?CfnApplicationCSVMappingParametersPropertyFromCloudFormation(properties.CSVMappingParameters):void 0),ret.addPropertyResult("jsonMappingParameters","JSONMappingParameters",properties.JSONMappingParameters!=null?CfnApplicationJSONMappingParametersPropertyFromCloudFormation(properties.JSONMappingParameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_RecordColumnPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mapping",cdk.validateString)(properties.mapping)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("sqlType",cdk.requiredValidator)(properties.sqlType)),errors.collect(cdk.propertyValidator("sqlType",cdk.validateString)(properties.sqlType)),errors.wrap('supplied properties not correct for "RecordColumnProperty"')}function cfnApplicationRecordColumnPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_RecordColumnPropertyValidator(properties).assertSuccess(),{Mapping:cdk.stringToCloudFormation(properties.mapping),Name:cdk.stringToCloudFormation(properties.name),SqlType:cdk.stringToCloudFormation(properties.sqlType)}):properties}function CfnApplicationRecordColumnPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mapping","Mapping",properties.Mapping!=null?cfn_parse.FromCloudFormation.getString(properties.Mapping):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("sqlType","SqlType",cfn_parse.FromCloudFormation.getString(properties.SqlType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_RecordFormatPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mappingParameters",CfnApplication_MappingParametersPropertyValidator)(properties.mappingParameters)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.requiredValidator)(properties.recordFormatType)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "RecordFormatProperty"')}function cfnApplicationRecordFormatPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_RecordFormatPropertyValidator(properties).assertSuccess(),{MappingParameters:cfnApplicationMappingParametersPropertyToCloudFormation(properties.mappingParameters),RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationRecordFormatPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mappingParameters","MappingParameters",properties.MappingParameters!=null?CfnApplicationMappingParametersPropertyFromCloudFormation(properties.MappingParameters):void 0),ret.addPropertyResult("recordFormatType","RecordFormatType",cfn_parse.FromCloudFormation.getString(properties.RecordFormatType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutputPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationName",cdk.requiredValidator)(properties.applicationName)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("output",cdk.requiredValidator)(properties.output)),errors.collect(cdk.propertyValidator("output",CfnApplicationOutput_OutputPropertyValidator)(properties.output)),errors.wrap('supplied properties not correct for "CfnApplicationOutputProps"')}function cfnApplicationOutputPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutputPropsValidator(properties).assertSuccess(),{ApplicationName:cdk.stringToCloudFormation(properties.applicationName),Output:cfnApplicationOutputOutputPropertyToCloudFormation(properties.output)}):properties}function CfnApplicationOutputPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationName","ApplicationName",cfn_parse.FromCloudFormation.getString(properties.ApplicationName)),ret.addPropertyResult("output","Output",CfnApplicationOutputOutputPropertyFromCloudFormation(properties.Output)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplicationOutput extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalytics_CfnApplicationOutputProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplicationOutput),error}cdk.requireProperty(props,"applicationName",this),cdk.requireProperty(props,"output",this),this.applicationName=props.applicationName,this.output=props.output}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationOutputPropsFromCloudFormation(resourceProperties),ret=new CfnApplicationOutput(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{applicationName:this.applicationName,output:this.output}}renderProperties(props){return cfnApplicationOutputPropsToCloudFormation(props)}}exports.CfnApplicationOutput=CfnApplicationOutput,_b=JSII_RTTI_SYMBOL_1,CfnApplicationOutput[_b]={fqn:"aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput",version:"2.42.0"},CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalytics::ApplicationOutput";function CfnApplicationOutput_DestinationSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "DestinationSchemaProperty"')}function cfnApplicationOutputDestinationSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_DestinationSchemaPropertyValidator(properties).assertSuccess(),{RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationOutputDestinationSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordFormatType","RecordFormatType",properties.RecordFormatType!=null?cfn_parse.FromCloudFormation.getString(properties.RecordFormatType):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "KinesisFirehoseOutputProperty"')}function cfnApplicationOutputKinesisFirehoseOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationOutputKinesisFirehoseOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_KinesisStreamsOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "KinesisStreamsOutputProperty"')}function cfnApplicationOutputKinesisStreamsOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_KinesisStreamsOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationOutputKinesisStreamsOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_LambdaOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "LambdaOutputProperty"')}function cfnApplicationOutputLambdaOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_LambdaOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn),RoleARN:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnApplicationOutputLambdaOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addPropertyResult("roleArn","RoleARN",cfn_parse.FromCloudFormation.getString(properties.RoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_OutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("destinationSchema",cdk.requiredValidator)(properties.destinationSchema)),errors.collect(cdk.propertyValidator("destinationSchema",CfnApplicationOutput_DestinationSchemaPropertyValidator)(properties.destinationSchema)),errors.collect(cdk.propertyValidator("kinesisFirehoseOutput",CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator)(properties.kinesisFirehoseOutput)),errors.collect(cdk.propertyValidator("kinesisStreamsOutput",CfnApplicationOutput_KinesisStreamsOutputPropertyValidator)(properties.kinesisStreamsOutput)),errors.collect(cdk.propertyValidator("lambdaOutput",CfnApplicationOutput_LambdaOutputPropertyValidator)(properties.lambdaOutput)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.wrap('supplied properties not correct for "OutputProperty"')}function cfnApplicationOutputOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_OutputPropertyValidator(properties).assertSuccess(),{DestinationSchema:cfnApplicationOutputDestinationSchemaPropertyToCloudFormation(properties.destinationSchema),KinesisFirehoseOutput:cfnApplicationOutputKinesisFirehoseOutputPropertyToCloudFormation(properties.kinesisFirehoseOutput),KinesisStreamsOutput:cfnApplicationOutputKinesisStreamsOutputPropertyToCloudFormation(properties.kinesisStreamsOutput),LambdaOutput:cfnApplicationOutputLambdaOutputPropertyToCloudFormation(properties.lambdaOutput),Name:cdk.stringToCloudFormation(properties.name)}):properties}function CfnApplicationOutputOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("destinationSchema","DestinationSchema",CfnApplicationOutputDestinationSchemaPropertyFromCloudFormation(properties.DestinationSchema)),ret.addPropertyResult("kinesisFirehoseOutput","KinesisFirehoseOutput",properties.KinesisFirehoseOutput!=null?CfnApplicationOutputKinesisFirehoseOutputPropertyFromCloudFormation(properties.KinesisFirehoseOutput):void 0),ret.addPropertyResult("kinesisStreamsOutput","KinesisStreamsOutput",properties.KinesisStreamsOutput!=null?CfnApplicationOutputKinesisStreamsOutputPropertyFromCloudFormation(properties.KinesisStreamsOutput):void 0),ret.addPropertyResult("lambdaOutput","LambdaOutput",properties.LambdaOutput!=null?CfnApplicationOutputLambdaOutputPropertyFromCloudFormation(properties.LambdaOutput):void 0),ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSourcePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationName",cdk.requiredValidator)(properties.applicationName)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("referenceDataSource",cdk.requiredValidator)(properties.referenceDataSource)),errors.collect(cdk.propertyValidator("referenceDataSource",CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator)(properties.referenceDataSource)),errors.wrap('supplied properties not correct for "CfnApplicationReferenceDataSourceProps"')}function cfnApplicationReferenceDataSourcePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSourcePropsValidator(properties).assertSuccess(),{ApplicationName:cdk.stringToCloudFormation(properties.applicationName),ReferenceDataSource:cfnApplicationReferenceDataSourceReferenceDataSourcePropertyToCloudFormation(properties.referenceDataSource)}):properties}function CfnApplicationReferenceDataSourcePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationName","ApplicationName",cfn_parse.FromCloudFormation.getString(properties.ApplicationName)),ret.addPropertyResult("referenceDataSource","ReferenceDataSource",CfnApplicationReferenceDataSourceReferenceDataSourcePropertyFromCloudFormation(properties.ReferenceDataSource)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplicationReferenceDataSource extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalytics_CfnApplicationReferenceDataSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplicationReferenceDataSource),error}cdk.requireProperty(props,"applicationName",this),cdk.requireProperty(props,"referenceDataSource",this),this.applicationName=props.applicationName,this.referenceDataSource=props.referenceDataSource}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationReferenceDataSourcePropsFromCloudFormation(resourceProperties),ret=new CfnApplicationReferenceDataSource(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{applicationName:this.applicationName,referenceDataSource:this.referenceDataSource}}renderProperties(props){return cfnApplicationReferenceDataSourcePropsToCloudFormation(props)}}exports.CfnApplicationReferenceDataSource=CfnApplicationReferenceDataSource,_c=JSII_RTTI_SYMBOL_1,CfnApplicationReferenceDataSource[_c]={fqn:"aws-cdk-lib.aws_kinesisanalytics.CfnApplicationReferenceDataSource",version:"2.42.0"},CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalytics::ApplicationReferenceDataSource";function CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.requiredValidator)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.validateString)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.requiredValidator)(properties.recordRowDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.validateString)(properties.recordRowDelimiter)),errors.wrap('supplied properties not correct for "CSVMappingParametersProperty"')}function cfnApplicationReferenceDataSourceCSVMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator(properties).assertSuccess(),{RecordColumnDelimiter:cdk.stringToCloudFormation(properties.recordColumnDelimiter),RecordRowDelimiter:cdk.stringToCloudFormation(properties.recordRowDelimiter)}):properties}function CfnApplicationReferenceDataSourceCSVMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumnDelimiter","RecordColumnDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordColumnDelimiter)),ret.addPropertyResult("recordRowDelimiter","RecordRowDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordRowDelimiter)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordRowPath",cdk.requiredValidator)(properties.recordRowPath)),errors.collect(cdk.propertyValidator("recordRowPath",cdk.validateString)(properties.recordRowPath)),errors.wrap('supplied properties not correct for "JSONMappingParametersProperty"')}function cfnApplicationReferenceDataSourceJSONMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator(properties).assertSuccess(),{RecordRowPath:cdk.stringToCloudFormation(properties.recordRowPath)}):properties}function CfnApplicationReferenceDataSourceJSONMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordRowPath","RecordRowPath",cfn_parse.FromCloudFormation.getString(properties.RecordRowPath)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_MappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csvMappingParameters",CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator)(properties.csvMappingParameters)),errors.collect(cdk.propertyValidator("jsonMappingParameters",CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator)(properties.jsonMappingParameters)),errors.wrap('supplied properties not correct for "MappingParametersProperty"')}function cfnApplicationReferenceDataSourceMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_MappingParametersPropertyValidator(properties).assertSuccess(),{CSVMappingParameters:cfnApplicationReferenceDataSourceCSVMappingParametersPropertyToCloudFormation(properties.csvMappingParameters),JSONMappingParameters:cfnApplicationReferenceDataSourceJSONMappingParametersPropertyToCloudFormation(properties.jsonMappingParameters)}):properties}function CfnApplicationReferenceDataSourceMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csvMappingParameters","CSVMappingParameters",properties.CSVMappingParameters!=null?CfnApplicationReferenceDataSourceCSVMappingParametersPropertyFromCloudFormation(properties.CSVMappingParameters):void 0),ret.addPropertyResult("jsonMappingParameters","JSONMappingParameters",properties.JSONMappingParameters!=null?CfnApplicationReferenceDataSourceJSONMappingParametersPropertyFromCloudFormation(properties.JSONMappingParameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_RecordColumnPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mapping",cdk.validateString)(properties.mapping)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("sqlType",cdk.requiredValidator)(properties.sqlType)),errors.collect(cdk.propertyValidator("sqlType",cdk.validateString)(properties.sqlType)),errors.wrap('supplied properties not correct for "RecordColumnProperty"')}function cfnApplicationReferenceDataSourceRecordColumnPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_RecordColumnPropertyValidator(properties).assertSuccess(),{Mapping:cdk.stringToCloudFormation(properties.mapping),Name:cdk.stringToCloudFormation(properties.name),SqlType:cdk.stringToCloudFormation(properties.sqlType)}):properties}function CfnApplicationReferenceDataSourceRecordColumnPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mapping","Mapping",properties.Mapping!=null?cfn_parse.FromCloudFormation.getString(properties.Mapping):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("sqlType","SqlType",cfn_parse.FromCloudFormation.getString(properties.SqlType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_RecordFormatPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mappingParameters",CfnApplicationReferenceDataSource_MappingParametersPropertyValidator)(properties.mappingParameters)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.requiredValidator)(properties.recordFormatType)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "RecordFormatProperty"')}function cfnApplicationReferenceDataSourceRecordFormatPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_RecordFormatPropertyValidator(properties).assertSuccess(),{MappingParameters:cfnApplicationReferenceDataSourceMappingParametersPropertyToCloudFormation(properties.mappingParameters),RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationReferenceDataSourceRecordFormatPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mappingParameters","MappingParameters",properties.MappingParameters!=null?CfnApplicationReferenceDataSourceMappingParametersPropertyFromCloudFormation(properties.MappingParameters):void 0),ret.addPropertyResult("recordFormatType","RecordFormatType",cfn_parse.FromCloudFormation.getString(properties.RecordFormatType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("referenceSchema",cdk.requiredValidator)(properties.referenceSchema)),errors.collect(cdk.propertyValidator("referenceSchema",CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator)(properties.referenceSchema)),errors.collect(cdk.propertyValidator("s3ReferenceDataSource",CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator)(properties.s3ReferenceDataSource)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "ReferenceDataSourceProperty"')}function cfnApplicationReferenceDataSourceReferenceDataSourcePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator(properties).assertSuccess(),{ReferenceSchema:cfnApplicationReferenceDataSourceReferenceSchemaPropertyToCloudFormation(properties.referenceSchema),S3ReferenceDataSource:cfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyToCloudFormation(properties.s3ReferenceDataSource),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnApplicationReferenceDataSourceReferenceDataSourcePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("referenceSchema","ReferenceSchema",CfnApplicationReferenceDataSourceReferenceSchemaPropertyFromCloudFormation(properties.ReferenceSchema)),ret.addPropertyResult("s3ReferenceDataSource","S3ReferenceDataSource",properties.S3ReferenceDataSource!=null?CfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyFromCloudFormation(properties.S3ReferenceDataSource):void 0),ret.addPropertyResult("tableName","TableName",properties.TableName!=null?cfn_parse.FromCloudFormation.getString(properties.TableName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumns",cdk.requiredValidator)(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordColumns",cdk.listValidator(CfnApplicationReferenceDataSource_RecordColumnPropertyValidator))(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordEncoding",cdk.validateString)(properties.recordEncoding)),errors.collect(cdk.propertyValidator("recordFormat",cdk.requiredValidator)(properties.recordFormat)),errors.collect(cdk.propertyValidator("recordFormat",CfnApplicationReferenceDataSource_RecordFormatPropertyValidator)(properties.recordFormat)),errors.wrap('supplied properties not correct for "ReferenceSchemaProperty"')}function cfnApplicationReferenceDataSourceReferenceSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator(properties).assertSuccess(),{RecordColumns:cdk.listMapper(cfnApplicationReferenceDataSourceRecordColumnPropertyToCloudFormation)(properties.recordColumns),RecordEncoding:cdk.stringToCloudFormation(properties.recordEncoding),RecordFormat:cfnApplicationReferenceDataSourceRecordFormatPropertyToCloudFormation(properties.recordFormat)}):properties}function CfnApplicationReferenceDataSourceReferenceSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumns","RecordColumns",cfn_parse.FromCloudFormation.getArray(CfnApplicationReferenceDataSourceRecordColumnPropertyFromCloudFormation)(properties.RecordColumns)),ret.addPropertyResult("recordEncoding","RecordEncoding",properties.RecordEncoding!=null?cfn_parse.FromCloudFormation.getString(properties.RecordEncoding):void 0),ret.addPropertyResult("recordFormat","RecordFormat",CfnApplicationReferenceDataSourceRecordFormatPropertyFromCloudFormation(properties.RecordFormat)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketArn",cdk.requiredValidator)(properties.bucketArn)),errors.collect(cdk.propertyValidator("bucketArn",cdk.validateString)(properties.bucketArn)),errors.collect(cdk.propertyValidator("fileKey",cdk.requiredValidator)(properties.fileKey)),errors.collect(cdk.propertyValidator("fileKey",cdk.validateString)(properties.fileKey)),errors.collect(cdk.propertyValidator("referenceRoleArn",cdk.requiredValidator)(properties.referenceRoleArn)),errors.collect(cdk.propertyValidator("referenceRoleArn",cdk.validateString)(properties.referenceRoleArn)),errors.wrap('supplied properties not correct for "S3ReferenceDataSourceProperty"')}function cfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator(properties).assertSuccess(),{BucketARN:cdk.stringToCloudFormation(properties.bucketArn),FileKey:cdk.stringToCloudFormation(properties.fileKey),ReferenceRoleARN:cdk.stringToCloudFormation(properties.referenceRoleArn)}):properties}function CfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketArn","BucketARN",cfn_parse.FromCloudFormation.getString(properties.BucketARN)),ret.addPropertyResult("fileKey","FileKey",cfn_parse.FromCloudFormation.getString(properties.FileKey)),ret.addPropertyResult("referenceRoleArn","ReferenceRoleARN",cfn_parse.FromCloudFormation.getString(properties.ReferenceRoleARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
//# sourceMappingURL=kinesisanalytics.generated.js.map
