"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Alias=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),core_1=require("../../core"),kms_generated_1=require("./kms.generated"),REQUIRED_ALIAS_PREFIX="alias/",DISALLOWED_PREFIX=REQUIRED_ALIAS_PREFIX+"aws/";class AliasBase extends core_1.Resource{get keyArn(){return core_1.Stack.of(this).formatArn({service:"kms",resource:this.aliasName})}get keyId(){return this.aliasName}addAlias(alias){return this.aliasTargetKey.addAlias(alias)}addToResourcePolicy(statement,allowNoOp){return this.aliasTargetKey.addToResourcePolicy(statement,allowNoOp)}grant(grantee,...actions){return this.aliasTargetKey.grant(grantee,...actions)}grantDecrypt(grantee){return this.aliasTargetKey.grantDecrypt(grantee)}grantEncrypt(grantee){return this.aliasTargetKey.grantEncrypt(grantee)}grantEncryptDecrypt(grantee){return this.aliasTargetKey.grantEncryptDecrypt(grantee)}}class Alias extends AliasBase{constructor(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_AliasProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Alias),error}let aliasName=props.aliasName;if(!core_1.Token.isUnresolved(aliasName)){if(aliasName.startsWith(REQUIRED_ALIAS_PREFIX)||(aliasName=REQUIRED_ALIAS_PREFIX+aliasName),aliasName===REQUIRED_ALIAS_PREFIX)throw new Error(`Alias must include a value after "${REQUIRED_ALIAS_PREFIX}": ${aliasName}`);if(aliasName.toLocaleLowerCase().startsWith(DISALLOWED_PREFIX))throw new Error(`Alias cannot start with ${DISALLOWED_PREFIX}: ${aliasName}`);if(!aliasName.match(/^[a-zA-Z0-9:/_-]{1,256}$/))throw new Error("Alias name must be between 1 and 256 characters in a-zA-Z0-9:/_-")}super(scope,id,{physicalName:aliasName}),this.aliasTargetKey=props.targetKey;const resource=new kms_generated_1.CfnAlias(this,"Resource",{aliasName:this.physicalName,targetKeyId:this.aliasTargetKey.keyArn});this.aliasName=this.getResourceNameAttribute(resource.aliasName),props.removalPolicy&&resource.applyRemovalPolicy(props.removalPolicy)}static fromAliasAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_AliasAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAliasAttributes),error}class _Alias extends AliasBase{get aliasName(){return attrs.aliasName}get aliasTargetKey(){return attrs.aliasTargetKey}}return new _Alias(scope,id)}static fromAliasName(scope,id,aliasName){class Import extends core_1.Resource{constructor(){super(...arguments),this.keyArn=core_1.Stack.of(this).formatArn({service:"kms",resource:aliasName}),this.keyId=aliasName,this.aliasName=aliasName}get aliasTargetKey(){throw new Error("Cannot access aliasTargetKey on an Alias imported by Alias.fromAliasName().")}addAlias(_alias){throw new Error("Cannot call addAlias on an Alias imported by Alias.fromAliasName().")}addToResourcePolicy(_statement,_allowNoOp){return{statementAdded:!1}}grant(grantee,..._actions){return iam.Grant.drop(grantee,"")}grantDecrypt(grantee){return iam.Grant.drop(grantee,"")}grantEncrypt(grantee){return iam.Grant.drop(grantee,"")}grantEncryptDecrypt(grantee){return iam.Grant.drop(grantee,"")}}return new Import(scope,id)}generatePhysicalName(){return REQUIRED_ALIAS_PREFIX+super.generatePhysicalName()}}exports.Alias=Alias,_a=JSII_RTTI_SYMBOL_1,Alias[_a]={fqn:"aws-cdk-lib.aws_kms.Alias",version:"2.42.0"};
//# sourceMappingURL=alias.js.map
