"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.PackageManager=exports.LockFile=void 0;const os=require("os"),path=require("path"),types_1=require("./types");var LockFile;(function(LockFile2){LockFile2.NPM="package-lock.json",LockFile2.YARN="yarn.lock",LockFile2.PNPM="pnpm-lock.yaml"})(LockFile=exports.LockFile||(exports.LockFile={}));class PackageManager{constructor(props){this.lockFile=props.lockFile,this.installCommand=props.installCommand,this.runCommand=props.runCommand,this.argsSeparator=props.argsSeparator}static fromLockFile(lockFilePath,logLevel){switch(path.basename(lockFilePath)){case LockFile.YARN:return new PackageManager({lockFile:LockFile.YARN,installCommand:logLevel&&logLevel!==types_1.LogLevel.INFO?["yarn","install","--no-immutable","--silent"]:["yarn","install","--no-immutable"],runCommand:["yarn","run"]});case LockFile.PNPM:return new PackageManager({lockFile:LockFile.PNPM,installCommand:logLevel&&logLevel!==types_1.LogLevel.INFO?["pnpm","install","--reporter","silent"]:["pnpm","install"],runCommand:["pnpm","exec"],argsSeparator:"--"});default:return new PackageManager({lockFile:LockFile.NPM,installCommand:logLevel?["npm","ci","--loglevel",logLevel]:["npm","ci"],runCommand:["npx","--no-install"]})}}runBinCommand(bin){const[runCommand,...runArgs]=this.runCommand;return[os.platform()==="win32"?`${runCommand}.cmd`:runCommand,...runArgs,...this.argsSeparator?[this.argsSeparator]:[],bin].join(" ")}}exports.PackageManager=PackageManager;
//# sourceMappingURL=package-manager.js.map
